
function allElementsChecked()
{
   var nChecked = 0;
   for( i = 0; i < numChoices; ++i )
   {
      if ( option[i].checked )
      {
         ++nChecked;
      }
   }   
   return nChecked == numChoices; 
}

function NCTableSelectAllClick()
   {
      CheckBoxTableSelectAllClick( option, numChoices );
   }

function NCTableCheckBoxClick()
   {
      CheckboxTableOnClick(numChoices)
   }

// Configuration Wizards Version
function DisplayNCTable(sSelectAllImg, sSelectAllHandler, sCheckboxToggleHandler) 
{      
   document.write("<form autocomplete='off' name='ncForm' onSubmit='return false;'>");
   writeSelectAll("maintable", sSelectAllImg, 5, sSelectAllHandler);
   writeCheckboxes("maintable", 5, sCheckboxToggleHandler); 
   document.write("</form>");
}


// Standard Path Version
function DisplayStandardCheckBoxTable(checkboxText, option, numChoices, changeHandler, selectAllHandler, selectAllImage ) 
{
   // Text Header for Select All
   document.write("<table width=100% align=center border=0 cellpadding=0 cellspacing=0 id='SELECT_ALL' class=normal>");
      document.write("<tr id=advTableHeader width=100% align=center>");
      document.write("<td width=100% id=advTableHeader align=center>");
      document.write( checkboxText );
      document.write("<td id=configtable width=10 height=25>&nbsp;</td>");
      document.write("</tr>");
   document.write("</table>");

   // Select All Button, Image, and Text
   document.write("<br>");
   writeSelectAll("advTable", selectAllImage, 5, selectAllHandler);
   
   // The rest of the checkboxes
   writeCheckboxes("advTable", 5, changeHandler);    
}


//------------------------------------------------------------------------------
// Name: writeCheckboxes()
// Desc: 
//
// Globals Used:    option[i].id - id of a checkbox element
//                  option[i].name - used for checkbox text
//                  option[i].checked - is checkbox initially checked?
//                  option[i].focusTag + "_ROW" - span id of a single checkbox
//                                                row that can be made not
//                                                visible.
// Parameters:      sCSSId   - row id to specify css class for checkbox row
//                  nCellPadding - cell padding
//                  sCheckboxToggleHandler - Handler that is called if a 
//                             checkbox is clicked.This parameter is optionable.
//                             It will be passed the number of the checkbox
//                             as a parameter. If the function is func(nIndex)
//                             then "func" should be the value for this variable
// Return Value:    none
// Pre-conditions:  Global objects must exist and be initialized
// Post-conditions: Checkbox table is written to page. CheckboxTableOnClick is 
//                  called as well as pOnclick whenever a checkbox is clicked. 
//                  See CheckboxTableOnClick desc for details. 
//                                                                     mm29Oct03
//------------------------------------------------------------------------------

function writeCheckboxes(sCSSId, nCellPadding, sCheckboxToggleHandler)
{
   for (var i = 0; i < numChoices; i++)
   {     
      document.write("<span id=" + option[i].focusTag + "_ROW>"); // Used to make an entire row visible/not visible mm29Oct03 
      document.write("<table width=100% align=center border=0 cellpadding=" + nCellPadding + " cellspacing=0 id='CheckBox" + i + "_TABLE' class=normal>");
      document.write("<tr id=" + sCSSId + ">"); 
      document.write("<td id=" + sCSSId + " nowrap>");      
      document.write("<input type='CHECKBOX' name='");
      document.write("CheckBox" + i );
      document.write("'");
      document.write(" value='");
      document.write(option[i].id);
      if (option[i].checked)
      {
         document.write("' CHECKED id=");
      }
      else
      {
         document.write("' id=");
      }
      document.write(option[i].id);
      document.write(" ");

      document.write("onclick=\"");
      document.write("CheckboxTableOnClick(numChoices); ");
      if ( sCheckboxToggleHandler != null && sCheckboxToggleHandler != "")
      {
         document.write( sCheckboxToggleHandler + "(" + i + ");");
      }
      document.write("\">");

      WriteElementImageFor(option[i]);
      document.write(InsertParmsInString(option[i].name));
      AddKBIndex(option[i].id);
      kbIdArray[option[i].id].isCheckbox=true;
      document.write("</td>");
      document.write("</tr>");
      document.write("</table>");
      document.write("</span>");    // End Row span
   }      
}

//------------------------------------------------------------------------------
// Name: writeSelectAll()
// Desc: Writes the select all checkbox to the page.
//
// Globals Used:    
// Parameters:      sCSSId   - CSS id to specify css class for checkbox row
//                  sSelectAllImage - path to image file for select all icon   
//                  nCellPadding - cell padding
//                  sSelectAllHandler - Handler that is called if a checkbox is 
//                             clicked. This parameter is optionable. It will
//                             pass whether it is checked or not as the 
//                             parameter. If the function is func(nIndex)
//                             then "func" should be the value for this variable
//             
// Return Value:    none
// Pre-conditions:  Global objects must exist and be initialized
// Post-conditions: CheckBoxAll_ROW - specifies the span id used to make the 
//                                    select all image visible/invisible.
//                  CheckBoxAll - specifies id of select all checkbox.
//                  NCTableSelectAllClick() - called when checkbox is clicked.
//                  CheckBoxAllImg - DOM id for checkbox image
//                  CheckBoxTableSelectAllClick() - always called when clicked.
//                                                                     mm29Oct03
//------------------------------------------------------------------------------

function writeSelectAll(sCSSId, sSelectAllImage, nCellPadding, sSelectAllHandler)
{
   if ( numChoices > 1 )
   {
      document.write("<span id=CheckBoxAll_ROW>");// mm29Oct03
      document.write("<table width=100% align=center border=0 cellpadding=" + nCellPadding + " cellspacing=0 id='CheckBoxAll_TABLE' class=normal>");
      document.write("<tr id=" + sCSSId + ">");
      document.write("<td id=" + sCSSId + " nowrap>");
      
     
      document.write("<input type='CHECKBOX' value='' ");

      if ( allElementsChecked() )
      {
         document.write("CHECKED");
      }
      

      document.write(" name='CheckBoxAll' id='CheckBoxAll' ");
    
      document.write("onclick=\"CheckBoxTableSelectAllClick( option, " + numChoices + "); "); 
      if ( sSelectAllHandler != null && sSelectAllHandler != "")
      {
         document.write( sSelectAllHandler + "(document.getElementById('CheckBoxAll').checked);");
      }
      document.write("\">");
      if ( sSelectAllImage != null && sSelectAllImage != "")
      {
         document.write("<IMG SRC=" + sSelectAllImage + " width=30 height=27 align=absmiddle id=CheckBoxAllImg>"); //mm29Oct03
      }
      WriteString("PX_TAG_SELECT_ALL");
      
      document.write("</td></tr>");
      document.write("</table>");
      document.write("</span>");    // End Row span
      
      AddKBIndex("CheckBoxAll");
      kbIdArray["CheckBoxAll"].isCheckbox=true;
   }
}


function NCFormReferenceArrayInit(form)
   {
   formReferenceArray = new Array();
   for (var i=0; i<numChoices; ++i)
     {
     option[i].command = offcommand;
     if (option[i].checked)
       {
       option[i].command = command;
       }
     formReferenceArray[i] = form.elements[i];
     }
   }

function NCFormReferenceArrayToggleItem(index)
   {
   option[index].checked = !option[index].checked;
   newCommand = offcommand;
   if ( option[index].checked )
      {
      newCommand = command;
      }    
   option[index].command = newCommand;
   formReferenceArray[index].name = option[index].command;
   //formReferenceArray[index].value = option[index].id;
   }

function NCFormReferenceArraySelectAll(isSelect)
   {
   newCommand = offcommand;
   checkedState = false;
   if (isSelect)
     {
     newCommand = command;
     checkedState = true;
     }
   for (var i=0; i<numChoices; ++i)
     {
     option[i].checked = checkedState;
     option[i].command = newCommand;
     formReferenceArray[i].name = option[i].command;
     //formReferenceArray[i].value = option[i].id;
     }
   }


function CheckBoxTableSelectAllClick( option, numChoices )
{
   var shouldCheck=document.getElementById("CheckBoxAll").checked; 
   for (var j=0; j<numChoices; ++j)
   { 
      document.getElementById(option[j].id).checked=shouldCheck;
   }
}


//------------------------------------------------------------------------------
// Name: CheckboxTableOnClick()
// Desc: This function will check the 'select all' check box automatically if 
//       all of the normal checkboxes are checked. It will also unselect it if
//       one of the checkboxes becomes unchecked. If a checkbox is not visible,
//       then we deregard it and go to the next one. 
//
// Globals Used:    option[j].id - id of a checkbox element
// Parameters:      numChoices - number of normal checkboxes available
// Return Value:    none
// Pre-conditions:  Global objects must exist and be initialized
// Post-conditions: none
//                                                            modified mm29Oct03
//------------------------------------------------------------------------------

function CheckboxTableOnClick(numChoices)
{
   var allChecked = true;
   for ( var j=0; (j<numChoices) && allChecked; ++j )
   {
      var obj = document.getElementById(option[j].id);
      if(obj && isElementVisible(obj))
      {
         allChecked = obj.checked;
      }
   }
   
   if (numChoices > 1)
   {
      document.getElementById("CheckBoxAll").checked = allChecked;
   }
}

