#!/bin/sh

# edit_blacklist.redhat.sh: adds support for the HSG80, MSA1000, and HSV110 to
#                    the SCSI blacklist in scsi_scan.c.  This script
#                    makes sure that there isn't any reference to
#                    either the HSG80, MSA1000, or HSV110 in the blacklist
#                    and then adds the definitions.  This version for red hat
#                    distributions

BLDIR="/usr/src/linux-2.4/drivers/scsi"
BLACKLISTFILE="$BLDIR/scsi_scan.c"
BLACKLISTFILE_NEW="$BLDIR/scsi_scan.c.new"
BLACKLISTFILE_OLD="$BLDIR/scsi_scan.c.old"
TMPFILE="$BLDIR/scsi_scan.tmp"
TMPFILE2="$BLDIR/scsi_scan.tmp2"
TMPFILE3="$BLDIR/scsi_scan.tmp3"
TMPFILE4="$BLDIR/scsi_scan.tmp4"
TMPFILE5="$BLDIR/scsi_scan.tmp5"
EDIT_BLACKLIST="./edit_blacklist.redhat"

# save blacklist file

cp $BLACKLISTFILE $BLACKLISTFILE_OLD

# get rid of any reference to either the HSG80 or MSA1000
# in the blacklist

cat $BLACKLISTFILE | grep -v HSG80 > $TMPFILE
cat $TMPFILE | grep -v MSA1000 > $TMPFILE2
cat $TMPFILE2 | grep -v HSV110 > $TMPFILE3
cat $TMPFILE3 | grep -v "MSA1000 VOLUME" > $TMPFILE4
cat $TMPFILE4 | grep -v HSV100 > $TMPFILE5

cp $TMPFILE5 $TMPFILE

rm -f $TMPFILE2
rm -f $TMPFILE3
rm -f $TMPFILE4
rm -f $TMPFILE5

# call edit_blacklist executable to make changes to blacklist

$EDIT_BLACKLIST

rm -f $TMPFILE

# move new blacklist file to original

mv -f $BLACKLISTFILE_NEW $BLACKLISTFILE
