#
# Makefile 1.5.1   April 30, 2002
#
#
# 1. To make UP version of ISP2200 driver
#  make qla2200.o 
#
# 2. To make UP version of ISP2300 driver
#  make qla2300.o 
#
# 3. To make UP version of ISP2200 and ISP2300 drivers
#  make all 
#or 
#  make 
#
# To make SMP version of any of the above drivers
# append SMP=1 to one of the (3) make command lines above. 
#  make ... SMP=1
#
# To make a new firmware file (FILE must be a *.c file of the fw object)
#  make fw FILE2=2200tp.c
#

DRIVER=qla2200.o qla2300.o 

FILE2=2200tp.h
FILE3=2300tp.h

HOSTTYPE := $(shell uname -m)

#
# f/W include files
FWFILE2=ql2200_fw.h
FWFILE3=ql2300_fw.h
FWFILE2IP=ql2200ip_fw.h
FWFILE3IP=ql2300ip_fw.h

# Comment/uncomment the following line to enable/disable debugging
DEBUGFLAG=y
HSG80=n

# insmod does not like debugging enabled for PPC64
ifeq ($(HOSTTYPE),ppc64)
DEBUGFLAG=n
endif

QL_DEBUG=0x6

OSVER=linux-2.4

# Change it here or specify it on the "make" commandline
#(new)INCLUDEDIR = /lib/modules/`uname -r`/build/include
INCLUDEDIR = /usr/src/$(OSVER)/include

GCC_FLAVOR := $(shell gcc --version)

ifeq ($(DEBUGFLAG),y)
  DEBFLAGS = -O -g -DUDEBUG -DLINUX -Dlinux
else
  DEBFLAGS = -O2 -DLINUX -Dlinux
endif

CFLAGS = -D__KERNEL__ -DMODULE -Wall $(DEBFLAGS) -DINTAPI -DEXPORT_SYMTAB
#CFLAGS = -D__KERNEL__ -DMODULE -Wall $(DEBFLAGS) -DEXPORT_SYMTAB

ifeq ($(HSG80),y)
CFLAGS += -DCOMPAQ
endif


# set MODVERSIONS if the kernel uses it
VERSUSED = $(shell grep 'define CONFIG_MODVERSIONS' \
           $(INCLUDEDIR)/linux/autoconf.h | wc -l | sed 's/ //g')
VERSUSED = 1

ifeq ($(VERSUSED),1)
CFLAGS += -DMODVERSIONS -include $(INCLUDEDIR)/linux/modversions.h
endif

CFLAGS += -I$(INCLUDEDIR) -I$(INCLUDEDIR)/../drivers/scsi

ifeq ($(HOSTTYPE),i386)
CFLAGS += -Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe -malign-loops=2 -malign-jumps=2 -malign-functions=2 \
-DCONFIG_X86_LOCAL_APIC -fno-strict-aliasing -fno-common \
-mpreferred-stack-boundary=2 -march=i386
endif

ifeq ($(HOSTTYPE),i486)
CFLAGS += -Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe -malign-loops=2 -malign-jumps=2 -malign-functions=2 \
-DCONFIG_X86_LOCAL_APIC -fno-strict-aliasing -fno-common \
-mpreferred-stack-boundary=2 -march=i486
endif

ifeq ($(HOSTTYPE),i586)
CFLAGS += -Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe -malign-loops=2 -malign-jumps=2 -malign-functions=2 \
-DCONFIG_X86_LOCAL_APIC -fno-strict-aliasing -fno-common \
-mpreferred-stack-boundary=2 -march=i586
endif

ifeq ($(HOSTTYPE),i686)
CFLAGS += -Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe -malign-loops=2 -malign-jumps=2 -malign-functions=2 \
-DCONFIG_X86_LOCAL_APIC -fno-strict-aliasing -fno-common \
-mpreferred-stack-boundary=2 -march=i686
endif

ifeq ($(HOSTTYPE),ia64)
CFLAGS += -Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe -DWORD_FW_LOAD
endif

ifeq ($(HOSTTYPE),alpha)
CFLAGS += -D__alpha__ \
-Wall -Wstrict-prototypes -fomit-frame-pointer -fno-strength-reduce \
-pipe  -fno-strict-aliasing -mno-fp-regs -ffixed-8 -mcpu=ev56 -Wa,-mev6
endif

ifeq ($(HOSTTYPE),ppc64)
# Assign the following path based on the distribution used
#CROSS_COMPILE=powerpc64-linux-
CROSS_COMPILE=/opt/cross/bin/powerpc64-linux-
AS              = $(CROSS_COMPILE)as
LD              = $(CROSS_COMPILE)ld
CC              = $(CROSS_COMPILE)gcc
CPP             = $(CC) -E
AR              = $(CROSS_COMPILE)ar
NM              = $(CROSS_COMPILE)nm
STRIP           = $(CROSS_COMPILE)strip
OBJCOPY         = $(CROSS_COMPILE)objcopy
OBJDUMP         = $(CROSS_COMPILE)objdump

CFLAGS += -Wall -Wstrict-prototypes -Wno-trigraphs -fomit-frame-pointer \
-fno-strict-aliasing -fno-common -fsigned-char -msoft-float -pipe \
-Wno-uninitialized -mminimal-toc -fno-builtin  
endif

ifeq ("1","$(IP)")
CFLAGS += -DFC_IP_SUPPORT  
endif

ifeq ("1","$(SMP)")
CFLAGS += -D__SMP__  -DCONFIG_SMP  
endif

COFLAGS = -kv

MPATH = /lib/modules

SRC_FILES=qla_settings.h qla2x00.h qla2x00.c qla_cfg.c qla_cfg.h qla_cfgln.c \
qla_fo.h qla_fo.c qlfo.h qla2x00_ioctl.c qla_inioct.c \
qla_mbx.c qla_mbx.h qla_debug.h	qla_version.h qla_ip.c qla_ip.h

KERNVER := $(shell uname -r)
LIBMODULES = /lib/modules/$(KERNVER)/kernel/drivers


# Where is all starts..
#
# -- default is always first.
default: $(DRIVER)
	@echo ""
	@echo "You are running $(shell uname -r ). This is the kernel version that the QLogic driver has been compiled for."
	@echo "GCC Flavor $(GCC_FLAVOR)"
	@echo ""

all:	$(DRIVER)

clean: 
	rm -f $(DRIVER)

install: $(DRIVER)
	install -d -o root -g root $(LIBMODULES)/scsi/
	install -o root -g root $(DRIVER) $(LIBMODULES)/scsi/
	@if [ -f "$(LIBMODULES)/addon/qla2200/qla2200.o" ] ; then \
		mv $(LIBMODULES)/addon/qla2200/qla2200.o $(LIBMODULES)/addon/qla2200/qla2200_rh.o ; \
	fi
	@if [ -f "$(LIBMODULES)/addon/qla2200/qla2300.o" ] ; then \
		mv $(LIBMODULES)/addon/qla2200/qla2300.o $(LIBMODULES)/addon/qla2200/qla2300_rh.o ; \
	fi
	@if [ -f "$(LIBMODULES)/addon/qla2200_new/qla2200.o" ] ; then \
		mv $(LIBMODULES)/addon/qla2200_new/qla2200.o $(LIBMODULES)/addon/qla2200_new/qla2200_rh.o ; \
	fi
	@if [ -f "$(LIBMODULES)/addon/qla2200_new/qla2300.o" ] ; then \
		mv $(LIBMODULES)/addon/qla2200_new/qla2300.o $(LIBMODULES)/addon/qla2200_new/qla2300_rh.o ; \
	fi

fw:
	mv $(FILE2) $(FWFILE2)
	mv $(FILE3) $(FWFILE3)

qla2100.o  : $(SRC_FILES)
	$(CC) $(CFLAGS) -c qla2100.c -o $@

qla2200.o  : $(SRC_FILES) $(FWFILE2)
	$(CC) $(CFLAGS) -c qla2200.c -o $@

qla2300.o  : $(SRC_FILES) $(FWFILE3)
	$(CC) $(CFLAGS) -c qla2300.c -o $@

# @echo "Editing file to produce -> [isp_fw.h]"
# sh do_fw.sh $(FILE) cvtfw
# @echo "Editing file to produce -> [isp1_fw.h]"
# sh do_fw.sh $(FILE2) cvtfw22
