#!/bin/sh
#
# edit_rc_sysinit.sh
#
# Adds or removes the startup code to the /etc/rc.sysinit file for the
# qla2200 and qla2300 modules

RC_SYSINIT="/etc/rc.d/rc.sysinit"
RC_SYSINIT_NEW="/etc/rc.d/rc.sysinit.new"
RC_SYSINIT_OLD="/etc/rc.d/rc.sysinit.old"
EDIT_RC_SYSINIT="./edit_rc_sysinit"
REMOVE_TEXT="./remove_text"

# This function adds the startup code to the rc.sysinit file

add_text () {
 
 # save old copy of rc.sysinit file
 
 cp $RC_SYSINIT $RC_SYSINIT_OLD
 
 # make the edits to the rc.sysinit file
 
 $EDIT_RC_SYSINIT
 
 # copy the new version of rc.sysinit to the original
 
 mv -f $RC_SYSINIT_NEW $RC_SYSINIT
 chmod 755 $RC_SYSINIT
}

# This function removes the startup code from the rc.sysinit file

remove_text () {

 # save old copy of rc.sysinit file
 
 cp $RC_SYSINIT $RC_SYSINIT_OLD
 
 # make the edits to the rc.sysinit file
 
 $REMOVE_TEXT $RC_SYSINIT
 
 # copy the new version of rc.sysinit to the original
 
 mv -f $RC_SYSINIT_NEW $RC_SYSINIT
 chmod 755 $RC_SYSINIT
}

#
# Main
#

ARG=$1

case $ARG in
 "--add") add_text;;
 "--remove") remove_text;;
 *) echo "Usage: edit_rc_sysinit.sh [--add|--remove]"
    exit 1;;
esac

exit 0  
 
