#!/bin/sh
#
# Name: change_module.sh
# Copyright: (C) 2003 Hewlett-Packard Company
#
# Descriptions: this script copies the correct precompiled module depending on whether
#               the system is SMP enabled and which kernel is running
#
# Modification History
# 
# Chad Dupuis	02/11/03 Initial Devlopment
# Chad Dupuis   02/13/03 Changed the code that determines what
#                        type of kernel we are running

ARG=$1
MKSYSLOG="/opt/hp/storage_drivers/qla604/mksyslog"
DIST=sles7
SRCDIR=/usr/src/linux
DRVDIR=/opt/hp/storage_drivers/qla604

if [ "$ARG" != "sp" ] && [ "$ARG" != "nonsp" ]
then
 echo "Usage: change_module.sh [sp|nonsp]"
 echo ""
 echo "sp: copy a Secure Path compatible modules"
 echo "nonsp: copy single-path modules" 
 exit 1
fi

# determine which kernel we are using

if [ "`uname -r`" = "2.4.7-64GB" ] || [ "`uname -r`" = "2.4.7-64GB-SMP" ]
then
 KERNVER="2.4.7"
 PRECOMPILED=y
 echo "This directory has precompiled modules for `uname -r`"
elif [ "`uname -r`" = "2.4.18-64GB" ] || [ "`uname -r`" = "2.4.18-64GB-SMP" ]
then
 KERNVER="2.4.18"
 PRECOMPILED=y
 echo "This directory has precompiled modules for `uname -r`"
else
 PRECOMPILED=n
 echo ""
 echo "Your current kernel does not match 2.4.7-64GB, 2.4.7-64GB-SMP,"
 echo "2.4.18-64GB or 2.4.18-64GB-SMP, so this RPM does not contain any precompiled"
 echo "modules for your kernel."
 echo "You will have to manually recompile the qla2200 and qla2300 modules."
 echo "The driver source is located in ${DRVDIR}/src. Once you have"
 echo "recompiled the modules, you will need to copy them to"
 echo "/lib/modules/`uname -r`/kernel/drivers/scsi"
 exit 1
fi

# Only attempt to insert precompiled modules if the current
# kernel version matches one of the supported kernels

if [ "$PRECOMPILED" = "y" ]
then
 # determine if we have an UNI or SMP kernel

 SMP=1 # assume SMP kernel for now

 SMPINFO=`cat /proc/version | grep SMP`

 if [ "$SMPINFO" != "" ]
 then
  SMP=1
  echo "System is running a SMP kernel"
 else
  SMP=0
  echo "System is running a UNI kernel"
 fi

 # copy correct secure path qla2200 and qla2300 driver to modules directory

 if [ $SMP -eq 0 ]
 then
  echo "Using the files:"
  echo ""
  echo "qla2300_${DIST}_${ARG}_nonsmp.o-${KERNVER}"
  echo "qla2200_${DIST}_${ARG}_nonsmp.o-${KERNVER}" 
  $MKSYSLOG "Executing cp ${DRVDIR}/modules/qla2300_${DIST}_${ARG}_nonsmp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2300.o"
  cp ${DRVDIR}/modules/qla2300_${DIST}_${ARG}_nonsmp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2300.o 1>/dev/null 2>/dev/null
  $MKSYSLOG "Executing cp ${DRVDIR}/modules/qla2200_${DIST}_${ARG}_nonsmp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2200.o"
  cp ${DRVDIR}/modules/qla2200_${DIST}_${ARG}_nonsmp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2200.o 1>/dev/null 2>/dev/null
 else
  echo "Using the files:"
  echo ""
  echo "qla2300_${DIST}_${ARG}_smp.o-${KERNVER}"
  echo "qla2200_${DIST}_${ARG}_smp.o-${KERNVER}"
  $MKSYSLOG "Executing cp ${DRVDIR}/modules/qla2300_${DIST}_${ARG}_smp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2300.o" 
  cp ${DRVDIR}/modules/qla2300_${DIST}_${ARG}_smp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2300.o 1>/dev/null 2>/dev/null
  $MKSYSLOG "Executing cp ${DRVDIR}/modules/qla2200_${DIST}_${ARG}_smp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2200.o"
  cp ${DRVDIR}/modules/qla2200_${DIST}_${ARG}_smp.o-${KERNVER} /lib/modules/`uname -r`/kernel/drivers/scsi/qla2200.o 1>/dev/null 2>/dev/null
 fi
fi

echo ""
echo "You will have to reload the qla2200 and qla2300 modules for the changes"
echo "to take effect!"
