#!/bin/sh
#
# edit_boot.sh
#
# Adds or removes the startup code to the /etc/rc.d/boot file for the
# qla2200 and qla2300 modules

BOOT="/etc/rc.d/boot"
BOOT_NEW="/etc/rc.d/boot.new"
BOOT_OLD="/etc/rc.d/boot.old"
EDIT_BOOT="./edit_boot"
REMOVE_TEXT="./remove_text"

# This function adds the startup code to the boot file

add_text () {
 
 # save old copy of boot file
 
 cp $BOOT $BOOT_OLD
 
 # make the edits to the boot file
 
 $EDIT_BOOT
 
 # copy the new version of boot to the original
 
 mv -f $BOOT_NEW $BOOT
 chmod 744 $BOOT
 chown root:root $BOOT
}

# This function removes the startup code from the boot file

remove_text () {
 
 # save old copy of boot file
 
 cp $BOOT $BOOT_OLD
 
 # make the edits to the boot file
 
 $REMOVE_TEXT $BOOT
 
 # copy the new version of boot to the original
 
 mv -f $BOOT_NEW $BOOT
 chmod 744 $BOOT
 chown root:root $BOOT
}

#
# Main
#

ARG=$1

case $ARG in
 "--add") add_text;;
 "--remove") remove_text;;
 *) echo "Usage: edit_boot.sh [--add|--remove]"
    exit 1;;
esac

exit 0  
 
