#!/bin/sh
#
# Name: makenode.sh
# Copyright: (C) 2003 Hewlett-Packard Company
#
# Description: This script creates extra /dev/sd* node
#              files so Linux can bind to more than
#              16 LUNs using the MAKEDEV script
#
# Modification History
#
# Chad Dupuis	03/26/03	Modifications for platform kit
#

# check /dev/MAKEDEV

ls /dev/MAKEDEV 1>/dev/null 2>/dev/null

if [ $? -ne 0 ]
then
 echo "/dev/MAKEDEV does not exist."
 exit 1
fi

LETT_LIST=" a b c d e f g h i j k l m n o p q r s t u v w x y z aa ab ac ad ae af ag ah ai aj ak al am an ao ap aq ar as at au av aw ax ay az ba bb bc bd be bf bg bh bi bj bk bl bm bn bo bp bq br bs bt bu bv bw bx by bz ca cb cc cd ce cf cg ch ci cj ck cl cm cn co cp cq cr cs ct cu cv cw cx cy cz da db dc dd de df dg dh di dj dk dl dm dn do dp dq dr ds dt du dv dw dx " 

cd /dev # have to be in the /dev directory to do this

for i in $LETT_LIST
do
 if [ ! -b /dev/sd${i} ]
 then
  /dev/MAKEDEV sd${i}
 fi
done

