REM *******************************************************************************
REM Script to call EVM job
REM 10/17/00, Revision 0.1a-4
REM Compaq Computer Corporation
REM
REM *******************************************************************************
REM Set Script Variables
REM *******************************************************************************

SET DOMINOserver=<servername>
SET EVMJOB=<fulljobpath>
REM EVM_HOME variable set by EVM installation

REM ****************************************************************
REM Stop Lotus Domino
REM ****************************************************************

net stop "Lotus Domino Server (LotusDominoData)"

echo Application Stopped... 
echo Press any key to continue...
pause

REM *******************************************************************************
REM Start logging for this Script
REM
REM *******************************************************************************

md %windir%\rundomevm
net time \\%computername% >> %windir%\rundomevm\rundomevm.log
echo Beginning of job... >> %windir%\rundomevm\rundomevm.log
echo DOMNIOserver=%DOMINOserver% >> %windir%\rundomevm\rundomevm.log
echo EVMJOB=%EVMJOB% >> %windir%\rundomevm\rundomevm.log
echo EVM_HOME=%EVM_HOME% >> %windir%\rundomevm\rundomevm.log

REM *******************************************************************************
REM Verify required variables
REM
REM *******************************************************************************

IF NOT DEFINED DOMINOserver goto nodom
IF NOT DEFINED EVMJOB goto noevmjb
IF NOT DEFINED EVM_HOME goto noevmhm
goto runevm

:nodom
echo Dominoserver variable not set... Exiting...
echo Dominoserver variable not set... Exiting... >> %windir%\rundomevm\rundomevm.log
goto end

:noevmjb
echo EVMJOB variable not set... Exiting...
echo EVMJOB variable not set... Exiting... >> %windir%\rundomevm\rundomevm.log
goto end

:noevmhm
echo EVM_HOME variable not set... Exiting...
echo EVM_HOME variable not set... Exiting... >> %windir%\rundomevm\rundomevm.log
goto end

:runevm
REM *******************************************************************************
REM RUN EVM JOB
REM
REM *******************************************************************************

CD %evm_home%\bin
###  evmcl %DOMINOserver% %EVMJOB%
IF %ERRORLEVEL%==0 CPQLE 4 2000 "PROCESS:%0, EVM complete".
REM CPQLE 4 2010 "PROCESS:%0, Clone:%EVMJOBClone% DID NOT DELETE. "

REM *******************************************************************************
REM Close logging for this Script
REM
REM *******************************************************************************

echo End of job... >> %windir%\rundomevm\rundomevm.log
net time \\%computername% >> %windir%\rundomevm\rundomevm.log

REM *******************************************************************************
REM End of Script
REM
REM *******************************************************************************

:end