:: (C) Compaq Computer Corp. - Sample script for StorageWorks Virtual Replicator

REM *************************************************************************
REM	Run this RESTORE SCRIPT to get back to NORMAL Exchange Database locations,
REM	after running from a RECOVERY/SNAPSHOT state.
REM	
REM
REM	Note: Script is expecting CPQLE.EXE, ESEFILE.EXE, SCOPY.EXE to be 
REM        	in a directory in the System PATH. CPQLEMESS.DLL is required in
REM		the %systemroot%\system directory.   
REM
REM     Requires Exchange 5.5 Service Pack 2 or greater.
REM	ESEFILE and ESEUTIL are available from Microsoft.  ESEFILE is availble 
REM	with Exchange Server 5.5 SP3.  SCOPY is provided on the NT Resource Kit.  
REM
REM
REM *************************************************************************
REM     Modify this section with drive (no ":") for the priv.edb & pub.edb, 
REM 	the Exchange Bin Location and the EDB.CHK file
REM *************************************************************************

SET MDBDrive=G
SET ExchBinLocate=C:\exchsrvr\bin 
SET CHKLocate=c:\exchsrvr\mdbdata

REM *** Modify this section with the desired Parent and SNAPSHOT names:

SET ParentName=vdedb
SET SNAPSHOTName=snapdb1
SET SNAPSHOTDrive=s

REM *************************************************************************
REM	End Modification Section : Save the snaprest.cmd file
REM *************************************************************************

REM *** COMMAND TITLE 
TITLE %0

@echo OFF
REM REM SET echo=ON
@if not "%ECHO%"=="" echo %ECHO%
REM *************************************************************************

md c:\compaq\swvr\log\
net time \\%computername% >> c:\compaq\swvr\log\restore.out

REM *************************************************************************
REM  	STOP THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM *************************************************************************


net stop MSExchangeIS /y

REM *************************************************************************
REM 	UNMAP THE PARENT VIRTUAL DISK - note test for success                                      
REM *************************************************************************

Snapmgr virtual  %ParentName% /unmap  >> c:\compaq\swvr\log\restore.out
CPQLE 4 4000 "PROCESS:%0, Unmap PARENT:%ParentName% complete.  COMMAND:Snapmgr virtual  %ParentName% /unmap "


Snapmgr snap  %SNAPSHOTName% /unmap >> c:\compaq\swvr\log\restore.out
CPQLE 4 4001 "PROCESS:%0, Unmap SNAPSHOT:%SNAPSHOTName% complete. COMMAND:Snapmgr snap  %SNAPSHOTName% /unmap "

REM *************************************************************************
REM MAP DRIVELETTER FOR THE PARENT
REM *************************************************************************

snapmgr snap  %SNAPSHOTName% /map:%SNAPSHOTDrive% >> c:\compaq\swvr\log\restore.out
CPQLE 4 4002 "PROCESS:%0, SNAP:%SNAPSHOTName% mapped to the %SNAPSHOTDrive%: drive. COMMAND:snapmgr snap  %SNAPSHOTName% /map:%SNAPSHOTDrive%"

Snapmgr virtual  %ParentName% /map:%MDBDrive% >> c:\compaq\swvr\log\restore.out
CPQLE 4 4003 "PROCESS:%0, PARENT mapped to the %MDBDrive%: drive. COMMAND:Snapmgr virtual  %ParentName% /map:%MDBDrive%"

REM *************************************************************************
REM 	COPY SNAPSHOT to PARENT
REM *************************************************************************

CPQLE 4 4004 "PROCESS:%0, Start offline copy of SNAP: %SNAPSHOTName%"
scopy %SNAPSHOTDrive%:\exchsrvr\mdbdata\*.*  %MDBDrive%:\Exchsrvr\mdbdata /s /o
CPQLE 4 4004 "PROCESS:%0, End offline copy of SNAP: %SNAPSHOTName%. Drive path:%SNAPSHOTDrive%:\exchsrvr\mdbdata\*.* Copied to Drive: %MDBDrive%"

REM *************************************************************************
REM  	DELETE EDB.CHK  
REM *************************************************************************

del %CHKLocate%\edb.chk 
CPQLE 4 4005 "PROCESS:%0, %CHKLocate%\edb.chk deleted "

REM *************************************************************************
REM  	START THE MICROSOFT EXCHANGE SYSTEM ATTENDANT, DIRECTORY SERVICE  
REM *************************************************************************

Net Start MSExchangeSA
Net Start MSExchangeDS

REM **************************************************************************
REM  	RUN ISINTEG -PATCH                                                                                   
REM **************************************************************************

%ExchBinLocate%\isinteg -patch >> c:\compaq\swvr\log\restore.out

REM **************************************************************************
REM  START THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM  Note: The Microsoft Exchange Event Service, Key Manager Service,  
REM  Internet Mail Service are dependencies of the Information Store 
REM *************************************************************************

Net start MSExchangeIS
net start MSExchangeES
net start MSExchangeIMC
net start MSExchangeKMS

REM **************************************************************************

net time \\%computername% >> c:\compaq\swvr\log\restore.out

EXIT