//
// debug.js
// 
// Copyright  2005 by NVIDIA Corporation.  All rights reserved.
// All information contained herein is proprietary and confidential to
// NVIDIA Corporation.  Any use, reproduction, or disclosure without the
// written permission of NVIDIA Corporation is prohibited.
//

var debugWinId = 0;

//
// debugWrite
//

function debugWrite (msg) {
    if (debugWinId && !debugWinId.closed) {
        var paneId;
        var date = new Date();

        paneId = debugWinId.document.getElementById ?
                debugWinId.document.getElementById("debugPane") : debugPane;

        if (paneId) {
            paneId.innerHTML = date.toLocaleString() + ": " + msg + "<hr>" +
                paneId.innerHTML;
        }
    }
}

//
// debugOpen
//

function debugOpen() {
    if (!debugWinId) {
        // Try to open debug window

        debugWinId = window.open("/nvraid/L1033/html/debug.html", "debugWin",
                    "height=100,width=600,toolbar=no,scrollbars=yes,menubar=no,location=no");

        if (debugWinId) {
            debugWinId.focus();
        } else {
            alert("didn't get debugWinId");
        }
    }
}

//
// debugClose - force closure of debug window
//

function debugClose() {
    if (debugWinId) {
        debugWinId.close();
        debugWinId = 0;
    }
}

// Uncomment the line below to enable debug window. Disabled by default.
//addEvent(window, "load", debugOpen);

