//
// mainPane.js
// 
// Copyright ?2005 by NVIDIA Corporation.  All rights reserved.
// All information contained herein is proprietary and confidential to
// NVIDIA Corporation.  Any use, reproduction, or disclosure without the
// written permission of NVIDIA Corporation is prohibited.
//

// ID of main pane table

var mainPaneTableId = null;
var diskarr = new Array();
var freedisk = new Array();
var noSelectionMask = 0;


//
// mainPaneCellAdd - add cell to table row
//

function mainPaneCellAdd (row, position, className, width, html) {

    var cell = row.insertCell(position);

    cell.className = className;
    cell.width = width;
    cell.innerHTML = html;

    return cell;
}

//
// mainPaneDiskFind - find specific disk's row in main pane table
//

function mainPaneDiskFind (id) {
    var i;

    for (i = 0; i < mainPaneTableId.rows.length; i++) {
        if (mainPaneTableId.rows.item(i).id == id) {
            return i;
        }
    }

    return "";
}


//
// mainPaneDiskAdd - add disk row to main pane
//

function mainPaneDiskAdd(id, clickFunc, img, name, status, capacity, iface, channel, device, mask)
{
    var row;

    // Create new row at end of table

    row = mainPaneTableId.insertRow(mainPaneTableId.rows.length);
    row.onclick = clickFunc;
    row.onmouseout = function() { diskMouseOut() };
    row.id = id;
    row.value = mask;

   
    // Build cells in new row

    mainPaneCellAdd(row, 0, "plain", 16, img);
    mainPaneCellAdd(row, 1, "regular", "", name);
    mainPaneCellAdd(row, 2, "regular", "", status);
    mainPaneCellAdd(row, 3, "regular", "", capacity);
    mainPaneCellAdd(row, 4, "regular", "", iface);
    mainPaneCellAdd(row, 5, "regular", "", channel);
    mainPaneCellAdd(row, 6, "regular", "", device);
}

//
// mainPaneDiskModify - update existing disk in main pane 
//

function mainPaneDiskModify(id, img, status, nameStyle) {
    var i;

    if ((i = mainPaneDiskFind(id)) != "") {
        var row = mainPaneTableId.rows.item(i);
        var cell;

        if (img != "") {
            cell = row.cells.item(0);
            cell.innerHTML = img;
        }

        if (status != "") {
            cell = row.cells.item(2);
            cell.innerHTML = status;
        }
	if (nameStyle != "") {
            cell = row.cells.item(1);
            cell.className = nameStyle;
        }
    }
}

//
// mainPaneDiskRemove - remove existing row from main pane 
//

function mainPaneDiskRemove(id) {
    var i;

    if ((i = mainPaneDiskFind(id)) != "") {
        mainPaneTableId.deleteRow(i);
    }
}


function showDiskStatus(req) {

    if (req.status == 200) {
        if(diskarr != null){
	    for(var i=0; i<diskarr.length;i++){
		mainPaneDiskRemove(diskarr[i][0]);
	}
    }
    diskarr.length = 0;
    if(freedisk != null){
	for(var i=0; i<freedisk.length;i++){
		mainPaneDiskRemove(freedisk[i][0]);
	}
    }
    freedisk.length = 0;

    eval(req.responseText);
 	   // XXX replace this with call to fetch initial content from server
 	   // Comment below when you set the variable array in your backend system by using print
//	   var diskarr = new Array();
// 	   diskarr[0] = new Array("a0",0,"<b>Stripings</b>", "Healthy", "149.06 GB", "", "", "");
//	   diskarr[1] = new Array("a1",1,"ST380013AS", "Healthy", "74.53 GB", "SATA", "Primary", "Master");
//	    diskarr[2] = new Array("array2",1,"ST380013AS", "Healthy", "74.53 GB", "SATA", "Primary", "Master");
//	    diskarr[3] = new Array("array3",1,"ST380013AS", "Healthy", "74.53 GB", "SATA", "Secondary", "Master");
//	   diskarr[4] = new Array("array4",2,"<b>Free Disk</b>", "", "", "", "", "");  	  
//	  diskarr[5] = new Array("array5",1,"ST380013AS", "Healthy", "74.54 GB", "SATA", "Primary", "Master");
// 	  diskarr[6] = new Array("array6",1,"ST380013AS", "Healthy", "74.54 GB", "SATA", "Primary", "Master");
  
  	// Comment above when you set the variable array in your backend system by using printf

    	try{
     	    if(diskarr != null){
         	 var gifpath = "";
         	 for(var i=0;i<diskarr.length;i++){
             	 if(diskarr[i][1] == 0)
             	    gifpath = "<img src='/nvraid/images/Array.gif'>";
           	 else if(diskarr[i][1] == 1)
            	     gifpath = "<img src='/nvraid/images/HardDisk.gif'>";
		 else if(diskarr[i][1] == 2)
		     gifpath = "";
 //            	 mainPaneDiskAdd(diskarr[i][0], "arrayDiskClick('diskarr[i][0]');return false;",gifpath, diskarr[i][2], diskarr[i][3],diskarr[i][4], diskarr[i][5], diskarr[i][6], diskarr[i][7]);
		 mainPaneDiskAdd(diskarr[i][0], arrayDiskClick,gifpath, diskarr[i][2], diskarr[i][3],diskarr[i][4], diskarr[i][5], diskarr[i][6], diskarr[i][7], diskarr[i][8]);
		 
//		debugWrite("showdiskstatus: added diskarr" + i);
	       	}
     	    }
	    else{
//		debugWrite("showdiskstatus: diskarr is null");
	    }
    	}catch(e){
//      	mainPaneDiskAdd("array0", arrayDiskClick,
//         "<img src='/nvraid/images/Array.gif'>", "<b>Striping</b>", "Healthy",
//         "149.06 GB", "", "", "");

//      	mainPaneDiskAdd("array0.0", arrayDiskClick,
//        "<img src='/nvraid/images/HardDisk.gif'>", "ST380013AS", "Healthy",
//        "74.53 GB", "SATA", "Primary", "Master");

//      	mainPaneDiskAdd("array0.1", arrayDiskClick,
//      	  "<img src='/nvraid/images/HardDisk.gif'>", "ST380013AS", "Healthy",
//        "74.53 GB", "SATA", "Primary", "Master");

//      	mainPaneDiskAdd("array0.2", arrayDiskClick,
//        "<img src='/nvraid/images/HardDisk.gif'>", "ST380013AS", "Healthy",
//        "74.53 GB", "SATA", "Secondary", "Master");

//      	mainPaneDiskAdd("array1", arrayDiskClick,
//         "", "<b>Free Disk</b>", "",
//         "", "", "", "");

//      	mainPaneDiskAdd("array1.0", arrayDiskClick,
//        "<img src='/nvraid/images/HardDisk.gif'>", "ST380013AS", "Healthy",
//        "74.53 GB", "SATA", "Primary", "Master");

//      	mainPaneDiskAdd("array1.1", arrayDiskClick,
//        "<img src='/nvraid/images/HardDisk.gif'>", "ST380013AS", "Healthy",
//        "74.53 GB", "SATA", "Primary", "Master");
   	}
	try{
     	 if(freedisk != null){
         	 var gifpath = "";
         	 for(var i=0;i<freedisk.length;i++){
            	 if(freedisk[i][1] == 0)
             	    gifpath = "<img src='/nvraid/images/Array.gif'>";
           	 else if(freedisk[i][1] == 1)
            	     gifpath = "<img src='/nvraid/images/HardDisk.gif'>";
		 else if(freedisk[i][1] == 2)
		     gifpath = "";
            // 	 mainPaneDiskAdd(freedisk[i][0], "freeDiskClick('freedisk[i][0]');return false;",gifpath, freedisk[i][2], freedisk[i][3],freedisk[i][4], freedisk[i][5], freedisk[i][6], freedisk[i][7]);
		mainPaneDiskAdd(freedisk[i][0], freeDiskClick,gifpath, freedisk[i][2], freedisk[i][3],freedisk[i][4], freedisk[i][5], freedisk[i][6], freedisk[i][7], freedisk[i][8]);
		 
//		 debugWrite("showdiskstatus: added freedisk" + i);
	       	}
	  }
          else{
//		debugWrite("showdiskstatus: freedisk is null");
	  }
        }
	catch(e){
	}
     }
     else {
        // XXX
     }
}

//
// mainPaneOnLoad - load main pane with default content on initial load
//

function mainPaneOnLoad () {
   mainPaneTableId = getElementId("mainPaneTable");

// Synchronous requests to get array and disk status

//    debugWrite("beginning of mainpaneonload");


//    wizardOnLoad();
//    debugWrite("wizardonload called for diskstatusupdate");
    wizardRequest(showDiskStatus, "?diskStatusUpdate", false);
    if(prevSelected!="")
    	mainPaneDiskModify(prevSelected,"", "","selected");

//    debugWrite("wizardrequest called for diskstatusupdate");


}

addEvent(window, "load", mainPaneOnLoad);

