//
// systemTasks.js
// 
// Copyright  2005 by NVIDIA Corporation.  All rights reserved.
// All information contained herein is proprietary and confidential to
// NVIDIA Corporation.  Any use, reproduction, or disclosure without the
// written permission of NVIDIA Corporation is prohibited.
//

// System tasks table

var systemTasksTableId = null;
var systemTasksMaskId = null;
var detailIntervalId = "";
var detailData = "";


// Free disk menu options, system tasks

var freeDiskMenu=new Array()
var freeDiskTasks=new Array()

// Array disk menu options, system tasks

var arrayDiskMenu=new Array()
var arrayDiskTasks=new Array()

// Common system tasks

var commonMenu=new Array()

// Disable email alert, logging and save/load wizards for now.
//commonMenu[0]='<img class="plain" src="/nvraid/images/mediaShield.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'email\')">Email Alerts</a>'
//commonMenu[1]='<img class="plain" src="/nvraid/images/mediaShield.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'logging\')">Logging</a>'
//commonMenu[2]='<img class="plain" src="/nvraid/images/mediaShield.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'saveload\')">Save/Load Settings</a>'

//
// systemTasksTableEnable - enable links in system task table
//

function systemTasksTableEnable () {
    // Hide mask pane and show tasks pane
    systemTasksMaskId.style.display = "none";
//    systemTasksTableId.style.display = "block";
    systemTasksTableId.style.filter = "";
    systemTasksTableId.style.opacity = "";

}

//
// systemTasksTableDisable - disable links in system task table
//

function systemTasksTableDisable () {

//to make the task table grey

    systemTasksMaskId.style.display = "block";
    systemTasksMaskId.style.zIndex = "50";
//    systemTasksTableId.style.display = "none";
    systemTasksTableId.style.filter = "alpha(opacity=60)";
    systemTasksTableId.style.opacity = "0.60";
}

//
// systemTasksTableSet - update system task table with menu options
//

function systemTasksTableSet(tableContent) {
    var output="<table class='borderless' align=center width=100%>";

    for (var j = 0; j < tableContent.length; j++) {
        output += "<tr><td class='regular'>" + tableContent[j] + "</tr></td>";
    }

    // Spacer row
    output += "<tr><td height=10 class='regular'></td></tr>";

    for (var j = 0; j < commonMenu.length; j++) {
        output += "<tr><td class='regular'>" + commonMenu[j]  + "</tr></td>";
    }

    output += "</table>";


    systemTasksTableId.innerHTML = output;
}

//
// freeDiskClick - handle mouse click event on a free disk
//

function freeDiskClick (aEvent) {
    var obj = this;
//    var targ;
    var freeTargetId; 
    var rc;

    var event = window.event?window.event:aEvent;


//    if (event.target) 
//    	targ = event.target;
//    else if (event.srcElement) 
//	targ = event.srcElement;
//    if (targ.nodeType == 3) // defeat Safari bug
//   	targ = targ.parentNode;
//    var tname;
//	tname=targ.tagName;
//    alert("cell is "+targ.cells.item(3));
//    alert("You clicked on a targetid"+ obj.id+" innerHTML"+targ.innerHTML+" rowindex"+targ.rowIndex+" sectionRowIndex"+targ.sectionRowIndex+" tabIndex"+targ.tabIndex+" outerText"+targ.outerText);
//    alert("You clicked on a targetid"+ obj.id);
//alert("You clicked on a target value"+ obj.value);
    freeDiskSelected=obj.id;
    arrayDiskSelected = "";
    if(prevSelected!="")
    	mainPaneDiskModify(prevSelected,"", "","regular");
    mainPaneDiskModify(obj.id,"", "","selected");
    prevSelected=freeDiskSelected;
     if(freeDiskSelected.match("fdhead")!=null){
        freeTargetId = "fdhead";
	data = "freeDiskId=" +  freeTargetId + "&";
    }
    else if(freeDiskSelected.match("free")!=null){
	freeTargetId = freeDiskSelected.substring(4,freeDiskSelected.length);
    	data = "freeDiskId=" +  freeTargetId + "&";
	} 
//  debugWrite("freediskselected is"+freeDiskSelected);
    debugWrite(data);
//    for(i=0; i<arrayDiskTasks.length; i++){
//	arrayDiskTasks[i] = "";
//    }
//    for(i=0; i<arrayDiskMenu.length; i++){
//	arrayDiskMenu[i] = "";
//    }
//    wizardRequest(updateSystemTasks, "?systemTasksGet", false, data);
    updateSystemTasks(obj.value);
//    rc = dropdownmenu(obj, event, arrayDiskMenu, '150px');
// FIXME: Disable details pane for now.
//clear existing detail pane timer 
//    if(detailIntervalId != ""){
//	window.clearInterval(detailIntervalId);	
//    }	
//    detailData = data;
//set detail pane timer, 2 seconds interval
//    detailIntervalId = window.setInterval("updateDetailsRequest(detailData)",2000);	
    systemTasksTableSet(arrayDiskTasks);	
    //systemTasksTableSet(freeDiskTasks);
    rc = dropdownmenu(obj, event, arrayDiskMenu, '150px');
    return rc;
}

//
// arrayDiskClick - handle mouse click event on an array disk
//

function arrayDiskClick (aEvent) {
    var obj = this;
//    var targ;
    var data;
    var arrayTargetId;
    var diskTargetId; 
    var i =0;	
    var rc;	

    //arrayDiskTasks[7] = "";
    var event = window.event?window.event:aEvent;

 
//    if (event.target) 
//    	targ = event.target;
//    else if (event.srcElement) 
//	targ = event.srcElement;
//    if (targ.nodeType == 3) // defeat Safari bug
//   	targ = targ.parentNode;
//    var tname;
//	tname=targ.tagName;
//    alert("cell is "+targ.cells.item(3));
//   alert("You clicked on a targetid"+ obj.id+" innerHTML"+targ.innerHTML+" rowindex"+targ.rowIndex+" sectionRowIndex"+targ.sectionRowIndex+" tabIndex"+targ.tabIndex+" outerText"+targ.outerText);
//     alert("You clicked on a targetid"+ obj.id);
//alert("You clicked on a target value"+ obj.value);	
    arrayDiskSelected=obj.id;
    freediskselected = "";
    if(prevSelected!="")
    	mainPaneDiskModify(prevSelected,"", "","regular");
    mainPaneDiskModify(obj.id,"", "","selected");
    prevSelected=arrayDiskSelected;
    debugWrite("arraydiskselected is"+arrayDiskSelected);
    if(arrayDiskSelected.match("array")!=null){
        arrayTargetId = arrayDiskSelected.substring(5,arrayDiskSelected.length);
	data = "arrayId=" +  arrayTargetId + "&";
    }
    else if(arrayDiskSelected.match("disk")!=null){
	arrayTargetId = arrayDiskSelected.substring(4,arrayDiskSelected.indexOf("."));
	data = "arrayId=" +  arrayTargetId + "&";
        diskTargetId =  arrayDiskSelected.substring(arrayDiskSelected.indexOf(".") + 1, arrayDiskSelected.length);
	data = data + "diskId=" + diskTargetId + "&";
	}    

//    for(i=0; i<arrayDiskTasks.length; i++){
//	arrayDiskTasks[i] = "";
//    }
//    for(i=0; i<arrayDiskMenu.length; i++){
//	arrayDiskMenu[i] = "";
//    }
    debugWrite(data);	
//    wizardRequest(updateSystemTasks, "?systemTasksGet", false, data);
    updateSystemTasks(obj.value);
//    rc = dropdownmenu(obj, event, arrayDiskMenu, '150px');
// FIXME: disable details pane for now.
//clear existing detail pane timer 
//    if(detailIntervalId != ""){
//	window.clearInterval(detailIntervalId);	
//    }	
//    detailData = data;
//set detail pane timer, 2 seconds interval
//    detailIntervalId = window.setInterval("updateDetailsRequest(detailData)",2000);	
    systemTasksTableSet(arrayDiskTasks);
    rc = dropdownmenu(obj, event, arrayDiskMenu, '150px');
    return rc;
}

//send a request to server to get information to display in detail pane
function updateDetailsRequest(data)
{
    wizardRequest(updateSystemDetails, "?systemUpdateDetails", false, data);
}


//function updateSystemTasks(req) {
//debugWrite("before status check 200");
//if (req.status == 200) {
//        debugWrite("before evaluate");
//         eval(req.responseText);
//	debugWrite("after evaluate");
//        
//    } else {
//        debugWrite("status is not 200");
	 // XXX
//    }
//}

function updateSystemTasks(mask){
var count = 0;

//clear system tasks before the update

for(i=0; i<arrayDiskTasks.length; i++){
arrayDiskTasks[i] = "";
}

for(i=0; i<arrayDiskMenu.length; i++){
arrayDiskMenu[i] = "";
}

if(mask&0x0001){
//rebuild
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/RebuildArray.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'rebuild\')">Rebuild Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'rebuild\'); return false;">Rebuild Array...</a>');
count++;
}
if(mask&0x0002){
//designate
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/AllocateDisk.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'designate\')">Designate Spare Disk</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'designate\'); return false;">Designate Spare Disk...</a>');
count++;       
}
if(mask&0x0004){
//diskremove
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/DeleteArray.gif"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'remove\')">Remove Spare Disk</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'remove\'); return false;">Remove Spare Disk...</a>');
count++;     
}
if(mask&0x0008){
//create
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/CreateArray.gif"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'create\')">Create Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'create\'); return false;">Create Array...</a>');
count++;
}
if(mask&0x0010){
//delete
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/DeleteArray.gif"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'delete\')">Delete Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'delete\'); return false;">Delete Array...</a>');
count++;
}
if(mask&0x0020){
//convert
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/RebuildArray.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'convert\')">Migrate Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'convert\'); return false;">Migrate Array...</a>');
count++;
}
if(mask&0x0040){
//hotplug
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/CreateArray.gif"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'hotplug\')">Hot Plug Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'hotplug\'); return false;">Hot Plug Array...</a>');
count++;
}
if(mask&0x0080){
//init
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/RebuildArray.jpg"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'init\')">Initialize Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'init\'); return false;">Initialize Array...</a>');
count++;
}
if(mask&0x0100){
//sync
arrayDiskTasks[count] = new Array('<img class="plain" src="/nvraid/images/CreateArray.gif"> <a class="plain" href="#" onclick="javascript:wizardLoad(\'synchronize\')">Synchronize Array</a>');
arrayDiskMenu[count] = new Array('<a href="" onclick="wizardLoad(\'synchronize\'); return false;">Synchronize Array...</a>');
count++;
}
}

function updateSystemDetails(req) {
if (req.status == 200) {
    var detailPaneId = getElementId("detailsPane");
        detailPaneId.innerHTML = req.responseText;
    } else {
	 // XXX
    }
}

//
// diskMouseOut - handle mouse out event on a disk
//

function diskMouseOut () {
    delayhidemenu()
}

//
// systemTasksOnLoad - load main pane with default content on initial load
//

function systemTasksOnLoad () {
    systemTasksTableId = getElementId("systemTasksTable");
    systemTasksMaskId = getElementId("systemTasksMask");
    mainPaneOnLoad(); 
   // if(mainPaneDiskFind("fdhead")!=""){
//there're free disks
//	freeDiskMenu[1]='<a href="" onclick="wizardLoad(\'create\'); return false;">Create Array...</a>';
//	freeDiskTasks[1]='<img class="plain" src="/nvraid/images/CreateArray.gif"> <a class="plain" href="javascript:wizardLoad(\'create\')">Create Array</a>';
//    }
    updateSystemTasks(noSelectionMask);
    systemTasksTableSet(arrayDiskTasks);
}

addEvent(window, "load", systemTasksOnLoad);

