#!/bin/bash
#############################################################
# Copyright 2005, All Rights Reserved, Matrox Graphics Inc. #
#############################################################


#############################################################
#
# Vars Setup Starts Here
#
#############################################################

TOP=`pwd`
ROOT=$TOP
BACKUP_SUFFIX="mgabak"
BACKUP_DIR=/usr/share/matrox
EXTENSION=".o"
RESTARTX=0
UNDO=0
RESTORE=0
OVERWRITE=0
XPRESENT=0
DISPLAYHELP=0
FAILEDCOMPILATION=0
INSTALLXDRIVER=0
INSTALLXHALDRIVER=0
INSTALLUSINGINSTALL=0
MD5SUMBIN=`which md5sum 2> /dev/null`
UNAME=`uname -m`
PACKAGEVERSION=`cat version.txt`
BLACK='\E[30m'
RED='\E[31m'
GREEN='\E[32m'
YELLOW='\E[33m'
BLUE='\E[34m'
MAGENTA='\E[35m'
CYAN='\E[36m'
WHITE='\E[37m'
if [ "$UNAME" = "x86_64" ]; then
    if test -d /usr/lib64 ; then
        LIBPATH=lib64
    else
        LIBPATH=lib
    fi
else
    LIBPATH=lib
fi
if test -e /usr/X11R6/$LIBPATH/modules/extensions/libxtrap.so; then
EXTENSION="so"
elif test -e /usr/$LIBPATH/xorg/modules/extensions/libxtrap.so; then
EXTENSION="so"
else
EXTENSION="o"
fi
PACKAGEVERSION=`cat version.txt`
if [ "$PACKAGEVERSION" = "" ]; then
    PACKAGEVERSION="Unknown"
fi


#############################################################
#
# Script Functions Start Here
#
#############################################################


function IsArch
{
    if [ "$UNAME" != "x86_64" ]; then
        if test -e x86_64; then
            echo "----------------------------------------------------------"
            echo -e "$RED\033[1mERROR\033[0m: \033[1mThis package is for intel based 64bit architecture.\033[0m"
            echo "----------------------------------------------------------"
            echo ""
            exit 1
        fi
    fi
    if [ "$UNAME" = "x86_64" ]; then
        if test -e x86_32; then
            echo "----------------------------------------------------------"
            echo -e "$RED\033[1mERROR\033[0m: \033[1mThis package is for intel based 32bit architecture.\033[0m"
            echo "----------------------------------------------------------"
            echo ""
            exit 1
        fi
    fi
}

function IsRoot
{
    # check for superuser mode
    if ! test -r /proc/kmsg ; then
        echo "---------------------------------------------------------"
        echo -e "$RED\033[1mERROR\033[0m: \033[1mYou must be logged in as Root to run this program.\033[0m"
        echo "---------------------------------------------------------"
        echo ""
        exit 1
    fi
}

function UseInstall
{
    WHEREIS=`whereis X 2> /dev/null`
    field=`echo $WHEREIS | grep -s '/usr/bin/install'`
    if [ "$field" != "" ]; then
        INSTALLUSINGINSTALL=1
    fi
}

function ParseOptions
{
    n=$#
    i=0
    for arg in $* ; do
        param=`echo $arg | cut -d'=' -f1`
        value=`echo $arg | cut -d'=' -f2`
        case $param in
            "-h") DISPLAYHELP=1 ;;
            "-root") ROOT=$value ;;
            "-uninstall") UNDO=1 ;;
            "-restore") RESTORE=1 ;;
            "-overwrite") OVERWRITE=1 ;;
        esac;
    done
}

function GetXPath
{
    XPRESENT=0
#    XPATH=`which X 2> /dev/null`

    WHEREIS=`whereis X 2> /dev/null`
    field=`echo $WHEREIS | grep -s '/usr/X11R6/bin/X'`
    if [ "$field" = "" ]; then
        XPATH=/usr
    else
        XPATH=/usr/X11R6
    fi

#    if [ $? -ne 0 ] ; then
#        XPATH="/usr/X11R6/bin/X"
#        if test -h $XPATH ; then
#            WHEREIS=`whereis X 2> /dev/null`
#            field=`echo $WHEREIS | grep -s '/usr/X11R6/bin/X'`
#            if [ $? -eq 0 ] ; then
#                XPATH="/usr/X11R6"
#            else
#                echo ""
#                echo "Please enter the full path to your current X11R6 directory: "
#                echo "Example: /usr/X11R6"
#                read XPATH
#            fi
#        else
#            echo -e "$RED\033[1mERROR\033[0m: \033[1mNo X server found.\033[0m"
#            echo ""
#            exit 1
#        fi
#    fi
    
    export XPATH
    
    if  test -z $XPATH ; then
        echo -e "$RED\033[1mERROR\033[0m: \033[1mThe X11R6 path could not be found. Please make"
        echo -e "       sure that an X server is installed.\033[0m"
        echo ""
        exit 1
    fi
}

function GetXVersion
{
    XVERSION=`X -version 2>&1 | grep -s "XFree86 Version" | cut -d" " -f3 | sed -e "s/\([^\.]*\.[^\.]*\.[^\.]*\)\.[^\.]*/\1/"`

    if test -z $XVERSION ; then 
        XVERSION=`X -version 2>&1 | grep -s "X Protocol Version" | sed -e "s/Revision[^0-9]*\([0-9]*\), Release[^0-9]*\([0-9.]*\)/\2\.\1/" | cut -d" " -f 5-`
    fi
    
    export XVERSION

    if ! test -e ./xserver/$XVERSION ; then
	    # HACK fix for SuSE 9.1
    	if [ "$XVERSION" = "4.3.99" ]; then
            XPRESENT=1
            XVERSION="6.7.0"
    	elif [ "$XVERSION" = "4.3.99.902" ]; then
            XPRESENT=1
            XVERSION="6.7.0"
    	# HACK fix for Distros that use XFree86 4.4.0
	    elif [ "$XVERSION" = "4.4.0" ]; then
	        XPRESENT=1
    	    XVERSION="6.7.0"
	    elif [ "$XVERSION" = "6.8.1.0" ]; then
	        XPRESENT=1
    	    XVERSION="6.8.1"
	    elif [ "$XVERSION" = "6.8.2.0" ]; then
	        XPRESENT=1
            XVERSION="6.8.2"
	    elif [ "$XVERSION" = "7.1.1" ]; then
	        XPRESENT=1
            XVERSION="7.1.0"
	    elif [ "$XVERSION" = "7.1.1.0" ]; then
	        XPRESENT=1
            XVERSION="7.1.0"
    	else
            echo -e "$RED\033[1mERROR\033[0m: \033[1mThe X server drivers included in this installation package"
            echo -e "       do not support the current version of your X server.\033[0m"
    	    echo ""
            exit 1
	    fi
    else
        XPRESENT=1
    fi
}

function SetXInstallPath
{
    if [ "$XPRESENT"="1" ]; then
        if test -d /usr/X11R6/$LIBPATH/modules/drivers; then
            export XINSTALLDIR=/usr/X11R6/$LIBPATH/modules/drivers
        elif test -d /usr/$LIBPATH/xorg/modules/drivers; then
            export XINSTALLDIR=/usr/$LIBPATH/xorg/modules/drivers
        else
            echo -e "$RED\033[1mERROR\033[0m: \033[1mCould not find X server driver install path.\033[0m"
            echo ""
            exit 1
        fi
    else
        echo -e "$RED\033[1mERROR\033[0m: \033[1mX server not present.\033[0m"
        echo ""
        exit 1
    fi
}

function SetFilenames
{
    export XDRIVER="mga_drv.$EXTENSION"
    export XHALDRIVER="mga_hal_drv.$EXTENSION"
}

function InstallXDriver
{
    if [ "$OVERWRITE" = "1" ]; then
        ####################################
        # Install the driver
        ####################################

        echo -e "\033[1mYou are about to install the X server driver,"
        echo -en "do you wish to continue\033[0m $YELLOW\033[1m(y/n)\033[0m\033[1m?\033[0m "
        read STRCONT 
        echo ""
        if [ $STRCONT = 'y' -o $STRCONT = 'Y' ]; then
    
            # copying driver file for XFree86 4.3.0
            if [ "$XVERSION" = "4.3.0" ]; then
                echo "Installing X server driver for XFree86 4.3.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/4.3.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/4.3.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/4.3.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/4.3.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.7.0
            if [ "$XVERSION" = "6.7.0" ]; then
                echo "Installing X server driver for X.org 6.7.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.7.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.7.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.7.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.7.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.0
            if [ "$XVERSION" = "6.8.0" ]; then
                echo "Installing X server driver for X.org 6.8.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.1
            if [ "$XVERSION" = "6.8.1" ]; then
                echo "Installing X server driver for X.org 6.8.1"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.1/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.1/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.1/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.1/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.2
            if [ "$XVERSION" = "6.8.2" ]; then
                echo "Installing X server driver for X.org 6.8.2"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.2/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.2/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.2/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.2/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.9.0
            if [ "$XVERSION" = "6.9.0" ]; then
                echo "Installing X server driver for X.org 6.9.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.9.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.9.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.9.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.9.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 7.0.0
            if [ "$XVERSION" = "7.0.0" ]; then
                echo "Installing X server driver for X.org 7.0.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/7.0.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/7.0.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/7.0.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/7.0.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 7.1.0
            if [ "$XVERSION" = "7.1.0" ]; then
                echo "Installing X server driver for X.org 7.1.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/7.1.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/7.1.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/7.1.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/7.1.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi
        else
            echo -e "\033[1mAborting X server driver installation.\033[0m"
            echo ""
        fi
    
    else

        #######################################
        # driver has been installed before
        #######################################
        if test -e $XINSTALLDIR/$XDRIVER ; then
    
            ####################################
            # Is there a backup dir
            ####################################
            if ! test -e $BACKUP_DIR ; then
            
                ####################################
                # No create it
                ####################################
                mkdir $BACKUP_DIR
    
                TEST1="`$MD5SUMBIN -b ./xserver/$XVERSION/$XDRIVER | cut -b 1-32`"
                if test -e $XINSTALLDIR/$XDRIVER ; then 
                    TEST2="`$MD5SUMBIN -b $XINSTALLDIR/$XDRIVER | cut -b 1-32`"
                else
                    TEST2=""
                fi
    
                ####################################
                # no backups create a new one
                ####################################
                if test -e $XINSTALLDIR/$XDRIVER ; then 
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Creating a new X server driver backup file"
                        echo "$XDRIVER.$BACKUP_SUFFIX in $BACKUP_DIR."
                        echo ""
                        mv $XINSTALLDIR/$XDRIVER $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                    fi
                fi
    
                ####################################
                # Install the driver
                ####################################
    
                # copying driver file for XFree86 4.3.0
                if [ "$XVERSION" = "4.3.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for XFree86 4.3.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/4.3.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/4.3.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi
        
                # copying driver file for X.org 6.7.0
                if [ "$XVERSION" = "6.7.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 6.7.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.7.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.7.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi
    
                # copying driver file for X.org 6.8.0
                if [ "$XVERSION" = "6.8.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 6.8.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi
    
                # copying driver file for X.org 6.8.1
                if [ "$XVERSION" = "6.8.1" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 6.8.1"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.1/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.1/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi

                # copying driver file for X.org 6.8.2
                if [ "$XVERSION" = "6.8.2" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 6.8.2"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.2/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.2/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi

                # copying driver file for X.org 6.9.0
                if [ "$XVERSION" = "6.9.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 6.9.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.9.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.9.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi

                # copying driver file for X.org 7.0.0
                if [ "$XVERSION" = "7.0.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 7.0.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/7.0.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/7.0.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi

                # copying driver file for X.org 7.1.0
                if [ "$XVERSION" = "7.1.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing X server driver for X.org 7.1.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/7.1.0/$XDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/7.1.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled driver is the same file as the installer"
                        echo -e "version, not installing driver file.\033[0m"
                        echo ""
                    fi
                fi

                TEST1="`$MD5SUMBIN -b ./xserver/$XVERSION/$XHALDRIVER | cut -b 1-32`"
                if test -e $XINSTALLDIR/$XHALDRIVER; then
                    TEST2="`$MD5SUMBIN -b $XINSTALLDIR/$XHALDRIVER | cut -b 1-32`"
                else
                    TEST2=""
                fi
    
                ####################################
                # no backups create a new one
                ####################################
                if test -e $XINSTALLDIR/$XHALDRIVER ; then 
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Creating a new X server driver backup file"
                        echo "$XHALDRIVER.$BACKUP_SUFFIX in $BACKUP_DIR."
                        echo ""
                        mv $XINSTALLDIR/$XHALDRIVER $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX
                    fi
                fi
                
                ####################################
                # Install the driver
                ####################################
    
                # copying hal driver file for XFree86 4.3.0
                if [ "$XVERSION" = "4.3.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for XFree86 4.3.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/4.3.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/4.3.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi
        
                # copying hal driver file for X.org 6.7.0
                if [ "$XVERSION" = "6.7.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 6.7.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.7.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.7.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi
    
                # copying hal driver file for X.org 6.8.0
                if [ "$XVERSION" = "6.8.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 6.8.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi
    
                # copying hal driver file for X.org 6.8.1
                if [ "$XVERSION" = "6.8.1" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 6.8.1"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.1/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.1/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi

                # copying hal driver file for X.org 6.8.2
                if [ "$XVERSION" = "6.8.2" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 6.8.2"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.8.2/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.8.2/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi

                # copying hal driver file for X.org 6.9.0
                if [ "$XVERSION" = "6.9.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 6.9.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/6.9.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/6.9.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi

                # copying hal driver file for X.org 7.0.0
                if [ "$XVERSION" = "7.0.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 7.0.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/7.0.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/7.0.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi

                # copying hal driver file for X.org 7.1.0
                if [ "$XVERSION" = "7.1.0" ]; then
                    if ! [ "$TEST1" = "$TEST2" ]; then
                        echo "Installing mga_hal_drv.o for X.org 7.1.0"
                        echo ""
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 xserver/7.1.0/$XHALDRIVER $XINSTALLDIR
                        else
                            cp -f xserver/7.1.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                        fi
                    else
                        echo -e "\033[1mInstalled file is the same as the installer"
                        echo -e "version, not installing the file.\033[0m"
                        echo ""
                    fi
                fi

    
            ####################################
            # Yes there is a backup dir
            ####################################
            else
    
                ####################################
                # Yes backup dir is there!
                # Is there a backup?
                ####################################
                if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then
    
                    ####################################
                    # Yes there is a backup!
                    # Is the same as the current file?
                    ####################################
                    if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX; then
                        TEST1="`$MD5SUMBIN -b $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX | cut -b 1-32`"
                    else
                        TEST1="TEST1"
                    fi
                    if test -e $XINSTALLDIR/$XDRIVER; then
                        TEST2="`$MD5SUMBIN -b $XINSTALLDIR/$XDRIVER | cut -b 1-32`"
                    else
                        TEST2="TEST1"
                    fi
    
                    if ! [ "$TEST1" = "$TEST2" ] ; then
    
                        ####################################
                        # No but is the current installed
                        # driver the same as the installer?
                        ####################################
                        TEST1="`$MD5SUMBIN -b ./xserver/$XVERSION/$XDRIVER | cut -b 1-32`"
                        if test -e $XINSTALLDIR/$XDRIVER; then
                            TEST2="`$MD5SUMBIN -b $XINSTALLDIR/$XDRIVER | cut -b 1-32`"
                        else
                            TEST2=""
                        fi
    
                        if [ "$TEST1" = "$TEST2" ]; then
    
                            ####################################
                            # Yes they are so do nothing
                            ####################################
                            echo -e "\033[1mCurrently installed driver is the same as the installer file."
                            echo -e "X server driver not installed.\033[0m"
                            echo ""
                            INSTALLXDRIVER=1
                        else
    
                            ####################################
                            # No they aren't so create a new 
                            # backup file
                            ####################################
                            CURRENTDATE=`date +%y%m%d%H%M%S`
                            if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX; then 
                                echo "Renaming current X server driver backup file"
                                echo "$XDRIVER.$CURRENTDATE in $BACKUP_DIR."
                                echo ""
                                mv $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $BACKUP_DIR/$XDRIVER.$CURRENTDATE
                            fi
                            
                            if test -e $XINSTALLDIR/$XDRIVER; then 
                                echo "Creating a new X server driver backup file"
                                echo "$XDRIVER.$BACKUP_SUFFIX in $BACKUP_DIR."
                                echo ""
                                mv $XINSTALLDIR/$XDRIVER $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                            fi
                            
                            if test -e $XINSTALLDIR/$XHALDRIVER; then 
                                echo "Creating a new X server driver backup file"
                                echo "$XHALDRIVER.$BACKUP_SUFFIX in $BACKUP_DIR."
                                echo ""
                                mv $XINSTALLDIR/$XHALDRIVER $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX
                            fi
                        fi
                    else
    
                        ####################################
                        # Yes so do nothing
                        ####################################
                        echo -e "\033[1mCurrent X server driver backup file is the same"
                        echo -e "as the currently installed file. No backups"
                        echo -e "created.\033[0m"
                        echo ""
                    fi

                    ####################################
                    # Yes there is a backup!
                    # Is the same as the current file?
                    ####################################
                    if test -e $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX; then
                        TEST8="`$MD5SUMBIN -b $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX | cut -b 1-32`"
                    else
                        TEST8="TEST8"
                    fi
                    if test -e $XINSTALLDIR/$XHALDRIVER; then
                        TEST9="`$MD5SUMBIN -b $XINSTALLDIR/$XHALDRIVER | cut -b 1-32`"
                    else
                        TEST9="TEST9"
                    fi
    
                    if ! [ "$TEST8" = "$TEST9" ] ; then
    
                        ####################################
                        # No but is the current installed
                        # driver the same as the installer?
                        ####################################
                        TEST1="`$MD5SUMBIN -b ./xserver/$XVERSION/$XHALDRIVER | cut -b 1-32`"
                        if test -e $XINSTALLDIR/$XHALDRIVER; then
                            TEST2="`$MD5SUMBIN -b $XINSTALLDIR/$XHALDRIVER | cut -b 1-32`"
                        else
                            TEST2=""
                        fi
    
                        if [ "$TEST1" = "$TEST2" ]; then
    
                            ####################################
                            # Yes they are so do nothing
                            ####################################
                            echo -e "\033[1mCurrently installed file is the same as the installer file."
                            echo -e "mga_hal_drv.o is not installed.\033[0m"
                            echo ""
                            INSTALLXDRIVER=1
                        else
                            if test -e $XINSTALLDIR/$XHALDRIVER; then
                                ####################################
                                # No they aren't so create a new 
                                # backup file
                                ####################################
                                CURRENTDATE=`date +%y%m%d%H%M%S`
                                if test -e $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX; then
                                    echo "Renaming current mga_hal_drv.o backup file"
                                    echo "to $XHALDRIVER.$CURRENTDATE in $BACKUP_DIR."
                                    echo ""
                                    mv $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $BACKUP_DIR/$XHALDRIVER.$CURRENTDATE
                                fi
                    
                                if test -e $XINSTALLDIR/$XHALDRIVER; then
                                    echo "Creating a new X mga_hal_drv.o backup file"
                                    echo "$XHALDRIVER.$BACKUP_SUFFIX in $BACKUP_DIR."
                                    echo ""
                                    mv $XINSTALLDIR/$XHALDRIVER $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX
                                fi
                            else
                                ####################################
                                # no files to backup. install it.
                                ####################################

                                # copying hal driver file for XFree86 4.3.0
                                if [ "$XVERSION" = "4.3.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for XFree86 4.3.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/4.3.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/4.3.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi
        
                                # copying hal driver file for X.org 6.7.0
                                if [ "$XVERSION" = "6.7.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 6.7.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/6.7.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/6.7.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi
    
                                # copying hal driver file for X.org 6.8.0
                                if [ "$XVERSION" = "6.8.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 6.8.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/6.8.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/6.8.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi
    
                                # copying hal driver file for X.org 6.8.1
                                if [ "$XVERSION" = "6.8.1" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 6.8.1"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/6.8.1/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/6.8.1/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi

                                # copying hal driver file for X.org 6.8.2
                                if [ "$XVERSION" = "6.8.2" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 6.8.2"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/6.8.2/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/6.8.2/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi

                                # copying hal driver file for X.org 6.9.0
                                if [ "$XVERSION" = "6.9.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 6.9.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/6.9.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/6.9.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi

                                # copying hal driver file for X.org 7.0.0
                                if [ "$XVERSION" = "7.0.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 7.0.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/7.0.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/7.0.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi

                                # copying hal driver file for X.org 7.1.0
                                if [ "$XVERSION" = "7.1.0" ]; then
                                    if ! [ "$TEST1" = "$TEST2" ]; then
                                        echo "Installing mga_hal_drv.o for X.org 7.1.0"
                                        echo ""
                                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                            install -p -m 755 xserver/7.1.0/$XHALDRIVER $XINSTALLDIR
                                        else
                                            cp -f xserver/7.1.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                                        fi
                                    else
                                        echo -e "\033[1mInstalled file is the same as the installer"
                                        echo -e "version, not installing the file.\033[0m"
                                        echo ""
                                    fi
                                fi
                            fi
                        fi
                    else
    
                        ####################################
                        # Yes so do nothing
                        ####################################
                        echo -e "\033[1mCurrent mga_hal_drv.o backup file is the same"
                        echo -e "as the currently installed file. No backups"
                        echo -e "created.\033[0m"
                        echo ""
                    fi

                else

                    ####################################
                    # no backups create a new on
                    # only if driver is not the same 
                    # file.
                    ####################################
                    TEST3="`$MD5SUMBIN -b ./xserver/$XVERSION/$XDRIVER | cut -b 1-32`"
                    if test -e $XINSTALLDIR/$XDRIVER; then
                        TEST4="`$MD5SUMBIN -b $XINSTALLDIR/$XDRIVER | cut -b 1-32`"
                    else
                        TEST4=""
                    fi

                    if [ "$TEST3" = "$TEST4" ]; then
                        echo -e "\033[1mCurrently installed driver is the same as the installer file."
                        echo -e "X server driver not installed.\033[0m"
                        echo ""
                        INSTALLXDRIVER=1
                    else
                        echo "Creating an X server driver backup file in $BACKUP_DIR."
                        echo ""
                        mv $XINSTALLDIR/$XDRIVER $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                    fi

                    ####################################
                    # no backups create a new on
                    # only if driver is not the same 
                    # file.
                    ####################################
                    TEST3="`$MD5SUMBIN -b ./xserver/$XVERSION/$XHALDRIVER | cut -b 1-32`"
                    if test -e $XINSTALLDIR/$XHALDRIVER; then
                        TEST4="`$MD5SUMBIN -b $XINSTALLDIR/$XHALDRIVER | cut -b 1-32`"
                    else
                        TEST4=""
                    fi

                    if [ "$TEST3" = "$TEST4" ]; then
                        echo -e "\033[1mCurrently installed file is the same as the installer file."
                        echo -e "mga_hal_drv.o is not installed.\033[0m"
                        echo ""
                        INSTALLXHALDRIVER=1
                    else
                        echo "Creating an X server driver backup file in $BACKUP_DIR."
                        echo ""
                        mv $XINSTALLDIR/$XHALDRIVER $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX
                    fi
                fi
    
                ####################################
                # Install the driver
                ####################################
                if [ "$INSTALLXDRIVER" = "0" ]; then
        
                    TEST5="`$MD5SUMBIN -b ./xserver/$XVERSION/$XDRIVER | cut -b 1-32`"
                    if test -e $XINSTALLDIR/$XDRIVER ; then
                        TEST6="`$MD5SUMBIN -b $XINSTALLDIR/$XDRIVER | cut -b 1-32`"
                    else
                        TEST6=""
                    fi
                    
                    # copying driver file for XFree86 4.3.0
                    if [ "$XVERSION" = "4.3.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for XFree86 4.3.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/4.3.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/4.3.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver file.\033[0m"
                            echo ""
                        fi
                    fi
            
                    # copying driver file for X.org 6.7.0
                    if [ "$XVERSION" = "6.7.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 6.7.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.7.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.7.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver file.\033[0m"
                            echo ""
                        fi
                    fi
            
                    # copying driver file for X.org 6.8.0
                    if [ "$XVERSION" = "6.8.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 6.8.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying driver file for X.org 6.8.1
                    if [ "$XVERSION" = "6.8.1" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 6.8.1"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.1/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.1/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying driver file for X.org 6.8.2
                    if [ "$XVERSION" = "6.8.2" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 6.8.2"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.2/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.2/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying driver file for X.org 6.9.0
                    if [ "$XVERSION" = "6.9.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 6.9.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.9.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.9.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying driver file for X.org 7.0.0
                    if [ "$XVERSION" = "7.0.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 7.0.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/7.0.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/7.0.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying driver file for X.org 7.1.0
                    if [ "$XVERSION" = "7.1.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing X server driver for X.org 7.1.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/7.1.0/$XDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/7.1.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled driver is the same file as the installer"
                            echo -e "version, not installing driver the file.\033[0m"
                            echo ""
                        fi
                    fi

                    TEST5="`$MD5SUMBIN -b ./xserver/$XVERSION/$XHALDRIVER | cut -b 1-32`"
                    if test -e $XINSTALLDIR/$XHALDRIVER ; then
                        TEST6="`$MD5SUMBIN -b $XINSTALLDIR/$XHALDRIVER | cut -b 1-32`"
                    else
                        TEST6="TEST6"
                    fi

                    # copying hal driver file for XFree86 4.3.0
                    if [ "$XVERSION" = "4.3.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for XFree86 4.3.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/4.3.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/4.3.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi
            
                    # copying hal driver file for X.org 6.7.0
                    if [ "$XVERSION" = "6.7.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 6.7.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.7.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.7.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi
            
                    # copying hal driver file for X.org 6.8.0
                    if [ "$XVERSION" = "6.8.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 6.8.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying hal driver file for X.org 6.8.1
                    if [ "$XVERSION" = "6.8.1" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 6.8.1"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.1/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.1/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying hal driver file for X.org 6.8.2
                    if [ "$XVERSION" = "6.8.2" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 6.8.2"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.8.2/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.8.2/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying hal driver file for X.org 6.9.0
                    if [ "$XVERSION" = "6.9.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 6.9.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/6.9.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/6.9.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying hal driver file for X.org 7.0.0
                    if [ "$XVERSION" = "7.0.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 7.0.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/7.0.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/7.0.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi

                    # copying hal driver file for X.org 7.1.0
                    if [ "$XVERSION" = "7.1.0" ]; then
                        if ! [ "$TEST5" = "$TEST6" ]; then
                            echo "Installing mga_hal_drv.o for X.org 7.1.0"
                            echo ""
                            if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                                install -p -m 755 xserver/7.1.0/$XHALDRIVER $XINSTALLDIR
                            else
                                cp -f xserver/7.1.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                            fi
                        else
                            echo -e "\033[1mInstalled file is the same file as the installer"
                            echo -e "version, not installing the file.\033[0m"
                            echo ""
                        fi
                    fi
                fi
            fi
    
        #######################################
        # driver hasn't been installed before
        #######################################
        else
    
            ####################################
            # Is there a backup dir
            ####################################
            if ! test -e $BACKUP_DIR ; then
    
                ####################################
                # No create it
                ####################################
                mkdir $BACKUP_DIR
            fi
            
            ####################################
            # Install the driver
            ####################################
    
            # copying driver file for XFree86 4.3.0
            if [ "$XVERSION" = "4.3.0" ]; then
                echo "Installing X server driver for XFree86 4.3.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/4.3.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/4.3.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/4.3.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/4.3.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi
    
            # copying driver file for X.org 6.7.0
            if [ "$XVERSION" = "6.7.0" ]; then
                echo "Installing X server driver for X.org 6.7.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.7.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.7.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.7.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.7.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.0
            if [ "$XVERSION" = "6.8.0" ]; then
                echo "Installing X server driver for X.org 6.8.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.1
            if [ "$XVERSION" = "6.8.1" ]; then
                echo "Installing X server driver for X.org 6.8.1"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.1/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.1/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.1/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.1/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.8.2
            if [ "$XVERSION" = "6.8.2" ]; then
                echo "Installing X server driver for X.org 6.8.2"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.8.2/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.8.2/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.8.2/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.8.2/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 6.9.0
            if [ "$XVERSION" = "6.9.0" ]; then
                echo "Installing X server driver for X.org 6.9.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/6.9.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/6.9.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/6.9.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/6.9.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 7.0.0
            if [ "$XVERSION" = "7.0.0" ]; then
                echo "Installing X server driver for X.org 7.0.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/7.0.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/7.0.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/7.0.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/7.0.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi

            # copying driver file for X.org 7.1.0
            if [ "$XVERSION" = "7.1.0" ]; then
                echo "Installing X server driver for X.org 7.1.0"
                echo ""
                if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                    install -p -m 755 xserver/7.1.0/$XDRIVER $XINSTALLDIR
                    install -p -m 755 xserver/7.1.0/$XHALDRIVER $XINSTALLDIR
                else
                    cp -f xserver/7.1.0/$XDRIVER $XINSTALLDIR/$XDRIVER
                    cp -f xserver/7.1.0/$XHALDRIVER $XINSTALLDIR/$XHALDRIVER
                fi
            fi
        fi
    fi
}

function Uninstall
{
    BACKUPS=0
    if test -e $BACKUP_DIR ; then
        if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then
             BACKUPS=1
        fi
        
        if [ "$BACKUPS" = "1" ] ; then
            echo -e "\033[1mDo you wish to uninstall or recover"
            echo -en "a backup or cancel \033[0m$YELLOW\033[1m(u/r/c)\033[0m? "
            read YESNOCANCEL
            echo ""
            if [ $YESNOCANCEL = 'u' -o $YESNOCANCEL = 'U' ]; then
                if test -e $XINSTALLDIR/$XDRIVER ; then 
                    echo "Uninstalling X driver"
                    rm -f $XINSTALLDIR/$XDRIVER
                fi

                echo ""
                echo "Uninstallation complete"
                echo ""

                echo -e "\033[1mDo you wish to restore a backup version"
                echo -en "(if available) \033[0m$YELLOW\033[1m(y/n)\033[0m? "
                read YESNOCANCEL
                echo ""
                if [ $YESNOCANCEL = 'y' -o $YESNOCANCEL = 'Y' ]; then
                    if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then 
                        echo "Restoring X driver"
                        if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                            install -p -m 755 $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                            install -p -m 755 $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                        else
                            cp -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XDRIVER
                            cp -f $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XHALDRIVER
                        fi
                        rm -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                        echo "Restoration complete"
                        exit 0
                    else
                        echo "No backup files to restore"
                        exit 0
                    fi
                fi
            fi

            if [ $YESNOCANCEL = 'r' -o $YESNOCANCEL = 'R' ]; then
                if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then 
                    echo "Restoring X driver"
                    if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                        install -p -m 755 $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                        install -p -m 755 $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                    else
                        cp -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XDRIVER
                        cp -f $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XHALDRIVER
                    fi
                    rm -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                    echo "Restoration complete"
                    exit 0
                else
                    echo "No backup files to restore"
                    exit 0
                fi
            fi

            echo "Canceling operation."
            echo ""
            exit 0
        else
            echo -e "\033[1mNo files were previous backed up,"
            echo -en "do you wish to uninstall \033[0m$YELLOW\033[1m(y/n)\033[0m? "
            read YESNOCANCEL
            echo ""
            if [ $YESNOCANCEL = 'y' -o $YESNOCANCEL = 'Y' ]; then
            if test -e $XINSTALLDIR/$XDRIVER ; then 
                    echo "Uninstalling X driver"
                    rm -f $XINSTALLDIR/$XDRIVER
                fi
                exit 0
            fi

            echo "Canceling operation."
            echo ""
            exit 0
        fi

    else
        echo -e "\033[1mNo files were previous backed up,"
        echo -en "do you wish to uninstall \033[0m$YELLOW\033[1m(y/n)\033[0m? "
        read YESNOCANCEL
        echo ""
        if [ $YESNOCANCEL = 'y' -o $YESNOCANCEL = 'Y' ]; then
            if test -e $XINSTALLDIR/$XDRIVER ; then 
                echo "Uninstalling X driver"
                rm -f $XINSTALLDIR/$XDRIVER
            fi
        fi

        echo "Canceling operation."
        echo ""
        exit 0
    fi
}

function Restore
{
    BACKUPS=0
    if test -e $BACKUP_DIR ; then
        if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then
             BACKUPS=1
        fi
        
        if [ "$BACKUPS" = "1" ] ; then
            echo -e "\033[1mDo you wish to restore a backup version"
            echo -en "(if available) \033[0m$YELLOW\033[1m(y/n)\033[0m? "
            read YESNOCANCEL
            echo ""
            if [ $YESNOCANCEL = 'y' -o $YESNOCANCEL = 'Y' ]; then
                if test -e $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX ; then 
                    echo "Restoring X driver"
                    if [ $INSTALLUSINGINSTALL -eq 1 ]; then
                        install -p -m 755 $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                        install -p -m 755 $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR
                    else
                        cp -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XDRIVER
                        cp -f $BACKUP_DIR/$XHALDRIVER.$BACKUP_SUFFIX $XINSTALLDIR/$XHALDRIVER
                    fi
                    rm -f $BACKUP_DIR/$XDRIVER.$BACKUP_SUFFIX
                    echo "Restoration complete"
                    exit 0
                else
                    echo "No backup files to restore"
                    exit 0
                fi
            fi

            echo "Canceling operation."
            echo ""
            exit 0
        else
            echo "No files to restore"
            echo ""
            exit 0
        fi
    else
        echo "No files to restore"
        echo ""
        exit 0
    fi
}


#############################################################
#
# Script Starts Here
#
#############################################################

clear
echo -e $GREEN"\033[1m"
echo "========================================"
echo "   Matrox Linux Driver Install Script   "
echo "========================================"
echo -e $GREEN"\033[0m"
echo "Installation package v$PACKAGEVERSION"
echo ""

#################################
# verify if user has root access
#################################
IsRoot

#################################
# verify if architecture is ok
#################################
IsArch

#################################
# verify if we can use install
#################################
UseInstall

#################################
# Parse command line options
#################################
ParseOptions $*

if [ "$DISPLAYHELP" = "1" ] ; then
    echo "Options :"
    echo ""
    echo "    -h            Displays this message."
    echo "    -overwrite    Used to force driver installation."
    echo "    -uninstall    Reinstalls a backup (if available) or"
    echo "                  uninstall the current driver."
    echo "    -restore      Reinstalls a backup (if available)"
    echo "                  the driver if none are available."
    echo ""
    exit 0
fi

if [ "$UNDO" = "1" ]; then

    #################################
    # Get installed X path
    #################################
    GetXPath
    
    #################################
    # Get installed X version
    #################################
    GetXVersion
    
    #################################
    # Set X install path
    #################################
    SetXInstallPath
    
    #################################
    # Setup File Vars
    #################################
    SetFilenames
    
    #################################
    # Uninstall
    #################################
    Uninstall
    exit 0

elif [ "$RESTORE" = "1" ]; then

    #################################
    # Get installed X path
    #################################
    GetXPath
    
    #################################
    # Get installed X version
    #################################
    GetXVersion
    
    #################################
    # Set X install path
    #################################
    SetXInstallPath
    
    #################################
    # Setup File Vars
    #################################
    SetFilenames
    
    #################################
    # Restore
    #################################
    Restore
    exit 0

else

    if [ "$OVERWRITE" = "1" ]; then
        echo -e "$RED\033[1mOverwrite option enabled."
        echo -e "No backups will be created.\033[0m"
        echo -en "\033[1mDo you wish to continue\033[0m $YELLOW\033[1m(y/n)\033[0m\033[1m?\033[0m "
        read STRCONT 
        echo ""
        if [ $STRCONT = 'n' -o $STRCONT = 'N' ]; then
            exit 1
        fi
        if [ $STRCONT = 'NO' -o $STRCONT = 'no' ]; then
            exit 1
        fi
    fi    

    #################################
    # Get installed X path
    #################################
    GetXPath
    
    #################################
    # Get installed X version
    #################################
    GetXVersion
    
    #################################
    # Set X install path
    #################################
    SetXInstallPath
    
    #################################
    # Setup File Vars
    #################################
    SetFilenames
    
    #################################
    # Install X server driver   
    #################################
    InstallXDriver

    exit 0
fi       
 
