#!/bin/sh
#

UTILS=`/bin/pwd`
MIBDIR=$UTILS"/Mibs"
IMDIR="/opt/mx"
MC="mcompile"
MXA="mxmib -a"
MXD="mxmib -d"
MODULES="hp-switch-pl"
####################################################################


####################################################################
# Functions
function ok {

  cd $IMDIR
  cd mibs
  echo "Deleting duplicate MIBs.  Ignore any error messages..."
  echo ""

  # Delete already registered mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MXD $name".mib" 1>&2
    fi
  done

  # The SIM compiler requires the filename match the module it defines.
  cp --reply=yes $MIBDIR/GbE2c-10G-L2L3.mib		hp-switch-pl.mib

  echo ""
  echo "Compiling MIBs..."
  echo ""

  # Compile mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MC $name".mib" 1>&2
    fi
  done

  echo ""
  echo "Importing MIBs to SIM..."
  echo ""

  # Register mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MXA $name".cfg" 1>&2
    fi
  done

  echo ""
  echo "MIB compilation and SIM import complete."

  errorlevel="0"
  echo ""
  echo "Restarting the Insight Manager service..."
  echo "Press ctrl-c to exit or press any key to continue..."
  read -n 1 wait
  echo ""
  echo "Stopping mx"
  mxstop
  echo "Starting mx"
  mxstart
  echo ""

}
readonly -f ok
declare -t ok
####################################################################


####################################################################
#Body
if test -d $IMDIR
then
  ok		#calls ok function
  exit 0	#exit with no errors
fi

echo ""
echo "=========================================================="
echo "Systems Insight Manager (SIM) installation not found at:"
echo $IMDIR
echo ""
echo "If SIM is installed elsewhere, edit this file to redefine"
echo "the IMDIR variable and then rerun this script."
echo "=========================================================="
echo ""
errorlevel="1"
exit 1		#exit with errors

