#! /bin/bash

conf_file=""
root_fs=""
boot_fs=""
kver=""
verbosity=1
force_install=0

root_part=""
boot_part=""

root_specified=
boot_specified=
boot_separate=0

script="INSTALL_ISCSI"

iboot_ver="4.1.26"
iboot_rel="1"
rpm_ver="$iboot_ver-$iboot_rel"

pkg="linux-iscsi-boot"
arch=`uname -i`
iscsi_src_rpm="$pkg-$rpm_ver.src.rpm"
iscsi_bin_rpm="$pkg-$rpm_ver.$arch.rpm"
spec="$pkg.spec"
iscsi_dir=""

#unfortunately setting to the > /dev/null 2>&1 does not work
#got to look at some other way to turn of message flood
redirect=""

tmpbdir="/tmp/iboot"

function usage()
{
	cat <<EOF
usage : install_iscsi -c </path/to/config> -s <dir/containing/srcrpm> [-f]
usage : install_iscsi --help
	--config|-c		absolute path of the configuration file
				containing iscsi mounted drives to be altered.
	--srcrpm|-s		absolute path to the directory containing 
				linux-iscsi-boot source rpm
	--force|-f		Forces the installation of iscsi rpm on target
				which has an iscsi instance.
	--verbose|-v		Turn on non error messages
	--help|-h		Display this usage message.
EOF

	exit $1
}

function cleanup()
{
	rmspec=$1
	pkgpath="/usr/src/redhat"

	[ -n $verbosity ] && echo "$script:Performing Cleanup"

	if [ -f /tmp/iboot.conf ];then
		rm -f /tmp/iboot.conf
	fi

	if [ -d /tmp/iboot ];then
		rm -rf /tmp/iboot
	fi

	if [ -f /tmp/$iscsi_src_rpm ];then
		rm -f /tmp/$iscsi_src_rpm
	fi

	if [ -f /etc/SuSE-release ];then
		pkgpath="/usr/src/packages"
	fi

	if [ -n "$rmspec" ];then
		rm -rf $pkgpath/BUILD/$pkg*
		rm -rf $pkgpath/SOURCES/$pkg*
		rm -rf $pkgpath/SPECS/$spec
	fi

	rm -rf $tmpbdir /tmp/iboot.tgz

	return 0
}

function append_string()
{
	local target=$1
	local addstring=$2
	local file=$3

	awk '
        {
                if (match($0, pattern)) {
                        replacement=pattern addstring;
                        gsub(pattern, replacement, $0);
                        print $0
                } else {
                        print $0;
                }
        }' pattern=$target addstring=$addstring $file > /tmp/append.out

	mv /tmp/append.out $file

	return 0

}

function build_rpm()
{
	local bin_pack=""
	local pack=""
	local ppath="/usr/src/redhat"
	local ver=""
	local exlist=""
	local ddlist=""

	#Install the linux-iscsi rpm on the target
	[ -n $verbosity ] && echo "$script:installing iscsi rpm"

	cp -f $iscsi_dir/$iscsi_src_rpm /tmp
	rpm -i /tmp/$iscsi_src_rpm $redirect
	if [ $? -ne 0 ];then
		cleanup  
		echo "Unable to install $iscsi_src_rpm"
		return 1
	fi

	if [ -f /etc/SuSE-release ]; then
		ppath="/usr/src/packages"
		iscsi_bin_rpm=`echo $iscsi_bin_rpm | sed s:i386:i586:`
	fi
	
	#Check for pre-requisite RPM
	ver=`echo $kver | cut -c1-3`
	if [ "$ver" = "2.6" -a -f /etc/redhat-release ];then
		rpm -q sysfsutils-devel
		if [ $? -ne 0 ];then
			cleanup
			echo "sysfsutils-devel package not installed"
			return 1
		fi
	fi

	append_string "KVER=" "$kver" $ppath/SPECS/$spec

	#prepare iboot.tgz for future builds of initrd
	mkdir $tmpbdir	
	tar -C $tmpbdir -zxf $ppath/SOURCES/$pkg-$iboot_ver.tar.gz
	ddlist=`find $tmpbdir -name "*.dd" -exec basename '{}' ';' |
			awk '{printf("%s ", $0)}'`
	for file in $ddlist;do
		exlist="$exlist --exclude $file"
	done
	tar -C /tmp $exlist -zcf /tmp/iboot.tgz iboot

	#build the binary
	rpmbuild --clean --rmsource --rmspec \
			-bb $ppath/SPECS/$spec $redirect
	if [ $? -ne 0 ];then
		cleanup "extra"
		echo "Unable to build $iscsi_bin_rpm"
		return 1
	fi

	pack=`find $ppath -name "$iscsi_bin_rpm" -print`
	bin_pack=`echo $pack | sed s:/*tmp/root/::`

	
	#Verify if the concerned package already exits on the target,if not
	#go ahead with installation
	rpm -q $pkg > /dev/null
	if [ $? -eq 0 ];then
		if [ $force_install -ne 1 ];then
			echo "An instance of $pkg is alredy installed."
			echo "Uninstall this and try again or use"
			echo "--force|-f option to force the installation."
			return 1;
		else
			export NOCHECK=1
			rpm -e $pkg
			unset NOCHECK
		fi
	fi

	rpm -i --replacefiles $bin_pack  $redirect
	if [ $? -ne 0 ];then
		cleanup  
		echo "Unable to install $iscsi_bin_rpm"
		return 1
	fi

	#install the iboot tar file built earlier
	install -D /tmp/iboot.tgz /opt/hp/iboot/src/iboot.tgz
	rm -rf $tmpbdir /tmp/iboot.tgz

	return 0
}

function process_records()
{

	#Verfiy we have a valid conf file
	if [ ! -f /tmp/iboot.conf ];then
		echo "/tmp/iboot.conf was not generated"
		return 1
	fi

	#build the rpm on the target
	build_rpm
	if [ $? -ne 0 ];then
		return $?
	fi

	#Get going 
	[ -n $verbosity ] && echo "$script:Executing helper script"
	/opt/hp/iboot/bin/iboot_config  --config /tmp/iboot.conf
	if [ $? -ne 0 ];then
		cleanup  
		echo "Unable to execute helper script"
		return 1
	fi

	cleanup 

	return 0
}

function parse_config_file() 
{
	local file_touched=0
	local process=0
	local left=
	local right=

	while read line ;do
	if [ ! -z "$line" ];then
		echo $line | egrep "^#"
		if [ $? -ne 0 ];then
			left=`echo $line | cut -d "=" -f1`	
			right=`echo $line | cut -d "=" -f2`	

			if [ "$left" = "ROOT_PARTITION" ];then
				root_part=$right;
				process=1
			fi

			if [ "$left" = "ROOT_FS" ];then
				root_fs=$right;
			fi

			if [ "$left" = "BOOT_PARTITION" ];then
				boot_part=$right;
			fi

			if [ "$left" = "KVER" ];then
				kver=$right;
			fi

			if [ "$left" = "BOOT_FS" ];then
				boot_fs=$right;
			fi

			if [ $file_touched -eq 0 ];then
				echo $line > /tmp/iboot.conf
				file_touched=1
			else
				echo $line >> /tmp/iboot.conf
			fi
		fi
	fi

	#the script expects the records for targets to be 
	#separated by white lines
	if [ -z "$line" ] && [ $process -eq 1 ];then
		process_records
		if [ $? -ne 0 ];then
			echo "Failed to process a Target Record..aborting"
		fi
		process=0
		file_touched=0
	fi
	done < $conf_file

	#if we have only one target record and we don't have a empty 
	#line at the end
	if [ -z "$line" ] && [ $process -eq 1 ];then
		process_records
		if [ $? -ne 0 ];then
			echo "Failed to process a Target Record..aborting"
		fi
	fi

	return 0
}

#############################################################

if [ $# -eq 0 ]; then
	usage 1
fi

extra_args=0
show_help=0

while [ $# -gt 0 ]; do
    case $1 in
	--config|-c)
    	if [ -z "$2" ]; then
		usage 1
	else
		conf_file=$2
		extra_args=1
	fi
	shift 2
	;;
	--srcrpm|-s)
	if [ -z "$2" ];then
		usage 1
	else
		iscsi_dir=$2
		extra_args=1
	fi
	shift 2
	;;
	--force|-f)
	force_install=1
	extra_args=1
	shift 1
	;;
	--verbose|-v)
	verbosity=1
	extra_args=1
	shift 1
	;;
	--help|-h)
	   show_help=1
	   shift 1
	   ;;
	 *)
	    usage 1
	    ;;
    esac
done

if [ $show_help -eq 1 -a $extra_args -eq 1 ]; then
	usage 1
elif [ $show_help -eq 1 ]; then
	usage 0
fi
 
if [ -z "$conf_file" -o  ! -s "$conf_file" ]; then
	echo "Invalid Config file"
	usage 1
fi

if [ -z "$iscsi_dir" -o  ! -s "$iscsi_dir/$iscsi_src_rpm" ]; then
	echo "Could not find $iscsi_src_rpm"
	usage 1
fi


parse_config_file
ret=$?

if [ $ret -ne 0 ];then
echo "Errors encountered...abnormal exit"
exit 1
fi

exit 0
