#!/bin/bash

##### main #####

if [ $# -eq 1 ]
then
	IBOOT_CONFIG=$1
else
	echo "usage: $0 <config file>"
	exit 1
fi

if [ ! -f $IBOOT_CONFIG ]
then
	echo "Error: $IBOOT_CONFIG: File not found"
	exit 1
fi

. $IBOOT_CONFIG

KERNEL=`echo $KVER | cut -c1-3`
if [ "$KERNEL" != "2.4" ] && [ "$KERNEL" != "2.6" ]
then
	echo "Error: Config file contains wrong kernel version!!"
	exit 1
fi

echo "Setting up the Kernel Tree..."
cd /lib/modules/$KVER/build

if [ -f /etc/redhat-release ]
then
	if [ "$KERNEL" = "2.4" ]
	then
		make mrproper
		cp /boot/config-$KVER .config
		make oldconfig
		make dep
	fi
elif [ -f /etc/SuSE-release ]
then
	make mrproper
	cp /boot/config-$KVER .config
	make oldconfig
	make modules_prepare	
else
	echo "Error: I don't know this kernel"
	exit 1;
fi
exit 0
