/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.nodemanager;

import com.hp.mx.core.nodemanager.DeviceTypesIfc;
import com.hp.mx.utilities.simenum.MxDynamicPersistedMap;
import com.hp.mx.utilities.simenum.MxEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class NodeTypeMapper
extends MxDynamicPersistedMap
implements DeviceTypesIfc {
    private static NodeTypeMapper ourDefaultMapper;
    private static List ourOverviewPageServerTypes;
    private static List ourOverviewPageClusterTypes;
    private static List ourOverviewPagePrinterTypes;
    private static List ourOverviewPageNetworkingTypes;
    private static List ourOverviewPageOtherTypes;
    private static List ourOverviewPageClientTypes;
    public static final int PROD_TYPE_CLASS_SVR = 1;
    public static final int PROD_TYPE_CLASS_CLUS = 2;
    public static final int PROD_TYPE_CLASS_PRINT = 3;
    public static final int PROD_TYPE_CLASS_NET = 4;
    public static final int PROD_TYPE_CLASS_CLIENT = 5;
    public static final int PROD_TYPE_CLASS_OTHER = 6;
    public static MxEnum COMPLEX_TYPE;
    public static MxEnum HANDHELD_TYPE;
    public static MxEnum PARTITION_TYPE;
    public static MxEnum POWERSUPPLY_TYPE;
    public static MxEnum THINCLIENT_TYPE;
    public static MxEnum STORAGE_TYPE;
    public static MxEnum TAPELIB_TYPE;
    public static MxEnum SHARED_RES_DOM_TYPE;
    public static MxEnum RES_PART_TYPE;
    public static MxEnum GEN_APP_TYPE;
    public static MxEnum VC_DOMAIN;
    public static MxEnum IO_EXPANSION;

    public static synchronized NodeTypeMapper getDefaultMapper() {
        if (ourDefaultMapper == null) {
            ourDefaultMapper = new NodeTypeMapper();
            MxEnum curEnum = null;
            curEnum = ourDefaultMapper.addPersistedMap("Unmanaged", 0, "Unmanaged", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Server", 1, "Server", Locale.ENGLISH);
            NodeTypeMapper.addServerOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Desktop", 2, "Desktop", Locale.ENGLISH);
            NodeTypeMapper.addClientOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Workstation", 3, "Workstation", Locale.ENGLISH);
            NodeTypeMapper.addClientOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Portable", 4, "Notebook", Locale.ENGLISH);
            NodeTypeMapper.addClientOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Router", 5, "Router", Locale.ENGLISH);
            NodeTypeMapper.addNetworkingOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Cluster", 6, "Cluster", Locale.ENGLISH);
            NodeTypeMapper.addClusterOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Printer", 7, "Printer", Locale.ENGLISH);
            NodeTypeMapper.addPrinterOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Switch", 8, "Switch", Locale.ENGLISH);
            NodeTypeMapper.addNetworkingOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Hub", 9, "Hub", Locale.ENGLISH);
            NodeTypeMapper.addNetworkingOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("RAS", 10, "Remote Access Device", Locale.ENGLISH);
            NodeTypeMapper.addNetworkingOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Unknown", 11, "Unknown", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("MgmtProc", 12, "Management Processor", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Rack", 13, "Rack", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Enclosure", 14, "Enclosure", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("KVM", 15, "KVM Switch", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("UPS", 16, "UPS", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("PDU", 17, "Power Distribution Unit", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
            curEnum = ourDefaultMapper.addPersistedMap("Env", 18, "Environmental Monitor", Locale.ENGLISH);
            NodeTypeMapper.addOtherOverviewType(curEnum);
        }
        return ourDefaultMapper;
    }

    protected MxEnum addPersistedMap(String label, String displayStr, Locale locale, int overviewClass) {
        MxEnum theEnum = this.addPersistedMap(label, displayStr, locale);
        switch (overviewClass) {
            case 1: {
                NodeTypeMapper.addServerOverviewType(theEnum);
                break;
            }
            case 2: {
                NodeTypeMapper.addClusterOverviewType(theEnum);
                break;
            }
            case 3: {
                NodeTypeMapper.addPrinterOverviewType(theEnum);
                break;
            }
            case 4: {
                NodeTypeMapper.addNetworkingOverviewType(theEnum);
                break;
            }
            case 5: {
                NodeTypeMapper.addClientOverviewType(theEnum);
                break;
            }
            default: {
                NodeTypeMapper.addOtherOverviewType(theEnum);
            }
        }
        return theEnum;
    }

    protected NodeTypeMapper() {
    }

    protected String getDbTableName() {
        return "NodeTypesEnum";
    }

    public static List getServerOverviewTypes() {
        return new ArrayList(ourOverviewPageServerTypes);
    }

    public static void addServerOverviewType(MxEnum curEnum) {
        ourOverviewPageServerTypes.add(new Integer(curEnum.getOrdinal()));
    }

    public static List getClusterOverviewTypes() {
        return new ArrayList(ourOverviewPageClusterTypes);
    }

    public static void addClusterOverviewType(MxEnum curEnum) {
        ourOverviewPageClusterTypes.add(new Integer(curEnum.getOrdinal()));
    }

    public static List getPrinterOverviewTypes() {
        return new ArrayList(ourOverviewPagePrinterTypes);
    }

    public static void addPrinterOverviewType(MxEnum curEnum) {
        ourOverviewPagePrinterTypes.add(new Integer(curEnum.getOrdinal()));
    }

    public static List getNetworkingOverviewTypes() {
        return new ArrayList(ourOverviewPageNetworkingTypes);
    }

    public static void addNetworkingOverviewType(MxEnum curEnum) {
        ourOverviewPageNetworkingTypes.add(new Integer(curEnum.getOrdinal()));
    }

    public static List getClientOverviewTypes() {
        return new ArrayList(ourOverviewPageClientTypes);
    }

    public static void addClientOverviewType(MxEnum curEnum) {
        ourOverviewPageClientTypes.add(new Integer(curEnum.getOrdinal()));
    }

    public static List getOtherOverviewTypes() {
        return new ArrayList(ourOverviewPageOtherTypes);
    }

    public static void addOtherOverviewType(MxEnum curEnum) {
        ourOverviewPageOtherTypes.add(new Integer(curEnum.getOrdinal()));
    }

    static {
        ourOverviewPageServerTypes = new ArrayList();
        ourOverviewPageClusterTypes = new ArrayList();
        ourOverviewPagePrinterTypes = new ArrayList();
        ourOverviewPageNetworkingTypes = new ArrayList();
        ourOverviewPageOtherTypes = new ArrayList();
        ourOverviewPageClientTypes = new ArrayList();
        COMPLEX_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("Complex", "Complex", Locale.ENGLISH, 6);
        HANDHELD_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("Handheld", "Handheld", Locale.ENGLISH, 5);
        PARTITION_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("Partition", "Partition", Locale.ENGLISH, 6);
        POWERSUPPLY_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("PowerSupply", "Power Supply", Locale.ENGLISH, 6);
        THINCLIENT_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("ThinClient", "Thin Client", Locale.ENGLISH, 5);
        STORAGE_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("Storage", "Storage Device", Locale.ENGLISH, 6);
        TAPELIB_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("TapeLibrary", "Tape Library", Locale.ENGLISH, 6);
        SHARED_RES_DOM_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("SRD", "Shared Resource Domain", Locale.ENGLISH, 6);
        RES_PART_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("RESPAR", "Resource Partition", Locale.ENGLISH, 6);
        GEN_APP_TYPE = NodeTypeMapper.getDefaultMapper().addPersistedMap("Application", "Application", Locale.ENGLISH, 6);
        VC_DOMAIN = NodeTypeMapper.getDefaultMapper().addPersistedMap("VCDomain", "Virtual Connect Domain", Locale.ENGLISH, 6);
        IO_EXPANSION = NodeTypeMapper.getDefaultMapper().addPersistedMap("IOExpansion", "IO Expansion", Locale.ENGLISH, 6);
    }
}

