/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.discovery;

import com.hp.mx.core.authorizationmanager.MxUnauthorizedUserException;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxDuplicateNodeException;
import com.hp.mx.core.nodemanager.MxInvalidNodeNameException;
import com.hp.mx.core.nodemanager.MxInvalidNodeOperationException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxNodeIsNotLockedException;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodePinger;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.protocol.dns.InetXe;
import com.hp.mx.core.subjects.usermanager.MxInvalidUserException;
import com.hp.mx.core.subjects.usermanager.MxUndefinedUserException;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.nodesecurity.MxCredential;
import com.hp.mx.nodesecurity.MxNodeAccessController;
import com.hp.mx.nodesecurity.MxNodeAccessControllerFactory;
import com.hp.mx.nodesecurity.MxProtocolException;
import com.hp.mx.portal.lm.lmBean;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DiscoverySystemResolver {
    private static Integer syncAdds = new Integer(0);
    private MxNode deviceByGUID;
    private MxNode deviceByAddress;
    private String addressUsed;
    private MxNode deviceByName;
    private String dnsName;
    private String shortHostName;
    private MxNode sourceNode;
    private boolean isCmsAdd = false;
    private boolean isPassedInNameFullDns = false;
    private boolean isAutoDiscovery = false;
    private static final String OTHER_HOST_NAME = "OtherHostName";
    private boolean haveSameHostNameDiffDomain = false;
    private static DebugSubsystem myDebug = new DebugSubsystem(DiscoverySystemResolver.class);
    private static MxNodeAccessController ourNodeAccessController = null;

    public void setIsCmsNodeResolving() {
        this.isCmsAdd = true;
    }

    public void setIsAutoDiscovery() {
        this.isAutoDiscovery = true;
    }

    public DiscoverySystemResolver(MxNode sourceNode) {
        this.setNodeToResolve(sourceNode);
    }

    private void setNodeToResolve(MxNode sourceNode) {
        this.sourceNode = sourceNode;
        this.dnsName = sourceNode.getHostName();
        this.shortHostName = sourceNode.getDiscoveredName() != null && sourceNode.getDiscoveredName().toString().length() > 0 ? sourceNode.getDiscoveredName().toString() : sourceNode.getNameString();
        this.deviceByGUID = null;
        this.deviceByName = null;
        this.deviceByAddress = null;
        myDebug.log(10, "Discovery Resolver called with a hostname of " + this.shortHostName + " FQDN of " + this.dnsName + " and address of " + sourceNode.getWorkingAddress());
        if (this.dnsName != null) {
            int dotPos = this.dnsName.indexOf(46);
            boolean isValidIp = InetXe.isValidIp((String)this.dnsName);
            if (!isValidIp && dotPos > 0) {
                this.isPassedInNameFullDns = true;
            }
        }
    }

    public MxNode startNodeResolving() {
        MxNode theDiscoveredDevice = this.resolveByIdentifiers();
        if (this.sourceNode.getIPAddressList().size() > 1) {
            myDebug.finer("Requested node has more than one IP, move the others over");
            Iterator ipIter = this.sourceNode.getIPAddressList().iterator();
            String curAddress = (String)ipIter.next();
            while (ipIter.hasNext()) {
                curAddress = (String)ipIter.next();
                myDebug.finer("Searching for system by address {0} ", new Object[]{curAddress});
                try {
                    MxNode tmpDev = MxNodeController.getDefaultControllerNoEx().getNodeByIPAddress(curAddress);
                    myDebug.finer("Found system by address {0} ", new Object[]{curAddress});
                    if (tmpDev == null || theDiscoveredDevice.getKey() == this.sourceNode.getKey()) continue;
                    myDebug.warning("Moving IPs to resolved node, source has > 1 IP {0} ", new Object[]{curAddress});
                    this.moveAddressFromDeviceOneToDeviceTwo(tmpDev, theDiscoveredDevice, curAddress);
                }
                catch (MxUndefinedNodeException ex) {
                    myDebug.finer("Not found so add this IP to the current system ");
                    theDiscoveredDevice.addIPAddress(curAddress);
                    try {
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theDiscoveredDevice, false);
                    }
                    catch (MxException ex2) {
                        myDebug.exception((Throwable)ex2);
                    }
                }
                catch (Exception ex) {
                    myDebug.exception((Throwable)ex);
                }
            }
        } else if (this.sourceNode.getWorkingAddress() != null && theDiscoveredDevice.getWorkingAddress() != null && this.sourceNode.getWorkingAddress().length() > 0 && !theDiscoveredDevice.getWorkingAddress().equals(this.sourceNode.getWorkingAddress())) {
            myDebug.fine("Resolved nodes primary IP not same as passed in nodes primary IP, moving it over");
            theDiscoveredDevice.setPrimaryIPAddress(this.sourceNode.getWorkingAddress());
        }
        return theDiscoveredDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MxNode resolveByIdentifiers(MxNode curNode, DeviceIdentificationData devIDData) {
        this.sourceNode = curNode;
        this.deviceByAddress = curNode;
        if (this.sourceNode.getWorkingAddress() != null) {
            this.addressUsed = this.sourceNode.getWorkingAddress();
        }
        Integer n = syncAdds;
        synchronized (n) {
            this.deviceByName = this.findDeviceByName();
            myDebug.finer("In resolveByIdentifiers of Discovery Resolver " + this.sourceNode.getWorkingAddress() + " name " + this.shortHostName);
            this.sourceNode = curNode;
            MxNode foundNodeByNormUniqueId = null;
            myDebug.fine("<<<<------------ searchNodeByUniqueIDENT: dev=" + this.sourceNode.getDebugString() + " -------->>>>");
            boolean foundIt = false;
            CopyOnWriteArrayList normUniqueIDENTList = devIDData.getNormUniqueIDENTList();
            String uniqueIDENTStr = null;
            if (normUniqueIDENTList.size() > 0) {
                for (String eachUniqueIDENT : normUniqueIDENTList) {
                    if (eachUniqueIDENT == null || eachUniqueIDENT.equals("")) {
                        myDebug.fine("  ---???---> one of unique identifier in the list is null or blank");
                        continue;
                    }
                    eachUniqueIDENT = eachUniqueIDENT.trim();
                    myDebug.fine("    <--- for each uniqueIDENT='" + eachUniqueIDENT + "' --->");
                    if (uniqueIDENTStr == null) {
                        uniqueIDENTStr = eachUniqueIDENT;
                    }
                    try {
                        foundNodeByNormUniqueId = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(eachUniqueIDENT);
                        myDebug.fine("  --> found uniqueIDENT from db fordevice=" + this.sourceNode.getDebugString());
                    }
                    catch (MxUndefinedNodeException ex3) {
                        myDebug.fine("   --->device=" + this.sourceNode.getDebugString() + ", has uniqueIDENT=" + eachUniqueIDENT + ", but not found in DB - checking more ");
                    }
                }
            }
            MxNode foundNodeByUUID = null;
            String agentIdStr = null;
            List uniqIdList = devIDData.getAgentUUIDList();
            if (uniqIdList.size() > 0) {
                myDebug.fine("<<<<------------ searchNodeByAgentUUID: dev=" + this.sourceNode.getDebugString() + " -------->>>>");
                for (String curUUID : uniqIdList) {
                    curUUID = curUUID.trim();
                    myDebug.fine("    <--- for each agent UUID=" + curUUID + "--->");
                    if (agentIdStr == null) {
                        agentIdStr = curUUID;
                    }
                    try {
                        foundNodeByUUID = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(curUUID);
                        myDebug.fine("  --> found agentUUID from db fordevice=" + this.sourceNode.getDebugString());
                        break;
                    }
                    catch (MxUndefinedNodeException ex3) {
                        myDebug.fine("   ???--->device=" + this.sourceNode.getDebugString() + ", has agent UUID=" + curUUID + ", but not found in DB - checking more ");
                    }
                }
            }
            if (this.deviceByName != null && foundNodeByNormUniqueId == null && foundNodeByUUID == null) {
                if (this.checkForDifferentIdentifiers(this.deviceByName.getUniqueIdentifier(), uniqueIDENTStr) || this.checkForDifferentIdentifiers(this.deviceByName.getAgentUUID(), agentIdStr)) {
                    MxNode theDiscoveredDevice;
                    myDebug.fine("Have device with different UUID than in DB by name - create new ");
                    if (this.sourceNode.getWorkingAddress() != null) {
                        this.assignAddressAsNameToDevice(this.sourceNode.getWorkingAddress(), this.sourceNode);
                    } else {
                        this.assignNameToOldDevice(this.createOrphanName(this.sourceNode), this.sourceNode);
                    }
                    this.deviceByGUID = theDiscoveredDevice = this.createNewDevice(this.sourceNode, true);
                    this.deviceByGUID = this.handleDeviceByIdentierResolving();
                } else {
                    myDebug.fine("Have device, not found by any UUID, see if need to set one, etc");
                    this.deviceByGUID = this.deviceByName;
                }
            } else if (foundNodeByNormUniqueId != null && foundNodeByUUID == null) {
                this.deviceByGUID = foundNodeByNormUniqueId;
                this.deviceByGUID = this.handleDeviceByIdentierResolving();
            } else if (foundNodeByNormUniqueId == null && foundNodeByUUID != null) {
                this.deviceByGUID = foundNodeByUUID;
                this.deviceByGUID = this.handleDeviceByIdentierResolving();
            } else if (foundNodeByNormUniqueId != null && foundNodeByUUID != null) {
                if (foundNodeByNormUniqueId.getKey() != foundNodeByUUID.getKey()) {
                    myDebug.panic("Have found two by guids, not same nodes ");
                }
                this.deviceByGUID = foundNodeByNormUniqueId;
                this.deviceByGUID = this.handleDeviceByIdentierResolving();
            } else {
                this.deviceByGUID = this.sourceNode;
            }
            if (uniqueIDENTStr != null && (this.deviceByGUID.getUniqueIdentifier() == null || this.deviceByGUID.getUniqueIdentifier().length() == 0)) {
                this.deviceByGUID.setUniqueIdentifier(uniqueIDENTStr);
                myDebug.fine("  <<===>>> set uniqueIdentifier to " + uniqueIDENTStr + " in db for device=" + this.deviceByGUID.getDebugString());
            } else {
                String currentUniqueIDENT = this.deviceByGUID.getUniqueIdentifier();
                if (currentUniqueIDENT != null && uniqueIDENTStr != null && !currentUniqueIDENT.equalsIgnoreCase(uniqueIDENTStr)) {
                    this.deviceByGUID.setUniqueIdentifier(uniqueIDENTStr);
                    myDebug.panic("  <<<?????>>> unique identifier for dev=" + this.deviceByGUID.getDebugString() + ", is not the same.  current=" + currentUniqueIDENT + ", found by identification=" + uniqueIDENTStr);
                }
            }
            if (agentIdStr != null && (this.deviceByGUID.getAgentUUID() == null || this.deviceByGUID.getAgentUUID().length() == 0)) {
                this.deviceByGUID.setAgentUUID(agentIdStr);
                myDebug.fine("  ---> set agentUUID to=" + agentIdStr + ", for dev=" + this.deviceByGUID.getDebugString());
                String agentNormUniqueIDENT = UniqueIdentifierUtility.normalizeUniqueID((String)agentIdStr, (boolean)true, (boolean)true);
                String normUniqueIDENT = this.deviceByGUID.getUniqueIdentifier();
                if (normUniqueIDENT == null || normUniqueIDENT.length() == 0) {
                    this.deviceByGUID.setUniqueIdentifier(agentNormUniqueIDENT);
                    myDebug.fine("  <<===>>> set UniqueIdentifier to " + agentIdStr + ", and uniqueIdentifier=" + agentNormUniqueIDENT + " in db for device=" + this.deviceByGUID.getDebugString());
                } else {
                    myDebug.fine("  <<===>>> uniqueIdentifier already exist= " + normUniqueIDENT + ", for dev=" + this.deviceByGUID.getDebugString() + ", didnot set uniqueIdentifier again");
                    if (!agentNormUniqueIDENT.equalsIgnoreCase(normUniqueIDENT)) {
                        myDebug.fine("  <<???????>>> normalized agent uuid=" + agentNormUniqueIDENT + ", is different than uniqueidentifier=" + normUniqueIDENT + ", for dev=" + this.deviceByGUID.getDebugString());
                    }
                }
            }
            return this.deviceByGUID;
        }
    }

    private boolean searchNodeByNormUniqueIDENTAndDoNodeMerge(DeviceIdentificationData devIDData) {
        boolean foundIt = false;
        return foundIt;
    }

    private boolean searchNodeByAgentUUIDAndDoNodeMerge(DeviceIdentificationData devIDData) {
        boolean foundIt = false;
        return foundIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MxNode resolveByIdentifiers() {
        MxNode theDiscoveredDevice = null;
        myDebug.fine("    <<<<<   Beginning discovery resolver for : {0} ({1}) {2}  >>>>>>>", new Object[]{this.dnsName, this.shortHostName, this.sourceNode.getWorkingAddress()});
        Integer n = syncAdds;
        synchronized (n) {
            myDebug.finer("In resolveByIdentifiers of Discovery Resolver " + this.sourceNode.getWorkingAddress() + " name " + this.shortHostName);
            String sourceNodesAgentUUID = this.sourceNode.getAgentUUID();
            String sourceNodesUniqueIdentifier = this.sourceNode.getUniqueIdentifier();
            if (sourceNodesUniqueIdentifier != null && sourceNodesUniqueIdentifier.trim().length() > 0) {
                try {
                    myDebug.fine("Look for system using the normalized unique identifier of {0} ", new Object[]{sourceNodesUniqueIdentifier});
                    this.deviceByGUID = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(sourceNodesUniqueIdentifier);
                    myDebug.fine("Found system using the normalized unique identifier of {0} ", new Object[]{sourceNodesUniqueIdentifier});
                }
                catch (MxUndefinedNodeException ex) {
                    myDebug.fine("No luck  finding system by UniqueIdentfier");
                }
            }
            if (this.deviceByGUID == null && sourceNodesAgentUUID != null && sourceNodesAgentUUID.trim().length() > 0) {
                try {
                    myDebug.fine("Look for system using the AgentUUID of {0} ", new Object[]{sourceNodesAgentUUID});
                    this.deviceByGUID = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(sourceNodesAgentUUID);
                    myDebug.fine("Found system using the agentUUID of {0} ", new Object[]{sourceNodesAgentUUID});
                }
                catch (MxUndefinedNodeException ex) {
                    myDebug.fine("No luck  finding system by AgentUUID");
                }
            }
            if (this.sourceNode.getWorkingAddress() != null) {
                this.addressUsed = this.sourceNode.getWorkingAddress();
                try {
                    myDebug.finer("Searching for system by address {0} ", new Object[]{this.addressUsed});
                    MxNode tmpDev = MxNodeController.getDefaultControllerNoEx().getNodeByIPAddress(this.addressUsed);
                    myDebug.finer("Found system by address {0} ", new Object[]{this.addressUsed});
                    this.deviceByAddress = tmpDev;
                }
                catch (MxUndefinedNodeException ex) {
                    // empty catch block
                }
            }
            this.deviceByName = this.findDeviceByName();
            DebugOutput.log((DebugSubsystem)myDebug, (int)20, (String)("resolveByIdentifiers foundByUUID/UniqueID = " + this.deviceByGUID + " byname= " + this.deviceByName + " by  address= " + this.deviceByAddress));
            if (this.deviceByGUID != null) return this.handleDeviceByIdentierResolving();
            if (this.deviceByName == null) {
                if (this.deviceByAddress != null) return this.processNodeFoundOnlyByIP(sourceNodesAgentUUID, sourceNodesUniqueIdentifier);
                myDebug.fine(" can't find by GUID, name and IP address, create a new node");
                return this.createNewDevice(this.sourceNode, false);
            }
            if (this.checkForDifferentIdentifiers(this.deviceByName.getUniqueIdentifier(), sourceNodesUniqueIdentifier) || this.checkForDifferentIdentifiers(this.deviceByName.getAgentUUID(), sourceNodesAgentUUID)) {
                myDebug.log(10, "Have device with different guid than in DB by name - create new ");
                if (this.deviceByName.getWorkingAddress() != null) {
                    this.assignAddressAsNameToDevice(this.deviceByName.getWorkingAddress(), this.deviceByName);
                } else {
                    this.assignNameToOldDevice(this.createOrphanName(this.deviceByName), this.deviceByName);
                }
                this.deviceByGUID = theDiscoveredDevice = this.createNewDevice(this.sourceNode, true);
                this.handleDeviceByIdentierResolving();
                return theDiscoveredDevice;
            }
            if (!this.deviceByName.getDiscoveredName().equals((Object)this.deviceByName.getName()) && this.deviceByAddress != null && !this.deviceByName.getGUID().equals((Object)this.deviceByAddress.getGUID())) {
                myDebug.log(10, "well we just discovered a node that has the same name as one somebody renamed, reset and - create new ");
                this.assignNameToOldDevice(this.deviceByName.getDiscoveredName().toString(), this.deviceByName);
                this.deviceByName = this.deviceByAddress;
            }
            theDiscoveredDevice = this.deviceByName;
            if (this.deviceByAddress == null) {
                if (this.sourceNode.getIPAddressList() != null) {
                    for (String curAddress : this.sourceNode.getIPAddressList()) {
                        this.assignAddressToDevice(curAddress, theDiscoveredDevice);
                    }
                }
            } else {
                this.assignNameToExistingNode(this.shortHostName, theDiscoveredDevice);
                if (!theDiscoveredDevice.equals((Object)this.deviceByAddress)) {
                    this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, theDiscoveredDevice, this.addressUsed);
                }
            }
            if (sourceNodesAgentUUID != null && sourceNodesAgentUUID.length() > 0) {
                theDiscoveredDevice.setAgentUUID(sourceNodesAgentUUID);
            }
            if (sourceNodesUniqueIdentifier != null && sourceNodesUniqueIdentifier.length() > 0) {
                theDiscoveredDevice.setUniqueIdentifier(sourceNodesUniqueIdentifier);
            }
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theDiscoveredDevice, false);
            }
            catch (MxException ex) {
                myDebug.exception((Throwable)ex);
            }
            return theDiscoveredDevice;
        }
    }

    private MxNode processNodeFoundOnlyByIP(String sourceNodesAgentUUID, String sourceNodesUniqueIdentifier) {
        MxNode theDiscoveredDevice = null;
        if (this.checkForDifferentIdentifiers(this.deviceByAddress.getUniqueIdentifier(), sourceNodesUniqueIdentifier) || this.checkForDifferentIdentifiers(this.deviceByAddress.getAgentUUID(), sourceNodesAgentUUID)) {
            myDebug.log(10, "Have device with different uniqueIdentifier/UUID than in DB by addr - create new ");
            theDiscoveredDevice = this.createNewDevice(this.sourceNode, true);
            this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, theDiscoveredDevice, this.addressUsed);
            return theDiscoveredDevice;
        }
        if (this.checkForDifferentIdentifiers(this.deviceByAddress.getNameString(), this.sourceNode.getNameString()) || this.checkForDifferentIdentifiers(this.deviceByAddress.getHostName(), this.sourceNode.getHostName())) {
            myDebug.log(10, "Have device with different name/hostanme than in DB by addr - check if name is IP though");
            if (!InetXe.isValidIp((String)this.deviceByAddress.getNameString()) && !InetXe.isValidIp((String)this.sourceNode.getNameString())) {
                myDebug.log(10, "Have device with different name/hostanme than in DB by addr - create new ");
                theDiscoveredDevice = this.createNewDevice(this.sourceNode, true);
                this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, theDiscoveredDevice, this.addressUsed);
                return theDiscoveredDevice;
            }
        }
        theDiscoveredDevice = this.deviceByAddress;
        this.assignNameToExistingNode(this.shortHostName, theDiscoveredDevice);
        if (sourceNodesAgentUUID != null && sourceNodesAgentUUID.length() > 0) {
            this.deviceByAddress.setAgentUUID(sourceNodesAgentUUID);
        }
        if (sourceNodesUniqueIdentifier != null && sourceNodesUniqueIdentifier.length() > 0) {
            this.deviceByAddress.setUniqueIdentifier(sourceNodesUniqueIdentifier);
        }
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theDiscoveredDevice, false);
        }
        catch (MxException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        return theDiscoveredDevice;
    }

    private String createOrphanName(MxNode aNode) {
        String devName = aNode.getNameString();
        int orphanNodeDevKey = aNode.getDeviceKey();
        String orphanNodeDevKeyStr = new Integer(orphanNodeDevKey).toString();
        StringBuffer orphanNodeName = new StringBuffer();
        if (aNode.getSerialNumber() != null && aNode.getSerialNumber().length() > 0) {
            orphanNodeName.append(aNode.getSerialNumber());
        }
        try {
            MxNode tmpNode = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(orphanNodeName.toString());
            if (!tmpNode.getGUID().equals((Object)aNode.getGUID())) {
                myDebug.error("On orphan node name create have dup name {0}", new Object[]{orphanNodeName.toString()});
                orphanNodeName.setLength(0);
            }
        }
        catch (MxInvalidNodeNameException e) {
            myDebug.error("On orphan rename got bad name {0}", new Object[]{orphanNodeName.toString()});
            orphanNodeName.setLength(0);
        }
        catch (MxUndefinedNodeException e) {
            // empty catch block
        }
        if (orphanNodeName.length() == 0) {
            if (!devName.contains("Orphan")) {
                orphanNodeName.append("Orphan-");
                orphanNodeName.append(orphanNodeDevKey);
                orphanNodeName.append("-");
            }
            orphanNodeName.append(devName);
        }
        return orphanNodeName.toString();
    }

    private boolean checkForDifferentIdentifiers(String identifier1, String identifier2) {
        return identifier1 != null && identifier2 != null && identifier1.length() > 0 && identifier2.length() > 0 && !identifier1.equals(identifier2);
    }

    private void assignAddressToDevice(String address, MxNode deviceObj) {
        if (deviceObj != null) {
            DebugOutput.log((DebugSubsystem)myDebug, (int)25, (String)("device object " + deviceObj.getDebugString() + " assigned address " + address));
            deviceObj.setPrimaryIPAddress(address);
            if (this.isAutoDiscovery) {
                myDebug.fine("checking IPs on node to see if they still respond, clean old ones that dont ");
                NodePinger.verifyIPAddresses((MxNode)deviceObj);
            }
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceObj, false);
            }
            catch (MxNodeIsNotLockedException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxObjectPersistenceException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxUndefinedNodeException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxInvalidNodeOperationException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxDuplicateNodeException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxInvalidTransactionException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxUnauthorizedUserException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxUndefinedUserException ex) {
                myDebug.exception((Throwable)ex);
            }
            catch (MxInvalidUserException ex) {
                myDebug.exception((Throwable)ex);
            }
        } else if (DebugOutput.debugEnabled) {
            DebugOutput.log((DebugSubsystem)myDebug, (int)25, (String)"device object in assign address:Discovery Resolver returned null");
        }
    }

    private void assignAddressAsNameToDevice(String address, MxNode nodeObj) {
        myDebug.finer("assign name {0} as IP for {1}", new Object[]{address, nodeObj.getDebugString()});
        MxNode origNode = (MxNode)nodeObj.clone();
        try {
            nodeObj.setDeviceName(address);
            nodeObj.setHostName("");
        }
        catch (MxInvalidNodeNameException ex) {
            myDebug.exception((Throwable)ex);
        }
        try {
            MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origNode, nodeObj);
            lmBean licenseBean = new lmBean();
            licenseBean.lmReconcile(origNode, nodeObj);
        }
        catch (MxNodeIsNotLockedException ex1) {
            myDebug.exception((Throwable)ex1);
        }
        catch (MxObjectPersistenceException ex1) {
            myDebug.exception((Throwable)ex1);
        }
        catch (MxUndefinedNodeException ex1) {
            myDebug.exception((Throwable)ex1);
        }
        catch (MxInvalidNodeOperationException ex1) {
            myDebug.exception((Throwable)ex1);
        }
        catch (MxDuplicateNodeException ex1) {
            myDebug.exception((Throwable)ex1);
        }
        catch (MxInvalidTransactionException ex1) {
            myDebug.exception((Throwable)ex1);
        }
    }

    private void assignNameToExistingNode(String newName, MxNode deviceObj) {
        boolean changed = false;
        if (deviceObj == null) {
            myDebug.error("set name on null node");
            return;
        }
        MxNode origNode = (MxNode)deviceObj.clone();
        myDebug.fine("device object " + deviceObj.getDebugString() + " may be renamed to " + newName);
        String origName = deviceObj.getDeviceName();
        String origFQName = deviceObj.getHostName();
        if (deviceObj.getSWAttribute("nonuniquehostname") != null) {
            this.haveSameHostNameDiffDomain = true;
        }
        if (this.haveSameHostNameDiffDomain) {
            newName = deviceObj.getHostName();
        }
        if (origName.equalsIgnoreCase(newName)) {
            myDebug.fine("told to set name, but names do not differ, don't waste time...");
            return;
        }
        try {
            String myDevSnmpSysName = deviceObj.getDeviceName(1);
            if (myDevSnmpSysName != null && myDevSnmpSysName.trim().length() > 0) {
                myDebug.finer("On assignName, the sysname is " + myDevSnmpSysName);
                boolean okToRename = false;
                if (origName != null && !origName.equalsIgnoreCase(myDevSnmpSysName) || newName.equalsIgnoreCase(myDevSnmpSysName)) {
                    okToRename = true;
                }
                if (origFQName != null && origFQName.equalsIgnoreCase(myDevSnmpSysName)) {
                    okToRename = false;
                }
                if (okToRename) {
                    myDebug.finer("On assignName, ok to rename - does not match sysName ");
                    if (InetXe.isValidIp((String)origName) && !InetXe.isValidIp((String)newName)) {
                        changed = true;
                        deviceObj.setDeviceName(newName);
                        myDebug.finer("Current name is " + origName + " and now it is " + newName);
                    } else if (!InetXe.isValidIp((String)origName) && !InetXe.isValidIp((String)newName)) {
                        changed = true;
                        deviceObj.setDeviceName(newName);
                        myDebug.finer("Current name is " + origName + " and now will be " + newName);
                    } else if (this.deviceByName == null) {
                        changed = true;
                        deviceObj.setDeviceName(newName);
                        myDebug.finer("Current name is " + origName + " and now it will be" + newName);
                    }
                    if (this.dnsName != null && !this.dnsName.equals(this.addressUsed) && !deviceObj.getHostName().equals(this.dnsName) || this.deviceByName == null) {
                        changed = true;
                        deviceObj.setHostName(this.dnsName);
                    }
                } else {
                    myDebug.fine("device object " + deviceObj.getDebugString() + " not renamed to " + newName + " current name matches SNMP sysname " + origName);
                    ArrayList<String> otherFDNSNames = deviceObj.getClientAttributeList(OTHER_HOST_NAME);
                    if (otherFDNSNames == null) {
                        otherFDNSNames = new ArrayList<String>();
                    }
                    if (this.dnsName != null && this.dnsName.length() > 0 && !otherFDNSNames.contains(this.dnsName)) {
                        otherFDNSNames.add(this.dnsName);
                    }
                    if (deviceObj.getHostName() != null && deviceObj.getHostName().length() > 0 && !otherFDNSNames.contains(deviceObj.getHostName())) {
                        otherFDNSNames.add(deviceObj.getHostName());
                    }
                    if (otherFDNSNames.size() > 0) {
                        deviceObj.setClientAttributeList(OTHER_HOST_NAME, otherFDNSNames);
                    }
                    newName = origName;
                }
            } else {
                if (InetXe.isValidIp((String)origName)) {
                    if (!InetXe.isValidIp((String)newName)) {
                        changed = true;
                        deviceObj.setDeviceName(newName);
                    }
                } else if (!origName.equalsIgnoreCase(newName)) {
                    changed = true;
                    deviceObj.setDeviceName(newName);
                }
                if (this.dnsName != null && !this.dnsName.equals(this.addressUsed) && !deviceObj.getHostName().equals(this.dnsName)) {
                    changed = true;
                    deviceObj.setHostName(this.dnsName);
                }
            }
        }
        catch (MxInvalidNodeNameException ex) {
            myDebug.exception((Throwable)ex);
        }
        try {
            if (changed) {
                MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origNode, deviceObj);
                lmBean licenseBean = new lmBean();
                licenseBean.lmReconcile(origNode, deviceObj);
            }
        }
        catch (MxNodeIsNotLockedException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxObjectPersistenceException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxUndefinedNodeException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxInvalidNodeOperationException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxDuplicateNodeException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxInvalidTransactionException ex2) {
            myDebug.exception((Throwable)ex2);
        }
    }

    private void assignNameToOldDevice(String name, MxNode deviceObj) {
        assert (deviceObj != null);
        boolean changed = false;
        MxNode origNode = (MxNode)deviceObj.clone();
        myDebug.fine(" old device object " + deviceObj.getDebugString() + " may be renamed to " + name);
        try {
            String tmpName = deviceObj.getDeviceName();
            this.deviceByName.setDefaultsMask(false, 0x40000000);
            deviceObj.setDeviceName(name);
            if (deviceObj.getHostName() != null && (deviceObj.getHostName().equalsIgnoreCase(tmpName) || deviceObj.getHostName().toLowerCase().startsWith(tmpName.toLowerCase()))) {
                myDebug.fine("Will also rest hostName on rename " + deviceObj.getHostName());
                deviceObj.setHostName("");
            }
            myDebug.fine("Current name (TMPNAME) was " + tmpName + " and now it is " + name);
        }
        catch (MxInvalidNodeNameException ex) {
            myDebug.exception((Throwable)ex);
        }
        try {
            MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origNode, deviceObj);
            lmBean licenseBean = new lmBean();
            licenseBean.lmReconcile(origNode, deviceObj);
        }
        catch (MxNodeIsNotLockedException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxObjectPersistenceException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxUndefinedNodeException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxInvalidNodeOperationException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxDuplicateNodeException ex2) {
            myDebug.exception((Throwable)ex2);
        }
        catch (MxInvalidTransactionException ex2) {
            myDebug.exception((Throwable)ex2);
        }
    }

    private final MxNode findDeviceByName() {
        boolean isFullDns;
        MxNode fullDnsDev;
        MxNode searchDevice;
        block32: {
            searchDevice = null;
            DebugOutput.log((DebugSubsystem)myDebug, (int)25, (String)("In findDeviceByName : dnsName = " + this.dnsName));
            fullDnsDev = null;
            if (this.isPassedInNameFullDns) {
                try {
                    fullDnsDev = MxNodeController.getDefaultControllerNoEx().getNodeByHostname(this.dnsName);
                }
                catch (MxUndefinedNodeException ex) {
                    fullDnsDev = null;
                }
                myDebug.fine("findDeviceByName: search dns name=" + this.dnsName + " host name=" + this.shortHostName + " is dns flag=" + this.isPassedInNameFullDns);
                if (fullDnsDev != null) {
                    myDebug.finer("Device found by full dns name is not null and it is : " + fullDnsDev.getHostName());
                    searchDevice = fullDnsDev;
                    if (searchDevice.getSWAttribute("nonuniquehostname") != null) {
                        this.haveSameHostNameDiffDomain = true;
                    }
                    this.assignNameToExistingNode(this.shortHostName, searchDevice);
                } else {
                    DebugOutput.log((DebugSubsystem)myDebug, (int)25, (String)("Device not found by full DNS name, and the name passed in was a full dns name " + fullDnsDev));
                }
            }
            if (searchDevice == null) {
                String AlternateWinsName;
                MxNode simpleNameDev = null;
                myDebug.finer("Resolver Didn't get it by full dns so lets get it the by just host name " + this.shortHostName);
                boolean hadTildaName = false;
                if (this.shortHostName.startsWith("is~")) {
                    AlternateWinsName = new String(this.shortHostName.substring(3));
                } else {
                    AlternateWinsName = new String("is~" + this.shortHostName);
                    hadTildaName = true;
                }
                if (myDebug.check(25)) {
                    myDebug.fine("Discovery Resolver looking for device named " + this.shortHostName + " or alt name " + AlternateWinsName);
                }
                try {
                    simpleNameDev = null;
                    try {
                        searchDevice = simpleNameDev = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(this.shortHostName, false);
                        if (this.isCmsAdd) {
                            this.assignNameToExistingNode(this.shortHostName, searchDevice);
                        }
                    }
                    catch (MxUndefinedNodeException ex2) {
                    }
                    catch (MxInvalidNodeNameException ex2) {
                        // empty catch block
                    }
                    if (searchDevice != null) break block32;
                    try {
                        simpleNameDev = null;
                        simpleNameDev = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(AlternateWinsName, false);
                    }
                    catch (MxUndefinedNodeException ex3) {
                    }
                    catch (MxInvalidNodeNameException ex3) {
                        // empty catch block
                    }
                    searchDevice = simpleNameDev;
                    if (searchDevice != null) {
                        if (hadTildaName) {
                            this.assignNameToExistingNode(this.shortHostName, searchDevice);
                        }
                        break block32;
                    }
                    try {
                        if (this.addressUsed != null) {
                            searchDevice = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(this.addressUsed, false);
                            this.assignNameToExistingNode(this.shortHostName, searchDevice);
                        }
                    }
                    catch (MxUndefinedNodeException ex4) {
                    }
                    catch (MxInvalidNodeNameException ex4) {}
                }
                catch (Exception e) {
                    myDebug.exception((Throwable)e);
                }
            }
        }
        if (fullDnsDev == null) {
            try {
                fullDnsDev = MxNodeController.getDefaultControllerNoEx().getNodeByHostname(this.dnsName);
            }
            catch (MxUndefinedNodeException ex1) {
                // empty catch block
            }
        }
        if (searchDevice != null) {
            myDebug.finer("Discovery Resolver checking for device by name " + this.shortHostName + " Found possible device object " + searchDevice);
        }
        if (!this.isCmsAdd && fullDnsDev == null && searchDevice != null && this.isPassedInNameFullDns && searchDevice.getHostName() != null && (isFullDns = DiscoverySystemResolver.checkIfIsFullDns(searchDevice.getHostName()))) {
            try {
                searchDevice.setDeviceName(searchDevice.getHostName());
                searchDevice.setClientAttribute("nonuniquehostname", "true");
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), searchDevice, false);
            }
            catch (MxException ex) {
                myDebug.exception((Throwable)ex);
            }
            searchDevice = null;
            this.haveSameHostNameDiffDomain = true;
            myDebug.log(20, "The device found by name had a DNS name and it was not found by the passed in DNS name - will not use " + this.shortHostName);
        }
        return searchDevice;
    }

    public static boolean checkIfIsFullDns(String someName) {
        if (someName.length() == 0) {
            return false;
        }
        int dotCnt = 0;
        boolean hasNonNumber = false;
        for (int i = 0; i < someName.length(); ++i) {
            char wrkChar = someName.charAt(i);
            if (wrkChar == '.') {
                ++dotCnt;
            }
            if (Character.isDigit(wrkChar)) continue;
            hasNonNumber = true;
        }
        return hasNonNumber && dotCnt > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MxNode createNewDevice(MxNode sourceNode, boolean clearUuids) {
        myDebug.fine("  <----- in DiscoverySystemResolver: createNewDevice  ----->");
        MxNode theNewNodeObject = (MxNode)sourceNode.clone();
        theNewNodeObject.setObjectID(new MxObjectID());
        theNewNodeObject.setGUID(null);
        if (clearUuids) {
            theNewNodeObject.setAgentUUID("");
            theNewNodeObject.setUniqueIdentifier("");
        }
        theNewNodeObject.clearDeviceState();
        theNewNodeObject.setDevicePending();
        try {
            Integer i;
            if (this.haveSameHostNameDiffDomain) {
                theNewNodeObject.setDeviceName(this.dnsName);
                theNewNodeObject.setSWAttribute("nonuniquehostname", "true");
                myDebug.fine("  have same host name diff domain, set device name to dnsName=" + this.dnsName);
            } else {
                theNewNodeObject.setDeviceName(this.shortHostName);
                myDebug.fine("  have same host name diff domain, set device name to shorthostname=" + this.shortHostName);
            }
            if (this.dnsName != null && !this.dnsName.equals(this.addressUsed)) {
                theNewNodeObject.setHostName(this.dnsName);
                myDebug.fine("  dns name is not an ip address, set host name to dns name=" + this.dnsName);
            }
            if (this.deviceByAddress != null) {
                this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, theNewNodeObject, this.addressUsed);
                if (this.deviceByAddress.getNameString().equalsIgnoreCase(this.shortHostName) || this.deviceByAddress.getNameString().equals(this.addressUsed)) {
                    if (this.deviceByAddress.getWorkingAddress() != null) {
                        this.assignAddressAsNameToDevice(this.deviceByAddress.getWorkingAddress(), this.deviceByAddress);
                    } else {
                        this.assignNameToOldDevice(this.createOrphanName(this.deviceByAddress), this.deviceByAddress);
                    }
                }
                myDebug.fine("  moveAddressFromDeviceOneToDeviceTwo");
            }
            if (theNewNodeObject.getSnmpTimeOut() == 0) {
                i = new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"2"));
                theNewNodeObject.setSnmpTimeOut(i.intValue());
            }
            if (theNewNodeObject.getSnmpRetry() == 0) {
                i = new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2"));
                theNewNodeObject.setSnmpRetry(i.intValue());
            }
            if (theNewNodeObject.getIcmpTimeOut() == 0) {
                i = new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"2"));
                theNewNodeObject.setIcmpTimeOut(i.intValue());
            }
            if (theNewNodeObject.getIcmpRetry() == 0) {
                i = new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2"));
                theNewNodeObject.setIcmpRetry(i.intValue());
            }
            int defaultsMask = 511;
            theNewNodeObject.setDefaultsMask(true, defaultsMask);
            DiscoverySystemResolver discoverySystemResolver = this;
            synchronized (discoverySystemResolver) {
                if (ourNodeAccessController == null) {
                    try {
                        ourNodeAccessController = MxNodeAccessControllerFactory.getNodeAccessController();
                    }
                    catch (MxProtocolException e) {
                        myDebug.log(10, " -- no wbem credential defined in the nodesecurity.xml file --\n" + (Object)((Object)e));
                        myDebug.exception((Throwable)e);
                    }
                    catch (Exception e) {
                        myDebug.log(10, " -- exception --\n" + e);
                        myDebug.exception((Throwable)e);
                    }
                }
            }
            MxCredential snmpCred = null;
            try {
                snmpCred = ourNodeAccessController.getNodeCredential(theNewNodeObject.getDeviceNameStandard(), "snmp");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (snmpCred != null && snmpCred.getUsername() != null) {
                myDebug.fine("node security has existing entry for a node, will not use defaults initially ");
                theNewNodeObject.setDefaultsMask(false, 3);
            }
            MxCredential wbemCred = null;
            try {
                wbemCred = ourNodeAccessController.getNodeCredential(theNewNodeObject.getDeviceNameStandard(), "wbem");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (wbemCred != null && wbemCred.getUsername() != null) {
                myDebug.log(15, "node security has existing wbemCred entry for a node, will not use defaults initially ");
                theNewNodeObject.setDefaultsMask(false, 192);
            }
            MxNodeController.getDefaultControllerNoEx().addNodeToCacheForDiscovery((MxTransaction)new MxCoreTransaction(), theNewNodeObject);
            myDebug.fine("   Discovery Resolver: Created new MxNode object {0} id {1} in cache for identification thread to run, not in db yet", new Object[]{theNewNodeObject.getNameString(), theNewNodeObject.getGUID()});
        }
        catch (Exception ex) {
            myDebug.error("GUID: Exception on create/update device " + ex);
            myDebug.exception((Throwable)ex);
        }
        return theNewNodeObject;
    }

    private MxNode handleDeviceByIdentierResolving() {
        myDebug.fine("handleDeviceByIdentierResolving, aka UniqueID/GUID " + this.addressUsed + " name " + this.shortHostName);
        MxNode theDiscoveredDevice = this.deviceByGUID;
        if (this.deviceByName == null) {
            this.assignNameToExistingNode(this.shortHostName, this.deviceByGUID);
            if (this.deviceByAddress == null) {
                if (this.sourceNode.getIPAddressList() != null) {
                    for (String curAddress : this.sourceNode.getIPAddressList()) {
                        this.assignAddressToDevice(curAddress, this.deviceByGUID);
                    }
                }
            } else if (!this.deviceByGUID.equals((Object)this.deviceByAddress)) {
                this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, this.deviceByGUID, this.addressUsed);
            }
        } else if (this.deviceByAddress == null) {
            if (this.deviceByName.getKey() == this.deviceByGUID.getKey()) {
                if (this.sourceNode.getIPAddressList() != null) {
                    for (String curAddress : this.sourceNode.getIPAddressList()) {
                        this.assignAddressToDevice(curAddress, this.deviceByGUID);
                    }
                }
            } else {
                if (this.deviceByName.getWorkingAddress() != null) {
                    if (!this.deviceByName.getDiscoveredName().equals((Object)this.deviceByName.getName())) {
                        this.assignNameToOldDevice(this.deviceByName.getDiscoveredName().toString(), this.deviceByName);
                    } else {
                        this.assignAddressAsNameToDevice(this.deviceByName.getWorkingAddress(), this.deviceByName);
                    }
                } else {
                    this.assignNameToOldDevice(this.createOrphanName(this.deviceByName), this.deviceByName);
                }
                if (this.sourceNode.getIPAddressList() != null) {
                    for (String curAddress : this.sourceNode.getIPAddressList()) {
                        this.assignAddressToDevice(curAddress, this.deviceByGUID);
                    }
                }
                this.assignNameToExistingNode(this.shortHostName, this.deviceByGUID);
            }
        } else {
            theDiscoveredDevice = this.canWeIdentifyDeviceByGuidPart4();
        }
        return theDiscoveredDevice;
    }

    private MxNode canWeIdentifyDeviceByGuidPart4() {
        DebugOutput.log((DebugSubsystem)myDebug, (int)30, (String)("Starting part 4 of GUID ID " + this.addressUsed + " name " + this.shortHostName + " Guid Dev " + this.deviceByGUID + " IP dev " + this.deviceByAddress + " name dev " + this.deviceByName));
        if (this.deviceByGUID.equals((Object)this.deviceByName) && !this.deviceByGUID.equals((Object)this.deviceByAddress)) {
            this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, this.deviceByGUID, this.addressUsed);
            if (this.deviceByAddress.getWorkingAddress() != null) {
                this.assignAddressAsNameToDevice(this.deviceByAddress.getWorkingAddress(), this.deviceByAddress);
            } else {
                this.assignNameToOldDevice(this.createOrphanName(this.deviceByAddress), this.deviceByAddress);
            }
        } else if (!this.deviceByGUID.equals((Object)this.deviceByName) && this.deviceByGUID.equals((Object)this.deviceByAddress)) {
            if (this.deviceByName.getWorkingAddress() != null) {
                this.assignAddressAsNameToDevice(this.deviceByName.getWorkingAddress(), this.deviceByName);
            } else {
                this.assignNameToOldDevice(this.createOrphanName(this.deviceByName), this.deviceByName);
            }
            this.assignNameToExistingNode(this.shortHostName, this.deviceByGUID);
        } else if (!this.deviceByGUID.equals((Object)this.deviceByName) && !this.deviceByGUID.equals((Object)this.deviceByAddress)) {
            this.moveAddressFromDeviceOneToDeviceTwo(this.deviceByAddress, this.deviceByGUID, this.addressUsed);
            if (this.deviceByAddress.getWorkingAddress() != null) {
                this.assignAddressAsNameToDevice(this.deviceByAddress.getWorkingAddress(), this.deviceByAddress);
            } else {
                this.assignNameToOldDevice(this.createOrphanName(this.deviceByAddress), this.deviceByAddress);
            }
            if (!this.deviceByAddress.equals((Object)this.deviceByName)) {
                if (this.deviceByName.getWorkingAddress() != null) {
                    this.assignAddressAsNameToDevice(this.deviceByName.getWorkingAddress(), this.deviceByName);
                } else {
                    this.assignNameToOldDevice(this.createOrphanName(this.deviceByName), this.deviceByName);
                }
            }
            this.assignNameToExistingNode(this.shortHostName, this.deviceByGUID);
        } else if (this.deviceByGUID.equals((Object)this.deviceByName) && this.deviceByGUID.equals((Object)this.deviceByAddress)) {
            this.assignNameToExistingNode(this.shortHostName, this.deviceByGUID);
        }
        return this.deviceByGUID;
    }

    private void moveAddressFromDeviceOneToDeviceTwo(MxNode fromDevice, MxNode toDevice, String address) {
        DebugOutput.log((DebugSubsystem)myDebug, (int)20, (String)("Moving IP " + address + " from dev1 " + fromDevice.getDebugString() + " to two " + toDevice.getDebugString()));
        fromDevice.removeIPAddress(address);
        toDevice.setPrimaryIPAddress(address);
        if (this.isAutoDiscovery) {
            myDebug.fine("checking IPs on node to see if they still respond, clean old ones that dont ");
            NodePinger.verifyIPAddresses((MxNode)toDevice);
        }
        try {
            if (!fromDevice.isDevicePending()) {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), fromDevice, false);
            }
            if (!toDevice.isDevicePending()) {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), toDevice, false);
            }
        }
        catch (MxException ex) {
            myDebug.exception((Throwable)ex);
        }
    }
}

