/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification;

import com.hp.mx.core.automation.AutomationEvent;
import com.hp.mx.core.automation.GenericEvent;
import com.hp.mx.core.automation.GenericReplyEvent;
import com.hp.mx.core.automation.InterconnectEngine;
import com.hp.mx.core.controllers.DiscoveryController;
import com.hp.mx.core.controllers.MpoController;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.jobmanager.MxJob;
import com.hp.mx.core.jobmanager.MxJobManager;
import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodePinger;
import com.hp.mx.core.nodemanager.NodeStatus;
import com.hp.mx.core.nodemanager.NodeStatusManager;
import com.hp.mx.core.nodemanager.NodeStatusPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusSourceManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeUrlManager;
import com.hp.mx.core.nodemanager.NodeUrlPersistenceException;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.taskmanager.MxAutomationJobIfc;
import com.hp.mx.core.taskmanager.MxRunnableTask;
import com.hp.mx.core.tools.datacollection.DCCategories;
import com.hp.mx.core.tools.datacollection.DcCoordinator;
import com.hp.mx.core.tools.datacollection.PolledDataResponse;
import com.hp.mx.core.tools.discovery.DiscoveryDoneJMSMessageBody;
import com.hp.mx.core.tools.discovery.DiscoveryEventData;
import com.hp.mx.core.tools.discovery.DiscoveryJMSPublisher;
import com.hp.mx.core.tools.discovery.DiscoverySystemResolver;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentifierCoordinator;
import com.hp.mx.core.tools.licensing.GatherLicenseData;
import com.hp.mx.core.tools.swmaintenance.SWDeploymentDcComp;
import com.hp.mx.core.tools.wakeonlan.RmWakerDcComp;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.dtf.MxTargetOutput;
import com.hp.mx.dtf.MxTargetState_t;
import com.hp.mx.dtf.MxTargetStatus;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.lm.lmBean;
import com.hp.mx.security.DetermineTrustStatus;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeviceIdentifyThread
implements Runnable {
    private static final String OTHER_HOST_NAME = "OtherHostName";
    private MxNode myDevice;
    private MxNode mySourceNodeData = null;
    private DiscoveryEventData mySourceOfDiscoveryRequest = null;
    private int errorOcurred = 0;
    private int operationId = 0;
    private boolean mySkipIdentifers = false;
    private AutomationEvent myDiscEvent = null;
    String myDbgStr = "?";
    long startTime = 0L;
    long totAllTime = 0L;
    long stDcTime = 0L;
    long totDcTime = 0L;
    long stAssocTime = 0L;
    long totAssocTime = 0L;
    long stLicTime = 0L;
    long totLicTime = 0L;
    long stTrustTime = 0L;
    long totTrustTime = 0L;
    long cnt;
    private IdentifierCoordinator myIdCoordinator;
    private MxRunnableTask myCurrentTask;
    private MxJob myJob;
    private MxTargetStatus myJobTargetStatus;
    public static DeviceStatusSource statusSrcPING = null;
    private Vector myDcCategoryList = null;
    private static DebugSubsystem myDebug = new DebugSubsystem(DeviceIdentifyThread.class, "The identification tool debugs ");
    private String myThreadId;
    private UniqueIdentifierUtility myUniqueIdentUtil = new UniqueIdentifierUtility();

    public DeviceIdentifyThread() {
        this("", Thread.currentThread().getThreadGroup());
    }

    public DeviceIdentifyThread(String ID, ThreadGroup parentThreadGroup) {
        this.myThreadId = ID;
        this.myIdCoordinator = new IdentifierCoordinator(this.myThreadId, parentThreadGroup);
    }

    protected void setRunnableTaskObject(MxRunnableTask curTask) {
        this.myCurrentTask = curTask;
    }

    protected void setJob(MxJob theJob) {
        this.myJob = theJob;
    }

    protected void setTargetStatus(MxTargetStatus jobTargetStatus) {
        this.myJobTargetStatus = jobTargetStatus;
    }

    protected MxTargetStatus getTargetStatus() {
        return this.myJobTargetStatus;
    }

    public void setDevice(MxNode d) {
        this.myDevice = d;
    }

    public MxNode getDevice() {
        return this.myDevice;
    }

    public void setSourceNodeData(MxNode srcNode) {
        this.mySourceNodeData = srcNode;
    }

    public void setSourceDiscoveryRequest(DiscoveryEventData srcReq) {
        this.mySourceOfDiscoveryRequest = srcReq;
    }

    public DiscoveryEventData getSourceOfDiscoveryRequest() {
        return this.mySourceOfDiscoveryRequest;
    }

    public void setDiscoveryEvent(AutomationEvent discEvent) {
        this.myDiscEvent = discEvent;
    }

    public void setSkipIdentificationPlugis(boolean skipId) {
        this.mySkipIdentifers = skipId;
    }

    public void clear() {
        myDebug.fine(" device identifythread is cleared");
        this.myDevice = null;
        this.mySourceNodeData = null;
        this.mySourceOfDiscoveryRequest = null;
        this.myCurrentTask = null;
        this.myJobTargetStatus = null;
        this.mySkipIdentifers = false;
        this.myJob = null;
        this.myDiscEvent = null;
        this.errorOcurred = 0;
        this.operationId = 0;
    }

    public void setOpId(int opId) {
        this.operationId = opId;
    }

    public int getOpId() {
        return this.operationId;
    }

    public void getStatusHdr(StringBuffer sb) {
        sb.append("<tr><td>Thread ID</td><td>device</td><td>cur time (ms)</td><td>Tot avg</td>");
        this.myIdCoordinator.getStatusHdr(sb);
        sb.append("<td>License</td><td>trust</td><td>DC time</td><td>Assoc time</td></tr>");
    }

    public void getStatus(StringBuffer sb) {
        sb.append("<tr><td>" + this.myThreadId + " " + this.myDbgStr + "</td>");
        if (this.myDevice == null) {
            sb.append("<td>no node </td>");
            sb.append("<td>not running</td>");
        } else {
            sb.append("<td>" + this.myDevice.getDebugString() + "</td>");
            if (this.startTime != 0L) {
                sb.append("<td><span style='color:blue; font-weight:bold;'>" + (System.currentTimeMillis() - this.startTime) + "</span></td>");
            } else {
                sb.append("<td>not running</td>");
            }
        }
        if (this.cnt > 0L) {
            sb.append("<td>");
            sb.append(this.totAllTime / this.cnt);
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append("</td>");
        }
        this.myIdCoordinator.getStatus(sb);
        if (this.cnt > 0L) {
            sb.append("<td>");
            if (this.stLicTime > 0L) {
                sb.append("<span style='color:blue; font-weight:bold;'>");
                sb.append(System.currentTimeMillis() - this.stLicTime);
                sb.append("</span>");
            } else {
                sb.append(this.totLicTime / this.cnt);
                sb.append(" (avg)");
            }
            sb.append("</td>");
            sb.append("<td>");
            if (this.stTrustTime > 0L) {
                sb.append("<span style='color:blue; font-weight:bold;'>");
                sb.append(System.currentTimeMillis() - this.stTrustTime);
                sb.append("</span>");
            } else {
                sb.append(this.totTrustTime / this.cnt);
                sb.append(" (avg)");
            }
            sb.append("</td>");
            sb.append("<td>");
            if (this.stDcTime > 0L) {
                sb.append("<span style='color:blue; font-weight:bold;'>");
                sb.append(System.currentTimeMillis() - this.stDcTime);
                sb.append("</span>");
            } else {
                sb.append(this.totDcTime / this.cnt);
                sb.append(" (avg)");
            }
            sb.append("</td>");
            sb.append("<td>");
            if (this.stAssocTime > 0L) {
                sb.append("<span style='color:blue; font-weight:bold;'>");
                sb.append(System.currentTimeMillis() - this.stAssocTime);
                sb.append("</span>");
            } else {
                sb.append(this.totAssocTime / this.cnt);
                sb.append(" (avg)");
            }
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("</td>");
        }
        sb.append("</tr>");
    }

    public int getErrorCode() {
        return this.errorOcurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        myDebug.fine(" <<<--- device identifythread started running... --->>>");
        this.startTime = System.currentTimeMillis();
        boolean respondedToPing = true;
        this.myDbgStr = "started ";
        int pingRespond = 0;
        if (this.myJobTargetStatus != null) {
            this.myJobTargetStatus.setState(MxTargetState_t.RUNNING);
            this.updateCurrentTargetStatus(this.myJobTargetStatus);
        }
        if (this.myDevice == null || this.myDevice.isDeviceDeleted()) {
            if (this.myJobTargetStatus != null) {
                this.myJobTargetStatus.setState(MxTargetState_t.FAILED);
                this.updateCurrentTargetStatus(this.myJobTargetStatus);
            }
            this.myDbgStr = "fail ";
            this.sendDiscoveryResponseIfNeeded();
            myDebug.fine("Node not identified, marked deleted " + this.myDevice.getKey());
            return;
        }
        try {
            this.myDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(this.myDevice.getObjectID());
            myDebug.fine(" >>> DeviceIdentyThread: Found MxNode [" + this.myDevice.getName().toString() + "] in cache/db ");
        }
        catch (MxUndefinedNodeException ex1) {
            this.sendDiscoveryResponseIfNeeded();
            myDebug.error("??? DeviceIdentyThread: Failed to find MxNode [" + this.myDevice.getName().toString() + "] in cache " + ex1.getMessage());
            return;
        }
        if (!this.myDevice.canDeviceBePolled() && this.myDevice.isDeviceInDB() && this.mySourceNodeData != null && this.mySourceNodeData.getActualSnoozeTime() == -4) {
            if (this.myJobTargetStatus != null) {
                this.myJobTargetStatus.setState(MxTargetState_t.SKIPPED);
                this.updateCurrentTargetStatus(this.myJobTargetStatus);
            }
            this.myDbgStr = "no poll ";
            this.sendDiscoveryResponseIfNeeded();
            myDebug.fine("Node not identified, marked as not pollable " + this.myDevice.getKey());
            return;
        }
        try {
            boolean passesFilter;
            String address = this.myDevice.getWorkingAddress();
            myDebug.important("Identification: Started Working address for " + this.myDevice.getDeviceNameStandard() + " ip " + address, new Object[0]);
            if (address == null) {
                respondedToPing = false;
                myDebug.important("  <<<<<<<<<====IP address is null = " + pingRespond + ", for dev=" + this.myDevice.getDeviceNameStandard() + " ====>>>>>>> ", new Object[0]);
            } else {
                pingRespond = NodePinger.PingDetail((MxNode)this.myDevice);
                respondedToPing = this.isDeviceRespondedToPing(this.myDevice, address, pingRespond);
                myDebug.important("  <<<<<<<<<====Node Reachable state = " + pingRespond + ", for dev=" + this.myDevice.getDeviceNameStandard() + " ====>>>>>>> ", new Object[0]);
            }
            DeviceIdentificationData theIdInfoData = new DeviceIdentificationData();
            myDebug.important(" ===> new DeviceIdentificationData is created " + this.myDevice.getDeviceNameStandard(), new Object[0]);
            if (!this.mySkipIdentifers) {
                this.appendMxTargetStatusOutput(this.getTargetStatus(), "startId", null);
                this.myDbgStr = "Run Id coordinator";
                this.myIdCoordinator.setDevice(this.myDevice);
                this.myIdCoordinator.setSourceNodeData(this.mySourceNodeData);
                this.myIdCoordinator.setDeviceResponding(respondedToPing);
                this.myIdCoordinator.setRunnableTaskObject(this.myCurrentTask);
                this.myIdCoordinator.setDiscoveryRequestSource(this.mySourceOfDiscoveryRequest);
                this.myIdCoordinator.setIdStateData(theIdInfoData);
                this.myIdCoordinator.setIdThread(this);
                myDebug.fine("<<<<<<------ Starting Identification plug-ins for dev=" + this.myDevice.getDeviceNameStandard() + "------>>>>>>");
                this.myIdCoordinator.startIdentification();
                if (this.myDevice.isDeviceDeleted()) {
                    if (this.myJobTargetStatus != null) {
                        this.myJobTargetStatus.setState(MxTargetState_t.FAILED);
                    }
                    this.myDbgStr = "done";
                    this.sendDiscoveryResponseIfNeeded();
                }
            } else {
                this.myDbgStr = "Skip Id coordinator";
            }
            this.myDbgStr = "Check Filter";
            if (this.myDevice.isDevicePending() && !(passesFilter = this.doesDevicePassFilter(theIdInfoData))) {
                this.appendMxTargetStatusOutput(this.getTargetStatus(), "failFilt", null);
                myDebug.important(" Device did not match the discovery filter " + this.myDevice, new Object[0]);
                MxNodeController.getDefaultControllerNoEx().deleteNode((MxTransaction)new MxCoreTransaction(), this.myDevice);
                if (this.myJobTargetStatus != null) {
                    this.myJobTargetStatus.setState(MxTargetState_t.FAILED);
                    this.updateCurrentTargetStatus(this.myJobTargetStatus);
                }
                this.sendDiscoveryResponseIfNeeded();
                this.myIdCoordinator.clear();
                return;
            }
            myDebug.fine("<<<<------------Resolve node for dev=" + this.myDevice.getDeviceNameStandard() + " - check for duplicates -------->>>>");
            this.myDbgStr = "Resolve node - check for duplicates";
            boolean devVirtual = this.isDeviceVirtual(this.myDevice);
            List uniqIdList = this.myIdCoordinator.getUniqueIdentifiers();
            Object agentIdStr = null;
            theIdInfoData.getAgentUUIDList().addAll(0, uniqIdList);
            String totalTime = OTHER_HOST_NAME;
            synchronized (OTHER_HOST_NAME) {
                if (!devVirtual) {
                    MxNode resolvedNode = null;
                    try {
                        String discSource;
                        DiscoverySystemResolver resolver = new DiscoverySystemResolver(this.myDevice);
                        if (this.mySourceOfDiscoveryRequest != null && (discSource = this.mySourceOfDiscoveryRequest.getDiscoverySource()).equals("Ping")) {
                            resolver.setIsAutoDiscovery();
                        }
                        resolvedNode = resolver.resolveByIdentifiers(this.myDevice, theIdInfoData);
                    }
                    catch (Throwable ex2) {
                        myDebug.panic(ex2);
                    }
                    if (resolvedNode != null && this.myDevice.getKey() != resolvedNode.getKey()) {
                        myDebug.fine("using node from resolver, will merge data " + resolvedNode.getDebugString());
                        this.doNodeMerge(resolvedNode);
                        if (this.myDevice.isDevicePending()) {
                            myDebug.fine("Also remove source node as it was merged to existing. " + this.myDevice.getDebugString());
                            MxNodeController.getDefaultControllerNoEx().deleteNode((MxTransaction)new MxCoreTransaction(), this.myDevice);
                        }
                        this.myDevice = resolvedNode;
                    }
                } else {
                    myDebug.fine("  ---- >>> device is virtual, no need to do merge - by UUID that is");
                }
                if (theIdInfoData.getSerialNumber() != null && theIdInfoData.getSerialNumber().trim().length() > 0) {
                    this.myDevice.setSerialNumber(theIdInfoData.getSerialNumber().trim());
                }
                if (this.myDevice.isDevicePending()) {
                    this.appendMxTargetStatusOutput(this.getTargetStatus(), "passFilt", null);
                    myDebug.fine(" Device passes the discovery filter, will add " + this.myDevice);
                    try {
                        MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), this.myDevice);
                        if (this.myDevice.canDeviceBePolled()) {
                            NodeStatus nodeStatus = new NodeStatus(this.myDevice.getDeviceKey());
                            if (statusSrcPING == null) {
                                statusSrcPING = NodeStatusSourceManager.getDefaultManager().getDeviceStatusSource("compaq.hmma.PingStatus");
                            }
                            if (pingRespond == NodePinger.PING_NO_RESP) {
                                myDebug.important("  <<<<<<<<<????????Ping Not Respond, Identification: " + this.myDevice.getDeviceNameStandard() + " could not ping device ????????>>>>>>> ", new Object[0]);
                                respondedToPing = false;
                            } else {
                                nodeStatus.getStatusValues().put(statusSrcPING, DeviceStatusType.NORMAL);
                            }
                            NodeStatusManager.getDefaultManager().add(nodeStatus);
                            myDebug.fine("<<<<------------dev=" + this.myDevice.getDeviceNameStandard() + " is added to db sucessfully -------->>>>");
                        }
                    }
                    catch (MxException ex) {
                        myDebug.exception((Throwable)ex);
                    }
                } else {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.myDevice, false);
                }
                // ** MonitorExit[totalTime] (shouldn't be in output)
                this.myDbgStr = "add extra nodes discovered during identification";
                myDebug.fine("      ---> add extra nodes discovered during identification?");
                this.addListOfMxNodes(theIdInfoData);
                this.myDbgStr = "send disc msg";
                myDebug.fine("      ---> send discovery message");
                this.sendDiscoveryResponseIfNeeded();
                this.myIdCoordinator.clear();
                myDebug.fine("<<<<------------ Identification Coordinator was cleared for dev=" + this.myDevice.getDeviceNameStandard() + " -------->>>>");
                if (respondedToPing) {
                    this.appendMxTargetStatusOutput(this.getTargetStatus(), "licMgr", null);
                    this.stLicTime = System.currentTimeMillis();
                    this.myDbgStr = "get license data";
                    GatherLicenseData licGetter = new GatherLicenseData();
                    licGetter.run(this.myDevice);
                    this.totLicTime += System.currentTimeMillis() - this.stLicTime;
                    this.stLicTime = 0L;
                    this.stTrustTime = System.currentTimeMillis();
                    this.myDbgStr = "check trust";
                    boolean trusted = DetermineTrustStatus.makeTrustRequest((MxNode)this.myDevice);
                    this.totTrustTime += System.currentTimeMillis() - this.stTrustTime;
                    if (trusted) {
                        this.appendMxTargetStatusOutput(this.getTargetStatus(), "smhTrusted", null);
                    } else {
                        this.appendMxTargetStatusOutput(this.getTargetStatus(), "smhNotTrusted", null);
                    }
                    this.stTrustTime = 0L;
                    this.appendMxTargetStatusOutput(this.getTargetStatus(), "limitedDc", null);
                    this.myDbgStr = "start gettting simple DC data";
                    this.getSimpleDcAttributes(this.myDevice, theIdInfoData);
                    this.myDbgStr = "done getting simple DC data";
                    this.appendMxTargetStatusOutput(this.getTargetStatus(), "sysRelationship", null);
                    this.myDbgStr = "Run assoc";
                    this.doNodeAssociations(this.myDevice, theIdInfoData);
                    this.myDbgStr = "Done assoc";
                } else {
                    myDebug.fine("  <<<???? Ping does not respond; no association is done. ???>>>");
                    if (this.myJobTargetStatus != null) {
                        try {
                            MxCoreTransaction tx = new MxCoreTransaction();
                            List existingMros = MpoController.getDefaultController().getListofManagementPathsManaging((MxTransaction)tx, this.myDevice.getGUID());
                            if (existingMros.size() == 0) {
                                this.myJobTargetStatus.setState(MxTargetState_t.FAILED);
                                this.appendMxTargetStatusOutput(this.getTargetStatus(), "nopingresp", null);
                            }
                        }
                        catch (Exception e) {
                            myDebug.panic((Throwable)e);
                        }
                    }
                }
                if (this.myDevice.getDeviceType().equals("Switch")) {
                    NodeStatus nodeStatus = new NodeStatus(this.myDevice.getDeviceKey());
                    nodeStatus.setDeviceKey(this.myDevice.getDeviceKey());
                    nodeStatus.getStatusValues().put(SWDeploymentDcComp.SWStatusSource, DeviceStatusType.SW_SWITCH);
                    try {
                        NodeStatusManager.getDefaultManager().update(nodeStatus);
                    }
                    catch (NodeStatusPersistenceException nspe) {
                        myDebug.error("DeviceIdentifyThread. error updating status " + (Object)((Object)nspe));
                    }
                }
                this.myDbgStr = "Done ID  ";
                if (this.myJobTargetStatus != null && !this.myJobTargetStatus.isTerminal()) {
                    this.myJobTargetStatus.setState(MxTargetState_t.COMPLETE);
                    this.updateCurrentTargetStatus(this.myJobTargetStatus);
                }
                this.appendMxTargetStatusOutput(this.getTargetStatus(), "done", null);
            }
        }
        catch (Exception e) {
            this.myDbgStr = "Exception in ID  " + e;
            myDebug.panic("EXCEPTION in Identification Thread " + e);
            myDebug.exception((Throwable)e);
        }
        finally {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - this.startTime;
            this.totAllTime += totalTime;
            this.startTime = 0L;
            ++this.cnt;
            myDebug.fine("Identification: Done with " + this.myDevice.getDeviceNameStandard() + " in " + totalTime + " milli seconds error ocurred " + this.errorOcurred);
        }
        {
            return;
        }
    }

    private void sendDiscoveryResponseIfNeeded() {
        if (this.myDiscEvent != null) {
            GenericEvent tmpEv = (GenericEvent)this.myDiscEvent;
            if (tmpEv.getData() instanceof DiscoveryEventData) {
                DiscoveryEventData srcData = (DiscoveryEventData)tmpEv.getData();
                if (srcData.getWaitForAdd()) {
                    GenericReplyEvent discResp = new GenericReplyEvent((Object)this, "core.discover.node.done", this.myDiscEvent, null);
                    InterconnectEngine.getDefaultEngine().fireEvent((AutomationEvent)discResp);
                }
                if (srcData.getAutoDiscoveryStatusObj() == null) {
                    ArrayList<MxObjectID> succesfullNodeIds = new ArrayList<MxObjectID>();
                    ArrayList failedNodeIds = new ArrayList();
                    succesfullNodeIds.add(this.getDevice().getObjectID());
                    DiscoveryDoneJMSMessageBody jmsMsg = new DiscoveryDoneJMSMessageBody(succesfullNodeIds, failedNodeIds, false, "");
                    DiscoveryJMSPublisher.setAyncJMSDiscoveryDoneMsg((DiscoveryDoneJMSMessageBody)jmsMsg);
                }
            }
        } else {
            myDebug.fine("Identify without discovery event, must be ID task not discovery ");
        }
    }

    private void getSimpleDcAttributes(MxNode device, DeviceIdentificationData deviceIdInfo) {
        this.myDbgStr = "rm waker db";
        this.stDcTime = System.currentTimeMillis();
        myDebug.fine(" <<<<----Start Simple DC for dev=" + device.getDeviceNameStandard() + ", starttime=" + this.stDcTime + " --->>>> ");
        RmWakerDcComp rwdcc = new RmWakerDcComp();
        rwdcc.determineOutputState(device);
        Vector simpleDcStorage = new Vector();
        DcCoordinator theDc = new DcCoordinator();
        this.myDbgStr = "simple DC";
        if (this.myDcCategoryList == null) {
            DCCategories dcCat = DCCategories.findCategoryByName((String)"Identification Supplement");
            Integer dcCatId = new Integer(dcCat.getClassId());
            this.myDcCategoryList = new Vector(1);
            this.myDcCategoryList.addElement(dcCatId);
            myDebug.finest("Simple dc, id data -- setup for category " + dcCat.getClassName() + " (classId=" + dcCatId + ")");
        }
        simpleDcStorage.clear();
        theDc.clear();
        theDc.setDevice(device);
        theDc.setCollectSNMPDataState(true);
        theDc.setCollectDMIDataState(true);
        theDc.setCollectWBEMDataState(true);
        theDc.setCollectHistoricalDataState(false);
        theDc.setCategoryList((List)this.myDcCategoryList);
        theDc.setUserStorage(simpleDcStorage);
        theDc.setTellReportingToRefresh(false);
        theDc.setUpdateCimTables(false);
        theDc.run();
        myDebug.fine(" Got back from Simple dc, id data -- after run have " + simpleDcStorage.size());
        List errList = theDc.getMessageIDs();
        if (errList == null || errList.size() == 0) {
            this.appendMxTargetStatusOutput(this.getTargetStatus(), "limitedDcDone", null);
        } else {
            Iterator iter = errList.iterator();
            while (iter.hasNext()) {
                this.appendMxTargetStatusOutput(this.getTargetStatus(), (String)iter.next(), null);
            }
        }
        for (Object obj : simpleDcStorage) {
            PolledDataResponse respData = (PolledDataResponse)obj;
            String idxStr = respData.getIndexString();
            String respondValStr = respData.getParsedResponseString();
            if (myDebug.check(40)) {
                myDebug.finer("Looking at item data " + respData.getPolledItem().getPollId() + " idx " + idxStr + " val " + respondValStr);
            }
            if (!(respData.getPolledItem().getPollId() != 700 && respData.getPolledItem().getPollId() != 710 && respData.getPolledItem().getPollId() != 714 || respondValStr == null || respondValStr.trim().length() <= 0 || deviceIdInfo.getSerialNumber() != null && deviceIdInfo.getSerialNumber().trim().length() != 0)) {
                deviceIdInfo.setSerialNumber(respondValStr);
                device.setSerialNumber(deviceIdInfo.getSerialNumber().trim());
            }
            if (respData.getPolledItem().getPollId() == 715 && respondValStr != null) {
                device.setProductId(respondValStr.trim());
            }
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), device, false);
            }
            catch (MxException ex) {
                myDebug.exception((Throwable)ex);
            }
        }
        this.totDcTime += System.currentTimeMillis() - this.stDcTime;
        myDebug.fine(" <<<<----Done Getting Simple DC for dev=" + device.getDeviceNameStandard() + ", total DC time=" + this.totDcTime + " --->>>> ");
        this.stDcTime = 0L;
    }

    protected void appendMxTargetStatusOutput(MxTargetStatus currentTargetStatus, String propId, String detail) {
        if (currentTargetStatus == null || this.myJob == null) {
            myDebug.finer("Cannot update target status for ID thread, no job or no target status - Discovery?");
            return;
        }
        myDebug.finest("writing common MxTargetStatus log detail data {0}", new Object[]{propId});
        currentTargetStatus.setExitCode(0);
        MxTargetOutput output = currentTargetStatus.getOutput();
        if (propId != null) {
            currentTargetStatus.appendToOutput(propId);
        }
        if (detail != null) {
            currentTargetStatus.appendToOutput(detail);
        }
        output.setExitCode(0);
        this.updateCurrentTargetStatus(currentTargetStatus);
    }

    protected void updateCurrentTargetStatus(MxTargetStatus targetStatus) {
        if (this.myJob != null && targetStatus != null) {
            this.myJob.addTargetStatus((MxTargetStatus)targetStatus.clone());
            this.reportStatusChange(targetStatus);
        }
    }

    private void reportStatusChange(MxTargetStatus targetStatus) {
        try {
            MxAutomationJobIfc myJobIfc = (MxAutomationJobIfc)MxJobManager.getJobIfc((String)this.myJob.getJobID());
            myJobIfc.updateTargetStatus((MxTargetStatus)targetStatus.clone());
            if (this.myJob.getState().isTerminal()) {
                myJobIfc.updateJobStatus(this.myJob);
            }
        }
        catch (Exception ex) {
            myDebug.exception((Throwable)ex);
        }
    }

    private void doNodeMerge(MxNode foundNodeByUUID) {
        int newNodeKey;
        int foundNodeKey = foundNodeByUUID.getKey();
        if (foundNodeKey != (newNodeKey = this.myDevice.getKey())) {
            myDebug.fine("system {0} has been resolved via resolver, found in DB {1}, different ", new Object[]{this.myDevice.getDebugString(), foundNodeByUUID.getDebugString()});
            foundNodeByUUID.mergeNodeData(this.myDevice, true);
            String discDevDobbyDSId = this.myDevice.getClientAttribute("DSId");
            if (discDevDobbyDSId != null) {
                // empty if block
            }
            try {
                NodeUrlManager.getDefaultManager().mergeAllUrlsForNodeAtoNodeB(this.myDevice.getKey(), foundNodeByUUID.getKey());
                myDebug.fine(" --> merged all url for node a to node b ");
            }
            catch (NodeUrlPersistenceException ex2) {
                myDebug.exception((Throwable)ex2);
            }
            try {
                MpoController.getDefaultController().mergeManagementPathsFromNodeAtoNodeB(this.myDevice.getGUID(), foundNodeByUUID.getGUID());
                myDebug.fine(" --> merged managed path objects from node a to node b ");
            }
            catch (MxObjectPersistenceException ex4) {
                myDebug.exception((Throwable)ex4);
            }
            catch (MxUndefinedNodeException ex4) {
                myDebug.exception((Throwable)ex4);
            }
            lmBean licenseBean = new lmBean();
            licenseBean.lmReconcile(this.myDevice, foundNodeByUUID);
            if ((foundNodeByUUID.getSnoozeTime() == -2 || foundNodeByUUID.getSnoozeTime() == -3) && foundNodeByUUID.getIPAddressCount() > 0) {
                foundNodeByUUID.setSnoozeTime(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListOfMxNodes(DeviceIdentificationData devIDData) {
        MxNode existingNode = null;
        String virtualNodeType2 = null;
        for (String virtualNodeType2 : devIDData.getMultiListOfNodes().keySet()) {
            ArrayList virtualNodeList;
            myDebug.fine("    <<<<oooooo adding " + virtualNodeType2 + " oooooo>>>>");
            if (virtualNodeType2.equalsIgnoreCase("hpvmguest")) {
                String hpvmguestDisc = GlobalSettings.getProperty((String)"hpvmDisc_enabled_state", (String)"NOT");
                if (!hpvmguestDisc.equalsIgnoreCase("checked")) {
                    myDebug.fine(" ---> the hpvmguest discovery check-box is not checked ");
                    return;
                }
            } else if (virtualNodeType2.equalsIgnoreCase("npar")) {
                String nparDisc = GlobalSettings.getProperty((String)"nparDisc_enabled_state", (String)"NOT");
                if (!nparDisc.equalsIgnoreCase("checked")) {
                    myDebug.fine(" ---> the npar discovery check-box is not checked ");
                    return;
                }
            } else if (virtualNodeType2.equalsIgnoreCase("vpar")) {
                String vparDisc = GlobalSettings.getProperty((String)"vparDisc_enabled_state", (String)"NOT");
                if (!vparDisc.equalsIgnoreCase("checked")) {
                    myDebug.fine(" ---> the vpar discovery check-box is not checked ");
                    return;
                }
            } else {
                myDebug.fine("   ---> found list of nodes for virtualType=" + virtualNodeType2 + ", don't need to add them for bullwinkle");
                continue;
            }
            ArrayList arrayList = virtualNodeList = devIDData.getListOfNodesByType(virtualNodeType2);
            synchronized (arrayList) {
                for (MxNode aNode : virtualNodeList) {
                    existingNode = null;
                    String curUniqueIdent = aNode.getUniqueIdentifier();
                    if (curUniqueIdent.equalsIgnoreCase("")) continue;
                    try {
                        existingNode = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(curUniqueIdent);
                    }
                    catch (MxUndefinedNodeException ex3) {
                        myDebug.fine("  <<-->> node=" + aNode.getDebugString() + " not found in db" + ", uniqueIDENT=" + curUniqueIdent);
                    }
                    if (existingNode != null) {
                        myDebug.fine("  <<-->> found the node=" + aNode.getDebugString() + " in db, trying merge " + ", uniqueIDENT=" + curUniqueIdent);
                        if (aNode.getIPAddressCount() <= 0) continue;
                        this.addToDiscoveryList(aNode);
                        continue;
                    }
                    try {
                        existingNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(curUniqueIdent);
                    }
                    catch (MxUndefinedNodeException ex3) {
                        myDebug.fine("  <<-->> node=" + aNode.getDebugString() + " not found in db" + ", agentUUID=" + curUniqueIdent);
                    }
                    if (existingNode != null) {
                        myDebug.fine("  <<-->> found the node=" + aNode.getDebugString() + " in db, trying merge " + ", agentUUID=" + curUniqueIdent);
                        if (aNode.getIPAddressCount() <= 0) continue;
                        this.addToDiscoveryList(aNode);
                        continue;
                    }
                    if (existingNode != null) continue;
                    try {
                        MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), aNode);
                        myDebug.fine("  <<-->> added node=" + aNode.getDebugString() + " to db" + ", uniqueIDENT=" + curUniqueIdent);
                        if (aNode.getIPAddressCount() <= 0) continue;
                        this.addToDiscoveryList(aNode);
                    }
                    catch (MxException e) {
                        myDebug.panic("  <<<????>>>MxNodeController.addNode() returns an exception in addListOfMxNodes() for node= " + aNode.getNameString() + ", uniqueID=" + curUniqueIdent);
                    }
                }
            }
        }
    }

    private void addToDiscoveryList(MxNode nodeToDiscover) {
        boolean doIdentification = false;
        try {
            if (nodeToDiscover.getIPAddressCount() > 0) {
                nodeToDiscover.setSnoozeTime(0);
                doIdentification = true;
            }
            DiscoveryController.getDefaultController().discoverASystem((MxTransaction)new MxCoreTransaction(), nodeToDiscover, doIdentification, "ID", false);
        }
        catch (MxException e) {
            myDebug.fine(" DiscoverASystem caught an exception" + nodeToDiscover.getIPAddress(0) + "exception=" + e.getLocalizedMessage());
        }
    }

    private void doNodeAssociations(MxNode device, DeviceIdentificationData devIDData) {
        this.stAssocTime = System.currentTimeMillis();
        myDebug.fine("<<<<------------Start node association handlers for dev=" + this.myDevice.getDeviceNameStandard() + " starts at=" + this.stAssocTime + " -------->>>>");
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            myNodeAssociationsManager.startDeviceAssociations(device.getDeviceKey(), devIDData);
        }
        catch (NodeAssociationsPersistenceException nape) {
            myDebug.error("NodeAssociationsPersistenceException in deviceIdentifyThread " + (Object)((Object)nape));
            myDebug.exception((Throwable)nape);
        }
        catch (Throwable ex) {
            myDebug.panic(ex);
        }
        this.totAssocTime += System.currentTimeMillis() - this.stAssocTime;
        myDebug.fine("<<<<------------End node association handlers for dev=" + this.myDevice.getDeviceNameStandard() + " total association time=" + this.totAssocTime + " -------->>>>");
        this.stAssocTime = 0L;
    }

    private boolean isDeviceRespondedToPing(MxNode device, String ipaddress, int pingRet) {
        boolean respondedToPing = true;
        if (ipaddress == null) {
            myDebug.important("Identification: " + device.getDeviceNameStandard() + " has no working address", new Object[0]);
            respondedToPing = false;
        }
        if (pingRet == NodePinger.PING_IPRESP_CHANGE) {
            myDebug.error("Identification: " + device.getDeviceNameStandard() + " ** pinged device, but got new primary address - ID will not run, discover message was sent");
            respondedToPing = false;
        }
        if (pingRet == NodePinger.PING_NO_RESP) {
            myDebug.error("Identification: " + device.getDeviceNameStandard() + " ** pinged device, it did not respond");
            respondedToPing = false;
        }
        if (respondedToPing) {
            myDebug.fine("  <--->device=", new Object[]{device.getDeviceNameStandard() + " responded to ping "});
        } else {
            myDebug.fine("  <--->device=", new Object[]{device.getDeviceNameStandard() + " doesn't respond to ping "});
        }
        return respondedToPing;
    }

    private boolean doesDevicePassFilter(DeviceIdentificationData devIDData) {
        String discSource;
        boolean isOkToFilter = false;
        if (this.mySourceOfDiscoveryRequest != null && ((discSource = this.mySourceOfDiscoveryRequest.getDiscoverySource()).equals("Ping") || discSource.equals("Manual") || discSource.equals("ID") || discSource.equals("SNMP Trap") || discSource.equals("Generic Event"))) {
            isOkToFilter = true;
            myDebug.fine("[doesDevicePassFilter] Discovery source = " + discSource + ", it's okay to filter");
        }
        boolean passesFilter = true;
        String compareDeviceType = this.myDevice.getDeviceType();
        if (this.myDevice.getDeviceType().equals("Cluster") || this.myDevice.getDeviceType().equals("Enclosure") || this.myDevice.getDeviceType().equals("Rack")) {
            compareDeviceType = "Server";
        }
        if (isOkToFilter && GlobalSettings.getProperty((String)"DiscFilterState", (String)"").equals("enabled")) {
            boolean continueChecking = false;
            String curSettings = GlobalSettings.getProperty((String)"DiscFilterTypes", (String)"");
            StringTokenizer devTypeParser = new StringTokenizer(curSettings, ",");
            myDebug.fine("\t[doesDevicePassFilter] Valid types are -" + curSettings);
            Vector<String> curSelections = new Vector<String>(15);
            while (devTypeParser.hasMoreTokens()) {
                String stringValue = devTypeParser.nextToken();
                curSelections.addElement(stringValue);
            }
            if (curSelections.size() > 0) {
                if (!curSelections.contains("Storage") && this.hasStorageSubtypes()) {
                    myDebug.fine("\tDevice being FILTERED OUT for SMI or Storage subtypes.");
                    passesFilter = false;
                } else if (!curSelections.contains(compareDeviceType)) {
                    myDebug.fine("\tDevice being FILTERED OUT for device type that does not match discovery filter.");
                    passesFilter = false;
                } else if (curSelections.contains("OnlyHp")) {
                    if (!this.mySkipIdentifers && !devIDData.getIsCompaqAndHpDevice()) {
                        myDebug.fine("\tDevice being FILTERED OUT for not being an HP device.");
                        passesFilter = false;
                    }
                } else if (!(this.mySkipIdentifers || !curSelections.contains("OnlyMgmt") || this.myDevice.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO) || this.myDevice.getIsProtocolSupported(MgmtProtoType_t.DMI_PROTO) || this.myDevice.getIsProtocolSupported(MgmtProtoType_t.HTTP_PROTO) || this.myDevice.getIsProtocolSupported(MgmtProtoType_t.WBEM_PROTO) || this.myDevice.getIsProtocolSupported(MgmtProtoType_t.SSH_PROTO))) {
                    myDebug.fine("\tDevice being FILTERED OUT for not being manageable - it has no mgmt protocols.");
                    passesFilter = false;
                }
            }
        }
        myDebug.fine("[doesDevicePassFilter] dev=" + this.myDevice.getDeviceNameStandard() + ", passes=" + passesFilter + "\n");
        return passesFilter;
    }

    private boolean hasStorageSubtypes() {
        List devSubtypes = this.myDevice.getDeviceSubTypes();
        return devSubtypes.contains(NodeSubTypeMapper.SMI_SUBTYPE.toString()) || devSubtypes.contains(NodeSubTypeMapper.STORAGE_SUBTYPE.toString());
    }

    private MxNode fixNodeWithMib2SysName(MxNode foundNodeByUUID) {
        MxNode nodeToKeep = null;
        int foundNodeKey = foundNodeByUUID.getKey();
        int newNodeKey = this.myDevice.getKey();
        String foundNodeSnmpSysName = foundNodeByUUID.getDeviceName(1);
        String discDevSnmpSysName = this.myDevice.getDeviceName(1);
        String discDevNodeName = this.myDevice.getNameString();
        String foundNodeName = foundNodeByUUID.getNameString();
        if (this.getSourceOfDiscoveryRequest() != null && this.getSourceOfDiscoveryRequest().getNodeToDiscover() != null) {
            discDevNodeName = this.getSourceOfDiscoveryRequest().getNodeToDiscover().getNameString();
        }
        if (foundNodeKey == newNodeKey) {
            if (discDevSnmpSysName != null && discDevSnmpSysName.length() > 0) {
                MxNode srcNode;
                String srcIp;
                myDebug.fine("  ---> disc dev SNMP SYS name=" + discDevSnmpSysName);
                if (this.getSourceOfDiscoveryRequest() != null && this.getSourceOfDiscoveryRequest().getNodeToDiscover() != null && discDevSnmpSysName.equalsIgnoreCase(discDevNodeName = this.getSourceOfDiscoveryRequest().getNodeToDiscover().getNameString()) && this.getSourceOfDiscoveryRequest() != null && (srcIp = (srcNode = this.getSourceOfDiscoveryRequest().getNodeToDiscover()).getWorkingAddress()) != null && this.myDevice.getWorkingAddress() != null && !this.myDevice.getWorkingAddress().equals(srcIp)) {
                    myDebug.fine("  ---> disc dev SNMP SYS set primary IP to {0} for name={1}", new Object[]{srcIp, discDevSnmpSysName});
                    this.myDevice.setActiveIpAddress(srcIp, true);
                    nodeToKeep = this.myDevice;
                }
            }
            return nodeToKeep;
        }
        if (discDevSnmpSysName != null && discDevSnmpSysName.length() > 0 && foundNodeSnmpSysName != null && foundNodeSnmpSysName.length() > 0 && foundNodeSnmpSysName.equalsIgnoreCase(discDevSnmpSysName)) {
            myDebug.fine("  ---> disc dev SNMP SYS name=" + discDevSnmpSysName);
            if (discDevNodeName.equalsIgnoreCase(foundNodeSnmpSysName)) {
                myDebug.fine("For SysName and primary IP, use current node as preferred");
                return this.handleClusterAppNameAndIPs(this.myDevice, foundNodeByUUID);
            }
            myDebug.fine("For SysName and primary IP, use foundbyId node as preferred");
            return this.handleClusterAppNameAndIPs(foundNodeByUUID, this.myDevice);
        }
        return null;
    }

    private MxNode handleClusterAppNameAndIPs(MxNode preferred, MxNode second) {
        Iterator discDevIPAddrIter = null;
        MxNode nodeToKeep = null;
        MxNode nodeToDel = null;
        boolean isUsingSecondary = false;
        if (preferred.isDevicePending() && second.isDeviceInDB()) {
            discDevIPAddrIter = preferred.getIPAddressList().iterator();
            nodeToKeep = second;
            nodeToDel = preferred;
            isUsingSecondary = true;
        } else if (second.isDevicePending() && preferred.isDeviceInDB()) {
            discDevIPAddrIter = second.getIPAddressList().iterator();
            nodeToKeep = preferred;
            nodeToDel = second;
        } else {
            discDevIPAddrIter = preferred.getIPAddressList().iterator();
            nodeToKeep = preferred;
            nodeToDel = second;
        }
        String foundNodeFDNSName = preferred.getHostName();
        String discDevFDNSName = second.getHostName();
        ArrayList<String> otherFDNSNames = nodeToKeep.getClientAttributeList(OTHER_HOST_NAME);
        if (otherFDNSNames == null) {
            otherFDNSNames = new ArrayList<String>();
        }
        if (foundNodeFDNSName != null && foundNodeFDNSName.length() > 0 && !otherFDNSNames.contains(foundNodeFDNSName)) {
            otherFDNSNames.add(foundNodeFDNSName);
        }
        if (discDevFDNSName != null && discDevFDNSName.length() > 0 && !otherFDNSNames.contains(discDevFDNSName)) {
            otherFDNSNames.add(discDevFDNSName);
        }
        if (otherFDNSNames.size() > 0) {
            nodeToKeep.setClientAttributeList(OTHER_HOST_NAME, otherFDNSNames);
        }
        if (isUsingSecondary) {
            nodeToKeep.setHostName(preferred.getHostName());
            nodeToKeep.setName(preferred.getName());
        }
        boolean setPrimary = false;
        while (discDevIPAddrIter.hasNext()) {
            String curIp = (String)discDevIPAddrIter.next();
            if (isUsingSecondary && !setPrimary) {
                nodeToKeep.setActiveIpAddress(curIp, true);
                setPrimary = true;
            } else {
                nodeToKeep.addIPAddress(curIp);
            }
            nodeToDel.removeIPAddress(curIp);
            myDebug.fine(" --> added ip address from discover device to foundNodeByUUID");
        }
        if (nodeToDel != null) {
            myDebug.fine("Will delete cluster app node not yet added to db {0} ", new Object[]{nodeToDel.getDebugString()});
            try {
                MxNodeController.getDefaultControllerNoEx().deleteNode((MxTransaction)new MxCoreTransaction(), nodeToDel);
            }
            catch (MxUndefinedNodeException ex) {
                myDebug.fine(" disc node is not yet added; delete failed, it's okay");
            }
            catch (MxException e) {
                myDebug.fine(" delete failed due to other exceptions, e=" + e.getMessage());
            }
        }
        return nodeToKeep;
    }

    private boolean isDeviceVirtual(MxNode tmpDev) {
        boolean isDeviceVirtual = false;
        String isThisACluster = tmpDev.getSWAttribute("isThisACluster");
        if (tmpDev.getDeviceType().equals("Cluster") || isThisACluster != null && isThisACluster.equals("yes")) {
            myDebug.fine("  ---> device is a cluster, dev=" + tmpDev.getHostName());
            isDeviceVirtual = true;
            return isDeviceVirtual;
        }
        String isThisAComplexNode = tmpDev.getSWAttribute("isThisAComplexNode");
        if (tmpDev.getDeviceType().equals("Complex") || isThisAComplexNode != null && isThisAComplexNode.equals("yes")) {
            isDeviceVirtual = true;
            myDebug.fine("  ---> device is a complex, dev=" + tmpDev.getHostName());
            return isDeviceVirtual;
        }
        String isVirtualSet = tmpDev.getSWAttribute("isVirtualNode");
        if (isVirtualSet != null && isVirtualSet.equals("yes")) {
            isDeviceVirtual = true;
            myDebug.fine("  ---> device is has virtual flag set, dev=" + tmpDev.getDebugString());
            return isDeviceVirtual;
        }
        return isDeviceVirtual;
    }
}

