/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification;

import com.hp.mx.core.controllers.DiscoveryController;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxInvalidOsRevisionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.taskmanager.MxRunnableTask;
import com.hp.mx.core.tools.discovery.DiscoveryEventData;
import com.hp.mx.core.tools.identification.BaseIdentifier;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.DeviceIdentifyThread;
import com.hp.mx.core.tools.identification.IdentifierIfc;
import com.hp.mx.core.tools.identification.IdentifierPluginData;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IdentifierCoordinator {
    public static DebugSubsystem myDebug = new DebugSubsystem(IdentifierCoordinator.class, "The identification tool debugs ");
    private MxNode device;
    private MxRunnableTask myCurrentTask;
    private int errorOcurred = 0;
    private DeviceIdentifyThread myParentThread;
    private String dbgStr = "?";
    private long startTime = 0L;
    private long totAllTime = 0L;
    private long cnt;
    private MxNode mySourceNodeData;
    private DiscoveryEventData myDiscSource;
    private DeviceIdentificationData myDeviceIdData;
    private boolean myIsDeviceResponding = true;
    private static List ourListOfIdentifierPluginDataObjects = new ArrayList();
    private static NodeSubTypeMapper ourNodeSubTypeMapper = null;
    private String myThreadIdentifier;
    private ThreadGroup parentThreadGroup = null;
    List myListOfIdentifierClasses = new ArrayList();

    public IdentifierCoordinator() {
        this("", Thread.currentThread().getThreadGroup());
    }

    public IdentifierCoordinator(String ID, ThreadGroup parentThreadGroup) {
        this.myThreadIdentifier = ID;
        this.parentThreadGroup = parentThreadGroup;
        IdentifierCoordinator.readIdentificationPluginXml();
        this.loadPluginClasses();
    }

    public static synchronized void readIdentificationPluginXml() {
        if (ourListOfIdentifierPluginDataObjects.size() == 0) {
            ourListOfIdentifierPluginDataObjects = DiscoveryController.getDefaultController().getLoadedIdentifierList();
        }
        if (ourNodeSubTypeMapper == null) {
            ourNodeSubTypeMapper = NodeSubTypeMapper.getDefaultMapper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginClasses() {
        List list = this.myListOfIdentifierClasses;
        synchronized (list) {
            this.myListOfIdentifierClasses.clear();
            for (IdentifierPluginData curPluginDef : ourListOfIdentifierPluginDataObjects) {
                String curClassName = curPluginDef.getPluginClassName();
                Class<?> c = null;
                try {
                    c = Class.forName(curClassName);
                }
                catch (Exception ex) {
                    myDebug.error("Identifer class load error on " + curClassName + " " + ex);
                    myDebug.exception((Throwable)ex);
                    continue;
                }
                catch (NoClassDefFoundError ex) {
                    myDebug.error("Identifer class load error on " + curClassName + " " + ex);
                    myDebug.exception((Throwable)ex);
                    continue;
                }
                if (IdentifierIfc.class.isAssignableFrom(c)) {
                    try {
                        IdentifierIfc curIdClass = (IdentifierIfc)c.newInstance();
                        this.myListOfIdentifierClasses.add(curIdClass);
                        if (curIdClass instanceof BaseIdentifier) {
                            BaseIdentifier dbgIdentierObj = (BaseIdentifier)curIdClass;
                            dbgIdentierObj.setMyName(curPluginDef.getMyPluginId());
                            dbgIdentierObj.setThreadsThreadGroup(this.parentThreadGroup);
                            dbgIdentierObj.setThreadIdentifier(this.myThreadIdentifier);
                        }
                        myDebug.log(30, "Identifer class added to list " + curClassName);
                    }
                    catch (InstantiationException ex) {
                        myDebug.log(5, "Identifer class create error on " + curClassName + " " + ex);
                    }
                    catch (Throwable ex) {
                        myDebug.log(5, "Identifer class create error on " + curClassName + " " + ex);
                    }
                    continue;
                }
                myDebug.log(5, "Identifer class does not support the  IdentifierIfc interface " + curClassName);
            }
        }
    }

    protected void setDevice(MxNode d) {
        this.device = d;
    }

    protected void setIdStateData(DeviceIdentificationData devIdData) {
        this.myDeviceIdData = devIdData;
    }

    protected void setSourceNodeData(MxNode srcNode) {
        this.mySourceNodeData = srcNode;
    }

    protected void setDiscoveryRequestSource(DiscoveryEventData discSource) {
        this.myDiscSource = discSource;
    }

    protected void setDeviceResponding(boolean isRespondingRightNow) {
        this.myIsDeviceResponding = isRespondingRightNow;
    }

    protected void setIdThread(DeviceIdentifyThread idThread) {
        this.myParentThread = idThread;
    }

    protected MxNode getDevice() {
        return this.device;
    }

    public void clear() {
        this.device = null;
        this.myCurrentTask = null;
        this.myIsDeviceResponding = true;
        this.mySourceNodeData = null;
        this.myDeviceIdData = null;
        this.myParentThread = null;
    }

    protected void getStatusHdr(StringBuffer sb) {
        Iterator iter = this.myListOfIdentifierClasses.iterator();
        BaseIdentifier dbgIdentierObj = null;
        sb.append("<td>Phase1 tot</td>");
        while (iter.hasNext()) {
            IdentifierIfc curIdentifier = null;
            curIdentifier = (IdentifierIfc)iter.next();
            dbgIdentierObj = null;
            if (!(curIdentifier instanceof BaseIdentifier)) continue;
            dbgIdentierObj = (BaseIdentifier)curIdentifier;
            sb.append("<td>");
            sb.append(dbgIdentierObj.getMyName());
            sb.append("</td>");
        }
    }

    protected void getStatus(StringBuffer sb) {
        if (this.cnt > 0L) {
            sb.append("<td>");
            if (this.startTime != 0L) {
                sb.append(System.currentTimeMillis() - this.startTime);
            } else {
                sb.append(this.totAllTime / this.cnt);
                sb.append(" (avg)");
            }
            sb.append("</td>");
        } else {
            sb.append("<td>na</td>");
        }
        Iterator iter = this.myListOfIdentifierClasses.iterator();
        BaseIdentifier dbgIdentierObj = null;
        while (iter.hasNext()) {
            IdentifierIfc curIdentifier = null;
            curIdentifier = (IdentifierIfc)iter.next();
            dbgIdentierObj = null;
            if (!(curIdentifier instanceof BaseIdentifier)) continue;
            dbgIdentierObj = (BaseIdentifier)curIdentifier;
            sb.append("<td>");
            if (dbgIdentierObj.getLastStartTime() != 0L) {
                sb.append(System.currentTimeMillis() - dbgIdentierObj.getLastStartTime());
                sb.append("<span style='color:blue; font-weight:bold;'>(running)</span>");
            } else {
                if (this.startTime != 0L) {
                    sb.append(dbgIdentierObj.getLastRunTime());
                    sb.append("(last) ");
                }
                if (dbgIdentierObj.getRunCnt() > 0L) {
                    sb.append(dbgIdentierObj.getTotRunTime() / dbgIdentierObj.getRunCnt());
                    sb.append("(avg)");
                } else {
                    sb.append("(never ran)");
                }
            }
            sb.append("</td>");
        }
    }

    protected int getErrorCode() {
        return this.errorOcurred;
    }

    protected void setRunnableTaskObject(MxRunnableTask curTask) {
        this.myCurrentTask = curTask;
    }

    protected void startIdentification() {
        if (this.device == null || this.device.isDeviceDeleted()) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        myDebug.important("Identification Coordinator starting on " + this.device.getDeviceNameStandard(), new Object[0]);
        this.dbgStr = "started " + this.device;
        MxNode idSeedDataNode = this.device;
        if (this.mySourceNodeData != null && this.myDiscSource != null && (this.myDiscSource.getDiscoverySource().equals("Manual") || this.myDiscSource.getDiscoverySource().equals("Soap") || this.myDiscSource.getDiscoverySource().equals("setup") || this.myDiscSource.getDiscoverySource().equals("ID") || this.myDiscSource.getDiscoverySource().equals("cli"))) {
            idSeedDataNode = this.mySourceNodeData;
        }
        if (idSeedDataNode.getDeviceType() != null && idSeedDataNode.getDeviceType().length() > 0 && (idSeedDataNode.getModel() == null || idSeedDataNode.getModel().trim().length() == 0)) {
            this.myDeviceIdData.setCurrentPluginId("previousIdDataLow");
            this.myDeviceIdData.addIdStateInfo(idSeedDataNode.getDeviceType(), idSeedDataNode.getDeviceSubType(), "", 24);
        } else if (idSeedDataNode.getDeviceType() != null && idSeedDataNode.getDeviceType().length() > 0 && idSeedDataNode.getModel() != null && idSeedDataNode.getModel().trim().length() > 0) {
            this.myDeviceIdData.setCurrentPluginId("previousIdDataMed");
            this.myDeviceIdData.addIdStateInfo(idSeedDataNode.getDeviceType(), idSeedDataNode.getDeviceSubType(), idSeedDataNode.getModel(), 30);
        }
        if (!idSeedDataNode.getOSName().equals("")) {
            this.myDeviceIdData.setOSType(idSeedDataNode.getOSName());
        }
        if (!idSeedDataNode.getOSNameStr().equals("")) {
            this.myDeviceIdData.setOSName(idSeedDataNode.getOSNameStr());
        }
        if (!idSeedDataNode.getOSVendor().equals("")) {
            this.myDeviceIdData.setOSVendor(idSeedDataNode.getOSVendor());
        }
        if (!idSeedDataNode.getOSRevision().equals("")) {
            this.myDeviceIdData.setOSVersion(idSeedDataNode.getOSRevision());
        }
        if (!idSeedDataNode.getOSRevisionText().equals("")) {
            this.myDeviceIdData.setOSDescription(idSeedDataNode.getOSRevisionText());
        }
        if (!idSeedDataNode.getSerialNumber().equals("")) {
            this.myDeviceIdData.setSerialNumber(idSeedDataNode.getSerialNumber());
        }
        if (this.myDiscSource != null && this.myDiscSource.getDiscoverySource() != null && this.mySourceNodeData != null) {
            boolean rename = false;
            rename = this.myDiscSource.getDiscoverySource().equals("Ping") || this.myDiscSource.getDiscoverySource().equals("ID") ? this.device.mergeNodeData(this.mySourceNodeData, false) : this.device.mergeNodeData(this.mySourceNodeData, true);
        }
        if (this.myDeviceIdData.getIdStateList().size() == 0) {
            this.myDeviceIdData.setCurrentPluginId("defaultState");
            this.myDeviceIdData.addIdStateInfo("Unmanaged", "None", "", 1);
        }
        if (this.myIsDeviceResponding) {
            Iterator iter = this.myListOfIdentifierClasses.iterator();
            BaseIdentifier dbgIdentierObj = null;
            while (iter.hasNext()) {
                if (this.device.isDeviceDeleted()) {
                    return;
                }
                IdentifierIfc curIdentifier = null;
                try {
                    curIdentifier = (IdentifierIfc)iter.next();
                    dbgIdentierObj = null;
                    if (curIdentifier instanceof BaseIdentifier) {
                        dbgIdentierObj = (BaseIdentifier)curIdentifier;
                        dbgIdentierObj.setLastStartTime(System.currentTimeMillis());
                        dbgIdentierObj.setParentThread(this.myParentThread);
                        this.myParentThread.appendMxTargetStatusOutput(this.myParentThread.getTargetStatus(), "idPluginStart." + dbgIdentierObj.getMyName(), null);
                    } else {
                        this.myParentThread.appendMxTargetStatusOutput(this.myParentThread.getTargetStatus(), "idPluginStart." + curIdentifier.getClass().getName(), null);
                    }
                    myDebug.finer("Run Identification plugin " + curIdentifier.getClass().getName());
                    this.myDeviceIdData.setCurrentPluginId(curIdentifier.getClass().getName());
                    curIdentifier.identifyNode(this.device, this.myDeviceIdData);
                    if (dbgIdentierObj == null) continue;
                    dbgIdentierObj.setParentThread(null);
                    dbgIdentierObj.incrRunCnt();
                    dbgIdentierObj.setTotRunTime(System.currentTimeMillis() - dbgIdentierObj.getLastStartTime());
                    dbgIdentierObj.setLastStartTime(0L);
                }
                catch (Throwable e) {
                    myDebug.error("EXCEPTION in Identification  " + e + " plugin = " + curIdentifier);
                    myDebug.exception(e);
                    dbgIdentierObj.setLastStartTime(0L);
                }
            }
        }
        if (this.myIsDeviceResponding || this.myDiscSource != null && !this.myDiscSource.getDiscoverySource().equals("Ping")) {
            DeviceIdentificationData.IdStateInfo bestGuessItem = this.myDeviceIdData.getBestGuessItem();
            if (bestGuessItem != null) {
                String removeVPar;
                String removeVParMon;
                String removeNPar;
                if (myDebug.check(10)) {
                    myDebug.fine("Identification Coordinator, will use type of " + bestGuessItem.getDevTypeId() + " subType of " + bestGuessItem.getDevSubTypeId() + " model name of " + bestGuessItem.getModelName() + " from " + bestGuessItem.getPluginName());
                }
                if ((bestGuessItem.getDevTypeId() == null || bestGuessItem.getDevTypeId().trim().length() == 0 || bestGuessItem.getDevTypeId().equals("Unmanaged")) && (this.device.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO) || this.device.getIsProtocolSupported(MgmtProtoType_t.DMI_PROTO) || this.device.getIsProtocolSupported(MgmtProtoType_t.SSH_PROTO) || this.device.getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO))) {
                    bestGuessItem.setDevTypeId("Unknown");
                    bestGuessItem.setDevSubTypeId("");
                }
                String isThisACluster = this.device.getSWAttribute("isThisACluster");
                if (this.device.getDeviceType().equals("Cluster") || isThisACluster != null && isThisACluster.equals("yes")) {
                    bestGuessItem.setDevTypeId("Cluster");
                }
                String isThisAComplexNode = this.device.getSWAttribute("isThisAComplexNode");
                if (this.device.getDeviceType().equals("Complex") || isThisAComplexNode != null && isThisAComplexNode.equals("yes")) {
                    if (this.device.getWorkingAddress() == null) {
                        bestGuessItem.setDevTypeId("Complex");
                    } else {
                        this.device.removeClientAttribute("isThisAComplexNode");
                    }
                }
                List allSubtypes = null;
                if (bestGuessItem.getConfidenceLevel() == 4 || bestGuessItem.getConfidenceLevel() == 24 || bestGuessItem.getConfidenceLevel() == 30) {
                    allSubtypes = idSeedDataNode.getDeviceSubTypes();
                    for (String curSt : this.myDeviceIdData.getSubTypeList()) {
                        if (allSubtypes.contains(curSt)) continue;
                        allSubtypes.add(curSt);
                    }
                } else {
                    allSubtypes = this.myDeviceIdData.getSubTypeList();
                }
                if (bestGuessItem.getDevSubTypeId() != null && bestGuessItem.getDevSubTypeId().length() > 0 && !allSubtypes.contains(bestGuessItem.getDevSubTypeId())) {
                    allSubtypes.add(bestGuessItem.getDevSubTypeId());
                }
                if (allSubtypes.size() == 0) {
                    allSubtypes.add("None");
                }
                if ((removeNPar = this.myDeviceIdData.getIdAttribute("removeNParSubType")) != null && removeNPar.equalsIgnoreCase("yes") && allSubtypes.contains(NodeSubTypeMapper.NPAR_SUBTYPE.toString())) {
                    allSubtypes.remove(NodeSubTypeMapper.NPAR_SUBTYPE.toString());
                }
                if ((removeVParMon = this.myDeviceIdData.getIdAttribute("removeVParMonSubType")) != null && removeVParMon.equalsIgnoreCase("yes") && allSubtypes.contains(NodeSubTypeMapper.VPARMONITOR_SUBTYPE.toString())) {
                    allSubtypes.remove(NodeSubTypeMapper.VPARMONITOR_SUBTYPE.toString());
                }
                if ((removeVPar = this.myDeviceIdData.getIdAttribute("removeVParSubType")) != null && removeVPar.equalsIgnoreCase("yes") && allSubtypes.contains(NodeSubTypeMapper.VPAR_SUBTYPE.toString())) {
                    allSubtypes.remove(NodeSubTypeMapper.VPAR_SUBTYPE.toString());
                }
                for (String curSubType : allSubtypes) {
                    try {
                        if (curSubType.length() <= 0) continue;
                        ourNodeSubTypeMapper.getByLabel(curSubType);
                    }
                    catch (Exception ex) {
                        myDebug.error("subtype map NOT found, try to add it " + curSubType);
                        ourNodeSubTypeMapper.addPersistedMap(curSubType);
                    }
                }
                try {
                    if (bestGuessItem.getDevTypeId() != null && bestGuessItem.getDevTypeId().trim().length() > 0) {
                        this.device.setDeviceType(bestGuessItem.getDevTypeId());
                        this.device.setDeviceSubTypes(allSubtypes);
                    } else {
                        myDebug.warning("Warning, no type actually assigned for node set to unknown ");
                        this.device.setDeviceType("Unmanaged");
                        this.device.setDeviceSubTypes(allSubtypes);
                    }
                }
                catch (Exception ex) {
                    myDebug.error("No type/subtype map found ");
                    myDebug.exception((Throwable)ex);
                }
                this.device.setModel(bestGuessItem.getModelName());
                if (bestGuessItem.getModelName() != null && (bestGuessItem.getModelName().toLowerCase().indexOf("compaq") != -1 || bestGuessItem.getModelName().indexOf("DEC") != -1 || bestGuessItem.getModelName().toLowerCase().indexOf("digital") != -1 || bestGuessItem.getModelName().toLowerCase().indexOf("hp") != -1 || bestGuessItem.getModelName().toLowerCase().indexOf("hewlett") != -1)) {
                    this.myDeviceIdData.setIsCompaqAndHpDevice(true);
                }
                if (this.myDeviceIdData.getOSType() != null) {
                    this.device.setOSType(this.myDeviceIdData.getOSType().trim());
                }
                if (this.myDeviceIdData.getOSName() != null) {
                    this.device.setOSNameStr(this.myDeviceIdData.getOSName().trim());
                }
                if (this.myDeviceIdData.getOSDescription() != null) {
                    this.device.setOSRevisionText(this.myDeviceIdData.getOSDescription().trim());
                }
                if (this.myDeviceIdData.getOSVersion() != null) {
                    try {
                        this.device.setOSRevision(this.myDeviceIdData.getOSVersion().trim());
                    }
                    catch (MxInvalidOsRevisionException ex1) {
                        myDebug.exception((Throwable)ex1);
                    }
                }
                if (this.myDeviceIdData.getOSVendor() != null) {
                    this.device.setOSVendor(this.myDeviceIdData.getOSVendor().trim());
                }
            }
            if (this.device.isDeviceInDB()) {
                try {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.device, false);
                }
                catch (MxException ex) {
                    myDebug.exception((Throwable)ex);
                }
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - this.startTime;
            this.totAllTime += totalTime;
            this.startTime = 0L;
            ++this.cnt;
            myDebug.fine("type Identification phase 1: Done with " + this.device.getDeviceName() + " in " + totalTime + " milli seconds error ocurred status= " + this.errorOcurred);
        }
    }

    protected List getUniqueIdentifiers() {
        ArrayList<String> uniqIdStrList = new ArrayList<String>();
        if (this.device == null || this.device.isDeviceDeleted()) {
            return uniqIdStrList;
        }
        this.startTime = System.currentTimeMillis();
        myDebug.important("Identification getUniqueIdentifiers() Coordinator starting on " + this.device.getDeviceNameStandard(), new Object[0]);
        this.dbgStr = "started " + this.device;
        if (this.myIsDeviceResponding) {
            Iterator iter = this.myListOfIdentifierClasses.iterator();
            Object dbgIdentierObj = null;
            while (iter.hasNext()) {
                if (this.device.isDeviceDeleted()) {
                    return uniqIdStrList;
                }
                IdentifierIfc curIdentifier = null;
                try {
                    curIdentifier = (IdentifierIfc)iter.next();
                    myDebug.finer("Run Identification plugin to get unique identifier ", new Object[]{curIdentifier.getClass().getName()});
                    this.myDeviceIdData.setCurrentPluginId(curIdentifier.getClass().getName());
                    String uniqueIDStr = curIdentifier.getUniqueIdentifierFromSystem(this.device, this.myDeviceIdData);
                    myDebug.finer("Run Identification plugin to get unique identifier got string of ", new Object[]{uniqueIDStr});
                    if (uniqueIDStr == null || uniqueIDStr.trim().length() <= 0) continue;
                    uniqIdStrList.add(uniqueIDStr);
                }
                catch (Throwable e) {
                    myDebug.error("EXCEPTION in Identification get unique ID  " + e + " plugin = " + curIdentifier);
                    myDebug.exception(e);
                }
            }
        }
        return uniqIdStrList;
    }
}

