/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification;

import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxOsNames_t;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpHelperMethods;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.BaseIdentifier;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugSubsystem;

public class ProliantSnmpIdentifier
extends BaseIdentifier {
    public static final String UNKNOWN_CPQ_DEVICE = "Unknown HP SNMP Device";
    private static String GUIDOID_STR = "1.3.6.1.4.1.232.11.2.10.3.0";
    private static String SNMPSYSNAME_OID = "1.3.6.1.2.1.1.5.0";
    private static String EMPTY_GUID_STR = "00000000000000000000000000000000";
    private static String EMPTY_GUID_STR2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static String RIBCARD_OIDSTR = "1.3.6.1.4.1.232.9.2.2.10.0";
    private static String INTEGRITY_SERVER_ID = "1.3.6.1.4.1.232.11.2.15.1.0";
    private final String ONBOARD_ADMINISTRATOR_STR = "Onboard Administrator";
    private static DebugSubsystem debugLogger = new DebugSubsystem(ProliantSnmpIdentifier.class);
    public static final String WindowsVer40 = "4.0";
    public static final String WindowsVer50 = "5.0";
    public static final String WindowsVer51 = "5.1";
    private UniqueIdentifierUtility m_uniqueIdentUtil = new UniqueIdentifierUtility();
    private boolean m_isASwitch = false;

    public void identifyNode(MxNode deviceObject, DeviceIdentificationData stateObject) {
        String mibStatusArray = null;
        this.dbgIdStr = "ID#" + this.myThreadIdentifier + " " + deviceObject.getDeviceNameStandard();
        debugLogger.enter("ProliantSnmpIdentifier:identifyNode()");
        this.m_isASwitch = false;
        SnmpRequest snmpReq = new SnmpRequest(deviceObject);
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            debugLogger.fine("--->Proliant SNMP Device Identification skipped (SNMP DISABLED GLOBALLY) on " + this.dbgIdStr);
            this.appendCurTargetStatus("snmp.globaldisable");
            return;
        }
        if (deviceObject.getWorkingAddress() == null) {
            debugLogger.fine("--->ProLiant SNMP  Device Identification skiped no address for " + this.dbgIdStr);
            this.appendCurTargetStatus("snmp.noaddress");
            return;
        }
        if (!deviceObject.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            debugLogger.fine("--->SNMP ProLiant Device Identification skiped snmp not detected on " + this.dbgIdStr);
            this.appendCurTargetStatus("snmp.notsupported");
            return;
        }
        debugLogger.fine("--->Starting ProLiant SNMP Device Identification on " + this.dbgIdStr);
        snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.11.2.10.1.0[1]");
        snmpReq.SnmpGet();
        SnmpResponse curResp = snmpReq.getResponseVarbinds();
        SnmpResponseVarBind vb = curResp.findById(1);
        if (vb == null) {
            debugLogger.fine("--->SNMP ProLiant Device Identification: ProLiant not detected " + this.dbgIdStr);
            this.appendCurTargetStatus("snmp.notproliant");
            return;
        }
        if (vb.isError() || vb.getValue() == null || vb.getValue().length() == 0) {
            if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                stateObject.setTimeOutOccurred(true);
            }
            debugLogger.fine("--->SNMP proliant Device Identification: Proliant not detected " + this.dbgIdStr);
            this.appendCurTargetStatus("snmp.notproliant");
            return;
        }
        stateObject.setIsCompaqAndHpDevice(true);
        mibStatusArray = vb.getValue();
        if (debugLogger.check(10)) {
            debugLogger.fine("--->the device " + this.dbgIdStr + " supports the Mib status array " + mibStatusArray);
        }
        deviceObject.setMibStatusArray(mibStatusArray);
        String octet2MibStatus = mibStatusArray.substring(4, 6);
        debugLogger.finer("--->Value from OCtet 2 : " + octet2MibStatus);
        int octet2IntVal = 0;
        try {
            octet2IntVal = Integer.valueOf(octet2MibStatus, 16);
        }
        catch (NumberFormatException e) {
            debugLogger.error("--->SNMP DEV ID REQ error " + e);
        }
        int isDesktop = (octet2IntVal & 1) / 1;
        boolean foundMp = false;
        foundMp = isDesktop == 1 ? this.proliantSnmpDesktopId(deviceObject, mibStatusArray, stateObject, snmpReq) : this.proliantSnmpServerId(deviceObject, mibStatusArray, stateObject, snmpReq);
        if (!foundMp) {
            this.getProliantOsDataFromMibs(deviceObject, stateObject, snmpReq);
        }
        if (foundMp || this.isThisDeviceVirtual(deviceObject, stateObject)) {
            myDebug.fine("  ----> found MP or cluster, don't set unique identifier for dev=" + deviceObject.getDeviceNameStandard());
            return;
        }
        if (deviceObject.getDeviceType().equals("Cluster")) {
            debugLogger.fine("Note, ProLiant SNMP ID, get unique ID has a cluster device won't get uuid ");
            return;
        }
        String cpqHoGUIDStr = this.getGuidFromSNMP(deviceObject);
        String normalizedGUIDStr = null;
        if (cpqHoGUIDStr != null) {
            stateObject.addAgentUUIDToList(cpqHoGUIDStr);
            normalizedGUIDStr = UniqueIdentifierUtility.normalizeUniqueID((String)cpqHoGUIDStr, (boolean)true, (boolean)true);
            debugLogger.fine("  ----> cpqHoGUID str=" + cpqHoGUIDStr + ", after normalized=" + normalizedGUIDStr + ", for dev=" + deviceObject.getDeviceNameStandard());
            stateObject.addNormUniqueIDENTToList(normalizedGUIDStr);
        }
        debugLogger.exit("ProliantSnmpIdentifier:identifyNode()");
    }

    private String getProductModelForEnclosure(SnmpRequest snmpReq) {
        String productModel = "Proliant BL e-Class Integrated Administrator";
        snmpReq.setAsn1Numbers("1.3.6.1.2.1.1.1.0[1],1.3.6.1.2.1.1.2.0[2],1.3.6.1.2.1.1.5.0[3]");
        snmpReq.SnmpGet();
        SnmpResponse curResp = snmpReq.getResponseVarbinds();
        String sysObjectId = null;
        SnmpResponseVarBind vb = null;
        vb = curResp.findById(2);
        if (vb != null && !vb.isError()) {
            sysObjectId = vb.getOidValue();
        }
        String sysDesc = this.getSimpleStringVal(curResp, 1);
        String productName = this.getSimpleStringVal(curResp, 3);
        if (sysObjectId != null) {
            debugLogger.fine("--->SysObjectID is " + sysObjectId);
            if (sysObjectId.equals("1.3.6.1.4.1.11.5.7.1.2") && sysDesc != null) {
                debugLogger.fine("--->Sys Description  is " + sysDesc);
                if (sysDesc.equalsIgnoreCase("Onboard Administrator")) {
                    productModel = sysDesc;
                }
            }
        }
        return productModel;
    }

    private void getProliantOsDataFromMibs(MxNode deviceObject, DeviceIdentificationData stateObject, SnmpRequest snmpReq) {
        String osDesc;
        String osVers;
        snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.11.2.2.1.0[1],1.3.6.1.4.1.232.11.2.2.2.0[2],1.3.6.1.4.1.232.11.2.2.3.0[3],1.3.6.1.4.1.232.11.2.2.4.0[4]");
        snmpReq.SnmpGet();
        SnmpResponse curResp = snmpReq.getResponseVarbinds();
        String osName = this.getSimpleStringVal(curResp, 1);
        if (osName != null) {
            stateObject.setOSName(osName);
            String osNameLc = osName.toLowerCase();
            if (osNameLc.indexOf("windows") != -1) {
                stateObject.setOSVendor("Microsoft");
                stateObject.setOSType("WINNT");
            } else if (osNameLc.indexOf("red") != -1) {
                stateObject.setOSVendor("RedHat");
                stateObject.setOSType("LINUX");
            } else if (osNameLc.indexOf("debian") != -1) {
                stateObject.setOSVendor("Debian");
                stateObject.setOSType("LINUX");
            } else if (osNameLc.indexOf("united") != -1) {
                stateObject.setOSVendor("United");
                stateObject.setOSType("LINUX");
            } else if (osNameLc.indexOf("linux") != -1) {
                stateObject.setOSType("LINUX");
            } else if (osNameLc.indexOf("novel") != -1) {
                stateObject.setOSVendor("Novell");
                stateObject.setOSType("NOVEL");
            } else if (osNameLc.indexOf("tru64") != -1) {
                stateObject.setOSVendor("HP");
                stateObject.setOSType("Tru64");
            } else if (osNameLc.indexOf("nsk") != -1) {
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_NSK.getOsCode());
                stateObject.setOSVendor("HP");
            } else if (osNameLc.indexOf("open-vms") != -1) {
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_VMS.getOsCode());
            } else if (osNameLc.indexOf("linux") != -1) {
                stateObject.setOSType("LINUX");
            } else if (osNameLc.indexOf("netware") != -1) {
                stateObject.setOSVendor("Novell");
                stateObject.setOSType("NOVEL");
            } else if (osNameLc.indexOf("unixware") != -1) {
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_UNIX.getOsCode());
            } else if (osNameLc.indexOf("sco-unix") != -1) {
                stateObject.setOSVendor("SCO");
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_UNIX.getOsCode());
            } else if (osNameLc.indexOf("os-2") != -1) {
                stateObject.setOSVendor("IBM");
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_OS2.getOsCode());
            } else if (osNameLc.indexOf("compaq") != -1) {
                stateObject.setOSVendor("HP");
                stateObject.setOSType(osName);
            } else if (osNameLc.indexOf("HP") != -1) {
                stateObject.setOSVendor("HP");
                stateObject.setOSType(osName);
            } else {
                stateObject.setOSType(osName);
            }
        }
        if ((osVers = this.getSimpleStringVal(curResp, 2)) != null) {
            if ((osVers = osVers.trim()).equals("4.00")) {
                osVers = WindowsVer40;
            } else if (osVers.equals("V4.0")) {
                osVers = WindowsVer40;
            } else if (osVers.equals(WindowsVer40)) {
                osVers = WindowsVer40;
            } else if (osVers.equals("V4")) {
                osVers = WindowsVer40;
            } else if (osVers.equals("4")) {
                osVers = WindowsVer40;
            } else if (osVers.equals("5.00")) {
                osVers = WindowsVer50;
            } else if (osVers.equals("V5.0")) {
                osVers = WindowsVer50;
            } else if (osVers.equals(WindowsVer50)) {
                osVers = WindowsVer50;
            } else if (osVers.equals("V5")) {
                osVers = WindowsVer50;
            } else if (osVers.equals("5")) {
                osVers = WindowsVer50;
            }
            stateObject.setOSVersion(osVers);
        }
        if ((osDesc = this.getSimpleStringVal(curResp, 3)) != null) {
            stateObject.setOSDescription(osDesc);
        } else if (osName != null) {
            stateObject.setOSDescription(osName);
        }
    }

    private boolean proliantSnmpServerId(MxNode deviceObject, String mibStatusArray, DeviceIdentificationData stateObject, SnmpRequest snmpReq) {
        debugLogger.enter("proliantSnmpServerId()");
        String productType = "Server";
        String productModel = UNKNOWN_CPQ_DEVICE;
        String productSubType = null;
        boolean exactMatch = false;
        boolean hasARib = this.checkMibStatusArrayForMib(mibStatusArray, 9);
        debugLogger.finer("SNMP ID " + this.dbgIdStr + " Is a Compaq Device, Check for RIB " + hasARib);
        snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.4.2.0[1]");
        snmpReq.SnmpGet();
        SnmpResponse curResp = snmpReq.getResponseVarbinds();
        SnmpResponseVarBind vb = curResp.findById(1);
        if (vb == null) {
            debugLogger.warning("--->SNMP ID " + this.dbgIdStr + " no product name in response ");
        } else if (vb.isError()) {
            if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                stateObject.setTimeOutOccurred(true);
                this.appendCurTargetStatus("snmp.noresponse");
                return false;
            }
            if (vb.getIntValue() == SnmpResponseVarBind.NO_SUCH_NAME_ERROR) {
                debugLogger.warning("--->Proliant SNMP ID " + this.dbgIdStr + " no product name ");
            }
        } else if (vb.getValue() != null && vb.getValue().length() > 0) {
            productModel = vb.getValue();
            exactMatch = true;
        }
        if (debugLogger.check(20)) {
            debugLogger.finer("--->Proliant SNMP ID " + this.dbgIdStr + " Is a Proliant server, or any compaq server or mgmt proc, Device model name: " + productModel);
        }
        String isThisACluster = deviceObject.getSWAttribute("isThisACluster");
        int ribLoc = 0;
        if (deviceObject.getDeviceType().equals("Cluster") || isThisACluster != null && isThisACluster.equals("yes")) {
            productType = "Cluster";
        } else {
            if (hasARib) {
                snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.9.2.2.10.0[1]");
                snmpReq.SnmpGet();
                curResp = snmpReq.getResponseVarbinds();
                vb = curResp.findById(1);
                if (vb == null) {
                    // empty if block
                }
                if (vb.isError()) {
                    if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                        stateObject.setTimeOutOccurred(true);
                        this.appendCurTargetStatus("snmp.noresponse");
                        return false;
                    }
                    if (vb.getIntValue() == SnmpResponseVarBind.NO_SUCH_NAME_ERROR) {
                        debugLogger.finer("--->Proliant SNMP ID " + this.dbgIdStr + " no RIB location data,  ");
                        return false;
                    }
                }
                if ((ribLoc = vb.getIntValue()) > 1) {
                    productType = "MgmtProc";
                    stateObject.setOSName(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
                    stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
                    stateObject.setOSDescription("");
                    stateObject.setOSVersion("");
                    stateObject.setOSVendor("HP");
                    if (ribLoc == 4) {
                        productSubType = NodeSubTypeMapper.MP_PBE_IA_SUBTYPE.toString();
                        productModel = this.getProductModelForEnclosure(snmpReq);
                        String theCpqSiSysSerialNo = null;
                        theCpqSiSysSerialNo = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.2.2.2.1.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                        if (theCpqSiSysSerialNo != null && theCpqSiSysSerialNo.trim().length() > 0 && !productModel.contains("Onboard Administrator")) {
                            stateObject.setSerialNumber(theCpqSiSysSerialNo);
                        }
                    } else {
                        String theRibSerialNo = null;
                        theRibSerialNo = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.9.2.2.15.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                        if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0) {
                            stateObject.setSerialNumber(theRibSerialNo);
                        }
                        productModel = "";
                        int modelEnum = SnmpHelperMethods.getIntValueFromMib((String)"1.3.6.1.4.1.232.9.2.2.21.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                        switch (modelEnum) {
                            case 1: {
                                productModel = "Remote Insight";
                                break;
                            }
                            case 2: {
                                productModel = "Remote Insight";
                                break;
                            }
                            case 3: {
                                productModel = "Remote Insight Lights-Out Edition";
                                productSubType = NodeSubTypeMapper.RILOE_SUBTYPE.toString();
                                break;
                            }
                            case 4: {
                                productModel = "Remote Insight Lights-Out Edition";
                                productSubType = NodeSubTypeMapper.RILOE_SUBTYPE.toString();
                                break;
                            }
                            case 5: {
                                productModel = "Integrated Lights-Out";
                                productSubType = NodeSubTypeMapper.ILO_SUBTYPE.toString();
                                break;
                            }
                            case 6: {
                                productModel = "Remote Insight Lights-Out Edition II";
                                productSubType = NodeSubTypeMapper.RILOE2_SUBTYPE.toString();
                                break;
                            }
                            default: {
                                productModel = "Integrated Lights-Out";
                                productSubType = NodeSubTypeMapper.ILO_SUBTYPE.toString();
                            }
                        }
                    }
                }
            }
            if (productType.equals("Server")) {
                productSubType = this.setBasicServerSubType(deviceObject, stateObject, snmpReq, productModel);
            }
            debugLogger.finer("--->Proliant SNMP ID " + this.dbgIdStr + " deviceType " + productType + " rib " + ribLoc + " name " + productModel);
        }
        debugLogger.fine("--->After Proliant server ID : " + this.dbgIdStr + " type " + productType + " Model " + productModel);
        if (!deviceObject.getDeviceType().equals("Cluster")) {
            if (exactMatch) {
                stateObject.addIdStateInfo(productType, productSubType, productModel, 50);
            } else {
                stateObject.addIdStateInfo(productType, null, productModel, 25);
            }
            this.appendCurTargetStatus("snmp.proliantsvsupport");
            debugLogger.fine("--->Proliant SNMP ID DONE " + this.dbgIdStr + " Product Type set to >" + productType + "< Model=" + productModel);
            this.setBladeSubTypesForServers(stateObject, productModel, ribLoc);
        } else {
            debugLogger.fine("--->Proliant SNMP ID DONE " + this.dbgIdStr + " Product Type is currently cluster, will not change ");
            stateObject.addIdStateInfo(productType, null, productModel, 50);
            this.appendCurTargetStatus("snmp.proliantsvsupport");
        }
        debugLogger.exit("proliantSnmpServerId()");
        return productType.equals("MgmtProc");
    }

    private void setBladeSubTypesForServers(DeviceIdentificationData stateObject, String productModel, int ribLoc) {
        boolean isABlade;
        boolean bl = isABlade = productModel.toUpperCase().contains("BL") || productModel.toUpperCase().contains("SB");
        if (!isABlade) {
            debugLogger.fine(" < this is not a blade.>");
            return;
        }
        if (productModel.indexOf("Integrated Administrator") == -1) {
            debugLogger.fine("--->Add Blade subtype" + NodeSubTypeMapper.BLADE_SUBTYPE.toString());
            stateObject.addSubType(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
        }
        if (productModel.endsWith("e")) {
            debugLogger.fine("--->Add Proliant SNMP SUBTYPE SETTING:" + NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
            stateObject.addSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
        } else {
            int BLIndex = 0;
            if (productModel.contains("BL")) {
                BLIndex = productModel.toUpperCase().indexOf("BL");
            } else if (productModel.contains("SB")) {
                BLIndex = productModel.toUpperCase().indexOf("SB");
                debugLogger.fine("--->Add Proliant SNMP SUBTYPE SETTING:" + NodeSubTypeMapper.STORAGE_SUBTYPE.toString());
                stateObject.addSubType(NodeSubTypeMapper.STORAGE_SUBTYPE.toString());
            } else {
                debugLogger.panic(" some logic is wrong; should have never gotten here ");
                return;
            }
            int endBLIndex = productModel.indexOf(" ", BLIndex);
            String subModel = null;
            if (endBLIndex != -1) {
                subModel = productModel.substring(BLIndex, endBLIndex);
                debugLogger.fine("--->Proliant SNMP SUBTYPE SETTING : SUBMODEL String = " + subModel);
            }
            if (subModel != null && subModel.endsWith("c")) {
                debugLogger.fine("--->Add Proliant SNMP SUBTYPE SETTING:" + NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
                stateObject.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
            } else if (subModel != null && subModel.endsWith("p") || ribLoc == 1) {
                debugLogger.fine("--->Add Proliant SNMP SUBTYPE SETTING:" + NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                stateObject.addSubType(NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
            }
        }
    }

    private String setBasicServerSubType(MxNode deviceObject, DeviceIdentificationData stateObject, SnmpRequest snmpReq, String productModel) {
        String productSubType;
        boolean isAStorage;
        String theCpqSiSysSerialNo = null;
        theCpqSiSysSerialNo = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.2.2.2.1.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
        if (theCpqSiSysSerialNo != null) {
            stateObject.setSerialNumber(theCpqSiSysSerialNo);
        }
        boolean bl = isAStorage = productModel.toUpperCase().contains("SB");
        if (isAStorage) {
            String productSubType2 = NodeSubTypeMapper.STORAGE_SUBTYPE.toString();
            return productSubType2;
        }
        if (this.getIsIntegrityServerFromSnmp(deviceObject)) {
            productSubType = "HPIntegrity";
        } else if (productModel.contains("AlphaServer")) {
            productSubType = "HPAlphaServer";
        } else {
            productSubType = "HPProLiant";
            if (!productModel.contains("Proliant")) {
                debugLogger.fine("--->Is the subtype wrong ? for device: " + this.dbgIdStr + "Product Model String: " + productModel);
            }
        }
        debugLogger.finer("--->Setting Server sub Type= " + productSubType);
        return productSubType;
    }

    private int getRibLoc(DeviceIdentificationData stateObject, SnmpRequest snmpReq) {
        SnmpResponse curResp = null;
        SnmpResponseVarBind vb = null;
        int ribLoc = 0;
        snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.9.2.2.10.0[1]");
        snmpReq.SnmpGet();
        curResp = snmpReq.getResponseVarbinds();
        vb = curResp.findById(1);
        if (vb == null) {
            // empty if block
        }
        if (vb.isError()) {
            if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                stateObject.setTimeOutOccurred(true);
                return -1;
            }
            if (vb.getIntValue() == SnmpResponseVarBind.NO_SUCH_NAME_ERROR) {
                debugLogger.finer("Proliant SNMP ID " + this.dbgIdStr + " no RIB location data,  ");
                return -1;
            }
        }
        ribLoc = vb.getIntValue();
        return ribLoc;
    }

    private boolean proliantSnmpDesktopId(MxNode deviceObject, String mibStatusArray, DeviceIdentificationData stateObject, SnmpRequest snmpReq) {
        String productType = "Desktop";
        String productModel = UNKNOWN_CPQ_DEVICE;
        boolean exactMatch = false;
        boolean hasAFormFactor = this.checkMibStatusArrayForMib(mibStatusArray, 2);
        boolean hasARib = this.checkMibStatusArrayForMib(mibStatusArray, 9);
        debugLogger.fine("SNMP ID " + this.dbgIdStr + " Is a Compaq Device, Check for FORM FACTOR " + hasAFormFactor);
        if (hasARib) {
            int ribLoc = this.getRibLoc(stateObject, snmpReq);
            debugLogger.fine("desktop Proliant ID, has rib loc is " + ribLoc);
            if (ribLoc == -1) {
                this.appendCurTargetStatus("snmp.noresponse");
            } else if (ribLoc > 1) {
                productType = "MgmtProc";
                stateObject.setOSName(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
                stateObject.setOSType(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
                stateObject.setOSDescription("");
                stateObject.setOSVersion("");
                stateObject.setOSVendor("HP");
                if (ribLoc == 4) {
                    productModel = this.getProductModelForEnclosure(snmpReq);
                    if (productModel.equalsIgnoreCase("Onboard Administrator")) {
                        stateObject.addSubType(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString());
                        stateObject.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
                    }
                    String theCpqSiSysSerialNo = null;
                    theCpqSiSysSerialNo = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.2.2.2.1.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                    if (theCpqSiSysSerialNo != null && theCpqSiSysSerialNo.trim().length() > 0 && !productModel.contains("Onboard Administrator")) {
                        stateObject.setSerialNumber(theCpqSiSysSerialNo);
                    }
                } else {
                    String theRibSerialNo = null;
                    theRibSerialNo = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.9.2.2.15.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                    if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0) {
                        stateObject.setSerialNumber(theRibSerialNo);
                    }
                    productModel = "";
                    int modelEnum = SnmpHelperMethods.getIntValueFromMib((String)"1.3.6.1.4.1.232.9.2.2.21.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
                    exactMatch = true;
                    switch (modelEnum) {
                        case 1: {
                            productModel = "Remote Insight";
                            break;
                        }
                        case 2: {
                            productModel = "Remote Insight";
                            break;
                        }
                        case 3: {
                            productModel = "Remote Insight Lights-Out Edition";
                            break;
                        }
                        case 4: {
                            productModel = "Remote Insight Lights-Out Edition";
                            break;
                        }
                        case 5: {
                            productModel = "Integrated Lights-Out";
                            break;
                        }
                        case 6: {
                            productModel = "Remote Insight Lights-Out Edition II";
                            break;
                        }
                        default: {
                            productModel = "Integrated Lights-Out";
                        }
                    }
                }
            }
        }
        if (!productType.equals("MgmtProc")) {
            String octetThreeVal = mibStatusArray.substring(6, 8);
            debugLogger.finer("Value from Octet 3: " + octetThreeVal);
            int octetThreeBitsValue = 0;
            try {
                octetThreeBitsValue = Integer.valueOf(octetThreeVal, 16);
            }
            catch (NumberFormatException e) {
                debugLogger.error("SNMP DEV ID REQ error " + e);
            }
            debugLogger.finer("Value from Octet 3: OctetThreeBitsValue " + octetThreeBitsValue);
            int tempPrdType = octetThreeBitsValue & 0x1F;
            switch (tempPrdType) {
                case 0: {
                    productType = "Desktop";
                    break;
                }
                case 1: {
                    productType = "Server";
                    break;
                }
                case 2: {
                    productType = "Desktop";
                    break;
                }
                case 3: {
                    productType = "Workstation";
                    break;
                }
                case 4: {
                    productType = "Portable";
                    break;
                }
                case 5: {
                    productType = "Router";
                    break;
                }
                case 6: {
                    productType = "Cluster";
                    break;
                }
                case 7: {
                    productType = "Printer";
                    break;
                }
                case 8: {
                    productType = "Switch";
                    this.m_isASwitch = true;
                    this.setSerialNumberForSwitches(deviceObject, stateObject);
                    break;
                }
                case 9: {
                    productType = "Hub";
                    break;
                }
                case 10: {
                    productType = "RAS";
                    break;
                }
                case 11: {
                    productType = "Unknown";
                    break;
                }
                case 12: {
                    productType = "MgmtProc";
                    break;
                }
                case 13: {
                    productType = "Rack";
                    break;
                }
                case 14: {
                    productType = "Enclosure";
                    break;
                }
                case 15: {
                    productType = "KVM";
                    break;
                }
                case 16: {
                    productType = "UPS";
                    break;
                }
                case 17: {
                    productType = "PDU";
                    break;
                }
                case 18: {
                    productType = "Env";
                    break;
                }
                default: {
                    productType = "Unknown";
                }
            }
            debugLogger.finer("Proliant ID, PRODUCT TYPE WITH New Octet info : " + this.dbgIdStr + " " + productType);
            snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.4.2.0[1]");
            snmpReq.SnmpGet();
            SnmpResponse curResp = snmpReq.getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(1);
            if (vb == null) {
                debugLogger.warning("SNMP ID " + this.dbgIdStr + " no product name in response ");
            } else if (vb.isError()) {
                if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                    stateObject.setTimeOutOccurred(true);
                    return false;
                }
                if (vb.getIntValue() == SnmpResponseVarBind.NO_SUCH_NAME_ERROR) {
                    debugLogger.warning("SNMP ID " + this.dbgIdStr + " no product name ");
                }
            } else if (vb.getValue() != null && vb.getValue().length() > 0) {
                productModel = vb.getValue();
                exactMatch = true;
                this.setSubTypesForNonServers(stateObject, productModel);
            }
            debugLogger.fine("SNMP ID " + this.dbgIdStr + " Is a HP proliant (desktop flag)  Device model" + productModel);
            int FormFactorValue = 0;
            if (hasAFormFactor) {
                snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.2.2.0[1]");
                snmpReq.SnmpGet();
                curResp = snmpReq.getResponseVarbinds();
                vb = curResp.findById(1);
                if (vb != null) {
                    if (vb.isError()) {
                        if (vb.getIntValue() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                            stateObject.setTimeOutOccurred(true);
                            return false;
                        }
                        if (vb.getIntValue() == SnmpResponseVarBind.NO_SUCH_NAME_ERROR) {
                            // empty if block
                        }
                    } else {
                        FormFactorValue = vb.getIntValue();
                        if (FormFactorValue == 2 || FormFactorValue == 3) {
                            productType = "Portable";
                        }
                    }
                }
            }
        }
        debugLogger.fine("SNMP ID DONE " + deviceObject.getDeviceName() + " Product Type set to  " + productType + " Model " + productModel);
        if (exactMatch) {
            stateObject.addIdStateInfo(productType, null, productModel, 50);
        } else {
            stateObject.addIdStateInfo(productType, null, productModel, 5);
        }
        this.appendCurTargetStatus("snmp.proliantdtsupport");
        return productType.equals("MgmtProc");
    }

    private void setSubTypesForNonServers(DeviceIdentificationData stateObject, String productModel) {
        if (productModel.toUpperCase().indexOf("P BLADE") != -1) {
            stateObject.addSubType(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
            stateObject.addSubType(NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
        } else if (productModel.toUpperCase().indexOf("C-CLASS") != -1) {
            stateObject.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        } else if (productModel.toUpperCase().indexOf("P-CLASS") != -1) {
            stateObject.addSubType(NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
        } else if (productModel.toUpperCase().indexOf("C BLADE") != -1) {
            stateObject.addSubType(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
            stateObject.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        } else if (productModel.toUpperCase().indexOf("VC-ENET") != -1) {
            stateObject.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        }
    }

    private String getSimpleStringVal(SnmpResponse curResp, int pos) {
        SnmpResponseVarBind vb = curResp.findById(pos);
        if (vb == null) {
            if (debugLogger.check(9)) {
                debugLogger.warning("SNMP ID " + this.dbgIdStr + " no simple string at " + pos);
            }
            return null;
        }
        if (vb.isError()) {
            if (debugLogger.check(9)) {
                debugLogger.warning("SNMP ID " + this.dbgIdStr + " no simple string at " + pos);
            }
        } else {
            if (vb.isBinary()) {
                return null;
            }
            if (vb.getValue() != null && vb.getValue().length() > 0) {
                return vb.getValue();
            }
        }
        return null;
    }

    private boolean checkMibStatusArrayForMib(String cpqMibStatusArray, int cpqMibId) {
        boolean retVal = false;
        if (cpqMibStatusArray == null) {
            return false;
        }
        try {
            int desiredPos = cpqMibId * 8;
            if (cpqMibStatusArray.length() < desiredPos + 8) {
                return false;
            }
            String mibStr = cpqMibStatusArray.substring(desiredPos, desiredPos + 8);
            if (!mibStr.equals("00000000")) {
                debugLogger.finer("Device = " + this.dbgIdStr + " supports MIB id " + cpqMibId + " mibStr " + mibStr);
                retVal = true;
            }
        }
        catch (Exception ex) {
            debugLogger.error("Checking MibStatArray for MIB ID " + cpqMibId + " ex " + ex);
        }
        return retVal;
    }

    public String getUniqueIdentifierFromSystem(MxNode deviceToResolve, DeviceIdentificationData deviceIdData) {
        return null;
    }

    private boolean isThisDeviceVirtual(MxNode deviceToResolve, DeviceIdentificationData stateObject) {
        boolean isThisDeviceVirtual = false;
        if (stateObject.getDeviceVirtual().booleanValue()) {
            return true;
        }
        if (deviceToResolve.getDeviceType().equals("MgmtProc")) {
            stateObject.setDeviceVirtual(Boolean.valueOf(true));
            return true;
        }
        int devRibLocation = this.getIsRibBoardFromSnmp(deviceToResolve);
        if (devRibLocation >= 2) {
            debugLogger.fine("Discovery Resolver: This device is a RIB board " + deviceToResolve.getWorkingAddress());
            isThisDeviceVirtual = true;
            stateObject.setDeviceVirtual(Boolean.valueOf(true));
        }
        return isThisDeviceVirtual;
    }

    private int getIsRibBoardFromSnmp(MxNode deviceToResolve) {
        SnmpRequest reqObj = new SnmpRequest(deviceToResolve);
        int ribLocation = 0;
        if (deviceToResolve.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            try {
                reqObj.setRequestType(1);
                reqObj.addSnmpGetVarbind(RIBCARD_OIDSTR);
                reqObj.SnmpGet();
                SnmpResponse curResp = reqObj.getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findResponse(RIBCARD_OIDSTR);
                if (vb != null && !vb.isError()) {
                    ribLocation = vb.getIntValue();
                }
            }
            catch (Exception ex) {
                debugLogger.error("Error on get rib card " + ex);
            }
        }
        return ribLocation;
    }

    private boolean getIsIntegrityServerFromSnmp(MxNode deviceToResolve) {
        SnmpRequest reqObj = new SnmpRequest(deviceToResolve);
        boolean isIntegrity = false;
        if (deviceToResolve.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            try {
                int val;
                reqObj.setRequestType(1);
                reqObj.addSnmpGetVarbind(INTEGRITY_SERVER_ID);
                reqObj.SnmpGet();
                SnmpResponse curResp = reqObj.getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findResponse(INTEGRITY_SERVER_ID);
                if (vb != null && !vb.isError() && (val = vb.getIntValue()) > 1) {
                    isIntegrity = true;
                }
            }
            catch (Exception ex) {
                debugLogger.error("Error on get integrity test " + ex);
            }
        }
        return isIntegrity;
    }

    private String getGuidFromSNMP(MxNode deviceToResolve) {
        String theCpqGuid = null;
        SnmpRequest reqObj = new SnmpRequest(deviceToResolve);
        if (deviceToResolve.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            try {
                reqObj.setRequestType(1);
                reqObj.addSnmpGetVarbind(SNMPSYSNAME_OID);
                reqObj.addSnmpGetVarbind(GUIDOID_STR);
                reqObj.SnmpGet();
                SnmpResponse curResp = reqObj.getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findResponse(SNMPSYSNAME_OID);
                if (vb != null) {
                    if (!vb.isError()) {
                        String devSnmpSysName = vb.getValue();
                        deviceToResolve.setDeviceName(1, devSnmpSysName);
                    } else if (vb.getErrorCode() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                        return null;
                    }
                }
                if ((vb = curResp.findResponse(GUIDOID_STR)) != null) {
                    if (!vb.isError()) {
                        String temp = vb.getValue();
                        if (temp != null) {
                            theCpqGuid = temp.trim();
                        }
                        debugLogger.fine("Value of proliant GUID : (" + theCpqGuid + ")");
                        if (theCpqGuid != null && theCpqGuid.compareTo("ERROR") != 0) {
                            if (theCpqGuid.compareTo(EMPTY_GUID_STR) != 0 && theCpqGuid.compareTo(EMPTY_GUID_STR2) != 0) {
                                return theCpqGuid;
                            }
                            theCpqGuid = null;
                            return theCpqGuid;
                        }
                    } else {
                        debugLogger.warning("Error Value from SNMP Get : " + vb.getErrorCode() + " for " + deviceToResolve.getWorkingAddress());
                    }
                }
            }
            catch (Exception e) {
                debugLogger.error("getGUIDFromSNMP : " + e.getMessage());
            }
        }
        return null;
    }

    private void setSerialNumberForSwitches(MxNode deviceToResolve, DeviceIdentificationData stateObject) {
        debugLogger.enter("setSerialNumberForSwitch()");
        String PROLIANT_SWITCH_SERIAL_NUMBER_STR = "1.3.6.1.4.1.232.22.2.6.1.1.1.7.1.1.1";
        String switchSerialNumber = null;
        SnmpRequest reqObj = new SnmpRequest(deviceToResolve);
        reqObj.setRequestType(1);
        debugLogger.fine("--->MIB request object: " + PROLIANT_SWITCH_SERIAL_NUMBER_STR);
        reqObj.addSnmpGetVarbind(PROLIANT_SWITCH_SERIAL_NUMBER_STR);
        reqObj.SnmpGet();
        SnmpResponse curResp = reqObj.getResponseVarbinds();
        SnmpResponseVarBind vb = curResp.findResponse(PROLIANT_SWITCH_SERIAL_NUMBER_STR);
        if (vb != null) {
            if (!vb.isError()) {
                switchSerialNumber = vb.getValue();
                if (switchSerialNumber != null) {
                    debugLogger.fine("--->Got Proliant Switch Serial Number: " + switchSerialNumber);
                    stateObject.setSerialNumber(switchSerialNumber);
                    debugLogger.fine("--->adding serial number to the agent UUID List");
                    stateObject.addAgentUUIDToList(switchSerialNumber);
                } else {
                    debugLogger.fine("--->Proliant Switch Serial Number is null ");
                    debugLogger.fine("--->Cannot add serial number to the agent UUID List");
                }
            } else if (vb.getErrorCode() == SnmpResponseVarBind.REQUEST_TIMED_OUT_ERROR) {
                debugLogger.fine("--->Proliant Switch Serial Number is not available error: timed out");
            }
        } else {
            debugLogger.fine("--->Proliant Switch Serial Number is not available: no response..");
        }
        debugLogger.exit("getSerialNumberForSwitch()");
    }
}

