/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification;

import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpHelperMethods;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.BaseIdentifier;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.SnmpDeviceIdentifyTable;
import com.hp.mx.core.tools.identification.systypmgr.SNMPRule;
import com.hp.mx.core.tools.identification.systypmgr.STMPostProcIfc;
import com.hp.mx.core.tools.identification.systypmgr.STMUtil;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.simenum.MxEnum;
import java.util.List;
import java.util.ListIterator;

public class SnmpSTMIdentifier
extends BaseIdentifier {
    private String identifier = "";
    private static DebugSubsystem debugLogger = new DebugSubsystem(SnmpSTMIdentifier.class);
    private static Object lockUrlObj = new Object();
    private static final String UNKNOWN_SNMP_DEVICE = "(Unknown SNMP Device)";

    public SnmpSTMIdentifier() {
    }

    public SnmpSTMIdentifier(String id) {
        this.identifier = id;
    }

    public void identifyNode(MxNode deviceObject, DeviceIdentificationData stateObject) {
        block26: {
            this.dbgIdStr = "ID#" + this.myThreadIdentifier + " " + deviceObject.getNameString();
            String theSysOid = null;
            String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
            if (!snmpEnabled.equals("checked")) {
                myDebug.finer("SNMP STM Device Identification skiped (SNMP DISABLED GLOBALLY) on " + this.dbgIdStr);
                this.appendCurTargetStatus("snmp.globaldisable");
                return;
            }
            String workingAddress = deviceObject.getWorkingAddress();
            if (workingAddress == null) {
                myDebug.finer("SNMP STM Device Identification skiped no address for " + this.dbgIdStr);
                this.appendCurTargetStatus("snmp.noaddress");
                return;
            }
            if (!deviceObject.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                debugLogger.fine("SNMP STM Device Identification skiped snmp not detected on " + this.dbgIdStr);
                this.appendCurTargetStatus("snmp.notsupported");
                return;
            }
            this.getGenericSerialNumber(deviceObject, stateObject);
            SnmpRequest snmpReq = new SnmpRequest(deviceObject);
            snmpReq.clearSnmpReqInfo();
            debugLogger.fine("Starting SNMP STM Device Identification on " + this.dbgIdStr);
            String productType = "Unmanaged";
            String productModel = "";
            snmpReq.setAsn1Numbers("1.3.6.1.2.1.1.2.0[1]");
            snmpReq.SnmpGet();
            SnmpResponse curResp = snmpReq.getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(1);
            if (vb == null || vb.isError()) {
                this.appendCurTargetStatus("snmp.stm.error");
                return;
            }
            theSysOid = vb.getOidValue();
            int confLevel = 0;
            SNMPRule rule = null;
            try {
                rule = this.findSysTypMgrRule(snmpReq, theSysOid);
            }
            catch (Exception ex) {
                rule = null;
                myDebug.error("STM exception; sysoid=" + theSysOid);
                myDebug.exception((Throwable)ex);
            }
            if (null == rule) {
                if (productType.equals("Unmanaged")) {
                    productType = "Unknown";
                }
                productModel = UNKNOWN_SNMP_DEVICE;
                stateObject.addIdStateInfo(productType, null, productModel, confLevel);
                this.appendCurTargetStatus("snmp.stm.norule");
                return;
            }
            debugLogger.fine("Found a System Type Manager rule match!; productModel=" + rule.getDevName() + " sys OID " + theSysOid);
            String stm_url = rule.getUrl();
            String stm_url_desc = rule.getUrl_desc();
            try {
                STMUtil.addUrl((MxNode)deviceObject, (String)stm_url, (String)stm_url_desc);
            }
            catch (Exception e) {
                debugLogger.exception((Throwable)e);
                debugLogger.error("could not add stm url");
            }
            if (3 == rule.getSysOIDRule()) {
                if (rule.getOverride_flag().equalsIgnoreCase("Y")) {
                    confLevel = 100;
                    debugLogger.fine("SNMP STM, conf level is absolute");
                } else {
                    confLevel = 50;
                }
                if (stateObject.getOSType() == null || stateObject.getOSType().length() == 0) {
                    if (rule.getOSName() != null && rule.getOSName().equals("HPUX")) {
                        stateObject.setOSName("HP-UX");
                    } else {
                        stateObject.setOSName(rule.getOSName());
                    }
                    stateObject.setOSType(rule.getOSName());
                    stateObject.setOSVendor(rule.getOSVendor());
                }
            } else {
                confLevel = 25;
            }
            MxEnum curEnum = null;
            try {
                curEnum = NodeTypeMapper.getDefaultMapper().getByOrdinal(rule.getDevType());
                productType = curEnum.toString();
            }
            catch (Exception ex1) {
                productType = "Unmanaged";
                debugLogger.error("Bad product type from STM; sysoid=" + theSysOid);
                debugLogger.exception((Throwable)ex1);
            }
            String productSubType = null;
            try {
                curEnum = NodeSubTypeMapper.getDefaultMapper().getByOrdinal(rule.getDevSubType());
                productSubType = curEnum.toString();
            }
            catch (Exception ex2) {
                productSubType = null;
                debugLogger.error("Bad sub type from STM; sysoid=" + theSysOid);
                debugLogger.exception((Throwable)ex2);
            }
            productModel = rule.getDevName();
            debugLogger.fine("SNMP STM has type {0} subtype {1} and model {2}", new Object[]{productType, productSubType, productModel});
            this.appendCurTargetStatus("snmp.stm.foundrule");
            stateObject.addIdStateInfo(productType, productSubType, productModel, confLevel);
            String postProcClassName = rule.getPostProcClassName().trim();
            if (postProcClassName.equals("")) {
                return;
            }
            try {
                Class<?> postProcClass = Class.forName(postProcClassName);
                Object postProcInst = postProcClass.newInstance();
                if (!(postProcInst instanceof STMPostProcIfc)) break block26;
                try {
                    ((STMPostProcIfc)postProcInst).processNode(deviceObject, stateObject);
                }
                catch (MxException ex) {
                    debugLogger.error("STM post proc failed");
                    debugLogger.exception((Throwable)ex);
                    return;
                }
            }
            catch (Exception ex) {
                debugLogger.error("Bad STM postProcClassName; postProcClassName=" + postProcClassName);
                debugLogger.exception((Throwable)ex);
                return;
            }
        }
    }

    private void getGenericSerialNumber(MxNode deviceObject, DeviceIdentificationData stateObject) {
        if (stateObject.getSerialNumber() != null && stateObject.getSerialNumber().length() > 0) {
            debugLogger.fine(" == >Serial number already set");
            return;
        }
        SnmpRequest snmpReq = new SnmpRequest(deviceObject);
        String serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.2.1.43.5.1.1.17.1[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
        if (serNum != null) {
            debugLogger.finest("Setting serial number from the mib value 1.3.6.1.2.1.43.5.1.1.17.1[1]= " + serNum);
            stateObject.setSerialNumber(serNum);
            return;
        }
        serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.1588.2.1.1.1.1.10.0[1]", (MxNode)deviceObject, (SnmpRequest)snmpReq);
        if (serNum != null) {
            debugLogger.finest("Setting serial number from the mib value 1.3.6.1.4.1.1588.2.1.1.1.1.10.0[1]= " + serNum);
            stateObject.setSerialNumber(serNum);
            return;
        }
        serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.2.1.47.1.1.1.1.11.1001", (MxNode)deviceObject, (SnmpRequest)snmpReq, (boolean)false);
        if (serNum != null) {
            debugLogger.finest("Setting serial number and agent UUID from the mib value 1.3.6.1.2.1.47.1.1.1.1.11.1001= " + serNum);
            stateObject.setSerialNumber(serNum);
            stateObject.addAgentUUIDToList(serNum);
            return;
        }
        serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.89.53.14.1.5.1", (MxNode)deviceObject, (SnmpRequest)snmpReq, (boolean)false);
        if (serNum != null) {
            debugLogger.finest("Setting serial number  from the mib value 1.3.6.1.4.1.89.53.14.1.5.1= " + serNum);
            stateObject.setSerialNumber(serNum);
            stateObject.addAgentUUIDToList(serNum);
            return;
        }
        serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.22.2.2.1.1.4.1", (MxNode)deviceObject, (SnmpRequest)snmpReq, (boolean)false);
        if (serNum != null) {
            debugLogger.finest("Setting serial number  from the mib value 1.3.6.1.4.1.232.22.2.2.1.1.4.1= " + serNum);
            stateObject.setSerialNumber(serNum);
            stateObject.addAgentUUIDToList(serNum);
            return;
        }
        serNum = SnmpHelperMethods.getStringValueFromMib((String)"1.3.6.1.4.1.232.2.2.2.1.0", (MxNode)deviceObject, (SnmpRequest)snmpReq, (boolean)false);
        if (serNum != null) {
            debugLogger.finest("Setting serial number  from the mib value 1.3.6.1.4.1.232.22.2.2.1.1.4.1= " + serNum);
            stateObject.setSerialNumber(serNum);
            stateObject.addAgentUUIDToList(serNum);
            return;
        }
        debugLogger.finest("Did not get any serial number");
    }

    private SNMPRule findSysTypMgrRule(SnmpRequest snmpReq, String theSysOid) {
        int bestPriority = 9999;
        if (debugLogger.check(10)) {
            debugLogger.finer("Checking device Snmp STM ID table: OID = " + theSysOid);
        }
        SNMPRule theRule = null;
        List match_rules = SnmpDeviceIdentifyTable.getRulesForMatch((String)theSysOid);
        if (null != match_rules) {
            ListIterator match_li = match_rules.listIterator();
            while (match_li.hasNext()) {
                SNMPRule rule = (SNMPRule)match_li.next();
                int rulePriority = rule.getRulePriority();
                if (0 == rule.getOid().length()) {
                    if (rulePriority >= bestPriority) continue;
                    theRule = rule;
                    bestPriority = rulePriority;
                    continue;
                }
                boolean sts = this.checkMibOidMatch(snmpReq, rule.getOid(), rule.getOidVal(), rule.getDataType(), rule.getCompareRule());
                if (!sts || rulePriority >= bestPriority) continue;
                theRule = rule;
                bestPriority = rulePriority;
            }
            if (null != theRule) {
                return theRule;
            }
        }
        String sOID = theSysOid + ".";
        while (-1 != sOID.indexOf(".")) {
            List startsWith_rules = SnmpDeviceIdentifyTable.getRulesForStartsWith((String)(sOID = sOID.substring(0, sOID.lastIndexOf("."))));
            if (null == startsWith_rules) continue;
            ListIterator startsWith_li = startsWith_rules.listIterator();
            while (startsWith_li.hasNext()) {
                SNMPRule rule = (SNMPRule)startsWith_li.next();
                int rulePriority = rule.getRulePriority();
                if (0 == rule.getOid().length()) {
                    if (rulePriority >= bestPriority) continue;
                    theRule = rule;
                    bestPriority = rulePriority;
                    continue;
                }
                boolean sts = this.checkMibOidMatch(snmpReq, rule.getOid(), rule.getOidVal(), rule.getDataType(), rule.getCompareRule());
                if (!sts || rulePriority >= bestPriority) continue;
                theRule = rule;
                bestPriority = rulePriority;
            }
            if (null == theRule) continue;
            return theRule;
        }
        return theRule;
    }

    private boolean checkMibOidMatch(SnmpRequest snmpReq, String mibOID, String oidVal, int oidDataType, int compareRule) {
        StringBuffer oidbuff = new StringBuffer(mibOID);
        oidbuff.append(".0[1],");
        oidbuff.append(mibOID);
        oidbuff.append("[2]");
        snmpReq.setAsn1Numbers(oidbuff.toString());
        snmpReq.SnmpGet();
        SnmpResponse curResp = snmpReq.getResponseVarbinds();
        SnmpResponseVarBind vb = curResp.findById(1);
        if ((vb == null || vb.isError()) && ((vb = curResp.findById(2)) == null || vb.isError())) {
            return false;
        }
        String mibValue = "";
        switch (vb.getIntType()) {
            case 64: {
                mibValue = vb.getIPAddrValue();
                break;
            }
            case 6: {
                mibValue = vb.getOidValue();
                break;
            }
            default: {
                mibValue = vb.getValue();
            }
        }
        if (debugLogger.check(40)) {
            debugLogger.finest("SNMP ID " + this.dbgIdStr + " Returned value is " + mibValue);
        }
        if (1 == compareRule && mibValue.startsWith(oidVal)) {
            return true;
        }
        if (2 == compareRule && -1 != mibValue.indexOf(oidVal)) {
            return true;
        }
        if (3 == compareRule && mibValue.equals(oidVal)) {
            return true;
        }
        if (4 == compareRule && mibValue.endsWith(oidVal)) {
            return true;
        }
        return 5 == compareRule;
    }

    public String getUniqueIdentifierFromSystem(MxNode deviceObject, DeviceIdentificationData stateObject) {
        String devUUID = stateObject.getIdAttribute("snmpstmrule.serialnum");
        if (devUUID != null && !devUUID.trim().toLowerCase().equals("none") && deviceObject.getDeviceType().contains("Switch")) {
            myDebug.fine(" set agent uuid for switches=" + devUUID);
            return devUUID;
        }
        return null;
    }
}

