/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.device;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.client.MxToolClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.controllers.NodeEntitlementController;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.DeviceUrl;
import com.hp.mx.core.nodemanager.DeviceUrlType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxInvalidNodeOperationException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxNodeIsLockedException;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusManager;
import com.hp.mx.core.nodemanager.NodeStatusPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusSourceManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeTypeMapper;
import com.hp.mx.core.nodemanager.NodeUrlManager;
import com.hp.mx.core.nodemanager.NodeUrlTypeManager;
import com.hp.mx.core.nodemanager.components.DeviceListUrlGenerator;
import com.hp.mx.core.nodemanager.components.DeviceListUrlGeneratorIfc;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.objectmodel.MxObjectName;
import com.hp.mx.core.persistence.dataaccess.DataAccessException;
import com.hp.mx.core.persistence.dataaccess.DataOperations;
import com.hp.mx.core.persistence.databean.CIM_ComputerSystem;
import com.hp.mx.core.persistence.databean.CIM_PhysicalPackage;
import com.hp.mx.core.persistence.databean.CIM_PortController;
import com.hp.mx.core.persistence.databean.CIM_Product;
import com.hp.mx.core.persistence.databean.CIM_SoftwareIdentity;
import com.hp.mx.core.persistence.databean.DataBean;
import com.hp.mx.core.persistence.databean.HP_NParCabinet;
import com.hp.mx.core.persistence.databean.HP_NParCell;
import com.hp.mx.core.persistence.databean.HP_NParComplex;
import com.hp.mx.core.persistence.databean.HP_NParIOChassis;
import com.hp.mx.core.persistence.databean.HP_NParPartition;
import com.hp.mx.core.persistence.databean.SIM_NodeEntitlement;
import com.hp.mx.core.persistence.util.storage.CIM_ProductComparator;
import com.hp.mx.core.persistence.util.storage.Common;
import com.hp.mx.core.persistence.util.storage.Debug;
import com.hp.mx.core.persistence.util.storage.GenericSMIData;
import com.hp.mx.core.persistence.util.storage.SoftwareIdentity;
import com.hp.mx.core.subjects.MxSubjectPrivilege;
import com.hp.mx.core.subjects.usermanager.MxUser;
import com.hp.mx.core.taskmanager.MxRunnableWebLaunchTask;
import com.hp.mx.core.toolmanager.MxInvalidToolNameException;
import com.hp.mx.core.toolmanager.MxTool;
import com.hp.mx.core.toolmanager.MxToolName;
import com.hp.mx.core.toolmanager.MxUndefinedToolException;
import com.hp.mx.core.toolmanager.MxWebLaunchTool;
import com.hp.mx.core.tools.discovery.DiscoverTheCMSLocalHost;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.DatabaseUtils;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.html.core.MxHtmlUtil;
import com.hp.mx.portal.applet.view.tableview.UrlObject;
import com.hp.mx.portal.core.MxAction;
import com.hp.mx.portal.core.MxActionList;
import com.hp.mx.portal.core.MxActionMgr;
import com.hp.mx.portal.core.MxTool_i18n;
import com.hp.mx.portal.device.DeviceAttributesBean;
import com.hp.mx.portal.res.MxResourceBean;
import com.hp.mx.portal.ui.MxDateAndTime;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.security.SsoManager;
import com.hp.mx.security.SsoSteSupport;
import com.hp.mx.soap.v5_0.server.MxpiPEUtil;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class MxDeviceBean {
    private static final DebugSubsystem myDebug = new DebugSubsystem(MxDeviceBean.class, "This debug is for Device Page");
    private MxActionList actionList;
    private MxActionList toolList;
    private String szUrlBase;
    private MxNode node;
    private MxNode oldNode;
    private MxNode clusterNode;
    private int deviceKey;
    private int clusterKey;
    private NodeStatusSourceManager nodeStatusSourceManager;
    private NodeStatusManager nodeStatusManager;
    private NodeUrlManager nodeUrlManager;
    private MxNodeClient myNodeClient;
    private MxGUID myNodeId;
    private MxUser user;
    private NodeAssociations nodeAssociations = null;
    private List agentLinkList;
    private List webLinkList;
    private GenericSMIData storageData = null;
    private boolean isWbem = false;
    private Locale myLocal = null;
    private Locale myLocalPreferred = null;
    private Vector listAssociations = new Vector();
    private Vector MPListAssociations = new Vector();
    private Object[] complexPartitionArray = null;
    private final int DO_NOT_REMOVE = Integer.MIN_VALUE;
    private final int PROPERTY_STATUS = 1;
    private final int PROPERTY_TOP = 2;
    public final int COMPLEX_NAME = 1;
    public final int COMPLEX_SERIAL_NUMBER = 2;
    public final int COMPLEX_PRODUCT_NAME = 3;
    public final int COMPLEX_CURRENT_PN = 4;
    public final int COMPLEX_ORIGINAL_PN = 5;
    public final int COMPLEX_PROFILE_REVISION = 6;
    public final int COMPLEX_UUID = 7;
    public final int IO_CABINET = 1;
    public final int COM_CABINET = 2;
    public final int PRIMARY_BOOT_PATH = 1;
    public final int HA_ALT_BOOT_PATH = 2;
    public final int ALT_BOOT_PATH = 3;
    public final int PERFORMANCE = 1;
    public final int ANHINGA = 2;
    public final int VMM = 3;
    public final int AM = 4;
    public static final int UNDEFINED_NODE = 1;
    public static final int FAILED_AUTHENTICATION = 2;
    public static final int LOCKED_NODE = 3;
    public static final int UNKNOWN_ERROR = 4;
    public static final int QUERY_TIMEOUT = 5;
    private SIM_NodeEntitlement nodeEntitlement = null;

    public int initialize(String nodeId, MxLoginBean loginBean) {
        this.szUrlBase = "/mxportal";
        try {
            this.myNodeClient = loginBean.getNodeClient();
            this.user = loginBean.getMxUser();
            this.myLocal = loginBean.getLocale();
            this.myLocalPreferred = loginBean.getLocalePreferred();
            this.myNodeId = new MxGUID(nodeId);
            MxObjectID nodeObject = new MxObjectID(this.myNodeId);
            this.node = this.myNodeClient.getNode(nodeObject, false);
            MxToolClient myToolClient = loginBean.getToolClient();
            ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
            nodeList.add(nodeObject);
            List toolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
            MxToolName toolName = new MxToolName("System Page");
            MxObjectID myObjectID = new MxObjectID((MxObjectName)toolName);
            MxTool myTool = myToolClient.getTool(myObjectID);
            if (!toolList.contains(myTool)) {
                throw new MxFailedAuthenticationException();
            }
            this.deviceKey = this.node.getDeviceKey();
            this.nodeStatusManager = NodeStatusManager.getDefaultManager();
            this.nodeStatusSourceManager = NodeStatusSourceManager.getDefaultManager();
            this.nodeUrlManager = NodeUrlManager.getDefaultManager();
            this.clusterNode = null;
            this.nodeEntitlement = null;
            this.getLinkList();
            this.getNodeAssociations();
            this.initEntitlement(loginBean);
            this.storageData = this.isDeviceSMI() ? this.getGenericStorageData() : null;
        }
        catch (MxUndefinedNodeException e) {
            return 1;
        }
        catch (MxFailedAuthenticationException e) {
            return 2;
        }
        catch (MxNodeIsLockedException e) {
            return 3;
        }
        catch (Exception e) {
            return 4;
        }
        return 0;
    }

    public int isValidNode(MxLoginBean loginBean, String szDev) {
        try {
            int devKey = Integer.parseInt(szDev);
            MxNode testNode = this.myNodeClient.getNodeByKey(devKey, false);
        }
        catch (MxUndefinedNodeException e) {
            return 1;
        }
        catch (MxFailedAuthenticationException e) {
            return 2;
        }
        catch (MxNodeIsLockedException e) {
            return 3;
        }
        catch (Exception e) {
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericSMIData getGenericStorageData() {
        GenericSMIData storageData = new GenericSMIData();
        DebugSubsystem ds = Debug.getDebugSubsystem();
        int count = 0;
        ds.fine("getGenericStorageData() Detected a SMI device [" + this.node.getDurableName() + "]; attempting to retreive generic storage data...");
        CIM_ComputerSystem cs = new CIM_ComputerSystem();
        cs.setNodeID(new Long(this.deviceKey));
        cs.setName(this.node.getDurableName());
        cs.setSnapshotID(new Long(-1L));
        DataOperations dop = null;
        try {
            dop = new DataOperations(true);
            dop.setQueryTimeout(5);
            Object[] csArray = dop.readArray((DataBean)cs);
            if (csArray.length == 0) {
                ds.error("getGenericStorageData(): No data found for device with durableName [" + cs.getName() + ", id [" + cs.getNodeID() + "].");
                GenericSMIData genericSMIData = null;
                return genericSMIData;
            }
            if (csArray.length != 1) {
                ds.error("getGenericStorageData(): for device with durableName [\"+cs.getName()+\", id [\"+cs.getNodeID()+\"]: Array length is an unexpected value (" + csArray.length + ")");
                GenericSMIData genericSMIData = null;
                return genericSMIData;
            }
            cs = (CIM_ComputerSystem)csArray[0];
            count += this.insertSoftwareClassifications(cs, storageData);
            count += this.insertProductData(cs, storageData);
        }
        catch (DataAccessException e) {
            myDebug.exception((Throwable)e);
        }
        catch (Exception e) {
            myDebug.exception((Throwable)e);
        }
        finally {
            try {
                dop.close();
            }
            catch (DataAccessException e) {
                myDebug.exception((Throwable)e);
            }
        }
        if (count == 0) {
            ds.fine("No generic storage data found.");
        }
        return storageData;
    }

    private int insertProductData(CIM_ComputerSystem cs, GenericSMIData storageData) {
        int count = 0;
        ArrayList physicalPackages = new ArrayList(cs.getPhysicalPackages());
        ArrayList<CIM_Product> products = new ArrayList<CIM_Product>();
        for (CIM_PhysicalPackage pp : physicalPackages) {
            ++count;
            ArrayList packageProducts = new ArrayList(pp.getProducts());
            Iterator it2 = packageProducts.iterator();
            while (it2.hasNext()) {
                ++count;
                CIM_Product p = (CIM_Product)it2.next();
                products.add(p);
            }
        }
        Collections.sort(products, new CIM_ProductComparator());
        CIM_Product p = (CIM_Product)products.get(0);
        Common.insertCIMProductData((CIM_Product)p, (GenericSMIData)storageData);
        return count;
    }

    private int insertSoftwareClassifications(CIM_ComputerSystem cs, GenericSMIData storageData) {
        int count = 0;
        Set installedSoftware = cs.getInstalledSoftware();
        count += this.insertInstalledSoftware(installedSoftware, storageData);
        for (CIM_ComputerSystem controller : cs.getControllers()) {
            count += this.insertSoftwareClassifications(controller, storageData);
        }
        for (CIM_PortController portController : cs.getPortControllers()) {
            count += this.insertInstalledSoftware(portController.getInstalledSoftware(), storageData);
        }
        return count;
    }

    private int insertInstalledSoftware(Set installedSoftware, GenericSMIData storageData) {
        int count = 0;
        Iterator it = installedSoftware.iterator();
        while (it.hasNext()) {
            ++count;
            CIM_SoftwareIdentity si = (CIM_SoftwareIdentity)it.next();
            Common.insertSoftwareClassificationData((SoftwareIdentity)new SoftwareIdentity(si), (GenericSMIData)storageData);
        }
        return count;
    }

    public int getDeviceKey() {
        return this.deviceKey;
    }

    public MxGUID getNodeId() {
        return this.myNodeId;
    }

    public MxNode getMxNode() {
        return this.node;
    }

    private void getLinkList() {
        this.agentLinkList = new ArrayList();
        this.webLinkList = new ArrayList();
        List listUrl = this.nodeUrlManager.getAllUrlsForANode(this.deviceKey);
        for (DeviceUrl deviceUrl : listUrl) {
            if (deviceUrl.getUrlName().equals("compaq.hmmo.Proxy")) continue;
            if (deviceUrl.getUrlName().trim().indexOf("compaq.hmmo") != -1) {
                this.agentLinkList.add(deviceUrl);
                continue;
            }
            this.webLinkList.add(deviceUrl);
        }
    }

    public void getNodeAssociations() {
        NodeAssociationsManager nodeAssociationManager = null;
        this.listAssociations = new Vector();
        this.MPListAssociations = new Vector();
        try {
            nodeAssociationManager = NodeAssociationsManager.getDefaultManager();
            this.nodeAssociations = null;
            this.nodeAssociations = nodeAssociationManager.getNodeAssociations(this.deviceKey);
            if (this.nodeAssociations != null) {
                Vector orgListAssociations = this.nodeAssociations.getAssociations();
                for (int i = 0; i < orgListAssociations.size(); ++i) {
                    DeviceAssociationObject oneAssociation = (DeviceAssociationObject)orgListAssociations.elementAt(i);
                    String szAssociationType = oneAssociation.getAssociationType();
                    if (szAssociationType.indexOf("MgmtProcToServer") >= 0 || szAssociationType.indexOf("MgmtProcToDesktop") >= 0) {
                        this.MPListAssociations.add(oneAssociation);
                        continue;
                    }
                    this.listAssociations.add(oneAssociation);
                }
            }
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return;
        }
    }

    public String getAssociationInfo(String type, int associationKey, String associationType, MxResourceBean deviceBundle) {
        try {
            MxNode associationNode = this.myNodeClient.getNodeByKey(associationKey, false);
            if (type.equals("ASSOCIATION_TYPE")) {
                String deviceType = associationNode.getDeviceType();
                NodeTypeMapper nodeTypeMapper = NodeTypeMapper.getDefaultMapper();
                return nodeTypeMapper.getLocalizedDisplayString(deviceType, this.myLocal);
            }
            if (type.equals("ASSOCIATION_TYPE_NAME")) {
                String deviceType = associationNode.getDeviceType();
                List deviceSubtype = associationNode.getDeviceSubTypes();
                if (associationType != null) {
                    if (associationType.equals("vParGuestTovParHost") && deviceSubtype.contains(NodeSubTypeMapper.VPAR_SUBTYPE.toString())) {
                        return deviceBundle.getString("VPAR_NAME");
                    }
                    if (associationType.equals("vParGuestTovParHost") && deviceSubtype.contains(NodeSubTypeMapper.VMGUEST_SUBTYPE.toString())) {
                        return deviceBundle.getString("GUEST_NAME");
                    }
                    if (associationType.equals("HPVMGuestToHPVMHost") && deviceSubtype.contains(NodeSubTypeMapper.HPVMGUEST_SUBTYPE.toString()) || associationType.equals("VMGuestToVMHost") && deviceSubtype.contains(NodeSubTypeMapper.VMGUEST_SUBTYPE.toString())) {
                        return deviceBundle.getString("GUEST_NAME");
                    }
                    if (associationType.equals("vParGuestTovParHost") && deviceSubtype.contains(NodeSubTypeMapper.VPARMONITOR_SUBTYPE.toString()) || associationType.equals("HPVMGuestToHPVMHost") && deviceSubtype.contains(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString()) || associationType.equals("VMGuestToVMHost") && deviceSubtype.contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString())) {
                        return deviceBundle.getString("HOSTED_BY");
                    }
                }
                if (deviceType != null) {
                    String tempType = deviceType.toUpperCase();
                    return deviceBundle.getString(tempType);
                }
                return null;
            }
            if (type.equals("ASSOCIATION_NAME")) {
                return associationNode.getNameString();
            }
        }
        catch (Throwable ex) {
            myDebug.exception(ex);
            return null;
        }
        return null;
    }

    public int getAssociationSize() {
        if (this.listAssociations != null) {
            return this.listAssociations.size();
        }
        return 0;
    }

    public int getAssociationKey(int index) {
        DeviceAssociationObject oneAssociation = (DeviceAssociationObject)this.listAssociations.elementAt(index);
        List subtype = this.node.getDeviceSubTypes();
        String type = this.node.getDeviceType();
        if (oneAssociation.getAssociationType().equals("NodeToComplex") && type.compareToIgnoreCase(NodeTypeMapper.COMPLEX_TYPE.toString()) == 0 || oneAssociation.getAssociationType().equals("NodeToCluster") && type.compareToIgnoreCase("Cluster") == 0 || oneAssociation.getAssociationType().equals("vParGuestTovParHost") && subtype.contains(NodeSubTypeMapper.VPARMONITOR_SUBTYPE.toString()) || oneAssociation.getAssociationType().equals("HPVMGuestToHPVMHost") && subtype.contains(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString()) || oneAssociation.getAssociationType().equals("VMGuestToVMHost") && subtype.contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString()) || oneAssociation.getAssociationType().equals("SwitchToVCDomain") && type.compareToIgnoreCase("VCDomain") == 0) {
            return oneAssociation.getDeviceKey();
        }
        return oneAssociation.getAssociatedDeviceKey();
    }

    public String getAssociationType(int index) {
        DeviceAssociationObject oneAssociation = (DeviceAssociationObject)this.listAssociations.elementAt(index);
        return oneAssociation.getAssociationType();
    }

    public int getOneLevelUpAssociationKey(int childKey) {
        try {
            NodeAssociationsManager nodeAssociationManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations childNodeAssociations = nodeAssociationManager.getNodeAssociations(childKey);
            if (childNodeAssociations != null) {
                MxNode parentNode = childNodeAssociations.getParent();
                if (parentNode != null) {
                    if (parentNode.getDeviceKey() == this.deviceKey) {
                        return 0;
                    }
                    return parentNode.getDeviceKey();
                }
                return 0;
            }
            return 0;
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return 0;
        }
    }

    public boolean isAnPar(int index) {
        DeviceAssociationObject oneAssociation = (DeviceAssociationObject)this.listAssociations.elementAt(index);
        return oneAssociation.getAssociationType().trim().equals("NodeToComplex");
    }

    public boolean isAClusterMember(int index) {
        DeviceAssociationObject oneAssociation = (DeviceAssociationObject)this.listAssociations.elementAt(index);
        return oneAssociation.getAssociationType().trim().equals("NodeToCluster");
    }

    public boolean isDeviceNPar() {
        return this.deviceHasSubtype(NodeSubTypeMapper.NPAR_SUBTYPE.toString());
    }

    public boolean isDeviceSMI() {
        return this.deviceHasSubtype(NodeSubTypeMapper.SMI_SUBTYPE.toString());
    }

    public boolean isDeviceStorageEssentials() {
        return this.deviceHasSubtype(NodeSubTypeMapper.STORAGE_ESSENTIALS_SUBTYPE.toString());
    }

    public boolean deviceHasSubtype(String subtype) {
        List subTypes = this.node.getDeviceSubTypes();
        if (subTypes != null) {
            for (int i = 0; i < subTypes.size(); ++i) {
                String oneSubtype = (String)subTypes.get(i);
                if (!oneSubtype.equals(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAssociationStatus(int associationKey) {
        DeviceStatusSource source = this.nodeStatusSourceManager.getDeviceStatusSource("compaq.hmma.OverallStatus");
        DeviceStatusType statusType = this.nodeStatusManager.getNodeStatusType(associationKey, source);
        return this.getStatusIcon(statusType.getStatusNumValue());
    }

    public boolean hasMPRelation() {
        return this.MPListAssociations != null && this.MPListAssociations.size() != 0;
    }

    public int hasContainer() {
        if (this.isMP()) {
            for (int i = 0; i < this.MPListAssociations.size(); ++i) {
                DeviceAssociationObject oneAssociation = (DeviceAssociationObject)this.MPListAssociations.elementAt(i);
                String szAssociationType = oneAssociation.getAssociationType();
                if (!szAssociationType.equals("MgmtProcToServer_Complex")) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] getMPDeviceKeyList() {
        DeviceAssociationObject oneAssociation;
        int i;
        int[] retDeviceKeyList = new int[this.MPListAssociations.size()];
        for (i = 0; i < this.MPListAssociations.size(); ++i) {
            oneAssociation = (DeviceAssociationObject)this.MPListAssociations.elementAt(i);
            myDebug.fine("DeviceKey : " + oneAssociation.getDeviceKey() + " and Associated DeviceKey : " + oneAssociation.getAssociatedDeviceKey());
        }
        if (this.isMP()) {
            for (i = 0; i < this.MPListAssociations.size(); ++i) {
                oneAssociation = (DeviceAssociationObject)this.MPListAssociations.elementAt(i);
                if (this.deviceKey == oneAssociation.getAssociatedDeviceKey()) {
                    if (!this.isThisEntryUnique(oneAssociation.getDeviceKey(), retDeviceKeyList)) continue;
                    retDeviceKeyList[i] = oneAssociation.getDeviceKey();
                    continue;
                }
                if (!this.isThisEntryUnique(oneAssociation.getAssociatedDeviceKey(), retDeviceKeyList)) continue;
                retDeviceKeyList[i] = oneAssociation.getAssociatedDeviceKey();
            }
            return retDeviceKeyList;
        }
        for (i = 0; i < this.MPListAssociations.size(); ++i) {
            oneAssociation = (DeviceAssociationObject)this.MPListAssociations.elementAt(i);
            if (this.deviceKey == oneAssociation.getDeviceKey()) {
                if (!this.isThisEntryUnique(oneAssociation.getAssociatedDeviceKey(), retDeviceKeyList)) continue;
                retDeviceKeyList[i] = oneAssociation.getAssociatedDeviceKey();
                continue;
            }
            if (!this.isThisEntryUnique(oneAssociation.getDeviceKey(), retDeviceKeyList)) continue;
            retDeviceKeyList[i] = oneAssociation.getDeviceKey();
        }
        return retDeviceKeyList;
    }

    public boolean isThisEntryUnique(int deviceKey, int[] retDeviceKeyList) {
        for (int i = 0; i < retDeviceKeyList.length; ++i) {
            if (retDeviceKeyList[i] != deviceKey) continue;
            return false;
        }
        return true;
    }

    public String getMPInfo(String type, int mpKey) {
        String szReturn = "";
        try {
            MxNode mpNode = this.myNodeClient.getNodeByKey(mpKey, false);
            if (type.equals("MP_NAME")) {
                szReturn = mpNode.getNameString();
            }
            if (type.equals("MP_IPADDRESS")) {
                List IPList = mpNode.getIPAddressList();
                Iterator itr = IPList.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    String tempString = (String)itr.next();
                    if (tempString == null) continue;
                    szReturn = i > 0 ? szReturn + ", " + tempString : szReturn + tempString;
                    ++i;
                }
            }
            if (type.equals("MP_MODEL")) {
                szReturn = mpNode.getModel();
            }
            if (type.equals("MP_TYPE")) {
                NodeTypeMapper nodeTypeMapper = NodeTypeMapper.getDefaultMapper();
                szReturn = mpNode.getDeviceType();
                szReturn = nodeTypeMapper.getLocalizedDisplayString(szReturn, this.myLocal);
            }
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
        if (szReturn == null) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public String getMPType(int mpKey) {
        try {
            MxNode mpNode = this.myNodeClient.getNodeByKey(mpKey, false);
            return mpNode.getDeviceType().toUpperCase();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return "";
        }
    }

    public String getHomePageUrl(MxLoginBean loginBean) {
        ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
        nodeList.add(new MxObjectID(this.myNodeId));
        String drillDownURL = null;
        MxToolClient myToolClient = loginBean.getToolClient();
        try {
            List sessionToolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
            MxToolName toolName = new MxToolName("System Management Homepage");
            MxObjectID myObjectID = new MxObjectID((MxObjectName)toolName);
            MxTool myTool = myToolClient.getTool(myObjectID);
            for (int j = 0; j < sessionToolList.size(); ++j) {
                MxTool tempTool = (MxTool)sessionToolList.get(j);
                if (tempTool.getGUID().compareTo((Object)myTool.getGUID()) != 0) continue;
                drillDownURL = "/mxportal/DevicePage/LaunchLinks.jsp?toolGUID=" + myTool.getGUID().toString();
                return drillDownURL;
            }
            return null;
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public int getWebLinkSize() {
        return this.webLinkList.size();
    }

    public int getAgentLinkSize() {
        for (int i = 0; i < this.agentLinkList.size(); ++i) {
            DeviceUrl deviceUrl = (DeviceUrl)this.agentLinkList.get(i);
        }
        return this.agentLinkList.size();
    }

    public String getDeviceUrl(int index, String type, String urlOrder) {
        DeviceUrl deviceUrl = null;
        deviceUrl = type.equals("AGENT") ? (DeviceUrl)this.agentLinkList.get(index) : (DeviceUrl)this.webLinkList.get(index);
        MxNode d = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(this.deviceKey));
        if (deviceUrl.getUrlName().equals("compaq.hmmo.Proxy")) {
            return null;
        }
        if (urlOrder.equals("description")) {
            return MxHtmlUtil.encodeHtmlEntities((String)deviceUrl.getUrlDescription(this.myLocal));
        }
        String devUrl = null;
        if (type.equals("AGENT")) {
            devUrl = deviceUrl.getUrl(false, true);
        } else {
            String urlName = deviceUrl.getUrlName();
            if (urlName.equalsIgnoreCase("hp.systemTypeManager")) {
                devUrl = deviceUrl.getUrlInfo();
                if (!devUrl.toLowerCase().startsWith("http")) {
                    devUrl = null;
                }
            } else if (urlName.startsWith("SMI_S") || urlName.startsWith("SIM")) {
                devUrl = deviceUrl.getUrl(false, true);
            }
            if (devUrl == null) {
                devUrl = deviceUrl.getUrl();
            }
            if (this.isMP() && devUrl != null) {
                String ssoKey = "ILO";
                if (this.isOA()) {
                    ssoKey = "OA";
                }
                devUrl = SsoManager.createCmsPageSsoUrl((String)devUrl, (MxNode)this.node, (int)3, (String)ssoKey);
            }
        }
        if (devUrl.equals("/")) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)devUrl);
    }

    public String getPropertyPageUrl(MxLoginBean loginBean, int linkType) throws MxUndefinedToolException, MxFailedAuthenticationException, MxInvalidTransactionException, MxInvalidToolNameException {
        String drillDownURL = null;
        MxToolName toolName = null;
        MxToolClient myToolClient = loginBean.getToolClient();
        toolName = linkType == 1 ? new MxToolName("Properties for Status") : new MxToolName("Properties");
        MxObjectID myObjectID = new MxObjectID((MxObjectName)toolName);
        MxTool myTool = myToolClient.getTool(myObjectID);
        ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
        nodeList.add(new MxObjectID(this.myNodeId));
        List toolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
        if (!toolList.contains(myTool)) {
            return null;
        }
        drillDownURL = "/mxportal/DevicePage/LaunchLinks.jsp?toolGUID=" + myTool.getGUID().toString();
        return drillDownURL;
    }

    public ArrayList buildMoreInfoLinks(MxLoginBean loginBean, MxActionList actionList, MxResourceBean deviceBundle) throws MxUndefinedToolException, MxFailedAuthenticationException, MxInvalidTransactionException, MxInvalidToolNameException {
        ArrayList<MxTool> listLink = new ArrayList<MxTool>();
        ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
        nodeList.add(new MxObjectID(this.myNodeId));
        MxToolClient myToolClient = loginBean.getToolClient();
        List sessionToolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
        MxAction tempToolList = (MxAction)actionList.findCascade(deviceBundle.getString("TOOL_INFO"))[0];
        this.toolList = tempToolList.getCascade();
        int j = 0;
        block0: for (int k = 0; k < this.toolList.size(); ++k) {
            MxAction oneAction = this.toolList.get(k);
            MxTool oneTool = oneAction.getMxTool();
            for (int i = 0; i < sessionToolList.size(); ++i) {
                MxTool tempTool = (MxTool)sessionToolList.get(i);
                if (!tempTool.getVisible() || tempTool.getGUID().compareTo((Object)oneTool.getGUID()) != 0) continue;
                listLink.add(j, tempTool);
                ++j;
                continue block0;
            }
        }
        return listLink;
    }

    public String getToolLink(MxTool myTool, MxLoginBean loginBean) {
        try {
            MxRunnableWebLaunchTask runnableTask = new MxRunnableWebLaunchTask((MxWebLaunchTool)myTool);
            runnableTask.addRawTarget(new MxObjectID(this.myNodeId));
            runnableTask = loginBean.getMxWebLauncher().runWebLaunchTask(runnableTask);
            return runnableTask.getMainURL(2);
        }
        catch (Throwable e) {
            myDebug.error("Unable to get the tool launch URL " + e);
            return null;
        }
    }

    public String getDisplayToolName(MxTool myTool) {
        MxTool_i18n tempTool_i18n = new MxTool_i18n(myTool, this.myLocal);
        return tempTool_i18n.getName();
    }

    public boolean canRunTool(String szToolName, MxLoginBean loginBean) throws MxUndefinedToolException, MxFailedAuthenticationException, MxInvalidTransactionException, MxInvalidToolNameException {
        Object drillDownURL = null;
        MxToolClient myToolClient = loginBean.getToolClient();
        MxToolName toolName = new MxToolName(szToolName);
        MxObjectID myObjectID = new MxObjectID((MxObjectName)toolName);
        MxTool myTool = myToolClient.getTool(myObjectID);
        ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
        nodeList.add(new MxObjectID(this.myNodeId));
        List toolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
        return toolList.contains(myTool);
    }

    public String getEditSystemPropertyURL(MxActionMgr actionMgr, String type, MxLoginBean loginBean) {
        if (this.user.hasPrivilege(MxSubjectPrivilege.FULL_RIGHTS) || this.user.hasPrivilege(MxSubjectPrivilege.DEBUG_RIGHTS)) {
            MxAction myAction = actionMgr.getById("EDIT_SYSTEM_PROPERTIES");
            if (myAction == null) {
                return null;
            }
            if (type.equals("URL")) {
                return myAction.getUrlMain(loginBean);
            }
            return myAction.getName();
        }
        return null;
    }

    public String getSuspendURL(MxActionMgr actionMgr, String type, MxLoginBean loginBean) {
        block7: {
            block6: {
                if (this.node.getSnoozeTimeLeft() == -2) break block6;
                if (this.node.getSnoozeTimeLeft() != -3) break block7;
            }
            return null;
        }
        if (this.user.hasPrivilege(MxSubjectPrivilege.FULL_RIGHTS) || this.user.hasPrivilege(MxSubjectPrivilege.DEBUG_RIGHTS)) {
            MxAction myAction = actionMgr.getById("SUSPEND_RESUME_PROPERTIES");
            if (myAction == null) {
                return null;
            }
            if (type.equals("URL")) {
                return myAction.getUrlMain(loginBean);
            }
            return myAction.getName();
        }
        return null;
    }

    public String getUrlBase() {
        return this.szUrlBase;
    }

    public String getStatusIcon(int iStatus) {
        if (iStatus == 0) {
            return DeviceStatusType.UNKNOWN.getIcon();
        }
        if (iStatus == 1) {
            return DeviceStatusType.NORMAL.getIcon();
        }
        if (iStatus == 2) {
            return DeviceStatusType.WARNING.getIcon();
        }
        if (iStatus == 3) {
            return DeviceStatusType.MINOR.getIcon();
        }
        if (iStatus == 4) {
            return DeviceStatusType.MAJOR.getIcon();
        }
        if (iStatus == 5) {
            return DeviceStatusType.CRITICAL.getIcon();
        }
        if (iStatus == 6) {
            return DeviceStatusType.UNMANAGED.getIcon();
        }
        if (iStatus == 7) {
            return DeviceStatusType.TESTING.getIcon();
        }
        if (iStatus == 8) {
            return DeviceStatusType.RESTRICTED.getIcon();
        }
        if (iStatus == 9) {
            return DeviceStatusType.DISABLED.getIcon();
        }
        if (iStatus == 10) {
            return DeviceStatusType.NOSTATUS.getIcon();
        }
        if (iStatus == 11) {
            return DeviceStatusType.SW_NOTRUST.getIcon();
        }
        if (iStatus == 12) {
            return DeviceStatusType.SW_NOVCA.getIcon();
        }
        if (iStatus == 13) {
            return DeviceStatusType.SW_NOPOLLDATA.getIcon();
        }
        if (iStatus == 14) {
            return DeviceStatusType.SW_SWITCH.getIcon();
        }
        if (iStatus == 15) {
            return DeviceStatusType.ENABLED.getIcon();
        }
        return DeviceStatusType.UNMANAGED.getIcon();
    }

    public String getSnoozeTime() {
        if (this.node.getSnoozeTimeLeft() == -2 || this.node.getSnoozeTimeLeft() == -3 || this.node.getSnoozeTimeLeft() == -1) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        long wakeUpTime = currentTime + (long)(this.node.getSnoozeTimeLeft() * 60 * 1000);
        MxDateAndTime wakeUpDate = new MxDateAndTime(this.myLocalPreferred, wakeUpTime);
        return wakeUpDate.getDateTimeStringSIMFormat();
    }

    public boolean isSnooze() {
        return !this.node.canDeviceBePolled();
    }

    public String getHWStatus() {
        DeviceStatusSource source = this.nodeStatusSourceManager.getDeviceStatusSource("compaq.hmma.OverallStatus");
        if (source == null) {
            return null;
        }
        DeviceStatusType statusType = this.nodeStatusManager.getNodeStatusType(this.deviceKey, source);
        if (statusType == null) {
            return null;
        }
        return statusType.getIcon();
    }

    public boolean isThereHWStatusUrl(MxLoginBean loginBean) {
        MxToolName toolName = null;
        MxObjectID myObjectID = null;
        MxTool myTool = null;
        ArrayList<MxObjectID> nodeList = new ArrayList<MxObjectID>();
        nodeList.add(new MxObjectID(this.myNodeId));
        MxToolClient myToolClient = loginBean.getToolClient();
        if (this.isMP() && this.getMPUrl(this.deviceKey) != null) {
            return true;
        }
        if (this.node.getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO)) {
            try {
                List sessionToolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
                toolName = new MxToolName("System Management Homepage");
                myObjectID = new MxObjectID((MxObjectName)toolName);
                myTool = myToolClient.getTool(myObjectID);
                for (int j = 0; j < sessionToolList.size(); ++j) {
                    MxTool tempTool = (MxTool)sessionToolList.get(j);
                    if (tempTool.getGUID().compareTo((Object)myTool.getGUID()) != 0) continue;
                    return true;
                }
                return false;
            }
            catch (Throwable e) {
                myDebug.error("MxDeviceBean::isThereHWStatusUrl " + e.getLocalizedMessage());
                myDebug.exception(e);
                return false;
            }
        }
        try {
            toolName = new MxToolName("Properties");
            myObjectID = new MxObjectID((MxObjectName)toolName);
            myTool = myToolClient.getTool(myObjectID);
            nodeList = new ArrayList();
            nodeList.add(new MxObjectID(this.myNodeId));
            List toolList = myToolClient.getToolsForSessionUserAndNodes(nodeList);
            return toolList.contains(myTool);
        }
        catch (Throwable e) {
            myDebug.error("MxDeviceBean::isThereHWStatusUrl " + e.getLocalizedMessage());
            myDebug.exception(e);
            return false;
        }
    }

    public String getHWStatusUrl(MxLoginBean loginBean) {
        if (this.isMP() && this.getMPUrl(this.deviceKey) != null) {
            return this.getMPUrl(this.deviceKey);
        }
        if (this.node.getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO)) {
            return this.getHomePageUrl(loginBean);
        }
        String szReturn = null;
        try {
            szReturn = this.getPropertyPageUrl(loginBean, 1);
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
        return szReturn;
    }

    public String getSWStatus() {
        boolean statusValue = false;
        DeviceStatusSource source = this.nodeStatusSourceManager.getDeviceStatusSource("compaq.hmma.swStatus");
        DeviceStatusType statusType = this.nodeStatusManager.getNodeStatusType(this.deviceKey, source);
        if (statusType == null) {
            return null;
        }
        return statusType.getIcon();
    }

    public String getSWStatusUrl() {
        UrlObject uo = new UrlObject();
        Integer dKey = new Integer(this.deviceKey);
        MxNode device = MxNodeController.getDefaultControllerNoEx().getNodeByKey(dKey);
        if (device == null) {
            return null;
        }
        boolean httpEnabled = DeviceListUrlGenerator.getIsHttpEnabled((MxNode)device);
        boolean useSecureLinks = DeviceListUrlGenerator.getUseSecureLinks((MxNode)device);
        DeviceListUrlGenerator.getSoftwareStatusUrl((MxNode)device, (boolean)httpEnabled, (boolean)useSecureLinks, (UrlObject)uo, (MxUser)this.user);
        String hpurl = uo.url;
        if (hpurl == null) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)hpurl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPlugInApplicationStatusUrl(int plugInType) {
        String szReturnUrl = null;
        if (plugInType == 1) {
            String PerfUrlStr = GlobalSettings.getProperty((String)"PerformanceModuleURL", (String)"/pmp/impf.htm");
            MxNode im7ServerNode = DiscoverTheCMSLocalHost.getTheXeDevice();
            String im7ServerLinkName = im7ServerNode.getDeviceLinkName();
            StringBuffer sb = new StringBuffer(250);
            sb.append("https://");
            sb.append(im7ServerLinkName);
            sb.append(SsoSteSupport.mapSslPort((int)2301));
            sb.append(PerfUrlStr);
            sb.append("?deviceKey=");
            sb.append(this.deviceKey);
            sb.append("&deviceName=");
            sb.append(this.getSystemName());
            sb.append("&deviceSerialNumber=");
            sb.append(this.getSerialNumber());
            szReturnUrl = SsoManager.createXePageSsoUrl((String)sb.toString(), (int)im7ServerNode.getDeviceKey());
        }
        if (plugInType == 2) {
            int count = 0;
            int pvmState = 0;
            Statement myStatement = null;
            ResultSet myResultSet = null;
            Connection myConnection = null;
            try {
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("VPM clicks");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select COUNT(*) as PVMCHK from lockdownStatus where DeviceKey=" + this.deviceKey);
                while (myResultSet.next()) {
                    count = myResultSet.getInt("PVMCHK");
                }
                if (0 < count) {
                    myResultSet = myStatement.executeQuery("select ldstatus from lockdownStatus where deviceKey=" + this.deviceKey);
                    if (myResultSet.next()) {
                        pvmState = myResultSet.getInt("ldstatus");
                    }
                } else {
                    pvmState = 100;
                }
                szReturnUrl = "/mxportal/VPM/column/vpmColMain.jsp?devID=" + this.deviceKey + "&pvmState=" + pvmState + "&devName=" + this.getSystemName();
                myResultSet.close();
                myStatement.close();
            }
            catch (Throwable e) {
                try {
                    myDebug.error("Plug-In Application Status Icon:: " + e.getLocalizedMessage());
                    myDebug.exception(e);
                    String string = null;
                    return string;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                    }
                    catch (SQLException ex1) {}
                }
            }
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
            }
            catch (SQLException ex1) {}
        }
        if (plugInType == 3) {
            try {
                Class<?> t = Class.forName("com.hp.mx.vmm.hpsim.statusurlgenerator.VmmStatusURLGenerator");
                DeviceListUrlGeneratorIfc dlugi = (DeviceListUrlGeneratorIfc)t.newInstance();
                UrlObject tmpUrlObject = dlugi.getStatusUrl(this.node, this.user);
                szReturnUrl = tmpUrlObject != null ? tmpUrlObject.url : "/mxportal/VMMUI/SysPageHost/vmmstatuslegend.jsp";
            }
            catch (Throwable ex) {
                myDebug.error("Get VMM Url:: " + ex.getLocalizedMessage());
                myDebug.exception(ex);
                return null;
            }
        }
        if (plugInType != 4) return szReturnUrl;
        try {
            return "/mxportal/DevicePage/devicepage.jsp?nodeId=" + this.myNodeId.toString() + "&selection=ID_PRP&index=3";
        }
        catch (Throwable ex) {
            myDebug.error("Get AM Url:: " + ex.getLocalizedMessage());
            myDebug.exception(ex);
            return null;
        }
    }

    public String getPlugInApplicationStatus(int plugInType) {
        int statusValue = -1;
        if (plugInType == 1) {
            statusValue = DatabaseUtils.getOneInteger((String)("select perfStatus from ppaStatus where deviceKey=" + this.deviceKey));
        }
        if (plugInType == 2) {
            try {
                String[] anhingaStatus = MxpiPEUtil.PEgetldStatusColumnStatebyID((int)this.deviceKey);
                if (Integer.parseInt(anhingaStatus[0]) == 0) {
                    statusValue = Integer.parseInt(anhingaStatus[2]);
                }
            }
            catch (Throwable e) {
                myDebug.error("Anhinga Status::" + e.getLocalizedMessage());
                myDebug.exception(e);
            }
        }
        if (plugInType == 3) {
            statusValue = DatabaseUtils.getOneInteger((String)("select vmmStatus from vmmStatus where deviceKey=" + this.deviceKey));
        }
        if (plugInType == 4) {
            statusValue = DatabaseUtils.getOneInteger((String)("select amstatus from amstatus where deviceKey=" + this.deviceKey));
        }
        if (statusValue == -1) {
            return null;
        }
        return this.getStatusIcon(statusValue);
    }

    public String getGenPlugInApplicationStatus(String dbvTable, String dbvColumn) {
        int statusValue = DatabaseUtils.getOneInteger((String)("select " + dbvColumn + " from " + dbvTable + " where deviceKey=" + this.deviceKey));
        if (statusValue == -1) {
            return null;
        }
        return this.getStatusIcon(statusValue);
    }

    public String getIPAddress() {
        String szReturn = "";
        List IPList = this.node.getIPAddressList();
        Iterator itr = IPList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            String tempString = (String)itr.next();
            szReturn = i > 0 ? szReturn + ", " + tempString : szReturn + tempString;
            ++i;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public String getSystemName() {
        if (this.node == null) {
            return "unknown node";
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getNameString().trim());
    }

    public String getTitle() {
        String szTitle = null;
        szTitle = this.getProductModel() == null ? this.getSystemType() : this.getProductModel();
        return this.getSystemName() + " (" + szTitle + ")";
    }

    public String getNetworkName() {
        if (this.node == null) {
            return "unknown node";
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getNetworkName().trim());
    }

    public String getDNSName() {
        if (this.node == null) {
            return "unknown";
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getHostName().trim());
    }

    public String getManagementProtocol() {
        String szReturn = "";
        List protocolList = this.node.getProtocolSupportList();
        int i = 0;
        this.isWbem = false;
        for (String szPtc : protocolList) {
            if (szPtc.substring(0, 4).compareToIgnoreCase("WBEM") == 0) {
                this.isWbem = true;
            }
            szReturn = i > 0 ? szReturn + ", " + szPtc : szReturn + szPtc;
            ++i;
        }
        if (szReturn == null || szReturn.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public boolean hasWbem() {
        return this.isWbem;
    }

    public String getSystemType() {
        NodeTypeMapper nodeTypeMapper = NodeTypeMapper.getDefaultMapper();
        String type = this.node.getDeviceType().trim();
        if (type == null) {
            return null;
        }
        String szReturn = nodeTypeMapper.getLocalizedDisplayString(type, this.myLocal);
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public String getSystemSubtype() {
        NodeSubTypeMapper nodeSubTypeMapper = NodeSubTypeMapper.getDefaultMapper();
        String szReturn = null;
        List subTypes = this.node.getDeviceSubTypes();
        if (subTypes != null) {
            boolean firstSubtype = true;
            for (int i = 0; i < subTypes.size(); ++i) {
                String oneSubtype = (String)subTypes.get(i);
                String localSubtype = nodeSubTypeMapper.getLocalizedDisplayString(oneSubtype, this.myLocal);
                if (localSubtype == null || localSubtype.compareToIgnoreCase("none") == 0) continue;
                if (firstSubtype) {
                    firstSubtype = false;
                    szReturn = localSubtype;
                    continue;
                }
                String tempStr = ", " + localSubtype;
                szReturn = szReturn + tempStr;
            }
        } else {
            return null;
        }
        if (szReturn == null) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities(szReturn);
    }

    public String getProductModel() {
        if (this.node == null) {
            return null;
        }
        if (this.node.getModel().trim() == null || this.node.getModel().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getModel());
    }

    public String getHWStatusFailCount() {
        int nFailTime = this.node.getHwStatusFailTime();
        if (nFailTime == -1) {
            return null;
        }
        return new Integer(nFailTime).toString();
    }

    public String getComments() {
        if (this.node.getComments().trim() == null || this.node.getComments().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getComments());
    }

    public String getCurrentApp() {
        if (this.node.getApplications().trim() == null || this.node.getApplications().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getApplications());
    }

    public String getHardwareDesc() {
        String szReturn = null;
        szReturn = this.node.getSysDescription().trim();
        if (szReturn == null || szReturn.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public String getOSName() {
        String OSNameString = this.node.getOSNameStr();
        if (OSNameString == null || OSNameString.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)OSNameString);
    }

    public String getOSNameType() {
        String OSType = this.node.getOSType().trim();
        if (OSType == null || OSType.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)OSType);
    }

    public String getOSVersion() {
        String OSVersion = this.node.getOSRevision().trim();
        if (OSVersion == null || OSVersion.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)OSVersion);
    }

    public String getOSDescription() {
        String OSDescription = this.node.getOSRevisionText().trim();
        if (OSDescription == null || OSDescription.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)OSDescription);
    }

    public String getAdministrator() {
        if (this.node == null) {
            return null;
        }
        String szAdministrator = this.node.getSysAdministrator().trim();
        if (szAdministrator == null || szAdministrator.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szAdministrator);
    }

    public String getContact() {
        if (this.node == null) {
            return null;
        }
        String szContact = this.node.getContact().trim();
        if (szContact == null || szContact.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szContact);
    }

    public String getDepartment() {
        if (this.node == null) {
            return null;
        }
        String szDepartment = this.node.getSysDepartment().trim();
        if (szDepartment == null || szDepartment.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szDepartment);
    }

    public String getLocation() {
        if (this.node == null) {
            return "";
        }
        String szLocation = this.node.getLocation().trim();
        if (szLocation == null || szLocation.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)szLocation);
    }

    public String getSerialNumber() {
        if (this.node.getSerialNumber().trim() == null || this.node.getSerialNumber().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getSerialNumber());
    }

    public String getUUID() {
        if (this.node.getAgentUUID().trim() == null || this.node.getAgentUUID().trim().length() == 0) {
            return null;
        }
        return this.node.getAgentUUID();
    }

    public String getProductID() {
        if (this.node.getProductId().trim() == null || this.node.getProductId().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getProductId());
    }

    public String getAssetNumber() {
        if (this.node == null) {
            return null;
        }
        String assetNumber = this.node.getAssetNumber().trim();
        if (assetNumber == null || assetNumber.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)assetNumber);
    }

    public String getAssetType() {
        if (this.node.getAssetType().trim() == null || this.node.getAssetType().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getAssetType());
    }

    public String getAssetClass() {
        if (this.node.getAssetClass().trim() == null || this.node.getAssetClass().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getAssetClass());
    }

    public String getPurchaseDate() {
        if (this.node.getPurchaseDate().trim() == null || this.node.getPurchaseDate().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getPurchaseDate());
    }

    public String getPurchasePrice() {
        if (this.node.getPurchasePrice().trim() == null || this.node.getPurchasePrice().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getPurchasePrice());
    }

    public String getServiceContract() {
        if (this.node.getServiceContract().trim() == null || this.node.getServiceContract().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getServiceContract());
    }

    public String getServiceContact() {
        if (this.node.getServiceContact().trim() == null || this.node.getServiceContact().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getServiceContact());
    }

    public String getServiceDate() {
        if (this.node.getServiceDate().trim() == null || this.node.getServiceDate().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getServiceDate());
    }

    public String getSupplier() {
        if (this.node.getSysSupplier().trim() == null || this.node.getSysSupplier().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getSysSupplier());
    }

    public String getWarranty() {
        if (this.node.getWarrantyText().trim() == null || this.node.getWarrantyText().trim().length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)this.node.getWarrantyText());
    }

    public boolean isSwitch() {
        String szType = this.node.getDeviceType().trim();
        return szType.equalsIgnoreCase("Switch");
    }

    public boolean isMP() {
        String szType = this.node.getDeviceType().trim();
        return szType.equalsIgnoreCase("MgmtProc");
    }

    public boolean isOA() {
        return this.node.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString());
    }

    public boolean isComplex() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase(NodeTypeMapper.COMPLEX_TYPE.toString()) == 0;
    }

    public boolean isCluster() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase("Cluster") == 0;
    }

    public boolean isServer() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase("Server") == 0;
    }

    public boolean isWorkStation() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase("Workstation") == 0;
    }

    public boolean isStorageArrary() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase("Storage") == 0;
    }

    public boolean isTapeLibrary() {
        String szType = this.node.getDeviceType().trim();
        return szType.compareToIgnoreCase("TapeLibrary") == 0;
    }

    public String getServerRole() {
        if (this.node == null) {
            return null;
        }
        String serverRole = this.node.getServerRole().trim();
        if (serverRole == null || serverRole.length() == 0) {
            return null;
        }
        return MxHtmlUtil.encodeHtmlEntities((String)serverRole);
    }

    public String getMPUrl(int mpKey) {
        NodeUrlTypeManager nodeUrlTypeManager = NodeUrlTypeManager.getDefaultManager();
        DeviceUrlType urlType = nodeUrlTypeManager.getUrlTypeByName("compaq.hmmd.MANAGEMENTPROCESSOR");
        DeviceUrl dUrl = this.nodeUrlManager.getDeviceUrlByBase(mpKey, urlType);
        if (dUrl == null) {
            return null;
        }
        String urlString = dUrl.getUrl().trim();
        String ssoUrlString = null;
        MxNode mpNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(mpKey));
        if (mpNode != null) {
            String ssoKey = "ILO";
            if (mpNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString())) {
                ssoKey = "OA";
            }
            ssoUrlString = SsoManager.createCmsPageSsoUrl((String)urlString, (MxNode)mpNode, (int)3, (String)ssoKey);
        }
        if (ssoUrlString != null) {
            return MxHtmlUtil.encodeHtmlEntities(ssoUrlString);
        }
        return MxHtmlUtil.encodeHtmlEntities((String)urlString);
    }

    public String getMPStatus(int mpKey) {
        DeviceStatusSource source = this.nodeStatusSourceManager.getDeviceStatusSource("compaq.hmma.OverallStatus");
        if (source == null) {
            return null;
        }
        DeviceStatusType statusType = this.nodeStatusManager.getNodeStatusType(mpKey, source);
        if (statusType == null) {
            return null;
        }
        return statusType.getIcon();
    }

    public boolean isMemberOfServiceguardCluster() throws MxUndefinedNodeException, MxNodeIsLockedException, MxInvalidTransactionException, MxFailedAuthenticationException, NodeStatusPersistenceException {
        if (this.clusterKey != 0) {
            if (this.clusterNode == null) {
                this.clusterNode = this.myNodeClient.getNodeByKey(this.clusterKey, false);
            }
            if (this.clusterNode.getDeviceSubType().trim().equalsIgnoreCase(NodeSubTypeMapper.SVCGRD_SUBTYPE.toString())) {
                return true;
            }
        }
        return false;
    }

    public boolean isVirtualNode() {
        return this.node.getDeviceSubType().trim().equalsIgnoreCase(NodeSubTypeMapper.SVCGRD_SUBTYPE.toString());
    }

    public String getSlot(int associationKey) throws MxUndefinedNodeException, MxNodeIsLockedException, MxInvalidTransactionException, MxFailedAuthenticationException, NodeStatusPersistenceException, NodeAssociationsPersistenceException {
        String szReturn = null;
        NodeAssociationsManager enclosureAssManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations enclosureAsso = enclosureAssManager.getNodeAssociations(associationKey);
        if (enclosureAsso == null) {
            return szReturn;
        }
        int numberOfSlot = enclosureAsso.getMaxNumItems();
        int slotNumber = this.nodeAssociations.getSlotNumber();
        if (slotNumber == -1) {
            return szReturn;
        }
        if (numberOfSlot == 8 || numberOfSlot == 0 || numberOfSlot == 16) {
            if (slotNumber == 0) {
                szReturn = "A ";
            } else if (slotNumber == 9 || slotNumber == 9999) {
                szReturn = "B ";
            } else {
                int nBlade = this.nodeAssociations.getNumBladeSlotsUsedXDir();
                if (nBlade > 1) {
                    int endBlade = slotNumber + nBlade - 1;
                    szReturn = slotNumber + "-" + endBlade;
                } else {
                    szReturn = slotNumber + " ";
                }
            }
        } else {
            int nBlade = this.nodeAssociations.getNumBladeSlotsUsedXDir();
            if (nBlade > 1) {
                int endBlade = slotNumber + nBlade - 1;
                szReturn = slotNumber + "-" + endBlade;
            } else {
                szReturn = slotNumber + " ";
            }
        }
        if (szReturn != null) {
            return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
        }
        return null;
    }

    public String getDimension(int associationKey) throws MxUndefinedNodeException, MxNodeIsLockedException, MxInvalidTransactionException, MxFailedAuthenticationException, NodeStatusPersistenceException, NodeAssociationsPersistenceException {
        String szReturn = null;
        NodeAssociationsManager enclosureAssManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = enclosureAssManager.getNodeAssociations(this.deviceKey);
        int height = nodeAssociations.getMmHeight();
        int width = nodeAssociations.getMmWidth();
        int depth = nodeAssociations.getMmDepth();
        if (height == 0 || height == -1) {
            return null;
        }
        szReturn = height + "mm " + width + "mm " + depth + "mm";
        return MxHtmlUtil.encodeHtmlEntities((String)szReturn);
    }

    public boolean shouldDisplayGroup(String groupType, DeviceAttributesBean daBean) throws MxUndefinedNodeException, MxNodeIsLockedException, MxInvalidTransactionException, MxFailedAuthenticationException, NodeAssociationsPersistenceException {
        if (groupType.equals("GROUPID_IDENTIFICATION") || groupType.equals("GROUPID_CLUSTER_IDENTIFICATION")) {
            if (this.getIPAddress() != null) {
                return true;
            }
            if (this.getSystemName() != null) {
                return true;
            }
            if (this.getNetworkName() != null) {
                return true;
            }
            if (this.getUUID() != null) {
                return true;
            }
            if (this.getSerialNumber() != null) {
                return true;
            }
            if (this.getnParPartitionName() != null) {
                return true;
            }
            return this.getnParPartitionNumber() != null;
        }
        if (groupType.equals("GROUPID_PD") || groupType.equals("GROUPID_CLUSTER_PD")) {
            if (this.getProductID() != null && this.getProductID().trim().length() > 0) {
                return true;
            }
            if (this.getSystemType() != null && this.getSystemType().trim().length() > 0) {
                return true;
            }
            if (this.getSystemSubtype() != null && this.getSystemSubtype().trim().length() > 0) {
                return true;
            }
            if (this.getProductModel() != null && this.getProductModel().trim().length() > 0) {
                return true;
            }
            if (this.getHardwareDesc() != null && this.getHardwareDesc().trim().length() > 0) {
                return true;
            }
            if (this.getOSName() != null && this.getOSName().trim().length() > 0) {
                return true;
            }
            if (this.getOSDescription() != null && this.getOSDescription().trim().length() > 0) {
                return true;
            }
            if (this.getOSVersion() != null && this.getOSVersion().trim().length() > 0) {
                return true;
            }
            if (this.getManagementProtocol() != null && this.getManagementProtocol().trim().length() > 0) {
                return true;
            }
            if (this.getServerRole() != null && this.getServerRole().trim().length() > 0) {
                return true;
            }
            if (this.getHWStatusFailCount() != null && this.getHWStatusFailCount().trim().length() > 0) {
                return true;
            }
            if (this.getComments() != null && this.getComments().trim().length() > 0) {
                return true;
            }
            if (this.getCurrentApp() != null && this.getCurrentApp().trim().length() > 0) {
                return true;
            }
            if (this.getnParCPUArchitecture() != null && this.getnParCPUArchitecture().trim().length() > 0) {
                return true;
            }
            if (this.getnParFirmwareRevision() != null && this.getnParFirmwareRevision().trim().length() > 0) {
                return true;
            }
            if (this.getnParBootPath(1) != null && this.getnParBootPath(1).trim().length() > 0) {
                return true;
            }
            if (this.getnParBootPath(2) != null && this.getnParBootPath(2).trim().length() > 0) {
                return true;
            }
            return this.getnParBootPath(3) != null && this.getnParBootPath(3).trim().length() > 0;
        }
        if (groupType.equals("GROUPID_COMPLEX_PD")) {
            if (this.getComplexProductDescription(1) != null && this.getComplexProductDescription(1).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(3) != null && this.getComplexProductDescription(3).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(2) != null && this.getComplexProductDescription(2).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(7) != null && this.getComplexProductDescription(7).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(4) != null && this.getComplexProductDescription(4).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(5) != null && this.getComplexProductDescription(5).trim().length() > 0) {
                return true;
            }
            if (this.getComplexProductDescription(6) != null && this.getComplexProductDescription(6).trim().length() > 0) {
                return true;
            }
            return this.getActiveServiceLocation() != null && this.getActiveServiceLocation().trim().length() > 0;
        }
        if (groupType.equals("GROUPID_SYSCONTACTINFO") || groupType.equals("GROUPID_CLUSTER_CI")) {
            if (this.getLocation() != null) {
                return true;
            }
            if (this.getAdministrator() != null) {
                return true;
            }
            if (this.getDepartment() != null) {
                return true;
            }
            return this.getContact() != null;
        }
        if (groupType.equals("GROUPID_CUSTCONTACTINFO")) {
            if (daBean == null) {
                return false;
            }
            if (daBean.getContactSalutation().length() > 0) {
                return true;
            }
            if (daBean.getContactSalutation().length() > 0) {
                return true;
            }
            if (daBean.getContactFirstName().length() > 0) {
                return true;
            }
            if (daBean.getContactLastName().length() > 0) {
                return true;
            }
            if (daBean.getContactTitle().length() > 0) {
                return true;
            }
            if (daBean.getContactPhone().length() > 0) {
                return true;
            }
            if (daBean.getContactEmail().length() > 0) {
                return true;
            }
            return daBean.getContactOther().length() > 0;
        }
        if (groupType.equals("GROUPID_ASSETINFO") || groupType.equals("GROUPID_CLUSTER_ASSETINFO")) {
            if (daBean != null) {
                if (daBean.getAssetNumber().length() > 0) {
                    return true;
                }
                if (daBean.getCustomSerialNumber().length() > 0) {
                    return true;
                }
                if (daBean.getCountry().length() > 0) {
                    return true;
                }
                if (daBean.getEntitlementType().length() > 0) {
                    return true;
                }
                if (daBean.getEntitlementId().length() > 0) {
                    return true;
                }
                if (daBean.getObligationId().length() > 0) {
                    return true;
                }
            }
            if (this.getAssetType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getPurchaseDate() != null) {
                return true;
            }
            if (this.getPurchasePrice() != null) {
                return true;
            }
            if (this.getServiceContract() != null) {
                return true;
            }
            if (this.getServiceContact() != null) {
                return true;
            }
            if (this.getServiceDate() != null) {
                return true;
            }
            return this.getSupplier() != null;
        }
        if (groupType.equals("GROUPID_COMPANYINFO")) {
            if (daBean == null) {
                return false;
            }
            if (daBean.getCompanyName().length() > 0) {
                return true;
            }
            if (daBean.getAddress1().length() > 0) {
                return true;
            }
            if (daBean.getAddress2().length() > 0) {
                return true;
            }
            if (daBean.getCity().length() > 0) {
                return true;
            }
            if (daBean.getState().length() > 0) {
                return true;
            }
            if (daBean.getPostalCode().length() > 0) {
                return true;
            }
            if (daBean.getCountry().length() > 0) {
                return true;
            }
            return daBean.getCustTimezone().length() > 0;
        }
        if (groupType.equals("GROUPID_ENTITLEMENTINFO")) {
            if (this.nodeEntitlement == null) {
                return false;
            }
            if (this.getStartDate().length() > 0) {
                return true;
            }
            if (this.getEndDate().length() > 0) {
                return true;
            }
            if (this.getEntitlementType().length() > 0) {
                return true;
            }
            if (this.getEntitlementStatus().length() > 0) {
                return true;
            }
            return this.getLastCollection(null).length() > 0;
        }
        if (groupType.equals("GROUPID_MP")) {
            if (this.isMP()) {
                return false;
            }
            return this.hasMPRelation();
        }
        if (groupType.equals("GROUPID_MANAGEDSYSTEM")) {
            if (!this.isMP()) {
                return false;
            }
            return this.hasMPRelation();
        }
        if (groupType.equals("GROUPID_ASSOCIATIONS")) {
            if (this.listAssociations == null) {
                return false;
            }
            return this.listAssociations.size() > 0;
        }
        if (groupType.equals("GROUPID_COMPLEX_MP")) {
            return this.hasMPRelation();
        }
        return true;
    }

    public String getComplexProductDescription(int type) {
        HP_NParComplex complex = new HP_NParComplex();
        complex.setNodeID(new Long(this.deviceKey));
        complex.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] complexArray = dop.readArray((DataBean)complex);
            if (complexArray.length != 0) {
                HP_NParComplex oneComplex = (HP_NParComplex)complexArray[0];
                if (type == 1) {
                    return this.getSystemName();
                }
                if (type == 3) {
                    return oneComplex.getOEMProductName();
                }
                if (type == 2) {
                    String szSerialNumber = oneComplex.getOEMSerialNumber();
                    if (szSerialNumber != null) {
                        return szSerialNumber;
                    }
                    szSerialNumber = oneComplex.getCreatorSerialNumber();
                    return szSerialNumber;
                }
                if (type == 4) {
                    return oneComplex.getCurrentProductOrderNumber();
                }
                if (type == 5) {
                    return oneComplex.getOriginalProductOrderNumber();
                }
                if (type == 6) {
                    return oneComplex.getRevisionString();
                }
                if (type == 7) {
                    return oneComplex.getUUID();
                }
            }
            return null;
        }
        catch (Throwable e) {
            myDebug.error("getComplexProductDescription:: " + e.getLocalizedMessage());
            myDebug.exception(e);
            return null;
        }
    }

    public String getActiveServiceLocation() {
        HP_NParCabinet cabinet = new HP_NParCabinet();
        cabinet.setNodeID(new Long(this.deviceKey));
        cabinet.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cabinetArray = dop.readArray((DataBean)cabinet);
            if (cabinetArray.length != 0) {
                for (int j = 0; j < cabinetArray.length; ++j) {
                    HP_NParCabinet oneCabinet = (HP_NParCabinet)cabinetArray[j];
                    if (Integer.parseInt(oneCabinet.getServiceProcessorCount()) == 0) continue;
                    String oneProcessorStatus = oneCabinet.getServiceProcessorStatus();
                    String[] szPS = oneProcessorStatus.split(",");
                    String oneProcessorLocation = oneCabinet.getServiceProcessorLocation();
                    String[] szPL = oneProcessorLocation.split(";");
                    for (int k = 0; k < szPS.length; ++k) {
                        if (!szPS[k].equals("2")) continue;
                        return szPL[k];
                    }
                    return null;
                }
            }
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
        return null;
    }

    public String getCabinet(int cabinetType) {
        HP_NParCabinet cabinet = new HP_NParCabinet();
        cabinet.setNodeID(new Long(this.deviceKey));
        cabinet.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        int count = 0;
        try {
            Object[] cabinetArray = dop.readArray((DataBean)cabinet);
            if (cabinetArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cabinetArray.length; ++i) {
                HP_NParCabinet oneCabinet = (HP_NParCabinet)cabinetArray[i];
                if (oneCabinet.getCabinetType() == 6) {
                    if (cabinetType != 1) continue;
                    ++count;
                    continue;
                }
                if (cabinetType != 2) continue;
                ++count;
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public void getComplexPartition() {
        HP_NParPartition partition = new HP_NParPartition();
        partition.setNodeID(new Long(this.deviceKey));
        partition.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            this.complexPartitionArray = dop.readArray((DataBean)partition);
        }
        catch (Throwable e) {
            myDebug.error("getComplexSize::" + e.getLocalizedMessage());
            myDebug.exception(e);
        }
    }

    public int getComplexSize() {
        return this.complexPartitionArray.length;
    }

    public String getNParLabel(int index) {
        HP_NParPartition onePartition = (HP_NParPartition)this.complexPartitionArray[index];
        return onePartition.getPartitionNameLabel();
    }

    public int getNParKey(int index, MxLoginBean loginBean) {
        try {
            HP_NParPartition onePartition = (HP_NParPartition)this.complexPartitionArray[index];
            String parNameLabel = onePartition.getPartitionNameLabel();
            String queryValue = this.node.getNameString() + "." + parNameLabel;
            List parList = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("CMPLX_PARTLABEL", queryValue);
            Integer parDeviceKey = (Integer)parList.get(0);
            return parDeviceKey;
        }
        catch (Throwable e) {
            myDebug.error("MxDeviceBean::getNParKey " + e.getLocalizedMessage());
            return -1;
        }
    }

    public String getComplexCell() {
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            return new Integer(cellArray.length).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getCPUCount() {
        int count = 0;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                count += oneCell.getcpuCount().intValue();
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getDIMMCount() {
        int count = 0;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                String DIMMstr = oneCell.getDIMMSlotPopulated();
                if (DIMMstr == null) continue;
                String[] szDIMM = DIMMstr.split(",");
                for (int j = 0; j < szDIMM.length; ++j) {
                    if (szDIMM[j].indexOf("true") <= 0) continue;
                    ++count;
                }
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getMemoryCount() {
        long count = 0L;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                count += oneCell.getTotalMemoryInstalled().longValue();
            }
            return new Long(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getIOChassisCount() {
        int count = 0;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                if (!oneCell.getConnectedToIOChassis().booleanValue()) continue;
                ++count;
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getIOCardsCount() {
        int count = 0;
        HP_NParIOChassis chassis = new HP_NParIOChassis();
        chassis.setNodeID(new Long(this.deviceKey));
        chassis.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] chassisArray = dop.readArray((DataBean)chassis);
            if (chassisArray.length == 0) {
                return null;
            }
            for (int i = 0; i < chassisArray.length; ++i) {
                HP_NParIOChassis oneChassis = (HP_NParIOChassis)chassisArray[i];
                count += oneChassis.getPopulatedPCISlotCount().intValue();
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParActiveCell() {
        int count = 0;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                if (oneCell.getComponentStatus().intValue() != 5) continue;
                ++count;
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParInactiveCell() {
        int count = 0;
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            for (int i = 0; i < cellArray.length; ++i) {
                HP_NParCell oneCell = (HP_NParCell)cellArray[i];
                if (oneCell.getComponentStatus().intValue() == 5) continue;
                ++count;
            }
            return new Integer(count).toString();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParCPUArchitecture() {
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            HP_NParCell oneCell = (HP_NParCell)cellArray[0];
            switch (oneCell.getCellArchitecture().intValue()) {
                case 0: {
                    return "Unknown";
                }
                case 1: {
                    return "Other";
                }
                case 2: {
                    return "PA_RISC";
                }
                case 3: {
                    return "Itanium-based";
                }
            }
            return null;
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParFirmwareRevision() {
        HP_NParCell cell = new HP_NParCell();
        cell.setNodeID(new Long(this.deviceKey));
        cell.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] cellArray = dop.readArray((DataBean)cell);
            if (cellArray.length == 0) {
                return null;
            }
            HP_NParCell oneCell = (HP_NParCell)cellArray[0];
            return oneCell.getFirmwareRevision();
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParBootPath(int type) {
        HP_NParPartition partition = new HP_NParPartition();
        partition.setNodeID(new Long(this.deviceKey));
        partition.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] partitionArray = dop.readArray((DataBean)partition);
            if (partitionArray.length == 0) {
                return null;
            }
            HP_NParPartition onePartition = (HP_NParPartition)partitionArray[0];
            if (type == 1) {
                return onePartition.getPrimaryBootPath();
            }
            if (type == 2) {
                return onePartition.getHAAlternateBootPath();
            }
            if (type == 3) {
                return onePartition.getAlternateBootPath();
            }
            return null;
        }
        catch (Throwable e) {
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParPartitionName() {
        HP_NParPartition partition = new HP_NParPartition();
        partition.setNodeID(new Long(this.deviceKey));
        partition.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] partitionArray = dop.readArray((DataBean)partition);
            if (partitionArray.length == 0) {
                return null;
            }
            HP_NParPartition onePartition = (HP_NParPartition)partitionArray[0];
            return onePartition.getPartitionName();
        }
        catch (Throwable e) {
            myDebug.error("getnParPartitionName::" + e.getLocalizedMessage());
            myDebug.exception(e);
            return null;
        }
    }

    public String getnParPartitionNumber() {
        HP_NParPartition partition = new HP_NParPartition();
        partition.setNodeID(new Long(this.deviceKey));
        partition.setSnapshotID(new Long(-1L));
        DataOperations dop = new DataOperations();
        try {
            Object[] partitionArray = dop.readArray((DataBean)partition);
            if (partitionArray.length == 0) {
                return null;
            }
            HP_NParPartition onePartition = (HP_NParPartition)partitionArray[0];
            return onePartition.getPartitionID().toString();
        }
        catch (Throwable e) {
            myDebug.error("getnParPartitionName::" + e.getLocalizedMessage());
            myDebug.exception(e);
            return null;
        }
    }

    public GenericSMIData getGenericSMIData() {
        return this.storageData;
    }

    public void setActionList(MxActionList actionList) {
        this.actionList = actionList;
    }

    public MxActionList getActionList() {
        return this.actionList;
    }

    public String getIdentityPageHelpTopic() {
        if (this.isComplex()) {
            return "\"useTools_systemPage_identity_complex\"";
        }
        if (this.isCluster()) {
            return "\"useTools_systemPage_identity_cluster\"";
        }
        if (this.isDeviceSMI() || this.isDeviceStorageEssentials()) {
            if (this.isSwitch()) {
                return "\"useTools_systemPage_identity_storageSwitch\"";
            }
            if (this.isTapeLibrary()) {
                return "\"useTools_systemPage_identity_tapeLibrary\"";
            }
            if (this.isStorageArrary()) {
                return "\"useTools_systemPage_identity_storageArray\"";
            }
            return "\"useTools_systemPage_identity_storageHost\"";
        }
        if (this.isServer()) {
            if (this.isDeviceNPar()) {
                return "\"useTools_systemPage_identity_partition\"";
            }
            return "\"useTools_systemPage_identity_server\"";
        }
        if (this.isMP()) {
            return "\"useTools_systemPage_identity_MP\"";
        }
        return "\"useTools_systemPage_identity_server\"";
    }

    public void initEntitlement(MxLoginBean myLoginBean) {
        try {
            NodeEntitlementController nodeEntitlementController = NodeEntitlementController.getDefaultController();
            MxTransaction transaction = myLoginBean.getMxSessionManager().getSession().getNextTransaction();
            MxObjectID nodeObject = new MxObjectID(this.myNodeId);
            this.nodeEntitlement = nodeEntitlementController.getNodeEntitlement(transaction, nodeObject);
        }
        catch (MxInvalidNodeOperationException ei) {
            myDebug.error("MxDeviceBean::initEntitlement -- " + ei.getLocalizedMessage());
            return;
        }
        catch (Throwable e) {
            myDebug.error("MxDeviceBean::initEntitlement -- " + e.getLocalizedMessage());
            return;
        }
    }

    public String getStartDate() {
        String szSD = this.nodeEntitlement.getStartDate();
        return MxHtmlUtil.encodeHtmlEntities((String)szSD);
    }

    public String getEndDate() {
        String szED = this.nodeEntitlement.getEndDate();
        return MxHtmlUtil.encodeHtmlEntities((String)szED);
    }

    public String getEntitlementStatus() {
        String szES = this.nodeEntitlement.getEntitlementStatus();
        return MxHtmlUtil.encodeHtmlEntities((String)szES);
    }

    public String getEntitlementType() {
        String szET = this.node.getEntitlementType();
        return MxHtmlUtil.encodeHtmlEntities((String)szET);
    }

    public String getLastCollection(MxLoginBean loginBean) {
        MxDateAndTime dateTime = loginBean == null ? new MxDateAndTime(this.myLocal, this.nodeEntitlement.getCollectionTime().longValue()) : new MxDateAndTime(loginBean.getLocale(), this.nodeEntitlement.getCollectionTime().longValue());
        String szLC = dateTime.getCurrentDateTimeStringSIMFormat();
        return MxHtmlUtil.encodeHtmlEntities((String)szLC);
    }
}

