/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.nodemanager.components;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.controllers.NodeAssociationsController;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.components.MxDefaultDynamicStatusHandler;
import com.hp.mx.core.objectmodel.MxObject;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class BladeIMEOAEnclosureBubbleHanlder
extends MxDefaultDynamicStatusHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(BladeIMEOAEnclosureBubbleHanlder.class);
    private NodeAssociationsController m_nodeAssociationsController;
    private MxNodeController m_nodeController;

    public BladeIMEOAEnclosureBubbleHanlder() {
        try {
            this.m_nodeController = MxNodeController.getDefaultController();
            this.m_nodeAssociationsController = NodeAssociationsController.getDefaultController();
        }
        catch (MxObjectPersistenceException e) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.Exception in static initializer: " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
        }
    }

    public DeviceStatusType getStatus(MxTransaction transaction, MxObject object) {
        LOGGER.enter("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
        if (object instanceof MxNode) {
            MxNode node = (MxNode)object;
            DefaultMutableTreeNode topologyTree = null;
            try {
                NodeAssociations deviceNodeAssociation = this.m_nodeAssociationsController.getNodeAssociations(transaction, node.getDeviceKey());
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatus.deviceNodeAssociation " + deviceNodeAssociation);
                if (deviceNodeAssociation != null) {
                    topologyTree = deviceNodeAssociation.getContainerDeviceTree();
                }
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatus.topologyTree " + topologyTree);
                if (topologyTree == null) {
                    DeviceStatusType status = node.getOverallStatus();
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatus.status " + status);
                    if (status == null) {
                        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
                        return DeviceStatusType.UNKNOWN;
                    }
                    LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
                    return status;
                }
                LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
                return this.getStatusForTree(topologyTree);
            }
            catch (MxException me) {
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatus.Unable to get topologytree. MxException: " + (Object)((Object)me));
                LOGGER.exception((Throwable)me);
                LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
                return DeviceStatusType.UNKNOWN;
            }
            catch (Exception e) {
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatus.Unable to get topologytree. Exception: " + e);
                LOGGER.exception((Throwable)e);
                LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
                return DeviceStatusType.UNKNOWN;
            }
        }
        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatus(" + transaction + "," + object + ")");
        return null;
    }

    private DeviceStatusType getStatusFromDeviceKey(Integer deviceKey) {
        LOGGER.enter("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey(" + deviceKey + ")");
        DeviceStatusType retval = DeviceStatusType.UNKNOWN;
        try {
            MxNode mxNode = this.m_nodeController.getReadOnlyNodeObject(deviceKey.intValue());
            retval = mxNode.getOverallStatus();
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey retval from Node " + retval);
            retval = this.getModifiedOverAllStatus(mxNode, retval);
        }
        catch (MxException me) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - MxException retrieving node " + deviceKey + " - " + (Object)((Object)me));
            LOGGER.exception((Throwable)me);
        }
        catch (OAException oae) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - OAException  " + deviceKey + " - " + oae);
            LOGGER.exception((Throwable)oae);
        }
        catch (Exception e) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey - Exception retrieving node " + deviceKey + " - " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey modified  retval " + retval);
        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatusFromDeviceKey(" + deviceKey + ")");
        return retval;
    }

    private synchronized DeviceStatusType getStatusForTree(DefaultMutableTreeNode topologyTree) {
        LOGGER.enter("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree(" + topologyTree + ")");
        DeviceStatusType retval = DeviceStatusType.UNKNOWN;
        DeviceStatusType tmpStatus = DeviceStatusType.UNKNOWN;
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.topologyTree.getChildCount() " + topologyTree.getChildCount());
        for (int i = 0; i < topologyTree.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. childNode " + childNode);
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. childNode.getChildCount() " + childNode.getChildCount());
            if (childNode.getChildCount() > 0) {
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. Not a Leaf Node");
                tmpStatus = this.getStatusForTree(childNode);
            } else {
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree. Leaf Node - No children");
                tmpStatus = this.getStatusFromDeviceKey((Integer)childNode.getUserObject());
            }
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.tmpStatus " + tmpStatus);
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval before comparision in loop " + retval);
            if (tmpStatus.equals((Object)DeviceStatusType.CRITICAL)) {
                retval = tmpStatus;
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.Critical Staus. Breaking from loop");
                break;
            }
            if (tmpStatus.greaterThanBubbleUp(retval)) {
                retval = tmpStatus;
            }
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval after comparision in loop " + retval);
        }
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.retval for devices" + retval);
        tmpStatus = this.getStatusFromDeviceKey((Integer)topologyTree.getUserObject());
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.tmpStatus for root" + tmpStatus);
        if (tmpStatus.greaterThanBubbleUp(retval)) {
            retval = tmpStatus;
        }
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree.final retval " + retval);
        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getStatusForTree(" + topologyTree + ")");
        return retval;
    }

    private DeviceStatusType getModifiedOverAllStatus(MxNode mxNode, DeviceStatusType retval) throws OAException {
        LOGGER.enter("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus(" + mxNode + "," + retval + ")");
        if (mxNode.getDeviceType().equalsIgnoreCase("MgmtProc") && mxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString()) && mxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString())) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.It's an OA device");
            OAHelper oaHelper = OAHelper.getOAHelper();
            OnboardAdministrator onboardAdministrator = (OnboardAdministrator)oaHelper.getOLDevice(mxNode, mxNode);
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Primary/Secondary OA" + onboardAdministrator.getIsPrimary());
            if (!onboardAdministrator.getIsPrimary() && this.isPrimaryNormal(mxNode)) {
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Secondary OA status " + retval.getStatusValue());
                if (retval.getStatusValue() != DeviceStatusType.NORMAL.getStatusValue()) {
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.Bubble up Minor Status for Secondary OA");
                    retval = DeviceStatusType.MINOR;
                }
            }
        }
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus.retval " + retval);
        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.getModifiedOverAllStatus(" + mxNode + "," + retval + ")");
        return retval;
    }

    private boolean isPrimaryNormal(MxNode secondaryOAMxNode) throws OAException {
        LOGGER.enter("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal(" + secondaryOAMxNode + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        boolean isPrimaryNormal = false;
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            int enclosureDeviceKey = myNodeRelationshipManager.getAssociatedDeviceKey(secondaryOAMxNode.getDeviceKey(), "MgmtProcToEnclosure");
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.enclosureDeviceKey " + enclosureDeviceKey);
            Vector associatedDeviceList = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(enclosureDeviceKey, "MgmtProcToEnclosure");
            int deviceKey = 0;
            MxNode mxNode = null;
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.associatedDeviceList.size() " + associatedDeviceList.size());
            for (int i = 0; i < associatedDeviceList.size(); ++i) {
                deviceKey = (Integer)associatedDeviceList.get(i);
                LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.deviceKey " + deviceKey);
                if (deviceKey == secondaryOAMxNode.getDeviceKey()) continue;
                try {
                    mxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
                    OnboardAdministrator onboardAdministrator = (OnboardAdministrator)oaHelper.getOLDevice(mxNode, mxNode);
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.Primary/Secondary OA " + onboardAdministrator.getIsPrimary());
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.OA Overall Status " + mxNode.getOverallStatus());
                    if (!onboardAdministrator.getIsPrimary() || mxNode.getOverallStatus().getStatusValue() != DeviceStatusType.NORMAL.getStatusValue()) continue;
                    isPrimaryNormal = true;
                    continue;
                }
                catch (MxUndefinedNodeException mune) {
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.MxUndefinedNodeException.deviceKey " + deviceKey);
                    LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.MxUndefinedNodeException " + (Object)((Object)mune));
                }
            }
        }
        catch (NodeAssociationsPersistenceException nape) {
            LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.Node Associations Persistence Exception: " + (Object)((Object)nape));
            LOGGER.exception((Throwable)nape);
        }
        LOGGER.fine("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal.isPrimaryNormal " + isPrimaryNormal);
        LOGGER.exit("BladeIMEOAEnclosureBubbleHanlder.isPrimaryNormal(" + secondaryOAMxNode + ")");
        return isPrimaryNormal;
    }
}

