/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.db.urack;

import com.hp.mx.core.tools.datacollection.db.urack.UserRackException;
import com.hp.mx.core.tools.datacollection.db.urack.data.ExtendedURAssociation;
import com.hp.mx.core.tools.datacollection.db.urack.data.UserRack;
import com.hp.mx.core.tools.datacollection.db.urack.data.UserRackAssociation;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserRackManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(UserRackManager.class);
    private static UserRackManager userRackManager;

    protected UserRackManager() {
    }

    public static synchronized UserRackManager getDefaultManager() {
        LOGGER.enter("getDefaultManager");
        if (userRackManager == null) {
            userRackManager = new UserRackManager();
        }
        LOGGER.exit("getDefaultManager");
        return userRackManager;
    }

    public int deleteUserRack(int rackKey) throws UserRackException {
        LOGGER.enter("deleteUserRack " + rackKey);
        int toRet = -1;
        UserRack rack = new UserRack();
        rack.setDeviceKey(rackKey);
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.deleteUserRack");
            toRet = rack.delete(conn);
            LOGGER.fine(" deleted " + toRet + " rows");
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to delete user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("deleteUserRack " + rackKey);
        return toRet;
    }

    public int deleteAssociationsOfUserRack(int rackKey) throws UserRackException {
        LOGGER.enter("deleteAssociationsOfUserRack " + rackKey);
        int toRet = -1;
        UserRackAssociation rackAssc = new UserRackAssociation();
        rackAssc.setDeviceKey1(rackKey);
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.deleteAssociationsOfUserRack");
            toRet = rackAssc.deleteAssociatedToRack(conn);
            LOGGER.fine("deleted " + toRet + " associations to user rack " + rackKey);
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to delete associations for user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("deleteAssociationsOfUserRack " + rackKey);
        return toRet;
    }

    public int deleteAssociationsOfEncl(int enclKey) throws UserRackException {
        LOGGER.enter("deleteAssociationsOfEncl " + enclKey);
        int toRet = -1;
        UserRackAssociation rackAssc = new UserRackAssociation();
        rackAssc.setDeviceKey1(enclKey);
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.deleteAssociationsOfEncl");
            toRet = rackAssc.deleteAssociatedToEncl(conn);
            LOGGER.fine("deleted " + toRet + " associations with encl " + enclKey);
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to delete associations for enclosure [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("deleteAssociationsOfEncl " + enclKey);
        return toRet;
    }

    public int addAssociation(int rackKey, int enclKey, int index, int startU, int endU) throws UserRackException {
        LOGGER.enter("addAssociation " + rackKey + ", " + enclKey + ", " + index + ", " + startU + ", " + endU);
        int toRet = -1;
        UserRackAssociation rackAssc = new UserRackAssociation();
        rackAssc.setDeviceKey1(rackKey);
        rackAssc.setDeviceKey2(enclKey);
        rackAssc.setDeviceKey2Position(index);
        rackAssc.setStartU(startU);
        rackAssc.setEndU(endU);
        rackAssc.setAssociationTypeNumber("subRack");
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.addAssociation");
            toRet = rackAssc.insert(conn);
            LOGGER.fine("added " + toRet + " Association for (rack:" + rackKey + ", encl:" + enclKey + ", pos:" + index + ", startU: " + startU + ", endU: " + endU);
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to add association [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("addAssociation " + rackKey + ", " + enclKey + ", " + index + ", " + startU + ", " + endU);
        return toRet;
    }

    public int updateUserRack(int rackKey, String rackName, String notes) throws UserRackException {
        LOGGER.enter("updateUserRack " + rackKey + ", " + rackName + ", " + notes);
        int toRet = -1;
        UserRack rack = new UserRack();
        rack.setDeviceKey(rackKey);
        rack.setRackName(rackName);
        rack.setNotes(notes);
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.updateUserRack");
            toRet = rack.update(conn);
            LOGGER.fine("updated " + toRet + " UserRack, rackKey: " + rackKey + ", rackName:" + rackName + ", notes: " + notes);
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to update user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("updateUserRack " + rackKey + ", " + rackName + ", " + notes);
        return toRet;
    }

    public int insertUserRack(String rackName, String notes) throws UserRackException {
        LOGGER.enter("insertUserRack " + rackName + ", " + notes);
        int toRet = -1;
        UserRack rack = new UserRack();
        rack.setRackName(rackName);
        rack.setNotes(notes);
        Connection conn = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.insertUserRack");
            conn.setAutoCommit(false);
            rack.setDeviceKey(this.getNewuserRackId(conn));
            toRet = rack.getDeviceKey();
            LOGGER.fine("inserted UserRack, rackName: " + rackName + ", notes:" + notes + ", with generated key :" + toRet);
            rack.insert(conn);
            conn.commit();
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to create user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.fine("insertUserRack " + rackName + ", " + notes);
        return toRet;
    }

    public List<ExtendedURAssociation> getEnclosuresForRack(int rackId) throws UserRackException {
        ArrayList<ExtendedURAssociation> arrToRet = new ArrayList<ExtendedURAssociation>();
        LOGGER.enter("getEnclosuresForRack " + rackId);
        Connection conn = null;
        PreparedStatement pStat = null;
        ResultSet results = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.getEnclosuresForRack");
            pStat = conn.prepareStatement("select ur.deviceKey as rack_id, ur.rackname as rack_name, d.deviceKey as encl_id, d.mxguid as encl_guid, d.Name as encl_name, u.DeviceKey2Position as encl_pos, u.startU as encl_SU, u.endU as encl_EU, u.AssociationTypeNumber as assc from user_rack_association u, devices d, user_rack ur where u.devicekey1=? and u.deviceKey2=d.deviceKey and ur.devicekey=u.deviceKey1 order by u.devicekey2position");
            pStat.setInt(1, rackId);
            results = pStat.executeQuery();
            UserRackAssociation ura = null;
            while (results.next()) {
                ura = new UserRackAssociation(results.getInt("rack_id"), results.getInt("encl_id"), results.getInt("encl_pos"), results.getInt("encl_SU"), results.getInt("encl_EU"), results.getString("assc"));
                arrToRet.add(new ExtendedURAssociation(results.getString("rack_name"), results.getString("encl_guid"), results.getString("encl_name"), ura));
                LOGGER.fine("got enclosure : " + results.getString("encl_guid") + ":" + results.getString("encl_name"));
            }
            results.close();
            pStat.close();
            results = null;
            pStat = null;
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to get enclosures for user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("getEnclosuresForRack " + rackId);
        return arrToRet;
    }

    private int getNewuserRackId(Connection conn) throws SQLException {
        LOGGER.enter("getNewuserRackId ");
        int toRet = -1;
        PreparedStatement pStat = null;
        ResultSet results = null;
        pStat = conn.prepareStatement("select deviceKey from user_rack");
        results = pStat.executeQuery();
        int max = 0;
        while (results.next()) {
            if (results.getInt(1) <= max) continue;
            max = results.getInt(1);
        }
        toRet = max + 1;
        LOGGER.fine("got user rack key : " + toRet);
        results.close();
        pStat.close();
        results = null;
        pStat = null;
        LOGGER.exit("getNewuserRackId ");
        return toRet;
    }

    public List<UserRack> getAllUserRacks() throws UserRackException {
        LOGGER.enter("getAllUserRacks ");
        ArrayList<UserRack> arrToRet = new ArrayList<UserRack>();
        Connection conn = null;
        PreparedStatement pStat = null;
        ResultSet results = null;
        try {
            conn = DatabaseManager.getDefaultDatabase().getConnection("UserRackManager.getAllUserRacks");
            pStat = conn.prepareStatement("select deviceKey, rackName, notes from user_rack");
            results = pStat.executeQuery();
            while (results.next()) {
                arrToRet.add(new UserRack(results.getInt("deviceKey"), results.getString("rackName"), results.getString("notes")));
                LOGGER.fine("got user rack " + results.getInt("deviceKey") + ":" + results.getString("rackName"));
            }
            results.close();
            pStat.close();
            results = null;
            pStat = null;
        }
        catch (SQLException sqlEx) {
            LOGGER.exception((Throwable)sqlEx);
            throw new UserRackException("unable to get all user rack [" + sqlEx.getErrorCode() + ":" + sqlEx.getMessage() + "]");
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
            }
            catch (SQLException e) {
                LOGGER.exception("exception trying to close connection : " + e.getMessage());
            }
        }
        LOGGER.exit("getAllUserRacks ");
        return arrToRet;
    }
}

