/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.toolmanager.filter.MxFilterOperator_t;
import com.hp.mx.core.toolmanager.filter.MxNameValueOperator;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class DCUtil {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DCUtil.class);

    private DCUtil() {
    }

    public static MxNode getNodeBySerialNumber(String SERIAL_NUMBER) throws DCException {
        LOGGER.enter("DCUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
        ArrayList filters = new ArrayList();
        ArrayList<MxNameValueOperator> currentFilter = new ArrayList<MxNameValueOperator>();
        filters.add(currentFilter);
        MxNameValueOperator namevaluePair = null;
        try {
            namevaluePair = new MxNameValueOperator("SerialNumber", MxFilterOperator_t.OPERATOR_EQ, SERIAL_NUMBER);
        }
        catch (MxException e) {
            LOGGER.error("DCUtil.getNodeBySerialNumber Unable to get Name Value Pair " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DCUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
            throw new DCException(e, "There is no device matching serial number " + SERIAL_NUMBER + " MxException in DCUtil.getNodeBySerialNumber");
        }
        currentFilter.add(namevaluePair);
        List nodeList = MxNodeController.getDefaultControllerNoEx().getFilterNodes((MxTransaction)new MxCoreTransaction(), filters);
        LOGGER.fine("DCUtil.getNodeBySerialNumber.nodeList.size() " + nodeList.size());
        if (nodeList.size() > 0) {
            LOGGER.exit("DCUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
            return (MxNode)nodeList.get(0);
        }
        LOGGER.exit("DCUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
        throw new DCException("There is no device matching serial number " + SERIAL_NUMBER);
    }

    public static String getHexString(byte[] byteArray) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            char[] array = new char[]{hexDigit[byteArray[i] >> 4 & 0xF], hexDigit[byteArray[i] & 0xF]};
            hexStringBuffer.append(array);
        }
        return hexStringBuffer.toString();
    }

    public static void commit(MxNode deviceMxNode) {
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (MxException e) {
            LOGGER.error("DCUtil.commit : MxException " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
        }
    }

    public static String trimAttribute(String value) {
        if (value == null || value.trim().length() == 0) {
            value = "";
        }
        return value.trim();
    }

    public static int getIntValue(String value) {
        return (value = DCUtil.trimAttribute(value)).equalsIgnoreCase("") ? -1 : Integer.parseInt(value);
    }

    public static float getFloatValue(String value) {
        return (value = DCUtil.trimAttribute(value)).equalsIgnoreCase("") ? -1.0f : Float.parseFloat(value);
    }
}

