/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http;

import com.hp.mx.utilities.DebugSubsystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.StringTokenizer;

public class Invoker {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(Invoker.class);

    public static void init(String METHOD_START_NAME, List xmlList, Class classObj, Object object) {
        LOGGER.enter("Invoker.init(" + METHOD_START_NAME + "," + xmlList + "," + classObj + "," + object + ")");
        String methodName = null;
        LOGGER.finer("Invoker.init.xmlList.size() " + xmlList.size());
        Object element = null;
        for (int i = 0; i < xmlList.size(); ++i) {
            element = xmlList.get(i);
            methodName = METHOD_START_NAME + Invoker.getMethodName(element);
            LOGGER.finer("Invoker.init.methodName " + methodName);
            try {
                Method method = classObj.getMethod(methodName, Object.class);
                method.invoke(object, element);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                LOGGER.finest("Invoker.init.NoSuchMethodException " + nsme);
                continue;
            }
            catch (IllegalAccessException iae) {
                LOGGER.finest("Invoker.init.IllegalAccessException " + iae);
                continue;
            }
            catch (InvocationTargetException ite) {
                LOGGER.finest("Invoker.init.InvocationTargetException " + ite);
                continue;
            }
            catch (SecurityException se) {
                LOGGER.finest("Invoker.init.SecurityException " + se);
            }
        }
        LOGGER.exit("Invoker.init(" + METHOD_START_NAME + "," + xmlList + "," + classObj + "," + object + ")");
    }

    private static String getMethodName(Object element) {
        LOGGER.enter("Invoker.getMethodName(" + element + ")");
        String className = element.getClass().getName();
        LOGGER.finer("Invoker.getMethodName.className " + className);
        String pkgName = element.getClass().getPackage().getName();
        LOGGER.finer("Invoker.getMethodName.pkgName " + pkgName);
        String methodName = className.substring(pkgName.length() + 1, className.length());
        StringTokenizer stringTokenizer = new StringTokenizer(methodName, "$");
        if (stringTokenizer.countTokens() > 0) {
            StringBuffer tempMethodName = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                tempMethodName.append("_");
                tempMethodName.append(stringTokenizer.nextToken());
            }
            methodName = tempMethodName.toString();
        } else {
            methodName = "_" + methodName;
        }
        LOGGER.exit("Invoker.getMethodName(" + element + ")");
        return methodName;
    }
}

