/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class DeviceManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DeviceManager.class);
    private Properties m_deviceClasses = null;
    private static DeviceManager deviceManager = null;

    private DeviceManager() {
    }

    public static DeviceManager getDeviceManager() {
        if (deviceManager == null) {
            deviceManager = new DeviceManager();
        }
        return deviceManager;
    }

    public ILO getILO(MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("DeviceManager.getILO(" + iLOMxNode + ")");
        LOGGER.fine("DeviceManager.getILO m_deviceClasses " + this.m_deviceClasses);
        this.loadProperty();
        ILO iLO = null;
        try {
            iLO = (ILO)this.getDevice(iLOMxNode, "MgmtProc");
        }
        catch (ClassCastException e) {
            LOGGER.error("DeviceManager.getILO Unable to get ILO object " + e);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getILO(" + iLOMxNode + ")");
            throw new ILOException(e, "Unable to get ILO object " + e);
        }
        LOGGER.exit("DeviceManager.getILO(" + iLOMxNode + ")");
        return iLO;
    }

    private void loadProperty() throws ILOException {
        LOGGER.enter("DeviceManager.loadProperty()");
        if (this.m_deviceClasses == null) {
            this.m_deviceClasses = new Properties();
            try {
                this.m_deviceClasses.load(this.getClass().getResourceAsStream("device.properties"));
            }
            catch (IOException e) {
                LOGGER.error("DeviceManager.loadProperty Unable to load the device.properties file. IOException " + e);
                LOGGER.exception((Throwable)e);
                LOGGER.exit("DeviceManager.loadProperty()");
                throw new ILOException(e, "DeviceManager.loadProperty Unable to load the device.properties file");
            }
        }
        LOGGER.exit("DeviceManager.loadProperty()");
    }

    private Object getDevice(MxNode deviceMxNode, String DEVICE_TYPE) throws ILOException {
        LOGGER.enter("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
        String className = (String)this.m_deviceClasses.get(DEVICE_TYPE);
        LOGGER.fine("DeviceManager.getDevice className " + className);
        if (className == null) {
            LOGGER.fine("DeviceManager.getDevice Unable to find class name for the device.");
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException("DeviceManager.getDevice Unable to find class name for the device.");
        }
        Object object = null;
        try {
            Class<?> classObj = Class.forName(className);
            Constructor<?> constructor = classObj.getConstructor(MxNode.class);
            object = constructor.newInstance(deviceMxNode);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DeviceManager.getDevice.ClassNotFoundException class name " + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to load class for class name " + className);
        }
        catch (SecurityException e) {
            LOGGER.error("DeviceManager.getDevice.SecurityException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to find constructor for class name" + className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("DeviceManager.getDevice.NoSuchMethodException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to find constructor for class name " + className);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("DeviceManager.getDevice.IllegalAccessException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to access method for class name " + className);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("DeviceManager.getDevice.IllegalArgumentException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to create device object for class name " + className);
        }
        catch (InstantiationException e) {
            LOGGER.error("DeviceManager.getDevice.InstantiationException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to create device object for class name " + className);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("DeviceManager.getDevice.InvocationTargetException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
            throw new ILOException(e, "DeviceManager.getDevice Unable to create device object for class name " + className);
        }
        LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + DEVICE_TYPE + ")");
        return object;
    }
}

