/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.ICMB;
import com.hp.mx.core.tools.datacollection.http.iLO.BladeEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.DeviceManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILODataManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOUtil;
import com.hp.mx.core.tools.datacollection.http.iLO.PowerEnclosure;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxPathProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ILOHelper {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILOHelper.class);
    private static ILOHelper iLOHelper = null;

    private ILOHelper() {
    }

    public static ILOHelper getILOHelper() {
        if (iLOHelper == null) {
            iLOHelper = new ILOHelper();
        }
        return iLOHelper;
    }

    public ILO getILO(MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("ILOHelper.getILO(" + iLOMxNode + ")");
        ILO iLO = DeviceManager.getDeviceManager().getILO(iLOMxNode);
        LOGGER.exit("ILOHelper.getILO(" + iLOMxNode + ")");
        return iLO;
    }

    public BladeEnclosure refreshBladeEnclosure(MxNode bladeEnclosureMxNode) {
        LOGGER.enter("ILOHelper.refreshBladeEnclosure(" + bladeEnclosureMxNode + ")");
        MxNode iLOMxNode = null;
        ILODataManager iLODataManager = null;
        BladeEnclosure bladeEnclosure = new BladeEnclosure();
        try {
            iLOMxNode = ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(bladeEnclosureMxNode);
            iLODataManager = new ILODataManager(iLOMxNode);
            bladeEnclosure = iLODataManager.refreshBladeEnclosure(bladeEnclosureMxNode, iLOMxNode);
            LOGGER.fine("ILOHelper.refreshBladeEnclosure successfull");
        }
        catch (ILOException ie) {
            LOGGER.error("ILOHelper.refreshBladeEnclosure failed " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILOHelper.refreshBladeEnclosure(" + bladeEnclosureMxNode + ")");
        return bladeEnclosure;
    }

    public PowerEnclosure refreshPowerEnclosure(MxNode pwrEnclToRefresh, Vector encloDevKeys) {
        LOGGER.enter("ILOHelper.refreshPowerEnclosure");
        ILODataManager iLODataManager = null;
        MxNode iLOMxNode = null;
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        try {
            iLOMxNode = ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList(encloDevKeys);
            iLODataManager = new ILODataManager(iLOMxNode);
            powerEnclosure = iLODataManager.refreshTargetPowerEnclosure(pwrEnclToRefresh, iLOMxNode);
            LOGGER.fine("ILOHelper.refreshPowerEnclosure successfull");
        }
        catch (ILOException ie) {
            LOGGER.error("ILOHelper.refreshPowerEnclosure(");
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILOHelper.refreshPowerEnclosure");
        return powerEnclosure;
    }

    public PowerEnclosure refreshPowerEnclosure(int powerEnclDevKey) {
        LOGGER.enter("ILOHelper.refreshPowerEnclosure(" + powerEnclDevKey + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        Vector<Integer> dcEnclKeys = new Vector<Integer>(5);
        try {
            MxNode powerEncl = MxNodeController.getDefaultController().getNodeByKey(powerEnclDevKey);
            String dcRackRUID = powerEncl.getClientAttribute("dCRackUUID");
            List lstDCEncls = MxNodeController.getDefaultController().getListOfNodesThatHaveThisProperty("dCRackUUID", dcRackRUID);
            for (int i = 0; i < lstDCEncls.size(); ++i) {
                MxNode enclMxNode = null;
                try {
                    enclMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(Integer.parseInt(lstDCEncls.get(i).toString()));
                    if (!enclMxNode.getDeviceType().equals("Enclosure")) continue;
                    dcEnclKeys.add(enclMxNode.getDeviceKey());
                    continue;
                }
                catch (Exception e) {
                    LOGGER.exception("Can not find an enclsoure");
                }
            }
            powerEnclosure = this.refreshPowerEnclosure(powerEncl, dcEnclKeys);
        }
        catch (Exception e) {
            // empty catch block
        }
        return powerEnclosure;
    }

    public String getILOXML(MxNode iLOMxNode) {
        return this.getXMLData(iLOMxNode.getWorkingAddress());
    }

    public String getBladeEnclosureICMBXMLString(MxNode iLOMxNode, BladeEnclosure bladeEnclosure) {
        LOGGER.enter("ILOHelper.getBladeEnclosureICMBXMLString(" + iLOMxNode + "," + bladeEnclosure + ")");
        String workingAddress = iLOMxNode.getWorkingAddress();
        LOGGER.fine("IloAssociationDataHandler.getBladeEnclosureICMBXMLString workingAddress " + workingAddress);
        String fileName = workingAddress + "-" + bladeEnclosure.getICMBAddress();
        LOGGER.fine("IloAssociationDataHandler.getBladeEnclosureICMBXMLString fileName " + fileName);
        LOGGER.exit("ILOHelper.getBladeEnclosureICMBXMLString(" + iLOMxNode + "," + bladeEnclosure + ")");
        return this.getXMLData(fileName);
    }

    public Map getPowerEnclosureICMBXMLStringMap(MxNode iLOMxNode, BladeEnclosure bladeEnclosure) {
        LOGGER.enter("ILOHelper.getPowerEnclosureICMBXMLStringMap(" + iLOMxNode + "," + bladeEnclosure + ")");
        String workingAddress = iLOMxNode.getWorkingAddress();
        LOGGER.fine("IloAssociationDataHandler.getPowerEnclosureICMBXMLStringMap.workingAddress " + workingAddress);
        HashMap<String, String> powerEnclosureICMBXMLStringMap = new HashMap<String, String>();
        List<ICMB> icmbList = bladeEnclosure.getRackTopology().getICMBList();
        ICMB icmb = null;
        String fileName = null;
        for (int i = 0; i < icmbList.size(); ++i) {
            icmb = icmbList.get(i);
            LOGGER.finer("IloAssociationDataHandler.getPowerEnclosureICMBXMLStringMap icmb.isServerEnclosure " + icmb.isServerEnclosure());
            if (icmb.isServerEnclosure()) continue;
            fileName = workingAddress + "-" + icmb.getICMBAddress();
            LOGGER.finer("IloAssociationDataHandler.getPowerEnclosureICMBXMLStringMap fileName " + fileName);
            powerEnclosureICMBXMLStringMap.put(icmb.getICMBAddress(), this.getXMLData(fileName));
        }
        LOGGER.exit("ILOHelper.getPowerEnclosureICMBXMLStringMap(" + iLOMxNode + "," + bladeEnclosure + ")");
        return powerEnclosureICMBXMLStringMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXMLData(String FILE_NAME) {
        LOGGER.enter("ILOHelper.getXMLData(" + FILE_NAME + ")");
        BufferedReader br = null;
        StringBuffer xmlBuffer = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(this.getFilePath(FILE_NAME)));
            String line = null;
            while ((line = br.readLine()) != null) {
                xmlBuffer.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("ILOHelper.getXMLData.Exception while reading " + FILE_NAME + ".xml file " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {}
        }
        LOGGER.exit("ILOHelper.getXMLData(" + FILE_NAME + ")");
        return xmlBuffer.toString();
    }

    private File getFilePath(String FILE_NAME) {
        LOGGER.enter("ILOHelper.getFilePath(" + FILE_NAME + ")");
        String FILE_PATH = MxPathProperty.getExpandedFilePath((String)"hpwebadmin", (String)"/webapps").getAbsolutePath();
        StringBuffer filePath = new StringBuffer(FILE_PATH);
        filePath.append(File.separator);
        filePath.append("ROOT");
        filePath.append(File.separator);
        filePath.append("mxportal");
        filePath.append(File.separator);
        filePath.append("bladeime");
        filePath.append(File.separator);
        filePath.append("ILO");
        filePath.append(File.separator);
        filePath.append(FILE_NAME);
        filePath.append(".xml");
        LOGGER.exit("ILOHelper.getFilePath(" + FILE_NAME + ")");
        return new File(filePath.toString());
    }
}

