/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceDetailsBean;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public class AllDevicesDetails {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(AllDevicesDetails.class);
    private StringBuffer logMsg;
    private NodeAssociationsManager nodeAssociationsManager;
    private NodeAssociations nodeAssociations;
    private MxNodeClient nodeClient;
    private String NA;

    public AllDevicesDetails() throws Exception {
        LOGGER.enter("********inside AllDevicesDetails() **********");
        this.logMsg = new StringBuffer();
        this.nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        LOGGER.exit("********inside AllDevicesDetails() **********");
    }

    public Vector getAllServersDetails(MxNode enclosureNode, MxLoginBean loginBean) throws Exception {
        LOGGER.enter("********AllDevicesDetails.getAllServerDetails(" + enclosureNode.getGUID() + ")**********");
        MxNode deviceMxNode = null;
        Vector<DeviceDetailsBean> allServersDetailsVector = new Vector<DeviceDetailsBean>();
        this.NA = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", loginBean.getLocale());
        String isSnmpEnabledOnGlobalScale = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        DeviceDetailsBean deviceDetailsBean = new DeviceDetailsBean();
        Vector serverKeyVector = this.nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclosureNode.getDeviceKey(), "ServerToEnclosure");
        for (int i = 0; i < serverKeyVector.size(); ++i) {
            Integer vectKey = (Integer)serverKeyVector.elementAt(i);
            int serverDeviceKey = vectKey;
            deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(serverDeviceKey);
            if (!deviceMxNode.getDeviceType().equals("Server")) continue;
            deviceDetailsBean = new DeviceDetailsBean();
            LOGGER.fine("AllDevicesDetails.getAllServersDetails() setting data for server device with key" + deviceMxNode.getDeviceKey());
            this.nodeAssociations = this.nodeAssociationsManager.getNodeAssociations(serverDeviceKey);
            int slotNumber = this.nodeAssociations.getSlotNumber();
            deviceDetailsBean.setBayNumber(BPVXML.checkValue(String.valueOf(slotNumber), loginBean));
            deviceDetailsBean.setSystemName(BPVXML.checkValue(deviceMxNode.getNameString(), loginBean));
            deviceDetailsBean.setModel(BPVXML.checkValue(deviceMxNode.getModel(), loginBean));
            deviceDetailsBean.setOsName(BPVXML.checkValue(deviceMxNode.getOSNameStr(), loginBean));
            deviceDetailsBean.setServerIPAddress(BPVXML.checkValue(deviceMxNode.getWorkingAddress(), loginBean));
            MxNode iLONode = BPVXML.getiLONode(deviceMxNode.getDeviceKey());
            if (iLONode != null) {
                deviceDetailsBean.setMgmtProcIPAddress(BPVXML.checkValue(iLONode.getWorkingAddress(), loginBean));
            } else {
                deviceDetailsBean.setMgmtProcIPAddress(this.NA);
            }
            if (deviceMxNode.getWorkingAddress() == null) {
                deviceMxNode = iLONode;
            }
            LOGGER.fine("isSnmpEnabledOnGlobalScale = " + isSnmpEnabledOnGlobalScale);
            if (deviceMxNode != null && isSnmpEnabledOnGlobalScale.equalsIgnoreCase("checked")) {
                MonteroSNMPUtils snmpUtils = new MonteroSNMPUtils(loginBean);
                snmpUtils.getFirmwareDetails(deviceMxNode);
                deviceDetailsBean.setSystemROMFMVersion(BPVXML.checkValue(snmpUtils.getSysROMFMVer(), loginBean));
                deviceDetailsBean.setMgmtProcFMVersion(BPVXML.checkValue(snmpUtils.getRemoteInsightROMFMVer(), loginBean));
                deviceDetailsBean.setMgmtAgentVersion(BPVXML.checkValue(snmpUtils.getInsightMgmtVersion(deviceMxNode), loginBean));
            } else {
                this.setFMVersionNotAvailable(deviceDetailsBean, this.NA);
            }
            this.writeDeviceDataToLogFile(deviceDetailsBean);
            allServersDetailsVector.add(deviceDetailsBean);
        }
        LOGGER.exit("******AllDevicesDetails.getAllServerDetails****");
        return allServersDetailsVector;
    }

    private void setFMVersionNotAvailable(DeviceDetailsBean deviceDetailsBean, String NA) {
        LOGGER.enter("**AllDevicesDetails.setFMVersionNotAvailable(" + deviceDetailsBean + ")****");
        deviceDetailsBean.setSystemROMFMVersion(NA);
        deviceDetailsBean.setMgmtProcFMVersion(NA);
        deviceDetailsBean.setMgmtAgentVersion(NA);
        LOGGER.exit("**AllDevicesDetails.setFMVersionNotAvailable(" + deviceDetailsBean + ")****");
    }

    private void writeDeviceDataToLogFile(DeviceDetailsBean deviceDetailsBean) {
        LOGGER.enter("********AllDevicesDetails.writeDeviceDataToLogFile()********");
        this.logMsg = new StringBuffer();
        this.logMsg.append("\n Bay Number: ").append(deviceDetailsBean.getBayNumber()).append("\n System Name: ").append(deviceDetailsBean.getSystemName()).append("\n System IP Address: ").append(deviceDetailsBean.getServerIPAddress()).append("\n System Model: ").append(deviceDetailsBean.getModel()).append("\n System OS Name: ").append(deviceDetailsBean.getOsName()).append("\n System ROM FM Version: ").append(deviceDetailsBean.getSystemROMFMVersion()).append("\n MP FW Version: ").append(deviceDetailsBean.getMgmtProcFMVersion()).append("\n Insight Mgmt Agent Version: ").append(deviceDetailsBean.getMgmtAgentVersion()).append("\n iLO IP Address: ").append(deviceDetailsBean.getMgmtProcIPAddress());
        LOGGER.finest("********AllDevicesDetails.writeDeviceDataToLogFile() " + this.logMsg.toString());
        LOGGER.exit("********AllDevicesDetails.writeDeviceDataToLogFile()********");
    }

    public DeviceDetailsBean getOADetails(String oaGuid, MxLoginBean loginBean) throws Exception {
        MxObjectID objID;
        MxNode oaNode1;
        OnboardAdministrator oAObj;
        LOGGER.enter("********AllDevicesDetails.getOADetails(" + oaGuid + ")*****************");
        this.nodeClient = loginBean.getNodeCtlr();
        OAHelper oaHelper = OAHelper.getOAHelper();
        DeviceDetailsBean deviceDetailsBean = new DeviceDetailsBean();
        String isHttpEnabledOnGlobalScale = GlobalSettings.getProperty((String)"http_check_state", (String)"checked");
        String i18nActiveOa = MonteroResourceManager.getInstance().getString("xml.activeOA", loginBean.getLocale());
        String i18nPassiveOa = MonteroResourceManager.getInstance().getString("xml.passiveOA", loginBean.getLocale());
        this.NA = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", loginBean.getLocale());
        if (oaGuid != null && !oaGuid.equals("") && (oAObj = (OnboardAdministrator)oaHelper.getOLDevice(oaNode1 = this.nodeClient.getNode(objID = new MxObjectID(new MxGUID(oaGuid)), false), oaNode1)) != null) {
            String role;
            deviceDetailsBean = new DeviceDetailsBean();
            deviceDetailsBean.setSystemName(BPVXML.checkValue(oaNode1.getNameString(), loginBean));
            deviceDetailsBean.setModel(BPVXML.checkValue(oaNode1.getModel(), loginBean));
            this.nodeAssociations = this.nodeAssociationsManager.getNodeAssociations(oaNode1.getDeviceKey());
            int slotNumber = this.nodeAssociations.getSlotNumber();
            deviceDetailsBean.setBayNumber(BPVXML.checkValue(String.valueOf(slotNumber), loginBean));
            deviceDetailsBean.setServerIPAddress(BPVXML.checkValue(oaNode1.getWorkingAddress(), loginBean));
            if (isHttpEnabledOnGlobalScale.equalsIgnoreCase("checked")) {
                role = oAObj.getIsPrimary() ? i18nActiveOa : i18nPassiveOa;
                deviceDetailsBean.setOaRole(BPVXML.checkValue(role, loginBean));
                deviceDetailsBean.setOaFMVersion(BPVXML.checkValue(oAObj.getFWRI(), loginBean));
            } else {
                LOGGER.fine("http is disabled at global level. OA firmware version and role will be set to \"Not Available\"");
                role = this.NA;
                deviceDetailsBean.setOaRole(BPVXML.checkValue(role, loginBean));
                deviceDetailsBean.setOaFMVersion(BPVXML.checkValue(this.NA, loginBean));
            }
            this.logMsg = new StringBuffer();
            this.logMsg.append("\nOA Data is \n Bay Number ").append(deviceDetailsBean.getBayNumber()).append("\n System Name").append(deviceDetailsBean.getSystemName()).append("\n System IP Address").append(deviceDetailsBean.getServerIPAddress()).append("\n System Model").append(deviceDetailsBean.getModel()).append("\n OA FM Version").append(deviceDetailsBean.getOaFMVersion()).append("\n Role").append(role);
            LOGGER.fine(this.logMsg.toString());
        }
        LOGGER.exit("********AllDevicesDetails.getOADetails(" + oaGuid + ")*****************");
        return deviceDetailsBean;
    }
}

