/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceManager;
import com.hp.mx.core.tools.datacollection.http.oa.OADataManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxPathProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAHelper {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OAHelper.class);
    private static OAHelper oaHelper = null;

    private OAHelper() {
    }

    public static OAHelper getOAHelper() {
        if (oaHelper == null) {
            oaHelper = new OAHelper();
        }
        return oaHelper;
    }

    public OLDevice getOLDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        LOGGER.enter("OAHelper.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        OLDevice olDevice = DeviceManager.getDeviceManager().getOLDevice(deviceMxNode, initFromMxNode);
        LOGGER.exit("OAHelper.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        return olDevice;
    }

    public OLDevice getOLDevice(OLEnclosure olEnclosure, int deviceKey) throws OAException {
        LOGGER.enter("OAHelper.getOLDevice(" + olEnclosure + "," + deviceKey + ")");
        if (olEnclosure == null) {
            throw new OAException("Unable to get the device from OLEnclosure as its null.");
        }
        OLDevice olDevice = null;
        try {
            MxNode device = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
            String deviceType = device.getDeviceType();
            Iterator<OLDevice> iter = null;
            if (deviceType.equalsIgnoreCase("Server") || deviceType.equalsIgnoreCase("Storage") || deviceType.equalsIgnoreCase("IO Expansion") || deviceType.equalsIgnoreCase("Workstation")) {
                iter = olEnclosure.getBladeList().iterator();
            } else if (deviceType.equalsIgnoreCase("Switch")) {
                iter = olEnclosure.getSwitchList().iterator();
            } else if (deviceType.equalsIgnoreCase("MgmtProc")) {
                iter = olEnclosure.getOAList().iterator();
            } else {
                LOGGER.fine("The method gets the latest data only forServers/Switches/Storage/MgmtProc, The deviceType for the given device is :" + deviceType + ",Hence exiting.");
                throw new OAException("Given device not a Servers/Switches/Storage/MgmtProc , Hence cannot get the latest data for the device");
            }
            while (iter.hasNext()) {
                olDevice = iter.next();
                MxNode deviceMxNode = null;
                deviceMxNode = olDevice.getDeviceMxNode();
                LOGGER.fine("OAHelper.getOLDevice.deviceMxNode " + deviceMxNode);
                if (deviceMxNode == null || deviceMxNode.getDeviceKey() != deviceKey) continue;
                break;
            }
        }
        catch (MxUndefinedNodeException undefExec) {
            LOGGER.fine("Unable to find a node with deviceKey" + deviceKey);
            throw new OAException("Unable to find a node, Hence cannot get the latest data for the device");
        }
        if (olDevice == null) {
            LOGGER.fine("Unable to find a node with deviceKey" + deviceKey);
            throw new OAException("Unable to find a node, Hence cannot get the latest data for the device");
        }
        LOGGER.enter("OAHelper.getOLDevice(" + olEnclosure + "," + deviceKey + ")");
        return olDevice;
    }

    public MxNode getDeviceNodeHavingProperty(String uniqueIdentifier) throws OAException {
        LOGGER.enter("OAHelper.getDeviceNodeHavingProperty(" + uniqueIdentifier + ")");
        List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("UUID_" + uniqueIdentifier, uniqueIdentifier);
        LOGGER.fine("OAHelper.getDeviceNodeHavingProperty.allDevicesWithThisProperty " + allDevicesWithThisProperty);
        LOGGER.fine("OAHelper.getDeviceNodeHavingProperty.allDevicesWithThisProperty.size() " + allDevicesWithThisProperty.size());
        MxNode mxNode = null;
        for (int i = 0; i < allDevicesWithThisProperty.size(); ++i) {
            int deviceKey = (Integer)allDevicesWithThisProperty.get(i);
            LOGGER.fine("OAHelper.getDeviceNodeHavingProperty.deviceKey " + deviceKey);
            try {
                mxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                LOGGER.fine("OAHelper.getDeviceNodeHavingProperty.mxNode " + mxNode);
                LOGGER.fine("OAHelper.getDeviceNodeHavingProperty.mxNode.getDeviceType() " + mxNode.getDeviceType());
                if (mxNode.getDeviceType().equalsIgnoreCase("Enclosure")) {
                    return mxNode;
                }
                LOGGER.exit("OAHelper.getDeviceNodeHavingProperty(" + uniqueIdentifier + ")");
                continue;
            }
            catch (MxException ex) {
                LOGGER.error("OAHelper.getDeviceNodeHavingProperty MxException " + (Object)((Object)ex));
                LOGGER.exception((Throwable)ex);
            }
        }
        LOGGER.exit("OAHelper.getDeviceNodeHavingProperty(" + uniqueIdentifier + ")");
        throw new OAException("Unable to get MxNode having property " + uniqueIdentifier);
    }

    public MxNode getOAMxNode(MxNode enclosureMxNode) throws OAException {
        MxNode oaMxNode = null;
        try {
            Integer devKey;
            NodeAssociationsManager nodeManager = NodeAssociationsManager.getDefaultManager();
            Vector oaDeviceKeyList = nodeManager.getAssociatedDevicesUsingATNs(enclosureMxNode.getDeviceKey(), "MgmtProcToEnclosure");
            MxNodeController nodeController = MxNodeController.getDefaultController();
            for (int i = 0; !(i >= oaDeviceKeyList.size() || nodeController.getNodeByKey(devKey = (Integer)oaDeviceKeyList.get(i)).getIPAddressCount() > 0 && ((OnboardAdministrator)this.getOLDevice(oaMxNode = nodeController.getNodeByKey(devKey), oaMxNode)).getIsPrimary()); ++i) {
            }
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Exception:" + (Object)((Object)e));
        }
        catch (MxObjectPersistenceException e) {
            LOGGER.fine("Exception:" + (Object)((Object)e));
        }
        if (oaMxNode == null || oaMxNode.getIPAddressCount() <= 0) {
            throw new OAException("Physical active/standby OA Not found to update the enclosure details.");
        }
        return oaMxNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLEnclosure refreshData(MxNode enclosureMxNode) {
        LOGGER.enter("OAHelper.refreshData(" + enclosureMxNode + ")");
        OLEnclosure olEnclosure = null;
        try {
            MxNode oaMxNode = this.getOAMxNode(enclosureMxNode);
            OADataManager oaDataManager = new OADataManager(oaMxNode);
            olEnclosure = oaDataManager.getEnclosureDevice();
            NodeAssociations myEnclosureNodeAssociations = null;
            NodeAssociations nodeAssociations = myEnclosureNodeAssociations = NodeAssociationsManager.getDefaultManager().getNodeAssociations(enclosureMxNode.getDeviceKey());
            synchronized (nodeAssociations) {
                this.refreshOLDevice(olEnclosure.getBladeList(), enclosureMxNode);
                this.refreshOLDevice(olEnclosure.getSwitchList(), enclosureMxNode);
                this.refreshOLDevice(olEnclosure.getOAList(), enclosureMxNode);
                olEnclosure.update(enclosureMxNode);
            }
        }
        catch (OAException oaExcep) {
            LOGGER.fine("Unable to get the latest data from the enclosure. Not Available will be shown");
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Unable to get the latest data from the enclosure. Not Available will be shown");
            LOGGER.exception((Throwable)e);
        }
        if (olEnclosure == null) {
            olEnclosure = new OLEnclosure();
        }
        LOGGER.exit("OAHelper.refreshData(" + enclosureMxNode + ")");
        return olEnclosure;
    }

    private void refreshOLDevice(List<OLDevice> deviceList, MxNode enclosureMxNode) {
        LOGGER.enter("OAHelper.refreshOLDevice(" + deviceList + "," + enclosureMxNode + ")");
        OLDevice olDevice = null;
        MxNode deviceMxNode = null;
        LOGGER.fine("OAHelper.refreshOLDevice.deviceList.size() " + deviceList.size());
        for (int i = 0; i < deviceList.size(); ++i) {
            olDevice = deviceList.get(i);
            LOGGER.fine("OAHelper.refreshOLDevice.olDevice.getClass().getName() " + olDevice.getClass().getName());
            LOGGER.fine("OAHelper.refreshOLDevice.olDevice.getDeviceUUID() " + olDevice.getDeviceUUID());
            LOGGER.fine("OAHelper.refreshOLDevice.olDevice.getDeviceSerialNumber() " + olDevice.getDeviceSerialNumber());
            if (!olDevice.isUniqueIdentifierExists()) {
                LOGGER.fine("OAHelper.refreshOLDevice : No Unique Identifier. Skipping Node Refresh");
                continue;
            }
            deviceMxNode = olDevice.getDeviceMxNode();
            LOGGER.fine("OAHelper.refreshOLDevice.deviceMxNode " + deviceMxNode);
            olDevice.update(deviceMxNode, enclosureMxNode);
        }
        LOGGER.exit("OAHelper.refreshOLDevice(" + deviceList + "," + enclosureMxNode + ")");
    }

    public OLEnclosure refreshEnclosureData(MxNode enclosureMxNode) throws OAException {
        LOGGER.enter("OAHelper.refreshDeviceData(" + enclosureMxNode + ")");
        OLEnclosure olEnclosure = new OLEnclosure();
        MxNode oaMxNode = this.getOAMxNode(enclosureMxNode);
        OADataManager oaDataManager = new OADataManager(oaMxNode);
        olEnclosure = oaDataManager.getEnclosureDevice();
        LOGGER.exit("OAHelper.refreshDeviceData(" + enclosureMxNode + ")");
        return olEnclosure;
    }

    public boolean isValidURL(String URLpattern) {
        LOGGER.enter("OAHelper.isValidURL");
        boolean isValidURL = true;
        try {
            new URL(URLpattern);
        }
        catch (MalformedURLException e) {
            isValidURL = false;
        }
        LOGGER.exit("OAHelper.isValidURL");
        return isValidURL;
    }

    public String getOAXML(MxNode oaMxNode) {
        LOGGER.enter("OAHelper.getOAXML(" + oaMxNode + ")");
        LOGGER.exit("OAHelper.getOAXML(" + oaMxNode + ")");
        return this.getXMLData(oaMxNode.getWorkingAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXMLData(String FILE_NAME) {
        LOGGER.enter("OAHelper.getXMLData(" + FILE_NAME + ")");
        BufferedReader br = null;
        StringBuffer xmlBuffer = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(this.getFilePath(FILE_NAME)));
            String line = null;
            while ((line = br.readLine()) != null) {
                xmlBuffer.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("OAHelper.getXMLData.Exception while reading " + FILE_NAME + ".xml file " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {}
        }
        LOGGER.exit("OAHelper.getXMLData(" + FILE_NAME + ")");
        return xmlBuffer.toString();
    }

    private File getFilePath(String FILE_NAME) {
        LOGGER.enter("OAHelper.getFilePath(" + FILE_NAME + ")");
        String FILE_PATH = MxPathProperty.getExpandedFilePath((String)"hpwebadmin", (String)"/webapps").getAbsolutePath();
        StringBuffer filePath = new StringBuffer(FILE_PATH);
        filePath.append(File.separator);
        filePath.append("ROOT");
        filePath.append(File.separator);
        filePath.append("mxportal");
        filePath.append(File.separator);
        filePath.append("bladeime");
        filePath.append(File.separator);
        filePath.append("OA");
        filePath.append(File.separator);
        filePath.append(FILE_NAME);
        filePath.append(".xml");
        LOGGER.exit("OAHelper.getFilePath(" + FILE_NAME + ")");
        return new File(filePath.toString());
    }

    public OADataManager getOADataManagerUT(MxNode oaMxNode) throws OAException {
        LOGGER.enter("OAAssociationHandler.getOADataManagerUT(" + oaMxNode + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        OADataManager oaDataManager = new OADataManager(oaHelper.getOAXML(oaMxNode));
        LOGGER.exit("OAAssociationHandler.getOADataManagerUT(" + oaMxNode + ")");
        return oaDataManager;
    }
}

