/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLBladePortMap;
import com.hp.mx.core.tools.datacollection.http.oa.OLConstants;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYINFOType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYOCCUPANTType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BLADEPortMap;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BLADEType;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class OLBlade
extends OLDevice {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OLBlade.class);
    private String assocDevBay = "";
    private String type = "";
    private OLBladePortMap olBladePortMap = new OLBladePortMap();
    private final String[] BLADECLIENTATTRIBUTES = new String[]{"BL_STRG_ASSOC_"};

    public OLBlade(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        LOGGER.enter("OLBlade(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
        this.print("OLBlade DB");
        this.assocDevBay = DCUtil.trimAttribute(initFromMxNode.getClientAttribute(this.BLADECLIENTATTRIBUTES[0] + this.uniqueIdentifier));
        LOGGER.exit("OLBlade(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
    }

    public OLBlade(BLADEType bladeType, BAYINFOType bayInfoType, String enclosureProductName) {
        LOGGER.enter("OLBlade(" + bladeType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", bladeType.getContent(), OLBlade.class, this);
        if (enclosureProductName.contains("c3000")) {
            this.calculateShortyDirection();
        } else {
            this.calculateDirection(8);
        }
        if (enclosureProductName.toLowerCase().contains("c3000")) {
            this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInXDirection;
            this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInYDirection;
        } else {
            this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
            this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        }
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = DCUtil.trimAttribute(bayInfoType.getSIDE());
        this.initUniqueIdentifier();
        this.print("OLBlade JAXB");
        LOGGER.exit("OLBlade(" + bladeType + "," + bayInfoType + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_BAYImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = DCUtil.getIntValue(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_BAYImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_MGMTIPADDRImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = DCUtil.trimAttribute(((BLADEType.MGMTIPADDR)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_MGMTIPADDRImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_SPNImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_SPNImpl(" + element + ")");
        this.spn = DCUtil.trimAttribute(((BLADEType.SPN)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_SPNImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_BSNImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_BSNImpl(" + element + ")");
        this.bsn = DCUtil.trimAttribute(((BLADEType.BSN)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_BSNImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_TYPEImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_TYPEImpl(" + element + ")");
        this.type = DCUtil.trimAttribute(((BLADEType.TYPE)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_TYPEImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_STATUSImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_STATUSImpl(" + element + ")");
        this.status = DCUtil.trimAttribute(((BLADEType.STATUS)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_STATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_PORTMAPImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_PORTMAPImpl(" + element + ")");
        this.olBladePortMap.init((BLADEPortMap)element);
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_PORTMAPImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_UUIDImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_UUIDImpl(" + element + ")");
        this.uuid = DCUtil.trimAttribute(((BLADEType.UUID)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_TEMPSImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((BLADEType.TEMPSType)element).getContent());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_TEMPSImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_FANSImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_FANSImpl(" + element + ")");
        BLADEType.FANSType fansType = (BLADEType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_FANSImpl(" + element + ")");
    }

    public void initializeINFRA2_BLADETypeImpl_ASSOCIATEDBLADEImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_BLADETypeImpl_ASSOCIATEDBLADEImpl(" + element + ")");
        this.assocDevBay = DCUtil.trimAttribute(((BLADEType.ASSOCIATEDBLADE)element).getValue());
        LOGGER.exit("OLBlade.initializeINFRA2_BLADETypeImpl_ASSOCIATEDBLADEImpl(" + element + ")");
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        int assocBay;
        super.updateDataOnDevice(deviceMxNode);
        LOGGER.enter("OLBlade.updateDataOnDevice(" + deviceMxNode + ")");
        if (this.assocDevBay != null && this.assocDevBay.matches("\\d+") && (assocBay = DCUtil.getIntValue(this.assocDevBay)) != 0) {
            deviceMxNode.setClientAttribute(this.BLADECLIENTATTRIBUTES[0] + this.uniqueIdentifier, this.assocDevBay);
        }
        LOGGER.exit("OLBlade.updateDataOnDevice(" + deviceMxNode + ")");
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        LOGGER.enter("OLBlade.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                LOGGER.fine("OLBlade.update.Cleaning device data from OLBlade uniqueIdentifier " + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                LOGGER.fine("OLBlade.update.Cleaning done from OLBlade uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                LOGGER.error("OLBlade.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("OLBlade.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            try {
                LOGGER.fine("OLBlade.update.updating device data on itself uniqueIdentifier " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLBlade.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            DCUtil.commit(deviceMxNode);
        }
        if (enclosureMxNode != null) {
            try {
                LOGGER.fine("OLBlade.update.Cleaning device data from enclosure uniqueIdentifier " + this.uniqueIdentifier);
                this.cleanDataFromEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLBlade.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            try {
                LOGGER.fine("OLBlade.update.updating device data on enclosure node uniqueIdentifier " + this.uniqueIdentifier);
                this.updateDataOnEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLBlade.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
        }
        LOGGER.exit("OLBlade.update(" + deviceMxNode + "," + enclosureMxNode + ")");
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        super.cleanDataFromDevice(deviceMxNode);
        LOGGER.enter("OLBlade.cleanDataFromDevice(" + deviceMxNode + ")");
        for (String propertyName : this.BLADECLIENTATTRIBUTES) {
            deviceMxNode.removeClientAttribute(propertyName + this.uniqueIdentifier);
        }
        LOGGER.exit("OLBlade.cleanDataFromDevice(" + deviceMxNode + ")");
    }

    public String getDeviceType() {
        for (int i = 0; i < OLConstants.OL_BLADE_TYPE.length; ++i) {
            if (!this.type.equalsIgnoreCase(OLConstants.OL_BLADE_TYPE[i][0])) continue;
            return OLConstants.OL_BLADE_TYPE[i][1];
        }
        return OLConstants.OL_BLADE_TYPE[0][1];
    }

    public OLBladePortMap getOLBladePortMap() {
        return this.olBladePortMap;
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        if (this.spn.toLowerCase().indexOf("xw460c") == -1) {
            if (this.spn.toLowerCase().indexOf("bl860c") > 0) {
                subTypeList.add("HPIntegrity");
            } else {
                subTypeList.add("HPProLiant");
            }
        }
        if (this.type.equalsIgnoreCase("IO")) {
            subTypeList.add(NodeSubTypeMapper.PCI_EXPANSION_SUBTYPE.toString());
        }
        return subTypeList;
    }

    public MxNode getDeviceMxNode() {
        LOGGER.enter("OLBlade.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        if (this.uuid != null && this.uuid.trim().length() > 0) {
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
            }
            catch (MxUndefinedNodeException except) {
                LOGGER.fine("OLBlade.getServerMxNode MxUndefinedNodeException: " + (Object)((Object)except));
                LOGGER.fine("OLBlade.getServerMxNode Unable to get server node by UUID : " + this.uuid);
                String nonSwapedNormalizedUUID = null;
                try {
                    nonSwapedNormalizedUUID = UniqueIdentifierUtility.normalizeUniqueID((String)this.uuid, (boolean)false, (boolean)true);
                    deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(nonSwapedNormalizedUUID);
                }
                catch (MxUndefinedNodeException ex) {
                    LOGGER.fine("OLBlade.getServerMxNode MxUndefinedNodeException: " + (Object)((Object)ex));
                    LOGGER.fine("OLBlade.getServerMxNode Unable to get server node by Unique Identifier: " + nonSwapedNormalizedUUID);
                }
            }
        } else {
            try {
                deviceMxNode = DCUtil.getNodeBySerialNumber(this.bsn);
            }
            catch (DCException de) {
                LOGGER.fine("OLBlade.getDeviceMxNode.DCException Unable to find Server MxNode by bsn[serial number]: " + de);
            }
        }
        LOGGER.exit("OLBlade.getDeviceMxNode()");
        return deviceMxNode;
    }

    public String getAssociatedBay() {
        return this.assocDevBay;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        LOGGER.enter("*********OLBlade.print(" + SOURCE + ")**************");
        LOGGER.fine("OLBlade.type " + this.type);
        LOGGER.exit("*********OLBlade.print(" + SOURCE + ")**************");
    }

    protected void initUniqueIdentifier() {
        LOGGER.enter("OLDevice.initUniqueIdentifier()");
        this.uniqueIdentifier = this.spn.toLowerCase().indexOf("bl860c") > 0 ? UniqueIdentifierUtility.normalizeUniqueID((String)this.uuid, (boolean)false, (boolean)true) : this.uuid;
        if (this.uniqueIdentifier == null || this.uniqueIdentifier.trim().length() == 0) {
            LOGGER.fine("  >>>>> uuid is empty, set bsn as uniqueidentifier... <<<<<");
            this.uniqueIdentifier = this.bsn;
        }
        LOGGER.exit("OLDevice.initUniqueIdentifier()");
    }

    private void calculateShortyDirection() {
        LOGGER.enter("OLBlade.calculateShortyDirection()");
        LOGGER.fine("occupiesList.size() " + this.occupiesList.size());
        int TOTAL_SLOTS_OCCUPIED = this.occupiesList.size() + 1;
        this.slotsUsedInYDirection = 1;
        if (this.occupiesList.size() > 0) {
            this.slotsUsedInYDirection = 2;
        }
        this.slotsUsedInXDirection = TOTAL_SLOTS_OCCUPIED / this.slotsUsedInYDirection;
        LOGGER.fine("slotsUsedInXDirection " + this.slotsUsedInXDirection);
        LOGGER.fine("slotsUsedInYDirection " + this.slotsUsedInYDirection);
        LOGGER.exit("OLBlade.calculateShortyDirection()");
    }
}

