/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceFansType;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceTempsType;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;

public abstract class OLDevice {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OLDevice.class);
    protected int connection = -1;
    protected List occupiesList;
    protected int slotsUsedInXDirection = -1;
    protected int slotsUsedInYDirection = -1;
    protected int width = -1;
    protected int height = -1;
    protected int depth = -1;
    protected String side = "";
    protected String mgmtIPAddress = "";
    protected String spn = "";
    protected String bsn = "";
    protected String status = "";
    protected String uuid = "";
    protected String uniqueIdentifier = "";
    protected DeviceTempsType deviceTempsType = new DeviceTempsType();
    protected DeviceFansType deviceFansType = new DeviceFansType();
    private final String[] CLIENTATTRIBUTES = new String[]{"DEV_CON_", "DEV_SLT_X_", "DEV_SLT_Y_", "DEV_WID_", "DEV_HEIG_", "DEV_DEP_", "UUID_"};

    public OLDevice() {
    }

    public OLDevice(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        LOGGER.enter("OLDevice(" + initFromMxNode + "," + deviceUniqueIdentifier + ")");
        this.uniqueIdentifier = deviceUniqueIdentifier;
        if (initFromMxNode != null && initFromMxNode.getDeviceType().equals("Enclosure")) {
            this.initFromEnclosure(initFromMxNode);
        }
        LOGGER.exit("OLDevice(" + initFromMxNode + "," + deviceUniqueIdentifier + ")");
    }

    private void initFromEnclosure(MxNode enclosureMxNode) {
        LOGGER.enter("OLDevice.initFromEnclosure(" + enclosureMxNode + ")");
        try {
            this.connection = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + this.uniqueIdentifier));
            this.slotsUsedInXDirection = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + this.uniqueIdentifier));
            this.slotsUsedInYDirection = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + this.uniqueIdentifier));
            this.width = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + this.uniqueIdentifier));
            this.height = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4] + this.uniqueIdentifier));
            this.depth = DCUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5] + this.uniqueIdentifier));
        }
        catch (Exception e) {
            LOGGER.error("OLDevice.initFromEnclosure.Exception. " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("OLDevice.initFromEnclosure(" + enclosureMxNode + ")");
    }

    protected void initUniqueIdentifier() {
        LOGGER.enter("OLDevice.initUniqueIdentifier()");
        this.uniqueIdentifier = this.uuid;
        if (this.uniqueIdentifier == null || this.uniqueIdentifier.trim().length() == 0) {
            LOGGER.fine("  >>>>> uuid is empty, set bsn as uniqueidentifier... <<<<<");
            this.uniqueIdentifier = this.bsn;
        }
        LOGGER.exit("OLDevice.initUniqueIdentifier()");
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        LOGGER.enter("OLDevice.updateDataOnDevice(" + deviceMxNode + ")");
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[6] + this.uniqueIdentifier, this.uniqueIdentifier);
        LOGGER.exit("OLDevice.updateDataOnDevice(" + deviceMxNode + ")");
    }

    protected void updateDataOnEnclosure(MxNode enclosureMxNode) {
        LOGGER.enter("OLDevice.updateDataOnEnclosure(" + enclosureMxNode + ")");
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + this.uniqueIdentifier, String.valueOf(this.connection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + this.uniqueIdentifier, String.valueOf(this.slotsUsedInXDirection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + this.uniqueIdentifier, String.valueOf(this.slotsUsedInYDirection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + this.uniqueIdentifier, String.valueOf(this.width));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[4] + this.uniqueIdentifier, String.valueOf(this.height));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[5] + this.uniqueIdentifier, String.valueOf(this.depth));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[6] + this.uniqueIdentifier, this.uniqueIdentifier);
        LOGGER.exit("OLDevice.updateDataOnEnclosure(" + enclosureMxNode + ")");
    }

    public String getDeviceSerialNumber() {
        return this.bsn;
    }

    public String getDeviceProductName() {
        return this.spn;
    }

    public int getDeviceSlot() {
        return this.connection;
    }

    public String getDeviceMgmtProcIp() {
        return this.mgmtIPAddress;
    }

    public String getDeviceSide() {
        return this.side;
    }

    public int getDeviceSlotsInXDirection() {
        return this.slotsUsedInXDirection;
    }

    public int getDeviceSlotsInYDirection() {
        return this.slotsUsedInYDirection;
    }

    public int getDeviceWidth() {
        return this.width;
    }

    public int getDeviceDepth() {
        return this.depth;
    }

    public int getDeviceHeight() {
        return this.height;
    }

    public String getDeviceStatus() {
        return this.status;
    }

    public String getDeviceUUID() {
        return this.uuid;
    }

    public abstract String getDeviceType();

    public abstract List getSubTypeList();

    public abstract MxNode getDeviceMxNode();

    public abstract void update(MxNode var1, MxNode var2);

    public boolean isUniqueIdentifierExists() {
        return this.uuid != null && this.uuid.trim().length() != 0 || this.bsn != null && this.bsn.trim().length() != 0;
    }

    public DeviceTempsType getDeviceTempsType() {
        return this.deviceTempsType;
    }

    public DeviceFansType getDeviceFansType() {
        return this.deviceFansType;
    }

    protected void calculateDirection(int MAX_SLOTS_IN_XDIRECTION) {
        LOGGER.enter("OLDevice.calculateDirection(" + MAX_SLOTS_IN_XDIRECTION + ")");
        LOGGER.fine("OLDevice.calculateDirection occupiesList.size() " + this.occupiesList.size());
        int TOTAL_SLOTS_OCCUPIED = this.occupiesList.size() + 1;
        this.slotsUsedInYDirection = 1;
        if (this.occupiesList.size() > 0) {
            int FIRST_OCCUPIED_SLOT = DCUtil.getIntValue((String)this.occupiesList.get(0));
            LOGGER.fine("OLDevice.calculateDirection FIRST_OCCUPIED_SLOT " + FIRST_OCCUPIED_SLOT);
            if (this.occupiesList.contains(String.valueOf(FIRST_OCCUPIED_SLOT + MAX_SLOTS_IN_XDIRECTION)) || this.connection + MAX_SLOTS_IN_XDIRECTION == FIRST_OCCUPIED_SLOT) {
                this.slotsUsedInYDirection = 2;
            }
        }
        this.slotsUsedInXDirection = TOTAL_SLOTS_OCCUPIED / this.slotsUsedInYDirection;
        LOGGER.fine("OLDevice.calculateDirection slotsUsedInXDirection " + this.slotsUsedInXDirection);
        LOGGER.fine("OLDevice.calculateDirection slotsUsedInYDirection " + this.slotsUsedInYDirection);
        LOGGER.exit("OLDevice.calculateDirection(" + MAX_SLOTS_IN_XDIRECTION + ")");
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        LOGGER.enter("OLDevice.cleanDataFromDevice(" + deviceMxNode + ")");
        for (String propertyName : this.CLIENTATTRIBUTES) {
            deviceMxNode.removeClientAttribute(propertyName + this.uniqueIdentifier);
        }
        LOGGER.exit("OLDevice.cleanDataFromDevice(" + deviceMxNode + ")");
    }

    protected void cleanDataFromEnclosure(MxNode enclosureMxNode) {
        LOGGER.enter("OLDevice.cleanDataFromEnclosure(" + enclosureMxNode + ")");
        for (String propertyName : this.CLIENTATTRIBUTES) {
            enclosureMxNode.removeClientAttribute(propertyName + this.uniqueIdentifier);
        }
        LOGGER.exit("OLDevice.cleanDataFromEnclosure(" + enclosureMxNode + ")");
    }

    protected void print(String SOURCE) {
        LOGGER.enter("*********OLDevice.print(" + SOURCE + ")**************");
        LOGGER.fine("OLDevice.connection " + this.connection);
        LOGGER.fine("OLDevice.occupiesList " + this.occupiesList);
        if (this.occupiesList != null) {
            LOGGER.fine("OLDevice.occupiesList.size() " + this.occupiesList.size());
        }
        LOGGER.fine("OLDevice.slotsUsedInXDirection " + this.slotsUsedInXDirection);
        LOGGER.fine("OLDevice.slotsUsedInYDirection " + this.slotsUsedInYDirection);
        LOGGER.fine("OLDevice.width " + this.width);
        LOGGER.fine("OLDevice.height " + this.height);
        LOGGER.fine("OLDevice.depth " + this.depth);
        LOGGER.fine("OLDevice.side " + this.side);
        LOGGER.fine("OLDevice.mgmtIPAddress " + this.mgmtIPAddress);
        LOGGER.fine("OLDevice.spn " + this.spn);
        LOGGER.fine("OLDevice.bsn " + this.bsn);
        LOGGER.fine("OLDevice.status " + this.status);
        LOGGER.fine("OLDevice.uuid " + this.uuid);
        LOGGER.fine("OLDevice.uniqueIdentifier " + this.uniqueIdentifier);
        LOGGER.exit("*********OLDevice.print(" + SOURCE + ")**************");
    }
}

