/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.snmp.vcm;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.tools.datacollection.snmp.vcm.VCDomainBean;
import com.hp.mx.core.tools.datacollection.snmp.vcm.interconnect.VCSwitchConfigStates;
import com.hp.mx.core.tools.datacollection.snmp.vcm.interconnect.VCSwitchRunningStatus;
import com.hp.mx.core.tools.identification.associations.VCDomainAssociationHandler;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;

public class VCDomain {
    private MxNode vcdNode;
    private MxLoginBean loginBean;
    private VCSwitchRunningStatus vcRunningStatus;
    private VCSwitchConfigStates vcConfigStatus;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(VCDomain.class);

    public VCDomain(MxNode vcdNode, MxLoginBean loginBean) throws NodeAssociationsPersistenceException {
        LOGGER.enter("VCDomain(" + vcdNode + ", " + loginBean + ")");
        this.vcdNode = vcdNode;
        this.loginBean = loginBean;
        this.vcRunningStatus = new VCSwitchRunningStatus(loginBean);
        this.vcConfigStatus = new VCSwitchConfigStates(loginBean);
        LOGGER.exit("VCDomain(" + vcdNode + " , " + loginBean + ")");
    }

    public VCDomainBean getVCDomainData() throws Exception {
        LOGGER.enter("VCDomain.getVCDomainData()");
        VCDomainBean vcDomainBean = new VCDomainBean();
        String cfgStatus = "";
        String runningStatus = "";
        String firmwareVersion = "";
        String vcDomainName = "";
        String vcmIp = "";
        String enclName = "";
        int switchSlotNumber = -1;
        String rackName = "";
        MxNode rackNode = null;
        MxNode switchNode = VCDomainAssociationHandler.getAssociatedNode(this.vcdNode, "SwitchToVCDomain");
        MxNode snmpSwNode = null;
        if (switchNode == null || switchNode.getIPAddressList().isEmpty()) {
            LOGGER.fine("switch node does exist. Creating a temp switch node");
            snmpSwNode = VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(this.vcdNode.getClientAttribute("vcDomainIP"));
        } else {
            snmpSwNode = switchNode;
        }
        if (this.vcdNode != null) {
            vcDomainName = this.vcdNode.getNameString();
            vcmIp = this.vcdNode.getClientAttribute("vcDomainIP");
            LOGGER.fine("name is " + vcDomainName + " vcm ip: " + vcmIp);
        }
        if (snmpSwNode != null) {
            LOGGER.fine("Name is " + snmpSwNode.getNameString());
            cfgStatus = this.vcConfigStatus.getVCDomainConfigurationStatus(snmpSwNode);
            runningStatus = this.vcRunningStatus.getVCDomainRunningStatus(snmpSwNode);
            firmwareVersion = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.6.1.1.4.1[0]", snmpSwNode);
        } else {
            LOGGER.fine("unable to make SNMP calls to master switch - no dummy node created.");
        }
        MxNode enclNode = null;
        if (switchNode != null) {
            enclNode = VCDomainAssociationHandler.getAssociatedNode(switchNode, "SwitchToEnclosure");
            NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nam.getNodeAssociations(switchNode.getDeviceKey());
            if (nodeAssociations != null) {
                switchSlotNumber = nodeAssociations.getSlotNumber();
            }
        } else {
            LOGGER.fine("associated switch node is not found. VCM data other than the name and vcm ip will be shown as NOT AVAILABLE");
        }
        if (enclNode == null) {
            enclNode = VCDomainAssociationHandler.getAssociatedNode(this.vcdNode, "EnclosureToVCDomain");
        }
        if (enclNode != null) {
            enclName = enclNode.getNameString();
            rackNode = VCDomainAssociationHandler.getAssociatedNode(enclNode, "EnclosureToRack");
        } else {
            LOGGER.fine("unable to find enclosure.");
        }
        if (rackNode != null) {
            rackName = rackNode.getNameString();
        } else {
            LOGGER.fine("unable to find rack.");
        }
        vcDomainBean.setVcDomainIP(BPVXML.checkValue(vcmIp, this.loginBean));
        vcDomainBean.setCfgStatus(BPVXML.checkValue(cfgStatus, this.loginBean));
        vcDomainBean.setRunningStatus(BPVXML.checkValue(runningStatus, this.loginBean));
        vcDomainBean.setVcmFirmware(BPVXML.checkValue(firmwareVersion, this.loginBean));
        vcDomainBean.setVcDomainName(BPVXML.checkValue(vcDomainName, this.loginBean));
        vcDomainBean.setEnclosureName(BPVXML.checkValue(enclName, this.loginBean));
        vcDomainBean.setSwitchSlotNumber(switchSlotNumber);
        vcDomainBean.setRackName(BPVXML.checkValue(rackName, this.loginBean));
        LOGGER.fine("Domain IP " + vcDomainBean.getVcDomainIP() + ", Name: " + vcDomainBean.getVcDomainName() + ", Cfg Status: " + vcDomainBean.getCfgStatus() + ", Running Status: " + vcDomainBean.getRunningStatus() + ", Enclosure Name = " + vcDomainBean.getEnclosureName() + ", Switch Slot " + switchSlotNumber + ", Rack name : " + vcDomainBean.getRackName());
        LOGGER.exit("VCDomain.getVCDomainData(" + this.vcdNode + ")");
        return vcDomainBean;
    }
}

