/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.soap.oa;

import com.hp.mx.utilities.DebugSubsystem;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;

public class UploadConfigFile {
    InputStream in;
    OutputStream out;
    HttpsURLConnection httpsCon;
    String boundary;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(UploadConfigFile.class);

    public String sendRequest(URL url, String oaSessionKey, String fileType, String fileName) throws Exception {
        int c;
        LOGGER.enter("********UploadConfigFile.sendRequest(" + url + ", " + oaSessionKey + ", " + fileType + "," + fileName + ")**********");
        this.setBoundaryValue();
        this.httpsCon = (HttpsURLConnection)url.openConnection();
        this.httpsCon.setConnectTimeout(360000);
        this.httpsCon.setDoOutput(true);
        this.httpsCon.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.out = this.httpsCon.getOutputStream();
        this.writeStringParameter("oaSessionKey", oaSessionKey);
        this.writeStringParameter("fileType", fileType);
        this.writeFileParameter("file", fileName);
        this.writeBoundary();
        this.out.write("\r\n--".getBytes());
        this.out.close();
        InputStream in = this.httpsCon.getInputStream();
        StringBuffer configResponse = new StringBuffer("");
        while ((c = in.read()) != -1) {
            configResponse.append((char)c);
        }
        in.close();
        LOGGER.fine("********Response is " + configResponse);
        LOGGER.exit("********UploadConfigFile.sendRequest(" + url + ", " + oaSessionKey + ", " + fileType + "," + fileName + ")**********");
        return configResponse.toString();
    }

    public void writeStringParameter(String name, String value) throws Exception {
        LOGGER.enter("********UploadConfigFile.writeStringParameter(" + name + ", " + value + ")**********");
        this.writeBoundary();
        String strHeaderProperty = this.getContentDispositionProperty(name, value);
        LOGGER.fine("********strHeaderProperty is " + strHeaderProperty);
        this.out.write(strHeaderProperty.getBytes());
        LOGGER.exit("********UploadConfigFile.writeStringParameter(" + name + ", " + value + ")**********");
    }

    public void setBoundaryValue() {
        this.boundary = "---------------------------" + this.getRandomString() + this.getRandomString() + this.getRandomString();
        LOGGER.fine("********UploadConfigFile.setBoundaryValue() boundary is " + this.boundary);
    }

    public String getRandomString() {
        Random random = new Random();
        return Long.toString(random.nextLong(), 36);
    }

    public void writeFileParameter(String paramName, String fileName) throws Exception {
        LOGGER.enter("********UploadConfigFile.writeFileParameter( " + paramName + ", " + fileName + ")********");
        this.writeBoundary();
        String strName = "\r\nContent-Disposition: form-data; name=\"" + paramName + '\"' + "; filename=\"" + fileName + '\"' + "\r\nContent-Type: ";
        String type = HttpsURLConnection.guessContentTypeFromName(fileName);
        if (type == null) {
            type = "application/octet-stream";
        }
        strName = strName + type + "\r\n\r\n";
        LOGGER.fine("UploadConfigFile.writeFileParameter strName is " + strName);
        this.out.write(strName.getBytes());
        this.writeFileContent(fileName);
        this.out.write("\r\n".getBytes());
        LOGGER.exit("********UploadConfigFile.writeFileParameter( " + paramName + ", " + fileName + ")********");
    }

    public void writeBoundary() throws Exception {
        LOGGER.enter("********UploadConfigFile.writeBoundary()********");
        String tmp = "--" + this.boundary;
        this.out.write(tmp.getBytes());
        LOGGER.exit("********UploadConfigFile.writeBoundary()********");
    }

    public String getContentDispositionProperty(String name, String value) {
        LOGGER.enter("********UploadConfigFile.getContentDispositionProperty( " + name + ", " + value + ")********");
        String tmpStr = "\r\nContent-Disposition: form-data; name=\"" + name + '\"' + "\r\n\r\n" + value + "\r\n";
        LOGGER.exit("********UploadConfigFile.getContentDispositionProperty( " + name + ", " + value + ")********");
        return tmpStr;
    }

    public void writeFileContent(String file) throws Exception {
        int c;
        LOGGER.enter("********UploadConfigFile.writeFileContent( " + file + ")******");
        FileInputStream fin = new FileInputStream(file);
        StringBuffer fileContent = new StringBuffer("");
        while ((c = fin.read()) != -1) {
            fileContent.append((char)c);
        }
        this.out.write(fileContent.toString().getBytes());
        this.out.flush();
        LOGGER.exit("********UploadConfigFile.writeFileContent( " + file + ")******");
    }
}

