/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.eclass.EClassAssociationHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugSubsystem;

public class DesktopAssociationDataHandler
extends EClassAssociationHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DesktopAssociationDataHandler.class);

    public DesktopAssociationDataHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode deviceMxNode, DeviceIdentificationData idInfo) {
        LOGGER.enter("DesktopAssociationDataHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
        LOGGER.fine("Node Name:" + deviceMxNode.getNameString());
        if (!deviceMxNode.getDeviceType().equals("Desktop")) {
            LOGGER.fine("Not a desktop,Exit!");
            this.cleanUpAssociationData(deviceMxNode);
            LOGGER.exit("DesktopAssociationDataHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
            return;
        }
        if (!GlobalSettings.getProperty((String)"wbemEnableState", (String)"enabled").equals("enabled")) {
            LOGGER.fine("WBEM Protocol disabled,Exit!");
            LOGGER.exit("DesktopAssociationDataHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
            return;
        }
        String workingAddress = deviceMxNode.getWorkingAddress();
        if (workingAddress == null) {
            LOGGER.fine("Working Address is null for device,Exit!");
            LOGGER.exit("DesktopAssociationDataHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
            return;
        }
        this.startAssociations(deviceMxNode);
        LOGGER.exit("DesktopAssociationDataHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode deviceMxNode) {
        LOGGER.enter("DesktopAssociationDataHandler.loadAssociationDataFromDb(" + deviceMxNode + ")");
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceMxNode.getDeviceKey(), true);
        if (deviceMxNode.getDeviceType().equalsIgnoreCase("Desktop")) {
            LOGGER.fine("Desktop Name:" + deviceMxNode.getNameString());
            LOGGER.fine("Loading node associations from db to cache.");
            na = AssociationHandlerUtil.loadAssocFrmDB(deviceMxNode.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("DesktopAssociationDataHandler.loadAssociationDataFromDb(" + deviceMxNode + ")");
        return na;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode deviceMxNode) {
        LOGGER.enter("DesktopAssociationDataHandler.cleanUpAssociationData(" + deviceMxNode + ")");
        LOGGER.fine("Device Name:" + deviceMxNode.getNameString());
        if (deviceMxNode.getDeviceType().equalsIgnoreCase("Desktop")) {
            super.cleanUpAssociationData(deviceMxNode);
        }
        LOGGER.exit("DesktopAssociationDataHandler.cleanUpAssociationData(" + deviceMxNode + ")");
    }

    protected String getIASerialNumber(MxNode deviceMxNode) {
        LOGGER.enter("DesktopAssociationDataHandler.getIASerialNumber(" + deviceMxNode + ")");
        String iaSerialNumber = null;
        iaSerialNumber = deviceMxNode.getClientAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString());
        LOGGER.fine("iaSerialNumber:" + iaSerialNumber);
        LOGGER.exit("DesktopAssociationDataHandler.getIASerialNumber(" + deviceMxNode + ")");
        return iaSerialNumber;
    }

    protected String getEnclosureATN() {
        return "DesktopToEnclosure";
    }

    protected String getMgmtATN() {
        return "MgmtProcToDesktop_Ia";
    }

    protected String getSource() {
        return "IA";
    }
}

