/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.eclass.EClassAssociationHandler;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;

public class EClassServerHandler
extends EClassAssociationHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EClassServerHandler.class);

    public EClassServerHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode deviceMxNode, DeviceIdentificationData idInfo) {
        LOGGER.enter("EClassServerHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
        LOGGER.fine("device subtype:" + deviceMxNode.getDeviceSubTypes());
        if (!deviceMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            LOGGER.fine("Device not a eclass server, Exit!");
            LOGGER.exit("EClassServerHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
            return;
        }
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(deviceMxNode);
        if (!isSNMPSupported) {
            LOGGER.fine("SNMP check failed, Exit!");
            LOGGER.exit("EClassServerHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
            return;
        }
        this.startAssociations(deviceMxNode);
        LOGGER.exit("EClassServerHandler.getAssociationData(" + deviceMxNode + "," + idInfo + ")");
    }

    protected String getIASerialNumber(MxNode deviceMxNode) {
        String iaSerialNumber;
        block2: {
            LOGGER.enter("EClassServerHandler.getIASerialNumber(" + deviceMxNode + ")");
            iaSerialNumber = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.6[0]");
            String serialNoResponseOID = null;
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findById(0);
                if (vb == null || vb.isError()) break block2;
                serialNoResponseOID = vb.getOid();
                LOGGER.fine("serialNoResponseOID:" + serialNoResponseOID);
                if (!serialNoResponseOID.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.6.")) break;
                if (vb.getValue() != null && vb.getValue().trim().length() > 0) {
                    iaSerialNumber = vb.getValue();
                    LOGGER.fine("theCpqSiSysSerialNo:" + iaSerialNumber);
                }
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(serialNoResponseOID, "0");
            }
            LOGGER.fine("IA Serial Number OID was not correct");
        }
        LOGGER.fine("iaSerialNumber:" + iaSerialNumber);
        LOGGER.exit("EClassServerHandler.getIASerialNumber(" + deviceMxNode + ")");
        return iaSerialNumber;
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode deviceMxNode) {
        LOGGER.enter("EClassServerHandler.loadAssociationDataFromDb(" + deviceMxNode + ")");
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceMxNode.getDeviceKey(), true);
        if (deviceMxNode.getDeviceType().equalsIgnoreCase("Server") && deviceMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            LOGGER.fine("EClass server name:" + deviceMxNode.getNameString());
            LOGGER.fine("Loading node associations from db to cache.");
            na = AssociationHandlerUtil.loadAssocFrmDB(deviceMxNode.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("EClassServerHandler.loadAssociationDataFromDb(" + deviceMxNode + ")");
        return na;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        LOGGER.enter("EClassServerHandler : buildContainerTree");
        LOGGER.fine("node1.name:" + node1.getNameString());
        LOGGER.fine("node1.getDeviceType:" + node1.getDeviceType());
        LOGGER.fine("node2.name:" + node2.getNameString());
        LOGGER.fine("node2.getDeviceType:" + node2.getDeviceType());
        if (node1.getDeviceType().equals("Server") && node2.getDeviceType().equals("Enclosure")) {
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
            myAssoc.setInContainer(true);
            myAssoc.setParent(node2.getDeviceKey());
        }
        LOGGER.exit("EClassServerHandler.buildContainerTree()");
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode deviceMxNode) {
        LOGGER.enter("EClassServerHandler.cleanUpAssociationData(" + deviceMxNode + ")");
        LOGGER.fine("Device Name:" + deviceMxNode.getNameString());
        if (deviceMxNode.getDeviceType().equalsIgnoreCase("Server") && deviceMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            super.cleanUpAssociationData(deviceMxNode);
        }
        LOGGER.exit("EClassServerHandler.cleanUpAssociationData(" + deviceMxNode + ")");
    }

    protected String getEnclosureATN() {
        return "ServerToEnclosure";
    }

    protected String getMgmtATN() {
        return "MgmtProcToServer_Ia";
    }

    protected String getSource() {
        return "IA";
    }
}

