/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.iLO.Blade;
import com.hp.mx.core.tools.datacollection.http.iLO.ILODataManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.IloAssociationDataHandler;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;

public class HurricaneAssociationDataHandler
extends IloAssociationDataHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(HurricaneAssociationDataHandler.class);

    public HurricaneAssociationDataHandler(MxNode node) {
        super(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode node, DeviceIdentificationData idInfo) {
        LOGGER.enter("HurricaneAsociationDataHandler.getAssociatedData(" + node + "," + idInfo + ")");
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            String MODEL_NAME = node.getModel().toLowerCase();
            LOGGER.fine("HurricaneAsociationDataHandler.getAssociatedData MODEL_NAME " + MODEL_NAME);
            if (MODEL_NAME.equals("integrated lights-out (ilo) for integrity and hp9000") || MODEL_NAME.equals("hp single partition server, management processor")) {
                this.performMPAssociation(node);
            } else if (MODEL_NAME.indexOf("bl60p") != -1) {
                this.performBladeAssociation(node);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("****************HurricaneAsociationDataHandler.getAssociatedData UNABLE TO GET RELATIONSHIP LOCK FOR ILO " + node.getWorkingAddress() + " PLEASE DISCOVER THIS ILO AFTER SOMETIME****************");
            LOGGER.error("InterruptedException in HurricaneAsociationDataHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("HurricaneAsociationDataHandler.getAssociationData(" + node + "," + idInfo + ")");
    }

    private void performMPAssociation(MxNode iLOMxNode) {
        LOGGER.enter("HurricaneAsociationDataHandler.performMPAssociation(" + iLOMxNode + ")");
        try {
            ILODataManager iLODataManager = new ILODataManager(iLOMxNode);
            LOGGER.fine("**********SUCCESSFULLY PARSED ILOXML. NOW PERFORMING ASSOCIATIONS FOR ILO " + iLOMxNode.getWorkingAddress() + "**********");
            super.performBladeILOAssociations(iLODataManager, iLOMxNode, "MgmtProcToServer_IPF");
            LOGGER.fine("**********SUCCESSFULLY PERFORMED ASSOCIATIONS FOR ILO " + iLOMxNode.getWorkingAddress() + "**********");
        }
        catch (HandlerException e) {
            LOGGER.error("****************UNABLE TO ASSOCIATE ILO " + iLOMxNode.getWorkingAddress() + " WITH ITS ENCLOSURE. PLEASE ENSURE ILO XML HAS GOT ENCLOSURE UUID, RACK UUID AND RACK TOPOLOGY IN IT****************");
            LOGGER.error("HandlerException in HurricaneAsociationDataHandler.performMPAssociation: " + e);
            LOGGER.exception((Throwable)e);
        }
        catch (ILOException e) {
            LOGGER.error("********ERROR IN PARSING ILO XML. PLEASE ENSURE ILO " + iLOMxNode.getWorkingAddress() + " IS UP AND HAS GOT LATEST FIRMWARE INSTALLED IN IT*********");
            LOGGER.error("ILOException in HurricaneAsociationDataHandler.performMPAssociation: " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("HurricaneAsociationDataHandler.performMPAssociation(" + iLOMxNode + ")");
    }

    private void performBladeAssociation(MxNode serverMxNode) {
        LOGGER.enter("HurricaneAsociationDataHandler.performBladeAssociation(" + serverMxNode + ")");
        MxNode mpMxNode = this.getMPNodeFromClientAttrb(serverMxNode, serverMxNode.getUniqueIdentifier());
        if (mpMxNode != null) {
            this.performMPAssociation(mpMxNode);
        }
        LOGGER.exit("HurricaneAsociationDataHandler.performBladeAssociation(" + serverMxNode + ")");
    }

    private MxNode getMPNodeFromClientAttrb(MxNode serverMxNode, String propertyValue) {
        LOGGER.enter("HurricaneAsociationDataHandler.getMPNodeFromClientAttrb(" + serverMxNode + ")");
        MxNode mpMxNode = null;
        if (propertyValue != null) {
            List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), propertyValue);
            LOGGER.fine("MP devices list size:" + allDevicesWithThisProperty.size());
            if (allDevicesWithThisProperty.size() == 1) {
                for (Integer assocDeviceKey : allDevicesWithThisProperty) {
                    LOGGER.fine("MP device key:" + assocDeviceKey);
                    LOGGER.fine("Server device key:" + serverMxNode.getDeviceKey());
                    try {
                        mpMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(assocDeviceKey.intValue());
                    }
                    catch (MxUndefinedNodeException exec) {
                        LOGGER.error("Either MP is not discovered yet,Unable to obtain MxNode of MP ,Association btwserver and MP failed. via SNMP");
                        LOGGER.exception("Exception:" + (Object)((Object)exec));
                    }
                }
            } else {
                LOGGER.error("Either there are multiple MP's/No MP's with the UUID/Unique identifier of server in the DB,This is incorrect,Associtaion btw server and MP failed");
            }
        }
        LOGGER.exit("HurricaneAsociationDataHandler.getMPNodeFromClientAttrb(" + serverMxNode + ")");
        return mpMxNode;
    }

    void storeAttributes(MxNode iLOMxNode, Blade blade) {
        LOGGER.enter("HurricaneAsociationDataHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
        String serverUUID = blade.getUUID();
        try {
            if (serverUUID != null && serverUUID.length() > 0) {
                LOGGER.fine("HurricaneAsociationDataHandler.storeAttributes Storing Unique identifier of the Server on the ILO MxNode,This will let the association to happen when the server is disovered after ILO." + serverUUID);
                String srvUniqueIdent = UniqueIdentifierUtility.normalizeUniqueID((String)serverUUID, (boolean)true, (boolean)true);
                if (srvUniqueIdent != null && srvUniqueIdent.length() > 0) {
                    iLOMxNode.setClientAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), srvUniqueIdent);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), iLOMxNode, false);
                } else {
                    LOGGER.error("The UUID of Hurricane Server from ILO XML :" + serverUUID + "Unable to obtain a non-swapped unique identifer,Association" + "will not form btw server and ilo with ILO XML.Unique Identifer" + "of server" + srvUniqueIdent);
                }
            } else {
                LOGGER.error("The UUID of Hurricane Server from ILO XML is nulland is a must to form association between ILO and Server from ILO XML. Association failed for Server and MP.");
            }
        }
        catch (MxException me) {
            LOGGER.error("HurricaneAsociationDataHandler.storeAttributes Failed,Association btw Server and ILOwill not happen.");
            LOGGER.exception((Throwable)me);
        }
        LOGGER.exit("HurricaneAsociationDataHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
    }

    public void cleanUpAssociationData(MxNode node) {
        LOGGER.enter("HurricaneAsociationDataHandler.cleanUpAssociationData(" + node + ")");
        String MODEL_NAME = node.getModel().toLowerCase();
        boolean isCleanUpReqd = false;
        if (node.getDeviceType().equalsIgnoreCase("MgmtProc") && (MODEL_NAME.equals("integrated lights-out (ilo) for integrity and hp9000") || MODEL_NAME.equals("hp single partition server, management processor"))) {
            isCleanUpReqd = true;
        } else if (node.getDeviceType().equalsIgnoreCase("Server") && MODEL_NAME.indexOf("bl60p") > 0) {
            isCleanUpReqd = true;
        }
        if (isCleanUpReqd) {
            LOGGER.fine("HurricaneAsociationDataHandler.cleanUpAssociationData Performing Cleaup");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), "MgmtProcToServer_IPF");
            this.myNodeRelationshipManager.deleteDimensionInformation(node.getDeviceKey(), "MgmtProcToServer_IPF");
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(node.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
        }
        LOGGER.exit("HurricaneAsociationDataHandler.cleanUpAssociationData(" + node + ")");
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode node) {
        LOGGER.enter("HurricaneAsociationDataHandler.loadAssociationDataFromDb(" + node + ")");
        String MODEL_NAME = node.getModel().toLowerCase();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(node.getDeviceKey(), true);
        boolean loadRequired = false;
        if (node.getDeviceType().equalsIgnoreCase("MgmtProc") && (MODEL_NAME.equals("integrated lights-out (ilo) for integrity and hp9000") || MODEL_NAME.equals("hp single partition server, management processor"))) {
            loadRequired = true;
        } else if (node.getDeviceType().equalsIgnoreCase("Server") && MODEL_NAME.indexOf("bl60p") > 0) {
            loadRequired = true;
        } else {
            LOGGER.fine("HurricaneAsociationDataHandler. Node is not an Hurricane ILO/Server " + node.getNameString());
            LOGGER.exit("HurricaneAsociationDataHandler.loadAssociationDataFromDb(" + node + ")");
            return na;
        }
        if (loadRequired) {
            na = AssociationHandlerUtil.loadAssocFrmDB(node.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("HurricaneAsociationDataHandler.loadAssociationDataFromDb(" + node + ")");
        return na;
    }
}

