/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class PbleClassAssociationDataHandler
extends SnmpRackMibHandler {
    private static Integer syncenclIa = new Integer(0);
    private MxNode m_EnclosureNode = null;
    private String m_swicthSerialNum = null;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PbleClassAssociationDataHandler.class);

    public PbleClassAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode iaNode, DeviceIdentificationData idInfo) {
        LOGGER.enter("PbleClassAssocaitionDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
        LOGGER.fine("IN The PblEclassASSOCIATIONDATAHANDLER.... - Getting the new associations");
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(iaNode);
        if (!isSNMPSupported) {
            LOGGER.fine("End:PbleClassAssociationDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
            return;
        }
        LOGGER.fine("AssociationHandlerSnmpConstants.ENCLOSURE_SERIAL_NUM_OID_FROM_IA:1.3.6.1.4.1.232.2.2.2.1.0[1]");
        try {
            this.getCommonEnclosureAttributesAndTopologyFromTheMib();
            this.getServerEnclosureAttributesFromTheMib();
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            this.doRackEnclosureDeviceProcessing(iaNode);
            this.doSwitchEnclAssociation(iaNode);
            this.setPowerSupplyDetailsOnEnclNode();
            String theEnclSysSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.2.2.2.1.0[1]", true);
            LOGGER.fine("PBLECLASSASSOCIATIONDATAHANDLER....After getting enclosure serial no. " + theEnclSysSerialNo + " for device " + iaNode.getNameString());
            if (theEnclSysSerialNo != null && theEnclSysSerialNo.trim().length() > 0) {
                this.setAssociationsForTheListOfAssociatedDevices(iaNode, theEnclSysSerialNo);
            }
        }
        catch (Exception e) {
            LOGGER.exit("exception PbleClassAssocaitionDataHandler.getAssociationData:" + e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("end :PbleClassAssocaitionDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        LOGGER.enter("PbleClassAssociatioDataHandler:loadAssociationDataFromDb for device:" + device.getWorkingAddress());
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            LOGGER.fine("In Loading Device Associations for " + device.getWorkingAddress() + "dKey:" + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                String mgmtEnclAssocType = "MgmtProcToEnclosure";
                if (device == null || !device.getDeviceType().equals("MgmtProc")) continue;
                if (associationTypeNumber.equalsIgnoreCase(mgmtEnclAssocType)) {
                    if (deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    continue;
                }
                if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ia") && !associationTypeNumber.equalsIgnoreCase("MgmtProcToDesktop_Ia") || deviceKey2 != deviceDbKey) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
            }
            myResultSet.close();
            myStatement.close();
            myResultSet = null;
            myStatement = null;
            LOGGER.fine("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
        }
        catch (SQLException myException) {
            try {
                LOGGER.exception("Failed to get the vector of devices that have associations " + myException);
            }
            catch (Throwable throwable) {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                throw throwable;
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        LOGGER.exit("end: PbleClassAssociatioDataHandler:loadAssociationDataFromDb for device:" + device.getWorkingAddress());
        return na;
    }

    private void setAssociationsForTheListOfAssociatedDevices(MxNode device, String theSerialNumber) {
        LOGGER.enter("PblaClassAssociationDataHandler:setAssociationsForTheListOfAssociatedDevices for :" + device.getWorkingAddress() + "theSerialNumber:" + theSerialNumber);
        MxNode associatedDevice = null;
        MxNode theEnclosure = null;
        try {
            theEnclosure = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(theSerialNumber);
        }
        catch (MxUndefinedNodeException ex) {
            LOGGER.exception("setAssociationsForTheListOfAssociatedDevices:Enclosure node not found:" + (Object)((Object)ex));
            return;
        }
        List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), theSerialNumber);
        Iterator iter = allDevicesWithThisProperty.iterator();
        LOGGER.fine("Size of the associated devices iteration : " + allDevicesWithThisProperty.size());
        while (iter.hasNext()) {
            Integer associatedDeviceKey = (Integer)iter.next();
            LOGGER.fine(" Adding association for device keys : " + associatedDeviceKey + " and " + device.getDeviceKey());
            try {
                associatedDevice = MxNodeController.getDefaultController().getNodeByKey(associatedDeviceKey.intValue());
                this.makeServerToIaAssociation(associatedDevice, device.getDeviceKey());
                this.getServerBladeAttributesFromTheMib(true, associatedDevice.getSerialNumber());
                this.makeServerToEnclAssociation(associatedDevice, theEnclosure);
                associatedDevice.setEnclosureName(theEnclosure.getNameString());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), associatedDevice, false);
            }
            catch (MxException ex1) {
                LOGGER.exception("setAssociationsForTheListOfAssociatedDevices:server/desktop node not found:" + (Object)((Object)ex1));
            }
        }
        PbleClassAssociationDataHandler.addSubTypeOnEnclNode(theEnclosure);
        LOGGER.exit("end: PblaClassAssociationDataHandler:setAssociationsForTheListOfAssociatedDevices for :" + device.getWorkingAddress() + "theSerialNumber:" + theSerialNumber);
    }

    private void makeServerToIaAssociation(MxNode serverNode, int iADeviceKey) {
        LOGGER.enter("PbleClassAssociationDataHandler:makeServerToIaAssociation " + serverNode.getDeviceKey() + ":" + iADeviceKey);
        NodeAssociations theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverNode.getDeviceKey());
        if (serverNode.getDeviceType().equals("Server")) {
            this.myNodeRelationships.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToServer_Ia", false);
            theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToServer_Ia", false);
        } else if (serverNode.getDeviceType().equals("Desktop")) {
            this.myNodeRelationships.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToDesktop_Ia", false);
            theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToDesktop_Ia", false);
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        LOGGER.exit("end: PbleClassAssociationDataHandler:makeServerToIaAssociation " + serverNode.getDeviceKey() + ":" + iADeviceKey);
    }

    private void makeServerToEnclAssociation(MxNode serverNode, MxNode theEnclosure) {
        LOGGER.enter("PbleClassAssociationDataHandler:makeServerToEnclAssociation:" + serverNode.getDeviceKey() + ":" + theEnclosure.getDeviceKey());
        NodeAssociations theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverNode.getDeviceKey());
        if (theAssociatedDeviceNodeAssociations == null) {
            theAssociatedDeviceNodeAssociations = new NodeAssociations(serverNode.getDeviceKey());
        }
        theAssociatedDeviceNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
        theAssociatedDeviceNodeAssociations.setSlotNumber(this.getBladeSlot());
        theAssociatedDeviceNodeAssociations.setMmHeight(this.getBladeHeight());
        theAssociatedDeviceNodeAssociations.setMmWidth(this.getBladeWidth());
        theAssociatedDeviceNodeAssociations.setMmDepth(this.getBladeDepth());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
        theAssociatedDeviceNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
        theAssociatedDeviceNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
        theAssociatedDeviceNodeAssociations.setInContainer(true);
        if (theEnclosure != null) {
            theAssociatedDeviceNodeAssociations.setParent(theEnclosure.getDeviceKey());
        }
        if (theEnclosure != null && theEnclosure.getDeviceType().equals("Enclosure")) {
            NodeAssociations theEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
            if (theAssociatedDeviceNodeAssociations.getSlotNumber() != -1) {
                if (serverNode.getDeviceType().equals("Server")) {
                    theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), theEnclosure.getDeviceKey(), "ServerToEnclosure", false);
                    theAssociatedDeviceNodeAssociations.setSource("ServerToEnclosure");
                } else if (serverNode.getDeviceType().equals("Desktop")) {
                    theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), theEnclosure.getDeviceKey(), "DesktopToEnclosure", false);
                    theAssociatedDeviceNodeAssociations.setSource("DesktopToEnclosure");
                }
                LOGGER.fine(" Just before adding the device " + serverNode.getDeviceKey() + " to the topology tree of " + theEnclosure.toString());
                this.addDeviceToTopologyTree(theEnclosureNodeAssociations, serverNode.getDeviceKey());
                LOGGER.fine("Finished adding the device to the topology tree");
                theAssociatedDeviceNodeAssociations.setInContainer(true);
                theAssociatedDeviceNodeAssociations.setParent(theEnclosure.getDeviceKey());
                this.myNodeRelationshipManager.update(theEnclosureNodeAssociations);
            }
        }
        this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
        LOGGER.exit("end: PbleClassAssociationDataHandler:makeServerToEnclAssociation:" + serverNode.getDeviceKey() + ":" + theEnclosure.getDeviceKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubTypeOnEnclNode(MxNode theEnclosure) {
        LOGGER.enter("PbleClassAssociationDataHandler.addSubTypeOnEnclNode(" + theEnclosure + ")");
        if (theEnclosure != null) {
            LOGGER.fine("Enclosure Name:" + theEnclosure.getNameString());
            List nodeSubTypeList = theEnclosure.getDeviceSubTypes();
            LOGGER.fine("Current subType list:" + nodeSubTypeList);
            boolean bModify = false;
            if (!nodeSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                bModify = true;
            }
            Integer n = syncenclIa;
            synchronized (n) {
                if (bModify) {
                    theEnclosure.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                    theEnclosure.setModel("Server Enclosure");
                    try {
                        LOGGER.fine("Model:Server Enclosure");
                        LOGGER.fine("SubType added:" + NodeSubTypeMapper.ECLASS_SUBTYPE);
                        LOGGER.fine("New subtype list:" + nodeSubTypeList);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclosure, false);
                    }
                    catch (Exception e1) {
                        LOGGER.exception("addSubTypeOnEnclNode:error while updating on enclosure node:" + e1);
                    }
                }
            }
        }
        LOGGER.exit("PbleClassAssociationDataHandler.addSubTypeOnEnclNode(" + theEnclosure + ")");
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        LOGGER.enter("PbleClassAssociationDataHandler:rackEnclosure Device Processing:" + d.getDeviceKey());
        LOGGER.fine("PbleClass : Before storing enclosure information");
        NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(this.getContainerEnclosureInformation(), null, null);
        if (theEnclNodeAssociations != null) {
            int myDeviceKey = d.getDeviceKey();
            int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
            LOGGER.fine("IA DEVICE KEY:" + myDeviceKey);
            LOGGER.fine("enclosure devicekey:" + theEnclDeviceKey);
            try {
                this.m_EnclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            }
            catch (MxUndefinedNodeException e) {
                LOGGER.exception("doRackEnclosureDeviceProcessing:exception:" + (Object)((Object)e));
            }
            LOGGER.fine("The encl device is " + theEnclDeviceKey);
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(theEnclDeviceKey, "MgmtProcToEnclosure");
            this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "MgmtProcToEnclosure", false);
            this.myNodeRelationships.setInContainer(true);
            this.myNodeRelationships.setParent(theEnclDeviceKey);
            theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
            theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
            theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
            theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
            theEnclNodeAssociations.setSource("Enclosure");
            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            try {
                String enclName = this.m_EnclosureNode.getNameString();
                d.setEnclosureName(enclName);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
            }
            catch (Exception e) {
                LOGGER.exception("doRackEnclosureDeviceProcessing:error while updating enclosure name on server:" + e);
            }
        }
        LOGGER.exit("end:PbleClassAssociationDataHandler:rackEnclosure Device Processing:" + d.getDeviceKey());
    }

    private void doSwitchEnclAssociation(MxNode d) {
        LOGGER.enter("PbleClassAssociationDataHandler:doSwitchEnclAssociation for IA :" + d.getWorkingAddress());
        this.getSwitchSerialNumberFromMib(d);
        LOGGER.fine("switch serial Number from IA:" + d.getWorkingAddress() + "is" + this.m_swicthSerialNum);
        NodeAssociations theAssociatedDeviceNodeAssociations = null;
        MxNode theSwitchDev = null;
        if (this.m_swicthSerialNum != null && this.m_swicthSerialNum.trim().length() > 0) {
            try {
                theSwitchDev = AssociationHandlerUtil.getNodeBySerialNumber(this.m_swicthSerialNum.trim());
            }
            catch (Exception e) {
                LOGGER.exception("PbleClassAssociationDataHandler:doSwicthEnclAssociation switch node not found" + e);
            }
            if (theSwitchDev != null && this.m_EnclosureNode != null) {
                NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(this.m_EnclosureNode.getDeviceKey());
                theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theSwitchDev.getDeviceKey());
                LOGGER.fine("asscotiate :" + theSwitchDev.getDeviceKey() + "and" + this.m_EnclosureNode.getDeviceKey());
                theAssociatedDeviceNodeAssociations.setTheAssociation(theSwitchDev.getDeviceKey(), this.m_EnclosureNode.getDeviceKey(), "SwitchToEnclosure", false);
                theAssociatedDeviceNodeAssociations.setSource("SwitchToEnclosure");
                theAssociatedDeviceNodeAssociations.setInContainer(true);
                theAssociatedDeviceNodeAssociations.setParent(this.m_EnclosureNode.getDeviceKey());
                this.addDeviceToTopologyTree(theEnclNodeAssociations, theSwitchDev.getDeviceKey());
                theEnclNodeAssociations.setSource("Enclosure");
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
            }
            LOGGER.fine("PbleClassAssociationDataHandler:doSwitchEnclAssociation :set Switch As client Attribute with Switch_SerNum:" + this.m_swicthSerialNum);
            this.m_EnclosureNode.setClientAttribute("Switch_SerNum", this.m_swicthSerialNum);
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.m_EnclosureNode, false);
            }
            catch (Exception e) {
                LOGGER.exception("doSwitchEnclAssociation:error while updating on enclosure node:" + e);
            }
        }
        LOGGER.exit("end:PbleClassAssociationDataHandler:doSwitchEnclAssociation for IA :" + d.getWorkingAddress());
    }

    private void getSwitchSerialNumberFromMib(MxNode d) {
        String serialNumberFromMib;
        block1: {
            LOGGER.enter("PbleClassAssociationDataHandler:getSwitchSerialNumberFromMib from IA:" + d.getNameString());
            String swserialNumberOID = null;
            serialNumberFromMib = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.7[0]");
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findById(0);
                if (vb == null || vb.isError()) break block1;
                swserialNumberOID = vb.getOid();
                if (!swserialNumberOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.7.")) break;
                LOGGER.fine("The Switch serial Number OID : " + swserialNumberOID);
                serialNumberFromMib = vb.getValue();
                LOGGER.fine(" switch serial Number :" + serialNumberFromMib);
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(swserialNumberOID, "0");
            }
            LOGGER.fine("switch serial number oid was not correct" + swserialNumberOID);
        }
        this.m_swicthSerialNum = serialNumberFromMib;
        LOGGER.exit("end:PbleClassAssociationDataHandler:getSwitchSerialNumberFromMib from IA:" + d.getNameString());
    }

    private void setPowerSupplyDetailsOnEnclNode() {
        boolean rightPowerSupPresent;
        boolean leftPowerSupPresent;
        block6: {
            LOGGER.enter("PbleClassAssociationDataHandler:setPowerSupplyDetailsOnEnclNode");
            String leftPowerSupplyIndex = "00000001";
            String rightPowerSupplyInder = "00000002";
            leftPowerSupPresent = false;
            rightPowerSupPresent = false;
            String powerSupplyIndexOID = null;
            String powerSupplySerialNumOID = null;
            String powerSupplyIndex = null;
            String powerSupplySerialNum = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.5.1.1.1.3[0],1.3.6.1.4.1.232.22.2.5.1.1.1.5[1]");
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind powerSupIndexVB = curResp.findById(0);
                if (powerSupIndexVB == null || powerSupIndexVB.isError()) break block6;
                powerSupplyIndexOID = powerSupIndexVB.getOid();
                LOGGER.fine("powerSupplyIndexOID" + powerSupplyIndexOID);
                SnmpResponseVarBind powerSupSerialNumVB = curResp.findById(1);
                if (powerSupSerialNumVB == null || powerSupSerialNumVB.isError()) break block6;
                powerSupplySerialNumOID = powerSupSerialNumVB.getOid();
                LOGGER.fine("powerSupplySerialNumOID:" + powerSupplySerialNumOID);
                if (!powerSupplyIndexOID.startsWith("1.3.6.1.4.1.232.22.2.5.1.1.1.3.")) break;
                powerSupplyIndex = powerSupIndexVB.getValue();
                powerSupplySerialNum = powerSupSerialNumVB.getValue();
                LOGGER.fine("powerSupplyIndex:" + powerSupplyIndex);
                LOGGER.fine("powerSupplySerialNum:" + powerSupplySerialNum);
                if (powerSupplyIndex.equals(leftPowerSupplyIndex) && powerSupplySerialNum != null && powerSupplySerialNum.trim().length() > 0) {
                    leftPowerSupPresent = true;
                    LOGGER.fine("leftPowerSupPresent:" + leftPowerSupPresent);
                } else if (powerSupplyIndex.equals(rightPowerSupplyInder) && powerSupplySerialNum != null && powerSupplySerialNum.trim().length() > 0) {
                    rightPowerSupPresent = true;
                    LOGGER.fine("rightPowerSupPresent:" + rightPowerSupPresent);
                }
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyIndexOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplySerialNumOID, "1");
            }
            LOGGER.fine("PowerSupply index OID was not correct" + powerSupplyIndexOID);
        }
        LOGGER.fine("power supply attributes on encl node as");
        LOGGER.fine("leftPowerSupply" + String.valueOf(leftPowerSupPresent));
        LOGGER.fine("rightPowerSupply:" + String.valueOf(rightPowerSupPresent));
        this.m_EnclosureNode.setClientAttribute("leftPowerSupply", String.valueOf(leftPowerSupPresent));
        this.m_EnclosureNode.setClientAttribute("rightPowerSupply", String.valueOf(rightPowerSupPresent));
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.m_EnclosureNode, false);
        }
        catch (Exception e) {
            LOGGER.exception("setPowerSupplyDetailsOnEnclNode:error while updating on enclosure node:" + e);
        }
        LOGGER.exit("end:PbleClassAssociationDataHandler:setPowerSupplyDetailsOnEnclNode");
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToDesktop_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToEnclosure");
        this.myNodeRelationshipManager.resetDeviceAssociations(d.getDeviceKey());
    }
}

