/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxInvalidNodeNameException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.OverlordSwitchHandler;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCDomainAssociationHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(VCDomainAssociationHandler.class);
    private MxNode switchNode;
    private MxNode vcDomainNode;
    private MxNode enclosureNode;
    private String masterIp;

    public VCDomainAssociationHandler() {
        LOGGER.fine("inside VCDomainAssocationHandler()");
    }

    public VCDomainAssociationHandler(String switchIp, MxNode enclosureNode) {
        LOGGER.fine("inside VCDomainAssocationHandler(" + switchIp + "," + enclosureNode + " )");
        this.switchNode = VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(switchIp);
        this.enclosureNode = enclosureNode;
        this.masterIp = switchIp;
    }

    public VCDomainAssociationHandler(MxNode switchNode, MxNode enclosureNode) {
        super(switchNode);
        this.switchNode = switchNode;
        this.enclosureNode = enclosureNode;
        LOGGER.fine("inside VCDomainAssocationHandler(" + switchNode + "," + enclosureNode + ")");
    }

    public VCDomainAssociationHandler(MxNode switchNode, String ipAddr, MxNode enclosureNode) {
        super(switchNode);
        this.switchNode = VCDomainAssociationHandler.getNodeWithSNMPProperties(switchNode, ipAddr);
        this.enclosureNode = enclosureNode;
        this.masterIp = ipAddr;
        LOGGER.fine("inside VCDomainAssocationHandler(" + switchNode + "," + enclosureNode + ")");
    }

    public VCDomainAssociationHandler(MxNode switchNode) {
        super(switchNode);
        this.switchNode = switchNode;
        LOGGER.fine("inside VCDomainAssocationHandler(" + switchNode + ")");
    }

    @Override
    public NodeAssociations loadAssociationDataFromDb(MxNode node) {
        LOGGER.enter("VCDomainAssociationHandler.loadAssociationDataFromDb(" + node + ")");
        LOGGER.fine("Node name:" + node.getNameString());
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(node.getDeviceKey(), true);
        if (node.getDeviceType().equalsIgnoreCase("VCDomain")) {
            na = AssociationHandlerUtil.loadAssocFrmDB(node.getDeviceKey(), this.myNodeRelationshipManager);
            LOGGER.fine("Associations size of VC cache:" + na.getAssociations().size());
        }
        LOGGER.exit("VCDomainAssociationHandler.loadAssociationDataFromDb(" + node + ")");
        return na;
    }

    @Override
    public void cleanUpAssociationData(MxNode vcdNode) {
        LOGGER.enter("VCDomainAssociationHandler.cleanUpAssociationData(" + vcdNode + ")");
        LOGGER.fine("cleanUpAssociationData.WORKING_ADDRESS " + vcdNode.getWorkingAddress());
        try {
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(vcdNode.getDeviceKey(), "EnclosureToVCDomain");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(vcdNode.getDeviceKey(), "SwitchToVCDomain");
            this.myNodeRelationshipManager.resetDeviceAssociations(vcdNode.getDeviceKey());
        }
        catch (Exception e) {
            LOGGER.error("VCDomainAssociationHandler.cleanUpAssociationData failed : Exception " + e.toString());
        }
        LOGGER.exit("VCDomainAssociationHandler.cleanUpAssociationData(" + vcdNode + ")");
    }

    public static MxNode getAssociatedNode(MxNode deviceNode, String asscType) {
        LOGGER.enter("VCDomainAssociationHandler.getAssociatedNode " + deviceNode.getNameString() + " and " + asscType);
        if (deviceNode == null) {
            return null;
        }
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector keyVector = nodeAssociationsManager.getAssociatedDevicesUsingATNs(deviceNode.getDeviceKey(), asscType);
            int key = 0;
            for (int i = 0; i < keyVector.size(); ++i) {
                Integer vectKey = (Integer)keyVector.elementAt(i);
                key = vectKey;
                LOGGER.fine("Associated key is " + key);
            }
            if (key == 0) {
                return null;
            }
            MxNode node = MxNodeController.getDefaultControllerNoEx().getNodeByKey(key);
            LOGGER.fine("Associated device is " + node.getDeviceKey() + " name is " + node.getNameString());
            LOGGER.exit("getAssociatedNode " + deviceNode.getNameString() + " and " + asscType);
            return node;
        }
        catch (MxUndefinedNodeException ex) {
            LOGGER.panic("associated node not found" + ex.toString());
        }
        catch (NodeAssociationsPersistenceException ex) {
            LOGGER.panic("error getting the associated node " + ex.toString());
        }
        LOGGER.exit("getAssociatedNode " + deviceNode.getNameString() + " and " + asscType);
        return null;
    }

    private void setVCMAssociations() {
        LOGGER.enter("VCDomainAssociationHandler.setVCMAssociations()");
        int switchDevKey = this.switchNode.getDeviceKey();
        int vcDomainKey = this.vcDomainNode.getDeviceKey();
        this.myNodeRelationships = this.myNodeRelationshipManager.getNodeAssociations(vcDomainKey);
        this.myNodeRelationships.setTheAssociation(switchDevKey, vcDomainKey, "SwitchToVCDomain", false);
        if (this.enclosureNode != null) {
            LOGGER.fine("got enclosure for switch " + this.switchNode.getNameString() + " - " + this.enclosureNode.getNameString());
            this.myNodeRelationships.setTheAssociation(this.enclosureNode.getDeviceKey(), vcDomainKey, "EnclosureToVCDomain", false);
            LOGGER.fine("done association with the enclosure");
        } else {
            LOGGER.fine("No associated enclosures found for " + this.switchNode.getNameString());
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        AssociationHandlerUtil.loadAssocFrmDB(this.switchNode.getDeviceKey(), this.myNodeRelationshipManager);
        LOGGER.exit("VCDomainAssociationHandler.setVCMAssociations()");
    }

    private boolean isVCSwitchPrimary() {
        LOGGER.enter("VCDomainAssociationHandler.isVCSwitchPrimary()");
        String switchRunningDesc = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.6.1.1.15.1[0]", this.switchNode);
        int runMode = -1;
        try {
            runMode = Integer.parseInt(switchRunningDesc);
        }
        catch (Exception e) {
            LOGGER.fine("switch is not primary - number not returned");
            return false;
        }
        if (runMode == 2) {
            LOGGER.fine("switch " + this.switchNode.getNameString() + " is primary (" + runMode + ")");
            return true;
        }
        LOGGER.fine("switch " + this.switchNode.getNameString() + " is not primary (" + runMode + ")");
        LOGGER.exit("VCDomainAssociationHandler.isVCSwitchPrimary()");
        return false;
    }

    private void createNewVCDomainNode(String name) {
        LOGGER.enter("createNewVCDomainNode(" + name + ")");
        String vcdUUID = this.getAssociatedEnclosureUUID();
        LOGGER.fine("enclosure uuid " + vcdUUID);
        if (vcdUUID == null) {
            LOGGER.fine("not associated with the enclosure");
            LOGGER.exit(" VCDomainAssociationHandler.createNewVCDomainNode()");
            return;
        }
        this.vcDomainNode = new MxNode();
        try {
            this.setVCDomainCommonDetails(name);
            this.vcDomainNode.setModel("HP Virtual Connect Domain");
            this.vcDomainNode.setDeviceType("VCDomain");
            ArrayList<String> deviceSubTypesList = new ArrayList<String>();
            deviceSubTypesList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
            this.vcDomainNode.setDeviceSubTypes(deviceSubTypesList);
            this.vcDomainNode.setSnoozeTime(-2);
            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), this.vcDomainNode);
            this.setVCMAssociations();
        }
        catch (Exception e) {
            LOGGER.panic("error creating the node : " + e.toString());
        }
        LOGGER.exit("createNewVCDomainNode(" + name + ")");
    }

    private void updateVCDomainNode(String vcdNewName) throws Exception {
        LOGGER.enter("VCDomainAssociationHandler.updateVCDomainNode(" + vcdNewName + ")");
        this.setVCDomainCommonDetails(vcdNewName);
        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.vcDomainNode, false);
        LOGGER.exit("VCDomainAssociationHandler.updateVCDomainNode(" + vcdNewName + ")");
    }

    public void createNewNodeOrUpdateNode() {
        LOGGER.enter("VCDomainAssociationHandler.createNewNodeOrUpdateNode()");
        if (this.switchNode == null) {
            LOGGER.fine("Switch node is null. vc domain will not be created");
            return;
        }
        this.myNodeRelationships = this.myNodeRelationshipManager.getNodeAssociations(this.switchNode.getDeviceKey());
        if (!this.isVCSwitchPrimary()) {
            this.removeVCDomainAssociationWithBackupSwitch(this.switchNode);
            LOGGER.exit("VCDomainAssociationHandler.createNewNodeOrUpdateNode()");
            return;
        }
        try {
            String vcdNewName = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.6.1.1.2.1[0]", this.switchNode);
            if (this.updateIfVCDomainNodeExists(vcdNewName)) {
                LOGGER.exit("vc domain node already exists. Updated existing node");
                return;
            }
            this.createNewVCDomainNode(vcdNewName);
        }
        catch (Exception ex) {
            LOGGER.panic("Error adding/updating the vcdomain node " + ex.toString());
            ex.printStackTrace(System.out);
        }
        LOGGER.exit("VCDomainAssociationHandler.createNewNodeOrUpdateNode()");
    }

    private boolean updateIfVCDomainNodeExists(String vcdNewName) throws Exception {
        LOGGER.enter(" VCDomainAssociationHandler.updateIfVCDomainNodeExists(" + vcdNewName + ")");
        MxNode tmpVCDomainNode = this.getVCDomainNodeIfExists();
        if (tmpVCDomainNode != null) {
            LOGGER.fine("vcd node already exists. Domain Name : " + tmpVCDomainNode.getNameString());
            String vcdOldName = tmpVCDomainNode.getNameString();
            LOGGER.fine("old name is " + vcdOldName + ", new name is " + vcdNewName);
            this.vcDomainNode = tmpVCDomainNode;
            if (vcdOldName != null && vcdNewName != null && !vcdOldName.equals(vcdNewName)) {
                LOGGER.fine("Domain name is changed on the VCM. VCD node will be updated with new name");
                this.updateVCDomainNode(vcdNewName);
            }
            this.updateIpAddressClientAttributeOnVCDomainNode();
            this.setVCMAssociations();
            Vector<MxNode> associatedSwitchNodesList = this.getAssociatedNodesList(tmpVCDomainNode, "SwitchToVCDomain");
            this.removeVCDomainAssociationWithBackupSwitch(associatedSwitchNodesList);
            LOGGER.fine("VCDomainAssociationHandler.refreshing cache for " + this.switchNode.getNameString());
            OverlordSwitchHandler switchHandler = new OverlordSwitchHandler(this.switchNode);
            switchHandler.loadAssociationDataFromDb(this.switchNode);
            LOGGER.exit(" VCDomainAssociationHandler.updateIfVCDomainNodeExists(" + vcdNewName + ")");
            return true;
        }
        LOGGER.exit(" VCDomainAssociationHandler.updateIfVCDomainNodeExists(" + vcdNewName + ")");
        return false;
    }

    private String getAssociatedEnclosureUUID() {
        LOGGER.enter(" VCDomainAssociationHandler.getAssociatedEnclosureUUID()");
        return this.enclosureNode.getAgentUUID();
    }

    private void removeVCDomainAssociationWithBackupSwitch(MxNode switchNode) {
        LOGGER.enter("VCDomainAssociationHandler.removeVCDomainAssociationWithBackupSwitch( " + switchNode.getNameString() + ")");
        LOGGER.fine("vc switch is backup. VCM association will be removed. Key is " + switchNode.getDeviceKey());
        try {
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(switchNode.getDeviceKey(), "SwitchToVCDomain");
            LOGGER.fine("Cleaning cache of VC domain and backup switch.");
            this.myNodeRelationshipManager.resetDeviceAssociations(switchNode.getDeviceKey());
            this.myNodeRelationshipManager.resetDeviceAssociations(this.vcDomainNode.getDeviceKey());
            LOGGER.fine("Loading VC domain cache.");
            this.loadAssociationDataFromDb(this.vcDomainNode);
        }
        catch (Exception e) {
            LOGGER.panic("Error removing the association " + e.toString());
        }
        LOGGER.exit("VCDomainAssociationHandler.removeVCDomainAssociationWithBackupSwitch( " + switchNode.getNameString() + ")");
    }

    private void removeVCDomainAssociationWithBackupSwitch(Vector<MxNode> switchNodesList) {
        LOGGER.enter("VCDomainAssociationHandler.removeVCDomainAssociationWithBackupSwitch()");
        for (int i = 0; i < switchNodesList.size(); ++i) {
            MxNode tmpSwitchNode = switchNodesList.elementAt(i);
            if (tmpSwitchNode == null) continue;
            LOGGER.fine("vcd node is already associated with the " + tmpSwitchNode.getNameString());
            if (tmpSwitchNode.getDeviceKey() == this.switchNode.getDeviceKey()) continue;
            LOGGER.fine("Current switch " + this.switchNode.getNameString() + "But the vc domain is already assocaited with the " + tmpSwitchNode.getNameString());
            this.removeVCDomainAssociationWithBackupSwitch(tmpSwitchNode);
        }
        LOGGER.exit("VCDomainAssociationHandler.removeVCDomainAssociationWithBackupSwitch()");
    }

    private MxNode getVCDomainNodeIfExists() {
        LOGGER.enter(" VCDomainAssociationHandler.getVCDomainNodeIfExists()");
        String vcdUUID = this.getAssociatedEnclosureUUID();
        LOGGER.fine("enclosure uuid " + vcdUUID);
        if (vcdUUID == null) {
            LOGGER.fine("enclosure uuid not found");
            LOGGER.exit(" VCDomainAssociationHandler.getVCDomainNodeIfExists()");
            return null;
        }
        MxNode tmpVCDomainNode = this.getNodeByClientAttribute("vcDomainAgentUUID", vcdUUID);
        if (tmpVCDomainNode != null) {
            LOGGER.fine("VCDomain with agent uuid " + vcdUUID + "exists. Name is " + tmpVCDomainNode.getNameString());
            return tmpVCDomainNode;
        }
        LOGGER.exit(" VCDomainAssociationHandler.getVCDomainNodeIfExists()");
        return null;
    }

    private MxNode getNodeByClientAttribute(String attrName, String value) {
        LOGGER.enter(" VCDomainAssociationHandler.getNodeByClientAttribute(" + attrName + ", " + value + ")");
        try {
            List vcdNodesList = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(attrName, value);
            if (vcdNodesList != null && vcdNodesList.size() == 1) {
                LOGGER.fine("vcd nodes list size is " + vcdNodesList.size());
                Integer key = (Integer)vcdNodesList.get(0);
                int deviceKey = key;
                LOGGER.fine("Domain device key is " + deviceKey);
                MxNode tmpVCDomainNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
                return tmpVCDomainNode;
            }
            LOGGER.exit(" VCDomainAssociationHandler.getNodeByClientAttribute(" + attrName + ", " + value);
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.panic("Could not retrieve node with client attribute " + attrName + " with value " + value);
        }
        LOGGER.exit(" VCDomainAssociationHandler.getNodeByClientAttribute(" + attrName + ", " + value);
        return null;
    }

    private void setVCDomainCommonDetails(String name) throws MxInvalidNodeNameException {
        String switchIP;
        LOGGER.enter("VCDomainAssociationHandler.setVCDomainCommomDetails(" + name + ")");
        String uniqueId = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.6.1.1.14.1[0]", this.switchNode);
        String enclUUID = this.getAssociatedEnclosureUUID();
        if (enclUUID == null) {
            LOGGER.fine("Switch is not associated with the enclosure. Cannot retrieve enclosure uuid. No vc node will be created");
            return;
        }
        LOGGER.fine("vc domain name is " + name + ", unique id is " + uniqueId + ", agent uuid is " + enclUUID);
        if (name != null && name.trim().length() == 0 && enclUUID != null) {
            name = "VCD_" + enclUUID;
        }
        if (uniqueId != null && uniqueId.trim().length() == 0) {
            uniqueId = "VCD_" + this.switchNode.getNameString();
        }
        if (this.doesNodeExistByName(name)) {
            LOGGER.fine("Duplicate node exists with the name " + name + ". Appending domain id with the vc domain nmae");
            name = name + "_" + uniqueId;
            LOGGER.fine("VC Domain device name " + name);
        }
        this.vcDomainNode.setDeviceName(name);
        this.vcDomainNode.setClientAttribute("vcDomainId", uniqueId);
        if (enclUUID != null && enclUUID.trim().length() > 0) {
            this.vcDomainNode.setClientAttribute("vcDomainAgentUUID", enclUUID);
        }
        if ((switchIP = this.switchNode.getWorkingAddress()) != null) {
            LOGGER.fine("switch IP is " + switchIP);
            this.vcDomainNode.setClientAttribute("vcDomainIP", switchIP);
        } else if (this.masterIp != null && this.masterIp.length() != 0) {
            this.vcDomainNode.setClientAttribute("vcDomainIP", this.masterIp);
        }
        LOGGER.fine("master ip is " + this.masterIp);
        LOGGER.exit("VCDomainAssociationHandler.setVCDomainCommomDetails(" + name + ")");
    }

    private Vector<MxNode> getAssociatedNodesList(MxNode deviceNode, String asscType) {
        LOGGER.fine("getAssociatedNodesList " + deviceNode.getNameString() + " and " + asscType);
        Vector<MxNode> nodesList = new Vector<MxNode>();
        if (deviceNode == null) {
            return null;
        }
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector keyVector = nodeAssociationsManager.getAssociatedDevicesUsingATNs(deviceNode.getDeviceKey(), asscType);
            int key = 0;
            for (int i = 0; i < keyVector.size(); ++i) {
                Integer vectKey = (Integer)keyVector.elementAt(i);
                key = vectKey;
                MxNode node = MxNodeController.getDefaultControllerNoEx().getNodeByKey(key);
                nodesList.add(node);
                LOGGER.fine("Associated key is " + key);
            }
        }
        catch (MxUndefinedNodeException ex) {
            LOGGER.panic("associated node not found" + ex.toString());
        }
        catch (NodeAssociationsPersistenceException ex) {
            LOGGER.panic("error getting the associated node " + ex.toString());
        }
        LOGGER.exit("getAssociatedNode " + deviceNode.getNameString() + " and " + asscType);
        return nodesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateToEnclosure() {
        LOGGER.enter("VCDomainAssociationHandler.associateToEnclosure()");
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            String strLocation = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.2.1.1.6.0[0]", this.switchNode);
            LOGGER.fine("Got Location : " + strLocation + " from " + this.switchNode.getNameString());
            String[] arrLoc = strLocation.split(":");
            if (arrLoc.length != 3 || arrLoc[1].length() == 0) {
                LOGGER.fine("Invlid enclosure name from syslocation on " + this.switchNode.getNameString());
                return;
            }
            MxNodeController nodeCtrl = MxNodeController.getDefaultControllerNoEx();
            MxNode enclNode = nodeCtrl.getNodeByNodeOrHostName(arrLoc[1], false);
            LOGGER.fine("Got enclosure : " + enclNode.getNameString());
            NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
            Vector swsInEncl = nam.getAssociatedDevicesUsingATNs(enclNode.getDeviceKey(), "SwitchToEnclosure");
            Iterator iter = swsInEncl.iterator();
            while (iter.hasNext()) {
                int swDevKey = (Integer)iter.next();
                MxNode currSw = nodeCtrl.getNodeByKey(swDevKey);
                LOGGER.fine("Checking switch : " + currSw.getNameString());
                if (!currSw.getSerialNumber().equals(this.switchNode.getSerialNumber()) || !currSw.getNameString().endsWith("-REAR")) continue;
                LOGGER.fine("Removing logical Node  " + currSw.getNameString());
                nodeCtrl.deleteNode((MxTransaction)new MxCoreTransaction(), currSw);
                LOGGER.fine("trying to associate  " + this.switchNode.getNameString() + " to " + enclNode.getNameString());
                this.makeSwitchToEnclAssociation(this.switchNode, enclNode.getDeviceKey());
                LOGGER.fine("Associated  " + this.switchNode.getNameString() + " to Enclosure " + enclNode.getNameString());
                break;
            }
        }
        catch (MxException mxe) {
            LOGGER.exception(mxe.getMessage());
        }
        finally {
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("VCDomainAssociationHandler.associateToEnclosure()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSwitchToEnclAssociation(MxNode switchNode, int theEnclDeviceKey) {
        LOGGER.enter("VCDomainAssociationHandler.makeAssociation(" + switchNode + "," + theEnclDeviceKey + ")");
        LOGGER.fine("switchNode Device Key:" + switchNode.getDeviceKey());
        LOGGER.fine("enclosure Device Key:" + theEnclDeviceKey);
        MxNode syncObject = switchNode;
        try {
            MxNode enclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
            if (na != null) {
                syncObject = na;
            }
            MxNode mxNode = syncObject;
            synchronized (mxNode) {
                if (na != null) {
                    int myDeviceKey = switchNode.getDeviceKey();
                    this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "SwitchToEnclosure", false);
                    this.addDeviceToTopologyTree(na, myDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    MxNode theRackDevice = VCDomainAssociationHandler.getAssociatedNode(enclosureNode, "EnclosureToRack");
                    this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), enclosureNode.getDeviceKey());
                    LOGGER.fine("OverlordSwitchHandler.makeAssociation: switchToEnclosure association set between :" + myDeviceKey + "and" + theEnclDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                    this.updateDevContainerAndRoleNames(theRackDevice);
                    switchNode.setEnclosureName(enclosureNode.getNameString());
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.exception("VCDomainAssociationHandler.makeAssociation: Exception :" + e);
        }
    }

    public static MxNode getTempSwitchNodeForVCMasterSwitch(String ipAddress) {
        LOGGER.enter("VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(" + ipAddress + ")");
        if (ipAddress == null) {
            LOGGER.fine("ipAddress is null.No switch node will be returned");
            LOGGER.exit("VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(" + ipAddress + ")");
            return null;
        }
        MxNode switchNode = new MxNode();
        VCDomainAssociationHandler.setSNMPProperties(switchNode, ipAddress);
        LOGGER.exit("VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(" + ipAddress + ")");
        return switchNode;
    }

    public MxNode getLogicalNodeForMasterSwitch(OLEnclosure olEnclosure, String vcmIpAddress) {
        LOGGER.enter("VCDomainAssociationHandler.getLogicalNodeForMasterSwitch" + olEnclosure + "," + vcmIpAddress + ")");
        List<OLDevice> olDeviceList = olEnclosure.getSwitchList();
        try {
            for (int i = 0; i < olDeviceList.size(); ++i) {
                OLDevice switchDevice = olDeviceList.get(i);
                if (switchDevice == null || switchDevice.getDeviceMgmtProcIp() == null || !switchDevice.getDeviceMgmtProcIp().equals(vcmIpAddress)) continue;
                String serialNumber = olDeviceList.get(i).getDeviceSerialNumber();
                if (serialNumber == null) {
                    LOGGER.fine("serial number not found");
                    return null;
                }
                LOGGER.fine("serial number of switch is " + serialNumber);
                MxNode logicalSwitchNode = AssociationHandlerUtil.getNodeBySerialNumber(serialNumber);
                if (logicalSwitchNode == null) continue;
                return logicalSwitchNode;
            }
        }
        catch (Exception e) {
            LOGGER.panic("unable to retrieve logical node for master switch " + e.toString());
        }
        LOGGER.fine("logical switch does not exist");
        LOGGER.exit("VCDomainAssociationHandler.getLogicalNodeForMasterSwitch" + olEnclosure + "," + vcmIpAddress + ")");
        return null;
    }

    private static void setSNMPProperties(MxNode switchNode, String ipAddress) {
        LOGGER.enter("VCDomainAssociationHandler.setSNMPProperties (" + switchNode.getNameString() + "," + ipAddress + ")");
        ArrayList<String> ip = new ArrayList<String>();
        ip.add(ipAddress);
        switchNode.setIPAddressList(ip);
        switchNode.setSnmpTimeOut(new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5")).intValue());
        switchNode.setSnmpRetry(new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2")).intValue());
        switchNode.setIcmpTimeOut(new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5")).intValue());
        switchNode.setIcmpRetry(new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2")).intValue());
        int defaultsMask = 255;
        switchNode.setDefaultsMask(true, defaultsMask);
        LOGGER.exit("VCDomainAssociationHandler.setSNMPProperties (" + switchNode.getNameString() + "," + ipAddress + ")");
    }

    private static MxNode getNodeWithSNMPProperties(MxNode switchNode, String ipAddress) {
        LOGGER.enter("VCDomainAssociationHandler.getNodeWithSNMPProperties (" + switchNode.getNameString() + "," + ipAddress + ")");
        MxNode nodeToRet = (MxNode)switchNode.clone();
        ArrayList<String> ip = new ArrayList<String>();
        ip.add(ipAddress);
        nodeToRet.setIPAddressList(ip);
        nodeToRet.setSnmpTimeOut(new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5")).intValue());
        nodeToRet.setSnmpRetry(new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2")).intValue());
        nodeToRet.setIcmpTimeOut(new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5")).intValue());
        nodeToRet.setIcmpRetry(new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2")).intValue());
        int defaultsMask = 255;
        nodeToRet.setDefaultsMask(true, defaultsMask);
        LOGGER.exit("VCDomainAssociationHandler.getNodeWithSNMPProperties (" + switchNode.getNameString() + "," + ipAddress + ")");
        return nodeToRet;
    }

    public void createOrUpdateVCDomainOnOADiscovery(String url, OLEnclosure olEnclosure) {
        LOGGER.enter("VCDomainAssociationHandler.createOrUpdateVCDomainOnOADisovery(" + url + ", " + olEnclosure + ")");
        MxNode switchNode = null;
        if (url != null && url.length() != 0) {
            String switchIp = "";
            try {
                switchIp = new URL(url).getHost();
                if (switchIp != null && olEnclosure != null) {
                    switchNode = this.getSwitchNode(switchIp, olEnclosure);
                }
                if (switchNode != null) {
                    VCDomainAssociationHandler vcDomainHandler = new VCDomainAssociationHandler(switchNode, switchIp, olEnclosure.getDeviceMxNode());
                    vcDomainHandler.createNewNodeOrUpdateNode();
                }
            }
            catch (MalformedURLException e) {
                LOGGER.panic(" VCM url error " + e.toString());
            }
            catch (OAException e) {
                LOGGER.panic("Unable to retrieve enclosure node " + e.toString());
            }
            catch (Exception e) {
                LOGGER.panic("Exception getting the switch node" + e.toString());
            }
        }
        LOGGER.exit("VCDomainAssociationHandler.createOrUpdateVCDomainOnOADisovery(" + url + ", " + olEnclosure + ")");
    }

    MxNode getSwitchNode(String switchIP, OLEnclosure olEnclosure) throws MxObjectPersistenceException, OAException {
        LOGGER.enter("VCDomainAssociationHandler.getSwitchNode(" + switchIP + "," + olEnclosure + ")");
        boolean doesSwitchExist = false;
        try {
            this.switchNode = MxNodeController.getDefaultController().getNodeByIPAddress(switchIP);
            LOGGER.fine("switch node exists " + this.switchNode.getNameString());
            return this.switchNode;
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.panic(" switch node des not exist" + e.toString());
            doesSwitchExist = false;
            LOGGER.fine("doesSwitchExist " + doesSwitchExist);
            if (!doesSwitchExist) {
                LOGGER.fine("getting the temp switch node");
                this.switchNode = this.getLogicalNodeForMasterSwitch(olEnclosure, switchIP);
                if (this.switchNode == null) {
                    this.switchNode = VCDomainAssociationHandler.getTempSwitchNodeForVCMasterSwitch(switchIP);
                }
                return this.switchNode;
            }
            LOGGER.exit("VCDomainAssociationHandler.getSwitchNode(" + switchIP + "," + olEnclosure + ")");
            return null;
        }
    }

    private void updateIpAddressClientAttributeOnVCDomainNode() throws Exception {
        LOGGER.enter("VCDomainAssociationHandler.inside updateIpAddressClientAttributeOnVCDomainNode");
        if (this.switchNode == null) {
            LOGGER.fine("switch node is null. Ip address will not be updated");
            LOGGER.exit("updateIpAddressClientAttributeOnVCDomainNode");
            return;
        }
        String switchIP = this.switchNode.getWorkingAddress();
        if (switchIP != null) {
            LOGGER.fine("switch IP is " + switchIP);
            this.vcDomainNode.setClientAttribute("vcDomainIP", switchIP);
        } else if (this.masterIp != null && this.masterIp.length() != 0) {
            this.vcDomainNode.setClientAttribute("vcDomainIP", this.masterIp);
        }
        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.vcDomainNode, false);
        LOGGER.exit("VCDomainAssociationHandler.updateIpAddressClientAttributeOnVCDomainNode");
    }

    private boolean doesNodeExistByName(String name) {
        LOGGER.enter("VCDomainAssociationHandler.doesNodeExistByName(" + name + ")");
        try {
            if (name != null) {
                MxNode tmpNode = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(name);
                int vcDomainKey = -1;
                if (this.vcDomainNode != null) {
                    LOGGER.fine("checking for the duplicate, the key of existing vc domain node is " + vcDomainKey);
                    vcDomainKey = this.vcDomainNode.getDeviceKey();
                }
                if (tmpNode != null && tmpNode.getDeviceKey() != vcDomainKey) {
                    LOGGER.fine("Duplicate node exists with the name " + name + " . Device key is " + tmpNode.getDeviceKey() + " , type is " + tmpNode.getDeviceType() + ", returning true");
                    LOGGER.exit("VCDomainAssociationHandler.doesNodeExistByName(" + name + ")");
                    return true;
                }
            }
        }
        catch (MxInvalidNodeNameException ex) {
            LOGGER.panic("could not retrieve node with name " + name + ". Error is " + ex.toString());
        }
        catch (MxUndefinedNodeException ex) {
            LOGGER.panic("could not retrieve node with name " + name + ". Erros is " + ex.toString());
        }
        LOGGER.fine("returning false");
        LOGGER.exit("VCDomainAssociationHandler.doesNodeExistByName(" + name + ")");
        return false;
    }
}

