/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations.eclass;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.associations.PbleClassAssociationDataHandler;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;

public abstract class EClassAssociationHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EClassAssociationHandler.class);

    public EClassAssociationHandler(MxNode deviceMxNode) {
        super(deviceMxNode);
    }

    protected abstract String getIASerialNumber(MxNode var1);

    protected abstract String getMgmtATN();

    protected abstract String getEnclosureATN();

    protected abstract String getSource();

    public void doEnclosureDeviceProcessing(PbleClassAssociationDataHandler pecadh, MxNode iaMxNode, MxNode deviceMxNode) {
        LOGGER.enter("EClassAssociationHandler.doEnclosureDeviceProcessing(" + (Object)((Object)pecadh) + "," + iaMxNode + "," + deviceMxNode + ")");
        int enclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(iaMxNode.getDeviceKey(), "MgmtProcToEnclosure");
        LOGGER.fine("Enclosure device key using IA:" + enclDeviceKey);
        if (enclDeviceKey <= 0) {
            LOGGER.fine("Unable to set associations btw device and enclosure,Enclosure doesnt exists.");
            return;
        }
        NodeAssociations enclNodeAssociations = null;
        try {
            enclNodeAssociations = NodeAssociationsManager.getDefaultManager().getNodeAssociations(enclDeviceKey);
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Unable to set associations btw device and enclosure,Exeception:" + (Object)((Object)e));
            return;
        }
        LOGGER.fine("Setting enclosure and device associations");
        int deviceKey = deviceMxNode.getDeviceKey();
        if (this.myNodeRelationships.getSlotNumber() != -1) {
            this.removeOldAssociationsFromThisSlot(deviceKey, enclDeviceKey);
            this.myNodeRelationships.setTheAssociation(deviceKey, enclDeviceKey, this.getEnclosureATN(), false);
            this.addDeviceToTopologyTree(enclNodeAssociations, deviceKey);
            this.myNodeRelationships.setInContainer(true);
            this.myNodeRelationships.setParent(enclDeviceKey);
        }
        LOGGER.fine("Update enclosure node assocaitions object");
        this.updateEnclosureNodeAssociations(enclNodeAssociations, pecadh);
        LOGGER.fine("Set enclosure name on device:" + deviceMxNode.getNameString());
        this.setEnclosureName(deviceMxNode, enclDeviceKey);
        LOGGER.enter("EClassAssociationHandler.doEnclosureDeviceProcessing(" + (Object)((Object)pecadh) + "," + iaMxNode + "," + deviceMxNode + ")");
    }

    private void updateDeviceNodeAssociationsCache(PbleClassAssociationDataHandler pecadh) {
        this.myNodeRelationships.setSlotNumber(pecadh.getBladeSlot());
        this.myNodeRelationships.setMmHeight(pecadh.getBladeHeight());
        this.myNodeRelationships.setMmWidth(pecadh.getBladeWidth());
        this.myNodeRelationships.setMmDepth(pecadh.getBladeDepth());
        this.myNodeRelationships.setNumBladeSlotsUsed(pecadh.getBladeSlotsUsed());
        this.myNodeRelationships.setNumBladeSlotsUsedXDir(pecadh.getBladeSlotsUsedXDir());
        this.myNodeRelationships.setNumBladeSlotsUsedYDir(pecadh.getBladeSlotsUsedYDir());
        this.myNodeRelationships.setSource(this.getSource());
    }

    private void updateEnclosureNodeAssociations(NodeAssociations enclNodeAssociations, PbleClassAssociationDataHandler pecadh) {
        enclNodeAssociations.setMaxNumItems(pecadh.getMaxNumBlades());
        enclNodeAssociations.setMaxNumItemsXDir(pecadh.getMaxNumBladesXDir());
        enclNodeAssociations.setMaxNumItemsYDir(pecadh.getMaxNumBladesYDir());
        enclNodeAssociations.setSource(this.getSource());
        this.myNodeRelationshipManager.update(enclNodeAssociations);
    }

    private void setEnclosureName(MxNode deviceMxNode, int enclDeviceKey) {
        try {
            String enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDeviceKey).getDeviceNameStandard();
            deviceMxNode.setEnclosureName(enclName);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (MxException ex) {
            LOGGER.fine("Error updating enclosure name on device.:" + (Object)((Object)ex));
        }
    }

    public void performDeviceAssociation(MxNode deviceMxNode) {
        LOGGER.enter("EClassAssociationHandler.performDeviceAssociation(" + deviceMxNode + ")");
        String iaSerialNumber = this.getIASerialNumber(deviceMxNode);
        if (iaSerialNumber != null && deviceMxNode.getSerialNumber() != null && iaSerialNumber.trim().length() > 0 && !iaSerialNumber.trim().equalsIgnoreCase(deviceMxNode.getSerialNumber().trim())) {
            int iaDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(iaSerialNumber, 12);
            if (iaDeviceKey > 0) {
                LOGGER.fine("IA discovered associating it with the device[server/desktop].");
                this.myNodeRelationships.setTheAssociation(deviceMxNode.getDeviceKey(), iaDeviceKey, this.getMgmtATN(), false);
                MxNode iaMxNode = null;
                try {
                    iaMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(iaDeviceKey);
                    LOGGER.fine("IA MxNode:" + iaMxNode.getNameString());
                    PbleClassAssociationDataHandler pecadh = new PbleClassAssociationDataHandler(iaMxNode);
                    pecadh.snmpPdh.resetSnmpRequestSettings();
                    pecadh.getRackAttributesFromTheMib();
                    pecadh.getCommonEnclosureAttributesAndTopologyFromTheMib();
                    pecadh.getServerEnclosureAttributesFromTheMib();
                    pecadh.getServerBladeAttributesFromTheMib(true, deviceMxNode.getSerialNumber());
                    LOGGER.fine("Updating device dimention information.");
                    this.updateDeviceNodeAssociationsCache(pecadh);
                    LOGGER.fine("Performing enclosure assocaitions.");
                    this.doEnclosureDeviceProcessing(pecadh, iaMxNode, deviceMxNode);
                }
                catch (MxUndefinedNodeException ex) {
                    LOGGER.exception("IA MxNode does not exits.");
                }
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
            } else {
                LOGGER.fine("IA is not yet discovered,Setting IA Serial number on device, So that when IA is discovered the device[desktop/server]is associated with its IA.");
                deviceMxNode.setClientAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), iaSerialNumber);
            }
        }
        LOGGER.exit("EClassAssociationHandler.performDeviceAssociation(" + deviceMxNode + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAssociations(MxNode deviceMxNode) {
        LOGGER.enter("EClassAssociationHandler.startAssociations(" + deviceMxNode + ")");
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            this.performDeviceAssociation(deviceMxNode);
        }
        catch (InterruptedException e) {
            LOGGER.fine("Unable to perform associations.Exception" + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("EClassAssociationHandler.startAssociations(" + deviceMxNode + ")");
    }

    public void cleanUpAssociationData(MxNode deviceMxNode) {
        LOGGER.enter("EClassAssociationHandler.cleanUpAssociationData(" + deviceMxNode + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(deviceMxNode.getDeviceKey(), this.getMgmtATN());
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(deviceMxNode.getDeviceKey(), this.getEnclosureATN());
        this.myNodeRelationshipManager.deleteDimensionInformation(deviceMxNode.getDeviceKey(), this.getSource());
        int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(deviceMxNode.getDeviceKey(), this.getEnclosureATN());
        this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
        TableModelHandler.notifyViewTopoHasChanged();
        LOGGER.exit("EClassAssociationHandler.cleanUpAssociationData(" + deviceMxNode + ")");
    }
}

