/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.polling;

import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeStatus;
import com.hp.mx.core.nodemanager.NodeStatusManager;
import com.hp.mx.core.nodemanager.NodeStatusPersistenceException;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MonteroUtils;
import com.hp.mx.utilities.PropertiesFile;
import java.util.HashMap;

public abstract class DeviceStatusPolling {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DeviceStatusPolling.class);
    private static PropertiesFile deviceProperties = null;

    void setStatus(String deviceStatus, MxNode deviceMxNode, DeviceStatusSource statusSrc) {
        LOGGER.enter("DeviceStatusPolling.setStatus(" + deviceStatus + "," + deviceMxNode + ")");
        deviceStatus = MonteroUtils.normaliseOAXMLSatus(deviceStatus);
        NodeStatus nodeStatus = new NodeStatus(deviceMxNode.getGUID());
        HashMap statusMap = new HashMap(1);
        nodeStatus.setStatusValues(statusMap);
        nodeStatus.getStatusValues().clear();
        nodeStatus.getStatusValues().put(statusSrc, DeviceStatusType.getStatusTypeByName((String)deviceStatus));
        LOGGER.fine("The status of " + deviceMxNode.getNameString() + "\tis " + DeviceStatusType.getStatusTypeByName((String)deviceStatus));
        try {
            NodeStatusManager.getDefaultManager().update(nodeStatus);
        }
        catch (NodeStatusPersistenceException e) {
            LOGGER.exception("Exception while http status polling of the storage device from OA XML");
        }
        LOGGER.exit("DeviceStatusPolling.setStatus(" + deviceStatus + "," + deviceMxNode + ")");
    }

    abstract String getDeviceStatus(MxNode var1, MxNode var2);

    boolean doesStatusNeedToBeSet(MxNode deviceMxNode) {
        LOGGER.enter("DeviceStatusPolling.doesStatusNeedToBeSet()");
        boolean setStatus = Boolean.valueOf(deviceProperties.getProperty(deviceMxNode.getDeviceType()));
        if (setStatus && deviceMxNode.getIPAddressCount() == 0) {
            setStatus = true;
        }
        LOGGER.fine("setStatus:" + setStatus);
        LOGGER.exit("DeviceStatusPolling.doesStatusNeedToBeSet()");
        return setStatus;
    }

    abstract void initialize();

    static {
        deviceProperties = new PropertiesFile(DeviceStatusPolling.class.getName(), "statuspolling.properties");
    }
}

