/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.polling;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusSourceManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.oa.OADataManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.polling.DeviceStatusPolling;
import com.hp.mx.core.tools.polling.HardwareStatusPollingIfc;
import com.hp.mx.core.tools.polling.HardwareStatusPollingTaskModel;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;
import java.util.Vector;

public class LogicalDeviceStatusPolling
extends DeviceStatusPolling
implements HardwareStatusPollingIfc {
    private DeviceStatusSource statusSrcHTTP = NodeStatusSourceManager.getDefaultManager().getDeviceStatusSource("compaq.hmma.HTTPStatus");
    private static final DebugSubsystem LOGGER = new DebugSubsystem(LogicalDeviceStatusPolling.class);
    OADataManager oaDataManager = null;

    public void initializePlugIn() {
    }

    public void startPolling(MxNode oaMxNode, HardwareStatusPollingTaskModel hsptm) {
        block6: {
            LOGGER.enter("LogicalDeviceStatusPolling.startPolling()");
            LOGGER.fine("The device type :" + oaMxNode.getDeviceType());
            if (!oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString())) {
                LOGGER.fine("The logical device hw status is polled at the time of OA.Thisdevice is not of type OA.");
                LOGGER.exit("LogicalDeviceStatusPolling.startPolling()");
                return;
            }
            this.initialize();
            try {
                int enclosureDeviceKey;
                NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
                if (!nam.hasNodeAssociationByType("MgmtProcToEnclosure", oaMxNode.getDeviceKey()) || (enclosureDeviceKey = nam.getAssociatedDeviceKey(oaMxNode.getDeviceKey(), "MgmtProcToEnclosure")) <= 0) break block6;
                Vector deviceKeys = nam.getAllDevsInContainer(enclosureDeviceKey);
                for (int i = 0; i < deviceKeys.size(); ++i) {
                    MxNode deviceMxNode = null;
                    try {
                        deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(Integer.parseInt(deviceKeys.get(i).toString()));
                    }
                    catch (MxUndefinedNodeException nodeExcep) {
                        LOGGER.fine("MxNode with key does not exists.:" + deviceKeys.get(i));
                        LOGGER.fine("Looking for the next deviceKey in the vector, if available.");
                        continue;
                    }
                    if (!this.doesStatusNeedToBeSet(deviceMxNode)) continue;
                    this.setStatus(this.getDeviceStatus(oaMxNode, deviceMxNode), deviceMxNode, this.statusSrcHTTP);
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.exception("Unable to fire OA XML query, Status pollingdid failed for device.");
            }
        }
        LOGGER.exit("LogicalDeviceStatusPolling.startPolling()");
    }

    String getDeviceStatus(MxNode sourceStatusMxNode, MxNode targetStatusMxNode) {
        LOGGER.enter("LogicalDeviceStatusPolling.getDeviceStatus()");
        String status = null;
        try {
            if (this.oaDataManager == null) {
                this.oaDataManager = new OADataManager(sourceStatusMxNode);
            }
            OLEnclosure olEnclosure = this.oaDataManager.getEnclosureDevice();
            List<OLDevice> deviceList = olEnclosure.getBladeList();
            if (targetStatusMxNode.getDeviceType().equalsIgnoreCase("Switch")) {
                deviceList = olEnclosure.getSwitchList();
            }
            OLDevice olDevice = null;
            NodeAssociations deviceNodeAsscs = NodeAssociationsManager.getDefaultManager().getNodeAssociations(targetStatusMxNode.getDeviceKey());
            int slotNumber = deviceNodeAsscs.getSlotNumber();
            for (int i = 0; i < deviceList.size(); ++i) {
                olDevice = deviceList.get(i);
                if (olDevice.getDeviceSlot() != slotNumber) continue;
                if (olDevice.getDeviceStatus() != null && olDevice.getDeviceStatus().length() > 0) {
                    status = olDevice.getDeviceStatus();
                }
                break;
            }
        }
        catch (OAException oaExcep) {
            LOGGER.exception("Unable to fire OA XML query, Status pollingfailed for" + targetStatusMxNode.getNameString() + ".Setting Unknown as the status.");
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.exception("Unable to NodeAssociations object, Status pollingfailed for" + targetStatusMxNode.getNameString() + ".Setting Unknown as the status.");
        }
        LOGGER.exit("LogicalDeviceStatusPolling.getDeviceStatus()");
        return status;
    }

    void initialize() {
        this.oaDataManager = null;
        this.statusSrcHTTP = NodeStatusSourceManager.getDefaultManager().getDeviceStatusSource("compaq.hmma.HTTPStatus");
    }
}

