/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.polling;

import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeStatus;
import com.hp.mx.core.nodemanager.NodeStatusManager;
import com.hp.mx.core.nodemanager.NodeStatusPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusSourceManager;
import com.hp.mx.core.tools.identification.associations.VCDomainAssociationHandler;
import com.hp.mx.core.tools.polling.HardwareStatusPollingIfc;
import com.hp.mx.core.tools.polling.HardwareStatusPollingTaskModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.HashMap;

public class VCDomainPollingProtocol
implements HardwareStatusPollingIfc {
    private static DeviceStatusSource statusSrcSNMP;
    private static final DebugSubsystem LOGGER;

    public VCDomainPollingProtocol() {
        statusSrcSNMP = NodeStatusSourceManager.getDefaultManager().getDeviceStatusSource("compaq.hmma.SNMPStatus");
    }

    public void initializePlugIn() {
    }

    public void startPolling(MxNode vcSwitchNode, HardwareStatusPollingTaskModel hsptm) {
        LOGGER.enter("VCDomainPollingProtocol.startPolling(" + vcSwitchNode.getNameString() + ", " + hsptm + ")");
        LOGGER.fine("The device type : " + vcSwitchNode.getDeviceType() + "; device key : " + vcSwitchNode.getDeviceKey() + "; device key : " + vcSwitchNode.getModel());
        if (!vcSwitchNode.getDeviceType().equals("Switch") || vcSwitchNode.getModel().indexOf("VC-Enet Module") == -1) {
            LOGGER.fine("Device not of type vcSwitch.");
            return;
        }
        MxNode vcdNode = VCDomainAssociationHandler.getAssociatedNode(vcSwitchNode, "SwitchToVCDomain");
        if (vcdNode == null) {
            LOGGER.fine("No vcDomain attaced to " + vcSwitchNode + ". Do no status update.");
            LOGGER.exit("VCDomainPollingProtocol.startPolling(" + vcSwitchNode.getNameString() + ", " + hsptm + ")");
            return;
        }
        this.setVCDomainHealthStatus(vcSwitchNode, vcdNode);
        LOGGER.exit("VCDomainPollingProtocol.startPolling(" + vcSwitchNode.getNameString() + ", " + hsptm + ")");
    }

    private void setVCDomainHealthStatus(MxNode switchNode, MxNode vcdNode) {
        int statusVal;
        LOGGER.fine("VCDomainPollingProtocol.setVCDomainHealthStatus(" + switchNode.getNameString() + ", " + vcdNode.getNameString() + ")");
        DeviceStatusType[] statusValues = new DeviceStatusType[]{DeviceStatusType.UNKNOWN, DeviceStatusType.NORMAL, DeviceStatusType.WARNING, DeviceStatusType.MINOR, DeviceStatusType.MAJOR, DeviceStatusType.CRITICAL, DeviceStatusType.DISABLED};
        String status = MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.6.1.1.12.1[0]", switchNode);
        LOGGER.fine("Status with snmp call is " + status);
        status = status != null ? ((statusVal = Integer.parseInt(status)) > 0 ? statusValues[--statusVal].toString() : DeviceStatusType.UNKNOWN.toString()) : DeviceStatusType.UNKNOWN.toString();
        LOGGER.fine("Status is " + status);
        this.setStatus(status, vcdNode);
        LOGGER.exit("VCDomainPollingProtocol.setVCDomainHealthStatus(" + vcdNode.getNameString() + ", " + switchNode.getNameString());
    }

    private void setStatus(String deviceStatus, MxNode device) {
        LOGGER.enter("VCDomainPollingProtocol.setStatus(" + deviceStatus + "," + device + ")");
        NodeStatus nodeStatus = new NodeStatus(device.getGUID());
        HashMap statusMap = new HashMap(1);
        nodeStatus.setStatusValues(statusMap);
        nodeStatus.getStatusValues().clear();
        nodeStatus.getStatusValues().put(statusSrcSNMP, DeviceStatusType.getStatusTypeByName((String)deviceStatus));
        LOGGER.fine("The status of " + device.getNameString() + "\tis " + DeviceStatusType.getStatusTypeByName((String)deviceStatus));
        try {
            NodeStatusManager.getDefaultManager().update(nodeStatus);
        }
        catch (NodeStatusPersistenceException e) {
            LOGGER.exception("Exception while polling for the health status of VC Domain" + e.toString());
        }
        LOGGER.exit("VCDomainPollingProtocol.setStatus(" + deviceStatus + " , " + device + ")");
    }

    static {
        LOGGER = new DebugSubsystem(VCDomainPollingProtocol.class);
    }
}

