/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.urack;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxNodeIsLockedException;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObject;
import com.hp.mx.core.tools.urack.RNode;
import com.hp.mx.core.tools.urack.RackablesParseErrHandler;
import com.hp.mx.core.tools.urack.data.Rackable;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxPathProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RackableController {
    public static final String CONFIG_XML_PATH = MxPathProperty.getExpandedPath((String)"CONFIG").getAbsolutePath() + "/rackable";
    private List<RNode> lstQueries = new ArrayList<RNode>();
    private static final DebugSubsystem LOGGER = new DebugSubsystem(RackableController.class);

    private void init(MxLoginBean loginBean) {
        LOGGER.enter("init");
        File file = new File(CONFIG_XML_PATH);
        File[] lstFiles = file.listFiles();
        for (int i = 0; i < lstFiles.length; ++i) {
            if (!lstFiles[i].getName().endsWith(".xml")) continue;
            LOGGER.fine("start parsing file " + lstFiles[i].getName());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                RackablesParseErrHandler errHandler = new RackablesParseErrHandler();
                builder.setErrorHandler(errHandler);
                factory.setValidating(true);
                Document doc = builder.parse(lstFiles[i]);
                if (errHandler.getError() != null) {
                    throw new SAXException("ERROR parsing rackables XML. " + lstFiles[i]);
                }
                Node node = doc.getFirstChild();
                if (!node.getNodeName().equals("rackable-list")) {
                    throw new SAXException(lstFiles[i].getName() + " : Root element <rackable-list> expected.");
                }
                NodeList rNodeList = XPathAPI.selectNodeList((Node)node, (String)"rackable");
                if (rNodeList.getLength() < 1) {
                    throw new SAXException(lstFiles[i].getName() + " : No <rackable> found in <rackable-list>.");
                }
                for (int rc = 0; rc < rNodeList.getLength(); ++rc) {
                    RNode rNode = new RNode();
                    Node rackable = rNodeList.item(rc);
                    NodeList nodelist = XPathAPI.selectNodeList((Node)rackable, (String)"@name");
                    if (nodelist.getLength() != 1) {
                        throw new SAXException(lstFiles[i].getName() + " : name expected for <rackable>");
                    }
                    boolean queryExists = true;
                    String qName = new String("rackable_" + nodelist.item(0).getNodeValue());
                    LOGGER.fine("GOT Q NAME " + qName);
                    try {
                        loginBean.getQueryClient().getQuery(qName);
                    }
                    catch (MxException e1) {
                        queryExists = false;
                    }
                    Vector<CriteriaDataObject> vCriteria = new Vector<CriteriaDataObject>(5, 2);
                    nodelist = XPathAPI.selectNodeList((Node)rackable, (String)"query/criteria/@name");
                    if (nodelist.getLength() < 1) {
                        throw new SAXException(lstFiles[i].getName() + " : query/criteria missing for <rackable>");
                    }
                    LOGGER.fine("QUERY ALREADY EXISTS? " + queryExists);
                    if (!queryExists) {
                        for (int nl = 0; nl < nodelist.getLength(); ++nl) {
                            try {
                                String cName = nodelist.item(nl).getNodeValue();
                                vCriteria.add(loginBean.getQueryClient().getCriteriaFactory().getObject(cName));
                                ((CriteriaDataObject)vCriteria.get(vCriteria.size() - 1)).addCriteriaValue(XPathAPI.selectNodeList((Node)rackable, (String)("query/criteria[@name='" + cName + "']/text()")).item(0).getNodeValue());
                                LOGGER.fine("ADDED CRITERIA  " + loginBean.getQueryClient().getCriteriaFactory().getObject(cName));
                                continue;
                            }
                            catch (MxException e) {
                                throw new SAXException(lstFiles[i].getName() + " : error getting query for " + qName);
                            }
                        }
                        if (vCriteria.size() > 0 && vCriteria.get(0) != null) {
                            Query query = new Query(qName, "DeviceViews", vCriteria);
                            query.setDynamic(true);
                            try {
                                loginBean.getQueryClient().addQuery(query, loginBean.getLocale());
                            }
                            catch (MxException e) {
                                LOGGER.exception((Throwable)e);
                            }
                        } else {
                            throw new SAXException(lstFiles[i].getName() + " : error getting query for " + qName);
                        }
                    }
                    rNode.query = qName;
                    nodelist = XPathAPI.selectNodeList((Node)rackable, (String)"attribute/@name");
                    if (nodelist.getLength() < 2) {
                        throw new SAXException(lstFiles[i].getName() + " : Atleast 2 <attribute> for <rackable> expected");
                    }
                    String attr = nodelist.item(0).getNodeValue();
                    rNode.attributes.put(attr, XPathAPI.selectNodeList((Node)rackable, (String)("attribute[@name='" + attr + "']/text()")).item(0).getNodeValue());
                    attr = nodelist.item(1).getNodeValue();
                    rNode.attributes.put(attr, XPathAPI.selectNodeList((Node)rackable, (String)("attribute[@name='" + attr + "']/text()")).item(0).getNodeValue());
                    nodelist = XPathAPI.selectNodeList((Node)rackable, (String)"filter-criteria/@name");
                    if (nodelist.getLength() < 2) {
                        throw new SAXException(lstFiles[i].getName() + " : Atleast 2 <filter-criteria> for <rackable> expected");
                    }
                    attr = nodelist.item(0).getNodeValue();
                    rNode.filterCriteria.put(attr, XPathAPI.selectNodeList((Node)rackable, (String)("filter-criteria[@name='" + attr + "']/text()")).item(0).getNodeValue());
                    attr = nodelist.item(1).getNodeValue();
                    rNode.filterCriteria.put(attr, XPathAPI.selectNodeList((Node)rackable, (String)("filter-criteria[@name='" + attr + "']/text()")).item(0).getNodeValue());
                    this.lstQueries.add(rNode);
                }
            }
            catch (SAXException e) {
                LOGGER.error(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                LOGGER.error(e.getMessage());
                LOGGER.exception((Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                LOGGER.exception((Throwable)e);
            }
            catch (TransformerException e) {
                LOGGER.error(e.getMessage());
                LOGGER.exception((Throwable)e);
            }
            LOGGER.fine("end parsing file " + lstFiles[i].getName());
        }
        LOGGER.exit("init");
    }

    public List<Rackable> getRackables(MxLoginBean loginBean) throws NodeAssociationsPersistenceException, MxFailedAuthenticationException, MxInvalidTransactionException {
        LOGGER.enter("getRackables (" + loginBean + ")");
        this.init(loginBean);
        ArrayList<Rackable> lstToReturn = new ArrayList<Rackable>();
        for (RNode rnode : this.lstQueries) {
            List lstEncl = null;
            try {
                lstEncl = loginBean.getQueryClient().executeQuery(rnode.query);
            }
            catch (MxException e1) {
                LOGGER.error(e1.getMessage());
                LOGGER.exception((Throwable)e1);
                continue;
            }
            MxNode node = null;
            int deviceKeyIndex = 0;
            int rackKey = 0;
            String rackName = null;
            List lstData = (List)lstEncl.get(0);
            for (int ii = 0; ii < lstData.size(); ++ii) {
                if (lstData.get(ii) == null || !lstData.get(ii).toString().toLowerCase().trim().equals("devicekey")) continue;
                deviceKeyIndex = ii;
            }
            ArrayList<Integer> lstEnclKeys = new ArrayList<Integer>();
            for (int i = 1; i < lstEncl.size(); ++i) {
                Rackable rackable = new Rackable();
                lstData = (List)lstEncl.get(i);
                try {
                    if (lstData.get(deviceKeyIndex).toString().trim().length() <= 0) continue;
                    node = loginBean.getNodeClient().getNodeByKey(Integer.parseInt(lstData.get(deviceKeyIndex).toString()), false);
                    if (node == null) continue;
                    LOGGER.fine("Found node " + node.getNameString() + " from query '" + rnode.query + "'");
                    if (lstEnclKeys.contains(node.getDeviceKey())) {
                        LOGGER.fine(node.getNameString() + " is duplicate and will be ignored.");
                        continue;
                    }
                    lstEnclKeys.add(node.getDeviceKey());
                    NodeAssociationsManager nodeAssocMgr = NodeAssociationsManager.getDefaultManager();
                    rackKey = nodeAssocMgr.getAssociatedDeviceKey(node.getDeviceKey(), "EnclosureToRack");
                    rackName = rackKey != 0 ? MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackKey).getNameString() : "";
                    rackable.setId(Integer.toString(node.getDeviceKey()));
                    rackable.setName(node.getNameString());
                    rackable.setHeight(rnode.attributes.get("height"));
                    rackable.setDescription(rnode.attributes.get("description"));
                    if (rnode.attributes.get("description").equals("p-Class power enclosure")) {
                        if (node.getProductId() != null && node.getProductId().equals("5")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (1U)"));
                            rackable.setHeight("1");
                        } else if (node.getProductId() != null && node.getProductId().equals("3")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (3U)"));
                            rackable.setHeight("3");
                        } else if (node.getAgentUUID() != null && node.getAgentUUID().startsWith("05")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (1U)"));
                            rackable.setHeight("1");
                        } else if (node.getAgentUUID() != null && node.getAgentUUID().startsWith("03")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (3U)"));
                            rackable.setHeight("3");
                        } else {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (3U)"));
                            rackable.setHeight("3");
                        }
                    }
                    if (rnode.attributes.get("description").equals("c-Class Enclosure")) {
                        if (node.getClientAttribute("enclosureTypeName") != null && node.getClientAttribute("enclosureTypeName").equals("c3000")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (c3000)"));
                            rackable.setHeight("6");
                        } else if (node.getClientAttribute("enclosureTypeName") != null && node.getClientAttribute("enclosureTypeName").equals("c7000")) {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (c7000)"));
                            rackable.setHeight("10");
                        } else {
                            rackable.setDescription(rnode.attributes.get("description").concat(" (c7000)"));
                            rackable.setHeight("10");
                        }
                    }
                    rackable.setSubType(rnode.filterCriteria.get("class"));
                    rackable.setType(rnode.filterCriteria.get("type"));
                    rackable.setRackId(Integer.toString(rackKey));
                    rackable.setRackName(rackName);
                    rackable.setDc(node.getClientAttribute("dCRackUUID"));
                    rackable.setDcOrder(node.getClientAttribute("Order"));
                    lstToReturn.add(rackable);
                    continue;
                }
                catch (MxUndefinedNodeException mux) {
                    LOGGER.exception((Throwable)mux);
                    continue;
                }
                catch (MxNodeIsLockedException e) {
                    LOGGER.exception((Throwable)e);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.exception((Throwable)e);
                    continue;
                }
                catch (MxFailedAuthenticationException e) {
                    LOGGER.exception((Throwable)e);
                    continue;
                }
                catch (MxInvalidTransactionException e) {
                    LOGGER.exception((Throwable)e);
                }
            }
        }
        LOGGER.exit("getRackables (" + loginBean + ")");
        return lstToReturn;
    }
}

