/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import org.jdom.Element;

public class MxBPVDesktop
extends MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVDesktop.class);
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;

    public MxBPVDesktop(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        LOGGER.enter("MxBPVDesktop.MxBPVDesktop(" + node + "," + parent + "," + loginBean + ")");
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
        this.deviceType = "Desktop";
        LOGGER.exit("MxBPVDesktop.MxBPVDesktop(" + node + "," + parent + "," + loginBean + ")");
    }

    public int getNumSlotsUsedXDir() {
        return this.numSlotsUsedXDir;
    }

    public int getNumSlotsUsedYDir() {
        return this.numSlotsUsedYDir;
    }

    String getDrillDownURL() {
        LOGGER.enter("MxBPVDesktop.getDrillDownURL()");
        return "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + this.getGUID() + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN + "&globalsetting=true";
    }

    String getPropertyPageURL(String drillDownType, String url) {
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + drillDownType + "&globalselection=true" + "&propertyPageURL=" + url;
    }

    public Element renderXML() {
        LOGGER.enter("MxBPVDesktop.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Element server = bpvXml.createDevice(this, false, this.loginBean);
        return server;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }
}

