/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxDynamicStatusClient;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVShortyEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxPathProperty;
import com.sun.xml.bind.JAXBObject;
import java.io.File;
import org.jdom.Element;

public abstract class MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVElement.class);
    private MxBPVElement parent;
    protected MxLoginBean loginBean;
    protected String deviceType;
    protected MxNode node;
    protected int numDukesSwitches = 0;
    protected int[] dukesSlotNumbers = new int[]{0, 0};
    protected int slotNumber;
    private String status;

    public MxBPVElement(MxNode node, MxBPVElement parent, MxLoginBean loginBean) {
        LOGGER.enter("MxBPVElement(" + node + "," + parent + "," + loginBean + ")");
        this.node = node;
        this.parent = parent;
        this.loginBean = loginBean;
        try {
            if (node != null) {
                if (this instanceof MxBPVContainer) {
                    MxDynamicStatusClient dynamicStatusClient = loginBean.getMxSessionManager().getDynamicStatusClient();
                    int intStatus = dynamicStatusClient.getStatusValueForGuidString(node.getObjectID().getGUID().toString());
                    DeviceStatusType devStatusType = DeviceStatusType.getStatusTypeByVal((int)intStatus);
                    this.status = devStatusType.toString();
                } else {
                    this.status = node.getOverallStatus().toString();
                }
                LOGGER.fine("status:" + this.status);
            }
        }
        catch (Exception e) {
            LOGGER.fine("in MxPBVElement constructor - error retrieving bubble-up status - " + e);
            LOGGER.fine("Exception:" + e);
        }
        LOGGER.exit("MxBPVElement(" + node + "," + parent + "," + loginBean + ")");
    }

    public MxNode getNode() {
        return this.node;
    }

    public String getStatus() {
        LOGGER.enter("MxBPVElement.getStatus()" + this.status);
        if (this.status == null || this.status.length() <= 0) {
            this.status = DeviceStatusType.UNKNOWN.toString();
            LOGGER.fine("status:" + this.status);
        }
        this.status = this.status.charAt(0) + this.status.substring(1, this.status.length()).toLowerCase();
        LOGGER.exit("MxBPVElement.getStatus()" + this.status);
        return this.status;
    }

    public int getKey() {
        return this.node != null ? this.node.getKey() : 0;
    }

    public String getGUID() {
        return this.node != null ? this.node.getGUID().toString() : "";
    }

    public String getName() {
        return this.node != null ? this.node.getNameString() : null;
    }

    public MxBPVElement getParent() {
        return this.parent;
    }

    public MxBPVElement getRootContainer() {
        MxBPVElement element = this;
        while (element.getParent() != null) {
            element = element.getParent();
        }
        return element;
    }

    public MxLoginBean getLoginBean() {
        return this.loginBean;
    }

    public int getNumSlotsUsed() {
        return 1;
    }

    public int getNumSlotsUsedXDir() {
        return 1;
    }

    public int getNumSlotsUsedYDir() {
        return 1;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public abstract Element renderXML() throws MxBPVException;

    public abstract JAXBObject renderJAXBXML();

    public int getDukesSlotNumbers(int i) {
        return this.dukesSlotNumbers[i];
    }

    public void setDukesSlotNumbers(int position) {
        this.dukesSlotNumbers[position] = 1;
    }

    public int getNumDukesSwitches() {
        return this.numDukesSwitches;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    protected String getImageURL(String imageType, String unSupportedImage) {
        LOGGER.enter("MxBPVElement.getImageURL()");
        String FILE_PATH = MxPathProperty.getExpandedPath((String)"WEBAPP").getAbsolutePath();
        StringBuffer filePath = new StringBuffer(FILE_PATH).append(File.separator).append("ROOT").append(File.separator).append("mxportal").append(File.separator).append("bladeime").append(File.separator).append("skin").append(File.separator).append("images").append(File.separator).append("c-class");
        if (this.getParent() instanceof MxBPVShortyEnclosure && imageType.equalsIgnoreCase("server")) {
            filePath.append(File.separator);
            filePath.append("shorty");
        }
        if (imageType.equalsIgnoreCase("server")) {
            filePath.append(File.separator).append("frontview");
        } else {
            filePath.append(File.separator).append("rearview");
        }
        filePath.append(File.separator).append(imageType);
        LOGGER.fine("filePath:" + filePath);
        File directory = new File(filePath.toString());
        String modelName = this.getNode().getModel().toLowerCase();
        LOGGER.fine("modelName:" + modelName);
        String imagePath = null;
        LOGGER.fine("directory.isDirectory():" + directory.isDirectory());
        if (directory.isDirectory()) {
            File[] imageNames;
            for (File image : imageNames = directory.listFiles()) {
                String pathName = image.getName();
                String pathNameLowerCase = pathName.toLowerCase();
                if (pathNameLowerCase.indexOf(".") > 0) {
                    pathNameLowerCase = pathNameLowerCase.substring(0, pathNameLowerCase.indexOf("."));
                }
                modelName = modelName.replace(':', '-');
                if ((modelName = modelName.replace('/', '-')).indexOf(pathNameLowerCase) < 0) continue;
                imagePath = image.getName();
                LOGGER.fine("imagePath:" + imagePath);
                break;
            }
            if (imagePath == null) {
                LOGGER.fine("Unable to find the image URL for server, Will set unknown image");
                imagePath = unSupportedImage;
            }
        }
        LOGGER.fine("imagePath:" + imagePath);
        LOGGER.exit("MxBPVElement.getImageURL()");
        return imagePath;
    }
}

