/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.PropertiesFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MxBPVObjectFactory {
    private static PropertiesFile m_classes = null;
    private static final DebugSubsystem LOGGER;

    public MxBPVElement createObject(MxNode device, MxBPVServerEnclosure enclosure, MxLoginBean login) throws BladeSystemException {
        LOGGER.enter("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
        String type = device.getDeviceType();
        String className = m_classes.getProperty(type);
        if (className == null) {
            className = m_classes.getProperty("Server");
        }
        LOGGER.fine("className:" + className);
        try {
            Class<?> bpvElement = Class.forName(className);
            Class[] argArray = new Class[]{MxNode.class, MxBPVElement.class, MxLoginBean.class};
            Constructor<?> constructor = null;
            Object object = null;
            try {
                constructor = bpvElement.getConstructor(argArray);
                Object[] objArray = new Object[]{device, enclosure, login};
                try {
                    object = constructor.newInstance(objArray);
                }
                catch (IllegalArgumentException e1) {
                    LOGGER.exception("Exception:" + e1);
                    LOGGER.fine("Throwing BladeSystemException");
                    throw new BladeSystemException("Error creating BPV element");
                }
                catch (InvocationTargetException e1) {
                    LOGGER.exception("Exception:" + e1);
                    LOGGER.fine("Throwing BladeSystemException");
                    throw new BladeSystemException("Error creating BPV element");
                }
            }
            catch (SecurityException e2) {
                LOGGER.exception("Exception:" + e2);
                LOGGER.fine("Throwing BladeSystemException");
                throw new BladeSystemException("Error creating BPV element");
            }
            catch (NoSuchMethodException e2) {
                LOGGER.exception("Exception:" + e2);
                LOGGER.fine("Throwing BladeSystemException");
                throw new BladeSystemException("Error creating BPV element");
            }
            LOGGER.exit("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
            return object;
        }
        catch (InstantiationException e) {
            LOGGER.exception("Exception:" + e);
        }
        catch (IllegalAccessException e) {
            LOGGER.exception("Exception:" + e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.exception("Exception:" + e);
        }
        LOGGER.fine("Throwing BladeSystemException");
        LOGGER.exit("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
        throw new BladeSystemException("Error creating BPV element");
    }

    static {
        m_classes = new PropertiesFile(MxBPVObjectFactory.class.getName(), "bpvelements.properties");
        LOGGER = new DebugSubsystem(MxBPVObjectFactory.class);
    }
}

