/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceFansType;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceTempsType;
import com.hp.mx.core.tools.datacollection.http.oa.EnclosurePowerSupplyType;
import com.hp.mx.core.tools.datacollection.http.oa.EnclosurePowerType;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.identification.associations.VCDomainAssociationHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Attribute;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.BladeEnclosure;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.CommonType;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.FANS;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Power;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.PowerSupplyUnit;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Status;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Temperature;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.TemperatureType;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MonteroUtils;
import com.sun.xml.bind.JAXBObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class MxBPVOverlordEnclosure
extends MxBPVServerEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVOverlordEnclosure.class);
    private final int firstSlotNumber = 1;
    private MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
    private Vector m_switchContents;
    private Vector m_oAContents;
    ObjectFactory m_objFactory = new ObjectFactory();
    protected OLEnclosure m_enclosureObj;

    public MxBPVOverlordEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getFirstSlotNumber() {
        return 1;
    }

    public void populateAll() throws MxBPVException {
        this.m_enclosureObj = OAHelper.getOAHelper().refreshData(this.node);
        this.populateServerSlots();
        this.populateSwitchSlots();
        this.populateOASlots();
    }

    void populateServerSlots() throws MxBPVException {
        LOGGER.enter("MxBPVOverlordEnclosure.populateServerSlots()");
        int slotNumber = this.getFirstSlotNumber();
        int numberOfServerSlots = this.getNumSlots();
        this.setSize(numberOfServerSlots + 1);
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException nape) {
            throw new MxBPVException("MxBPVOverlordEnclosure.createServer" + nape.getMessage());
        }
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        Vector allBlades = this.getDevicesVector(this.getKey(), "Server");
        while (slotNumber < numberOfServerSlots + 1) {
            MxBPVElement element;
            MxBPVElement top = element = this.getElementForSlot(allBlades, slotNumber);
            MxBPVElement bottom = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber + numberOfServerSlots);
            try {
                if (top != null && bottom != null) {
                    top.slotNumber = slotNumber;
                    bottom.slotNumber = slotNumber + numberOfServerSlots;
                    LOGGER.fine("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + numberOfServerSlots);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    ++slotNumber;
                    continue;
                }
                if (top != null && bottom == null) {
                    if (this.isBottomSlotEmpty(top)) {
                        bottom = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                        top.slotNumber = slotNumber;
                        bottom.slotNumber = slotNumber + numberOfServerSlots;
                        LOGGER.fine("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + numberOfServerSlots);
                        this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    } else {
                        LOGGER.fine("Set the Ice Blade the container");
                        this.set(slotNumber, top);
                    }
                    slotNumber += this.getNextSlotNumber(top);
                    continue;
                }
                if (top == null && bottom != null) {
                    top = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                    top.slotNumber = slotNumber;
                    bottom.slotNumber = slotNumber + numberOfServerSlots;
                    LOGGER.fine("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + numberOfServerSlots);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    ++slotNumber;
                    continue;
                }
                MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(false, slotNumber, this.getNumberOfEmptySlotsInXDirection(), this.getNumberOfEmptySlotsInYDirection());
                emptySlot.slotNumber = slotNumber;
                emptySlot.setDeviceTypeForEmptySlot("Server");
                LOGGER.fine("Set the Empty slot to the container");
                this.set(slotNumber, emptySlot);
                ++slotNumber;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LOGGER.exit("MxBPVOverlordEnclosure.populateServerSlots()");
    }

    void populateSwitchSlots() throws MxBPVException {
        LOGGER.enter("MxBPVOverlordEnclosure.populateSwitchSlots()");
        int slotNumber = this.getFirstSlotNumber();
        this.m_switchContents = new Vector();
        int numberSwitchSlots = this.getNumSwitchSlots();
        this.m_switchContents.setSize(numberSwitchSlots + 1);
        Vector allSwitches = this.getDevicesVector(this.getKey(), "Switch");
        while (slotNumber < numberSwitchSlots + 1) {
            MxBPVElement element = this.getElementForSlot(allSwitches, slotNumber);
            if (element != null && element instanceof MxBPVSwitch) {
                MxBPVSwitch switchElement = (MxBPVSwitch)element;
                this.setOverlordDevices(slotNumber, switchElement, false);
                LOGGER.fine("Number of slots occupied along X-dir by switch:" + switchElement.getNumSlotsUsedXDir());
                slotNumber += switchElement.getNumSlotsUsedXDir();
                continue;
            }
            LOGGER.fine("No switch at slotnumber:" + slotNumber);
            MxBPVEmptySlot emptyElement = new MxBPVEmptySlot(true, slotNumber, 1, 1);
            emptyElement.setDeviceTypeForEmptySlot("Switch");
            this.setOverlordDevices(slotNumber, emptyElement, false);
            ++slotNumber;
        }
        LOGGER.exit("MxBPVOverlordEnclosure.populateSwitchSlots()");
    }

    void populateOASlots() throws MxBPVException {
        LOGGER.enter("MxBPVOverlordEnclosure.populateOASlots()");
        int slotNumber = this.getFirstSlotNumber();
        this.m_oAContents = new Vector();
        int numberOfOASlots = this.getNumOASlots();
        this.m_oAContents.setSize(numberOfOASlots + 1);
        Vector allMPs = this.getDevicesVector(this.getKey(), "MgmtProc");
        while (slotNumber < numberOfOASlots + 1) {
            MxBPVElement element = this.getElementForSlot(allMPs, slotNumber);
            if (element != null) {
                this.setOverlordDevices(slotNumber, element, true);
                LOGGER.fine("Number of slots occupied along X-dir by OA:" + element.getNumSlotsUsedXDir());
                slotNumber += element.getNumSlotsUsedXDir();
                continue;
            }
            MxBPVEmptySlot emptyElement = new MxBPVEmptySlot(true, slotNumber, 1, 1);
            emptyElement.setDeviceTypeForEmptySlot("MgmtProc");
            this.setOverlordDevices(slotNumber, emptyElement, true);
            ++slotNumber;
        }
        LOGGER.exit("MxBPVOverlordEnclosure.populateOASlots()");
    }

    public Element renderXML() throws MxBPVException {
        LOGGER.enter("MxBPVOverlordEnclosure.renderXML()");
        Element enclosureRoot = null;
        try {
            BladeEnclosure enclosure = this.m_objFactory.createBladeEnclosure();
            this.setEnclosureAttributes(enclosure);
            this.createEnclosureAttributes(enclosure);
            this.createEnclPwrThermalAttributes(enclosure);
            List devices = enclosure.getDevice();
            this.renderServerDevices(devices);
            this.renderOverlordDevices(this.m_switchContents, devices);
            this.renderOverlordDevices(this.m_oAContents, devices);
            this.renderFANDetails(enclosure);
            this.renderPowerUnitDetails(enclosure);
            this.renderVCMDetails(enclosure);
            CommonType common = this.m_objFactory.createCommonType();
            common.setNodeId(this.getGUID());
            EnclosurePowerType powerType = this.m_enclosureObj.getEnclosurePowerType();
            common.setPowerSupplyPDU(powerType.getPDU());
            enclosure.setCommon(common);
            JAXBContext jc = JAXBContext.newInstance((String)"com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb");
            Marshaller xmlMarshaller = jc.createMarshaller();
            xmlMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter string = new StringWriter(3000);
            xmlMarshaller.marshal((Object)enclosure, (Writer)string);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(string.toString()));
            enclosureRoot = doc.getRootElement();
            LOGGER.fine("Overlord Enclosure Element:" + enclosureRoot.toString());
        }
        catch (PropertyException pe) {
            LOGGER.fine("MxBPVOverlordEnclosure.renderXML()" + (Object)((Object)pe));
            throw new MxBPVException(pe.getMessage());
        }
        catch (JAXBException jaxbe) {
            LOGGER.fine("MxBPVOverlordEnclosure.renderXML()" + (Object)((Object)jaxbe));
            throw new MxBPVException(jaxbe.getMessage());
        }
        catch (JDOMException jdome) {
            LOGGER.fine("MxBPVOverlordEnclosure.renderXML()" + (Object)((Object)jdome));
            throw new MxBPVException(jdome.getMessage());
        }
        catch (IOException ioe) {
            LOGGER.fine("MxBPVOverlordEnclosure.renderXML()" + ioe);
            throw new MxBPVException(ioe.getMessage());
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderXML()");
        return enclosureRoot;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }

    void setEnclosureAttributes(BladeEnclosure enclosure) {
        LOGGER.enter("setEnclosureAttributes(" + enclosure + ")");
        enclosure.setRackName(this.node.getRackName());
        enclosure.setEnclUUID(this.getValue(this.m_enclosureObj.getEnclosureUUID()));
        enclosure.setType("c-Class");
        enclosure.setTitleStatus(MonteroResourceManager.getInstance().getString("xml." + this.getHealthStatus(this.getStatus()), this.getLoginBean().getLocale()));
        if (this.node.getClientAttribute("enclStartU") != null && this.node.getClientAttribute("enclStartU").length() > 0) {
            enclosure.setStartU(this.node.getClientAttribute("enclStartU"));
        } else {
            enclosure.setStartU("NOT AVAILABLE");
        }
        if (this.node.getClientAttribute("enclEndU") != null && this.node.getClientAttribute("enclEndU").length() > 0) {
            enclosure.setEndU(this.node.getClientAttribute("enclEndU"));
        } else {
            enclosure.setEndU("NOT AVAILABLE");
        }
        enclosure.setUIDStatus(this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus()));
        enclosure.setSubType("c7000");
        LOGGER.fine("m_enclosureObj.getEnclosureUUIDStatus():" + this.m_enclosureObj.getEnclosureUUIDStatus());
        LOGGER.fine("getValue:" + this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus()));
        LOGGER.exit("setEnclosureAttributes(" + enclosure + ")");
    }

    private void renderServerDevices(List devices) {
        Iterator iter = this.iterator();
        MxBPVElement childElement = null;
        while (iter.hasNext()) {
            Object elementList = iter.next();
            if (elementList == null) continue;
            if (elementList instanceof MxBPVTyphoonSlot) {
                LOGGER.fine("Render the XML for Typhoon device");
                ((MxBPVTyphoonSlot)elementList).renderJAXBXML(devices);
                continue;
            }
            LOGGER.fine("Render the XML for the device which is not Typhoon");
            childElement = (MxBPVElement)elementList;
            JAXBObject device = childElement.renderJAXBXML();
            devices.add((Device)device);
        }
    }

    private void renderOverlordDevices(Vector deviceVector, List devices) {
        LOGGER.enter("renderOverlordDevices()");
        MxBPVElement childElement = null;
        for (int j = 1; j < deviceVector.size(); j += childElement.getNumSlotsUsedXDir()) {
            Object oAElement = deviceVector.get(j);
            childElement = (MxBPVElement)oAElement;
            JAXBObject device = childElement.renderJAXBXML();
            devices.add((Device)device);
        }
        LOGGER.exit("renderOverlordDevices()");
    }

    private void renderFANDetails(BladeEnclosure enclosure) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderFANDetails()");
        List fans = enclosure.getFANS();
        DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
        List<DeviceFansType.DeviceFanType> fanList = fansType.getDeviceFanTypeList();
        FANS fan = null;
        ArrayList<String> fanBayList = new ArrayList<String>();
        DeviceFansType.DeviceFanType fanType = null;
        DeviceFansType.DeviceFanType.DeviceFanBayOccupanType connectionType = null;
        String bayOccupiedByFan = null;
        try {
            for (int i = 0; i < fanList.size(); ++i) {
                fanType = fanList.get(i);
                connectionType = fanType.getDeviceFanBayOccupanType();
                fan = this.m_objFactory.createFANS();
                bayOccupiedByFan = connectionType.getCONNECTION();
                LOGGER.fine("The Bay Occupied by the Slot:" + bayOccupiedByFan);
                fanBayList.add(bayOccupiedByFan);
                fan.setBayNumber(Integer.parseInt(this.getValue(bayOccupiedByFan)));
                fan.setHasDevice("PRESENT");
                Status status = this.m_objFactory.createStatus();
                String fanStatus = this.getHealthStatusValue(fanType.getStatus());
                status.setUID(fanStatus);
                status.setTitle(MonteroResourceManager.getInstance().getString("xml." + fanStatus, this.getLoginBean().getLocale()));
                fan.setStatus(status);
                fan.setPartNumber(this.getValue(fanType.getPN()));
                fan.setPowerUsed(this.getValue(fanType.getPWRDUsed()));
                fan.setSpeed(this.getValue(fanType.getRPMCur()));
                fans.add(fan);
            }
            this.createEmptyFans(fanBayList, fans);
        }
        catch (JAXBException e) {
            LOGGER.fine("MxBPVOverlordEnclosure.renderFANDetails" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderFANDetails()");
    }

    private String getHealthStatusValue(String overStatus) {
        LOGGER.enter("MxBPVOverlordEnclosure.getHealthStatusValue(" + overStatus + ")");
        String status = MonteroUtils.normaliseOAXMLSatus(overStatus);
        status = status.charAt(0) + status.substring(1, status.length()).toLowerCase();
        LOGGER.fine("HPSIM Status:" + status);
        LOGGER.exit("MxBPVOverlordEnclosure.getHealthStatusValue(" + overStatus + ")");
        return status;
    }

    private void createEmptyFans(List fanBayList, List fans) {
        LOGGER.enter("MxBPVOverlordEnclosure.createEmptyFans");
        FANS fan = null;
        LOGGER.fine("Total number of Fans present in the OverlordEnclosure:" + fanBayList.size());
        int numberFans = this.getNumberOfFans();
        try {
            for (int i = 1; i <= numberFans; ++i) {
                if (fanBayList.contains("" + i)) continue;
                fan = this.m_objFactory.createFANS();
                fan.setBayNumber(i);
                fan.setHasDevice("ABSENT");
                fans.add(fan);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("MxBPVOverlordEnclosure.createEmptyFans" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.createEmptyFans");
    }

    private void renderPowerUnitDetails(BladeEnclosure enclosure) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderPowerUnitDetails(" + enclosure + ")");
        List powerUnitsList = enclosure.getPowerSupplyUnit();
        EnclosurePowerType powerType = this.m_enclosureObj.getEnclosurePowerType();
        List<EnclosurePowerSupplyType> powerUnitTypeList = powerType.getEnclosurePowerSupplyTypeList();
        PowerSupplyUnit powerUnit = null;
        EnclosurePowerSupplyType powerUnitType = null;
        List attributeList = null;
        ArrayList<String> pwrUnitsBayList = new ArrayList<String>();
        int noOfPowerUnits = powerUnitTypeList.size();
        LOGGER.fine("Total number of Power units present in the enclosure:" + noOfPowerUnits);
        try {
            for (int i = 0; i < noOfPowerUnits; ++i) {
                powerUnitType = powerUnitTypeList.get(i);
                powerUnit = this.m_objFactory.createPowerSupplyUnit();
                powerUnit.setHasDevice("PRESENT");
                int powerUnitBayNumber = powerUnitType.getConnection();
                LOGGER.fine("Add the Power Unit BayNumber " + powerUnitBayNumber + " to the List");
                pwrUnitsBayList.add("" + powerUnitBayNumber);
                powerUnit.setBayNumber(powerUnitBayNumber);
                String acInput = this.getHealthStatusValue(powerUnitType.getACInput());
                powerUnit.setACInput(acInput);
                String puStatus = this.getHealthStatusValue(powerUnitType.getStatus());
                Status status = this.m_objFactory.createStatus();
                status.setUID(puStatus);
                status.setTitle(MonteroResourceManager.getInstance().getString("xml." + puStatus, this.getLoginBean().getLocale()));
                powerUnit.setStatus(status);
                attributeList = powerUnit.getAttribute();
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.firmwareRevision", this.loginBean.getLocale()), this.getValue(powerUnitType.getFRWI())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.partNumber", this.loginBean.getLocale()), this.getValue(powerUnitType.getPN())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.serialNumber", this.loginBean.getLocale()), this.getValue(powerUnitType.getSN())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.ACInput", this.loginBean.getLocale()), this.getValue(this.getHealthStatus(powerUnitType.getACInput()))));
                powerUnitsList.add(powerUnit);
                this.renderPowerUnitPowerDetails(powerUnit, powerUnitType);
            }
            this.createEmptyPowerUnits(pwrUnitsBayList, powerUnitsList);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOverlord.renderPowerUnitDetails()" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderPowerUnitDetails(" + enclosure + ")");
    }

    private void renderVCMDetails(BladeEnclosure enclosure) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderVCMDetails(" + enclosure + ")");
        try {
            MxNode vcDomainNode = VCDomainAssociationHandler.getAssociatedNode(this.m_enclosureObj.getDeviceMxNode(), "EnclosureToVCDomain");
            if (vcDomainNode != null) {
                String vcmDomainName;
                LOGGER.fine("vc domain is associated with the enclosure. VC Domain is " + vcDomainNode.getNameString());
                String vcmIp = vcDomainNode.getClientAttribute("vcDomainIP");
                String vcmURL = "";
                String normalizedURL = "";
                List attributeList = enclosure.getAttribute();
                if (vcmIp != null && vcmIp.length() > 0) {
                    vcmURL = "http://" + vcmIp + "/";
                    normalizedURL = this.normalizeURL(vcmURL);
                    LOGGER.fine("vcmurl is " + vcmURL);
                    attributeList.add(this.getAttribute("Identification", "Both", null, "true", vcmURL, "true", this.m_manager.getString("vcd.vcm_title", this.loginBean.getLocale()), normalizedURL));
                }
                if ((vcmDomainName = vcDomainNode.getNameString()) != null && vcmDomainName.length() > 0) {
                    LOGGER.fine("vc domain name " + vcmDomainName);
                    String vcdSysPageURL = "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + vcDomainNode.getDeviceKey() + "&drillDownType=DrillDownType-DeviceName&globalselection=true";
                    attributeList.add(this.getAttribute("Identification", "Both", null, "true", vcdSysPageURL, "false", this.m_manager.getString("vcd.name", this.loginBean.getLocale()), vcmDomainName));
                }
            } else {
                LOGGER.fine("vcm ip and the name will be not shown in BPV since vc domain is not associated with the enclosure");
            }
        }
        catch (OAException e) {
            LOGGER.panic("error rendering vcm details " + e.toString());
        }
        catch (MalformedURLException e) {
            LOGGER.panic("error framing the url " + e.toString());
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderVCMDetails(" + enclosure + ")");
    }

    private String normalizeURL(String URLpattern) throws MalformedURLException {
        LOGGER.enter("MxBPVOverlordEnclosure.normalizeURL(" + URLpattern + ")");
        try {
            URL url = new URL(URLpattern);
            return url.getHost();
        }
        catch (MalformedURLException e) {
            LOGGER.fine("Not a valid URL");
            throw e;
        }
    }

    private void createEmptyPowerUnits(List pwrUnitsBayList, List powerUnitsList) {
        LOGGER.enter("MxBPVOverlordEnclosure.createEmptyPowerUnits");
        PowerSupplyUnit powerUnit = null;
        LOGGER.fine("Total number of Power Units present in the Overlord Enclsoure:" + pwrUnitsBayList.size());
        int numberOfPowerUnits = this.getNumberOfPU();
        try {
            for (int i = 1; i <= numberOfPowerUnits; ++i) {
                if (pwrUnitsBayList.contains("" + i)) continue;
                powerUnit = this.m_objFactory.createPowerSupplyUnit();
                powerUnit.setBayNumber(i);
                powerUnit.setHasDevice("ABSENT");
                powerUnitsList.add(powerUnit);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("MxBPVOverlordEnclosure.createEmptyPowerUnits" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.createEmptyPowerUnits");
    }

    private void renderPowerUnitPowerDetails(PowerSupplyUnit jaxbPowerUnit, EnclosurePowerSupplyType powerUnitType) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderPowerUnitPowerDetails");
        try {
            Power jaxbPower = this.m_objFactory.createPower();
            jaxbPower.setPowerAvailable(this.getValue(powerUnitType.getCapacity()));
            jaxbPower.setPowerUsed(this.getValue(powerUnitType.getActualOutput()));
            jaxbPowerUnit.setPower(jaxbPower);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOverlordEnclosure.renderPowerUnitPowerDetails" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderPowerUnitPowerDetails");
    }

    private void createEnclosureAttributes(BladeEnclosure enclosure) {
        List attributeList = enclosure.getAttribute();
        LOGGER.fine("Enclosure Status:" + this.getStatus());
        attributeList.add(this.getAttribute("System Status", "Both", "true", null, null, null, this.m_manager.getString("xml.status", this.loginBean.getLocale()), this.getHealthStatus(this.getStatus())));
        attributeList.add(this.getAttribute("Identification", "RackView", null, "true", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + this.node.getGUID() + "&drillDownType=DrillDownType-DeviceName&globalselection=true", null, this.m_manager.getString("xml.enclosureName", this.loginBean.getLocale()), this.getValue(this.node.getNameString())));
        attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.enclosureName", this.loginBean.getLocale()), this.getValue(this.node.getNameString())));
        attributeList.add(this.getAttribute("Identification", "Both", null, null, null, null, this.m_manager.getString("xml.serialNumber", this.loginBean.getLocale()), this.getValue(this.node.getSerialNumber())));
        attributeList.add(this.getAttribute("Identification", "Both", null, null, null, null, this.m_manager.getString("xml.uuid", this.loginBean.getLocale()), this.getValue(this.node.getAgentUUID())));
        MxNode rackNode = BPVXML.getRackNode(this.node);
        String rackHeightValue = null;
        String dataCentreIdValue = null;
        String dataCentreLocValue = null;
        int rowNumberValue = 0;
        int posInRowvalue = 0;
        if (rackNode != null) {
            String posInRowStr;
            attributeList.add(this.getAttribute("Identification", "EnclosureView", null, "true", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true", null, this.m_manager.getString("xml.rName", this.loginBean.getLocale()), this.getValue(rackNode.getNameString())));
            rackHeightValue = rackNode.getClientAttribute("rackHeight");
            dataCentreIdValue = rackNode.getClientAttribute("DataCentreID");
            dataCentreLocValue = rackNode.getClientAttribute("DataCentreLoc");
            String rowNumberStr = rackNode.getClientAttribute("RowNumber");
            if (rowNumberStr != null && rowNumberStr.length() > 0) {
                rowNumberValue = Integer.parseInt(rowNumberStr);
            }
            if ((posInRowStr = rackNode.getClientAttribute("PositionRow")) != null && posInRowStr.length() > 0) {
                posInRowvalue = Integer.parseInt(posInRowStr);
            }
            if (rackHeightValue != null && rackHeightValue.length() > 0) {
                rackHeightValue = rackHeightValue + " " + "U";
                attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rHeight", this.loginBean.getLocale()), this.getValue(rackHeightValue)));
            }
            if (dataCentreIdValue != null && dataCentreIdValue.length() > 0) {
                attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rDataCentreId", this.loginBean.getLocale()), this.getValue(dataCentreIdValue)));
            }
            if (dataCentreLocValue != null && dataCentreLocValue.length() > 0) {
                attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rDataCentreLoc", this.loginBean.getLocale()), this.getValue(dataCentreLocValue)));
            }
            if (rowNumberValue > 0) {
                attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rRowNumber", this.loginBean.getLocale()), String.valueOf(rowNumberValue)));
            }
            if (posInRowvalue > 0) {
                attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rPosInRow", this.loginBean.getLocale()), String.valueOf(posInRowvalue)));
            }
        } else {
            attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rName", this.loginBean.getLocale()), this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale())));
        }
        attributeList.add(this.getAttribute("Identification", "Both", "false", null, null, null, this.m_manager.getString("xml.uidStatus", this.loginBean.getLocale()), this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus())));
        if (GlobalSettings.getProperty((String)"http_check_state", (String)"checked").equals("checked")) {
            String oaName = this.m_manager.getString("xml.OALink", this.loginBean.getLocale());
            try {
                oaName = OAHelper.getOAHelper().getOAMxNode(this.node).getNameString();
                attributeList.add(this.getAttribute("Identification", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.OALink", this.loginBean.getLocale()), oaName));
            }
            catch (OAException bpvExcep) {
                LOGGER.fine("Could not get the OA Name from the Node,Hence OA linkwill not be shown in Rack/Enclosure view.");
            }
        }
    }

    private void createEnclPwrThermalAttributes(BladeEnclosure enclosure) {
        LOGGER.fine("MxBPVOverlordEnclosure:createAttributes(MxNode " + this.node.getNameString() + "BladeEnclosure " + enclosure);
        List attributeList = enclosure.getAttribute();
        DeviceTempsType deviceTemps = this.m_enclosureObj.getDeviceTempsType();
        this.renderTemperatureInfo(deviceTemps.getDeviceTempTypeList(), enclosure.getTemperature());
        EnclosurePowerType powerType = this.m_enclosureObj.getEnclosurePowerType();
        if (GlobalSettings.getProperty((String)"http_check_state", (String)"checked").equals("checked")) {
            try {
                OAHelper.getOAHelper().getOAMxNode(this.node);
                attributeList.add(this.getAttribute("Power And Thermal", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.powerRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(powerType.getPowerRedundancy())));
                DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
                attributeList.add(this.getAttribute("Power And Thermal", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.FanRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(fansType.getRedundancy())));
            }
            catch (OAException bpvExcep) {
                attributeList.add(this.getAttribute("Power And Thermal", "Both", null, null, null, null, this.m_manager.getString("xml.powerRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(powerType.getPowerRedundancy())));
                DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
                attributeList.add(this.getAttribute("Power And Thermal", "Both", null, null, null, null, this.m_manager.getString("xml.FanRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(fansType.getRedundancy())));
                LOGGER.fine("Only redundancy values will be shown andnot the links because either http/s global protocol settings is disabledor there are no physical active/standby oa in the enclosure.");
            }
        } else {
            attributeList.add(this.getAttribute("Power And Thermal", "Both", null, null, null, null, this.m_manager.getString("xml.powerRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(powerType.getPowerRedundancy())));
            DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
            attributeList.add(this.getAttribute("Power And Thermal", "Both", null, null, null, null, this.m_manager.getString("xml.FanRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(fansType.getRedundancy())));
            LOGGER.fine("Only redundancy values will be shown andnot the links because either http/s global protocol settings is disabledor there are no physical active/standby oa in the enclosure.");
        }
    }

    private String getRedundancyValue(String redundancy) {
        LOGGER.fine("MxBPVOverlordEnclosure.getRedundancyValue(String " + redundancy + ")");
        String value = this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale());
        if (redundancy != null && redundancy.trim().length() > 0) {
            value = this.m_manager.getString("xml." + redundancy, this.loginBean.getLocale());
        }
        LOGGER.fine("The Redundancy Value is:" + value);
        return value;
    }

    private void setOverlordDevices(int index, MxBPVElement element, boolean OA) {
        LOGGER.fine("MxBPVOverlordEnclosure.setOverlordDevices(int " + index + ",MxBPVElement " + element + ",boolean " + OA);
        if (!OA) {
            LOGGER.fine("Set the Element:" + element + "to the enclosure contents at:" + index);
            LOGGER.fine("m_switchContents:" + this.m_switchContents);
            LOGGER.fine("m_switchContents.get(index)" + this.m_switchContents.get(index));
            this.m_switchContents.set(index, element);
        } else {
            LOGGER.fine("Set the Element:" + element + "to the enclosure contents at:" + index);
            this.m_oAContents.set(index, element);
            LOGGER.fine("m_oAContents:" + this.m_oAContents);
        }
    }

    private void renderTemperatureInfo(List deviceTempInfoList, List jaxbTempList) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderTemperatureInfo(List " + deviceTempInfoList + ",List " + jaxbTempList + ")");
        DeviceTempsType.DeviceTempType deviceTemp = null;
        Temperature jaxbTemperature = null;
        Object atrribute = null;
        int deviceTempSize = deviceTempInfoList.size();
        Object attributeList = null;
        String tempDescription = null;
        String temperature = null;
        LOGGER.fine("The temperature List size:" + deviceTempSize);
        try {
            for (int i = 0; i < deviceTempSize; ++i) {
                deviceTemp = (DeviceTempsType.DeviceTempType)deviceTempInfoList.get(i);
                tempDescription = deviceTemp.getDESC();
                LOGGER.fine("Temperature Description:" + tempDescription);
                if (tempDescription == null || !tempDescription.equalsIgnoreCase("AMBIENT")) continue;
                jaxbTemperature = this.m_objFactory.createTemperature();
                temperature = deviceTemp.getC();
                if (temperature == null || temperature.equalsIgnoreCase("")) {
                    jaxbTemperature.setCurrent(this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale()));
                } else {
                    jaxbTemperature.setCurrent(temperature);
                }
                this.renderThreshold(deviceTemp, jaxbTemperature);
                jaxbTempList.add(jaxbTemperature);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("Exception in MxBPVOverlordenclsoure.renderTemperatureInfo()" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderTemperatureInfo(List " + deviceTempInfoList + ",List " + jaxbTempList + ")");
    }

    private void renderThreshold(DeviceTempsType.DeviceTempType deviceTempInfo, Temperature jaxbTemperature) {
        LOGGER.enter("MxBPVOverlordEnclosure.renderThreshold");
        List<DeviceTempsType.DeviceTempType.DeviceThresholdType> thresholdList = deviceTempInfo.getDeviceThreashold();
        int thresholdSize = thresholdList.size();
        String thresholdDesc = null;
        LOGGER.fine("The Threshold List size:" + thresholdSize);
        try {
            TemperatureType.ThresholdType jaxbThreshold = this.m_objFactory.createTemperatureTypeThresholdType();
            for (int i = 0; i < thresholdSize; ++i) {
                DeviceTempsType.DeviceTempType.DeviceThresholdType thresholdInfo = thresholdList.get(i);
                thresholdDesc = thresholdInfo.getDescription();
                LOGGER.fine("Threshold Description:" + thresholdDesc);
                if (thresholdDesc != null && thresholdDesc.equalsIgnoreCase("CAUTION")) {
                    jaxbThreshold.setCaution(this.getValue(thresholdInfo.getC()));
                    continue;
                }
                if (thresholdDesc == null || !thresholdDesc.equalsIgnoreCase("CRITICAL")) continue;
                jaxbThreshold.setCritical(this.getValue(thresholdInfo.getC()));
            }
            jaxbTemperature.setThreshold(jaxbThreshold);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOverlordEnclosure.renderThreshold" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOverlordEnclosure.renderThreshold");
    }

    private String getValue(String value) {
        LOGGER.fine("MxBPVOverlordEnclosure.getValue(String " + value + ")");
        if (value == null || value.equalsIgnoreCase("")) {
            return this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale());
        }
        return value;
    }

    private String getHealthStatus(String value) {
        if (value == null) {
            return "Unknown";
        }
        return value;
    }

    private Attribute getAttribute(String section, String location, String displayAsImage, String displayAsURL, String URL2, String displayInWindow, String name, String value) {
        Attribute attribute = null;
        try {
            attribute = this.m_objFactory.createAttribute();
            if (section != null) {
                attribute.setSection(section);
            }
            if (location != null) {
                attribute.setLocation(location);
            }
            if (displayAsImage != null) {
                attribute.setDisplayAsImage(displayAsImage);
            }
            if (displayAsURL != null) {
                attribute.setDisplayAsURL(displayAsURL);
            }
            if (URL2 != null) {
                attribute.setURL(URL2);
                attribute.setDispInWindow(displayInWindow);
            }
            attribute.setName(name);
            attribute.setValue(value);
        }
        catch (JAXBException e) {
            LOGGER.fine("Exception in MxBPVOverlordEnclosure.getAttribute()" + (Object)((Object)e));
        }
        return attribute;
    }

    public int getNumSlots() {
        return OverlordSlots.NUM_SERVER_SLOTS;
    }

    public int getNumSwitchSlots() {
        return OverlordSlots.NUM_SWITCH_SLOTS;
    }

    public int getNumOASlots() {
        return OverlordSlots.NUM_OA_SLOTS;
    }

    int getNumberOfFans() {
        return OverlordSlots.NUM_FANS;
    }

    int getNumberOfPU() {
        return OverlordSlots.NUM_POWERUNITS;
    }

    int getNextSlotNumber(MxBPVElement element) {
        return element.getNumSlotsUsedXDir();
    }

    int getNumberOfEmptySlotsInXDirection() {
        return 1;
    }

    int getNumberOfEmptySlotsInYDirection() {
        return 2;
    }

    boolean isBottomSlotEmpty(MxBPVElement top) {
        return top.getNumSlotsUsedYDir() == 1;
    }

    static class OverlordSlots {
        private static int NUM_SERVER_SLOTS = 8;
        private static int NUM_SWITCH_SLOTS = 8;
        private static int NUM_OA_SLOTS = 2;
        private static int NUM_FANS = 10;
        private static int NUM_POWERUNITS = 6;

        OverlordSlots() {
        }
    }
}

