/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLBlade;
import com.hp.mx.core.tools.datacollection.http.oa.OLBladePortMap;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVIceServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVOverlordEnclosure;
import com.hp.mx.portal.bpv.MxBPVShortyEnclosure;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.device.MxDeviceBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.AssociatedDevice;
import com.hp.mx.portal.utils.MonteroVMUtils;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jdom.Element;

public class MxBPVServer
extends MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVServer.class);
    private int numSlotsUsed;
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;
    ObjectFactory m_objFactory = new ObjectFactory();

    public MxBPVServer(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        LOGGER.enter("MxBPVServer.MxBPVServer(" + node + "," + parent + "," + loginBean + ")");
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsed = nodeAssociations.getNumBladeSlotsUsed();
        if (parent instanceof MxBPVShortyEnclosure) {
            this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedYDir();
            this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        } else {
            this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
            this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
            if (parent instanceof MxBPVIceServerEnclosure) {
                this.numSlotsUsedYDir = 2;
            }
            if (this.numSlotsUsedXDir * this.numSlotsUsedYDir != this.numSlotsUsed) {
                this.numSlotsUsedXDir = this.numSlotsUsed;
                this.numSlotsUsedYDir = 2;
            }
        }
        this.deviceType = "BladeServer";
        LOGGER.exit("MxBPVServer.MxBPVServer(" + node + "," + parent + "," + loginBean + ")");
    }

    public int getNumSlotsUsed() {
        return this.numSlotsUsed;
    }

    public int getNumSlotsUsedXDir() {
        return this.numSlotsUsedXDir;
    }

    public int getNumSlotsUsedYDir() {
        return this.numSlotsUsedYDir;
    }

    String getDrillDownURL(String drillDownType) {
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + drillDownType + "&globalselection=true";
    }

    String getPropertyPageURL(String drillDownType, String url) {
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + drillDownType + "&globalselection=true" + "&propertyPageURL=" + url;
    }

    public Element renderXML() {
        BPVXML bpvXml = BPVXML.getInstance();
        Element server = bpvXml.createDevice(this, false, this.loginBean);
        return server;
    }

    public JAXBObject renderJAXBXML() {
        LOGGER.enter("MxBPVServer.renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType(this.getNode().getDeviceType());
            device.setLocation("Front");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            LOGGER.fine("Server status:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setUID(deviceStatus);
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            this.setAutomationStatus(device);
            this.setAssociatedBlade(device);
            this.setVmHost(device);
            device.setImageURL(this.getImageURL("server"));
            LOGGER.exit("MxBPVServer.renderJAXBXML");
            return (JAXBObject)device;
        }
        catch (JAXBException je) {
            LOGGER.fine("JAXBException in MxBPVServer:renderJAXBXML()" + (Object)((Object)je));
            LOGGER.exit("MxBPVServer.renderJAXBXML");
            return null;
        }
    }

    private void setAssociatedBlade(DeviceType device) {
        LOGGER.enter("MxBPVServer.setAssociatedBlade");
        MxNode devNode = this.getNode();
        DeviceType.AssociatedBladeType assocBlade = null;
        try {
            assocBlade = this.m_objFactory.createDeviceTypeAssociatedBladeType();
            AssociatedDevice assocDev = new AssociatedDevice(devNode);
            int assocBay = assocDev.getAssociatedDevBay();
            MxNode assocSrvNode = assocDev.getAssociatedDevNode();
            if (assocSrvNode != null) {
                assocBlade.setBay(assocBay);
                assocBlade.setName(assocSrvNode.getNameString());
                assocBlade.setIsPresent("Yes");
            } else {
                assocBlade.setIsPresent("No");
            }
            device.setAssociatedBlade(assocBlade);
        }
        catch (JAXBException jexec) {
            LOGGER.fine("exception" + (Object)((Object)jexec));
        }
        LOGGER.exit("MxBPVServer.setAssociatedBlade");
    }

    private void setVmHost(DeviceType device) {
        LOGGER.enter("MxBPVServer.setVmHost");
        MxNode devNode = this.getNode();
        DeviceType.VmHostType vmHost = null;
        try {
            vmHost = this.m_objFactory.createDeviceTypeVmHostType();
            MonteroVMUtils m_vmUtil = new MonteroVMUtils();
            if (m_vmUtil.isVmHost(devNode)) {
                vmHost.setIsVmHost("Yes");
                vmHost.setVmGuestCount(m_vmUtil.getVMGuestCount(devNode));
                String vmHostOS = m_vmUtil.getVMHostOsName(this.node);
                if (vmHostOS != null && vmHostOS.length() != 0) {
                    vmHost.setVmHostName(vmHostOS);
                } else {
                    vmHost.setVmHostName(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.loginBean.getLocale()));
                }
            } else {
                vmHost.setIsVmHost("No");
            }
            device.setVmHost(vmHost);
        }
        catch (JAXBException jexec) {
            LOGGER.fine("Exception in MxBPVServer.setVmHost" + (Object)((Object)jexec));
        }
        LOGGER.exit("MxBPVServer.setVmHost");
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVServer.setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            LOGGER.fine("X Direction:" + this.numSlotsUsedXDir);
            LOGGER.fine("Y Direction:" + this.numSlotsUsedYDir);
            slots.setXDirection(this.numSlotsUsedXDir);
            slots.setYDirection(this.numSlotsUsedYDir);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVServer.setSlotsInfoForDevice" + (Object)((Object)e));
        }
    }

    private void setCommonInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVServer.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(this.getDeviceName());
            common.setProduct(this.node.getModel());
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL(MxDrillDown.DEVICE_NAME_DRILL_DOWN));
            if (this.getNode().getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO)) {
                common.setHomePageURL(this.getDrillDownURL(MxDrillDown.HW_STATUS_DRILL_DOWN));
            } else {
                String propertyPageURL = null;
                try {
                    boolean PROPERTY_STATUS = true;
                    MxDeviceBean devBean = new MxDeviceBean();
                    devBean.initialize(this.getGUID(), this.loginBean);
                    propertyPageURL = devBean.getPropertyPageUrl(this.loginBean, 1);
                    if (propertyPageURL != null) {
                        common.setHomePageURL(this.getPropertyPageURL("PropertyPage", propertyPageURL));
                    }
                }
                catch (Throwable e) {
                    LOGGER.fine("PropertyPageURL not supported on this server, Name:" + this.getName());
                }
            }
            common.setSerialNumber(BPVXML.checkValue(this.node.getSerialNumber(), this.loginBean));
            common.setIPAddress(BPVXML.checkValue(this.node.getWorkingAddress(), this.loginBean));
            common.setOS(BPVXML.checkValue(this.node.getOSNameStr(), this.loginBean));
            MxNode iLONode = BPVXML.getiLONode(this.node.getDeviceKey());
            if (iLONode != null) {
                common.setILOIP(BPVXML.checkValue(iLONode.getWorkingAddress(), this.loginBean));
            } else {
                common.setILOIP(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.loginBean.getLocale()));
            }
            this.getMezzInfo(this.node, common);
            device.setCommon(common);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVServer.setCommonInfoForDevice" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVServer.setCommonInfoForDevice");
    }

    private void setAutomationStatus(DeviceType device) {
    }

    private String getDeviceName() {
        return this.node.getNameString();
    }

    private void getMezzInfo(MxNode serverNode, DeviceType.CommonType common) {
        LOGGER.enter("BPVXML.getMezzInfo(serverNode " + this.node + ",common " + common + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        try {
            MxBPVOverlordEnclosure parent = (MxBPVOverlordEnclosure)this.getParent();
            OLBlade blade = (OLBlade)oaHelper.getOLDevice(parent.m_enclosureObj, this.node.getDeviceKey());
            OLBladePortMap bladePortMap = blade.getOLBladePortMap();
            List<OLBladePortMap.MezzType> mezzList = bladePortMap.getMezzTypeList();
            OLBladePortMap.MezzType mezzTypeInfo = null;
            List mezzDeviceList = common.getMezzDevice();
            for (int i = 0; i < mezzList.size(); ++i) {
                mezzTypeInfo = mezzList.get(i);
                OLBladePortMap.MezzType.DeviceType deviceType = mezzTypeInfo.getDeviceType();
                if (deviceType.getType().equalsIgnoreCase("MEZZ_DEV_TYPE_FIXED") || deviceType.getName().equalsIgnoreCase("")) continue;
                DeviceType.CommonType.MezzDeviceType mezzDevice = this.m_objFactory.createDeviceTypeCommonTypeMezzDeviceType();
                String deviceName = deviceType.getName();
                if (deviceType.getPortTypeList().size() == 0) {
                    deviceName = MonteroResourceManager.getInstance().getString("PortMap.ISVBError", this.loginBean.getLocale());
                }
                mezzDevice.setMezzSlotNumber(mezzTypeInfo.getNumber());
                mezzDevice.setMezzDeviceName(deviceName);
                mezzDeviceList.add(mezzDevice);
            }
        }
        catch (OAException e) {
            LOGGER.fine("OAException in MxBPVServer.getMezzInfo" + e);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVServer.getMezzInfo" + (Object)((Object)e));
        }
        LOGGER.exit("BPVXML.getMezzInfo");
    }

    protected String getImageURL(String imageType) {
        String unSupportImage;
        String string = unSupportImage = this.getNumSlotsUsedYDir() == 2 ? "full_unknown.gif" : "half_unknown.gif";
        if (this.getParent() instanceof MxBPVShortyEnclosure) {
            unSupportImage = this.getNumSlotsUsedXDir() == 2 ? "full_unknown.gif" : "half_unknown.gif";
        }
        return super.getImageURL(imageType, unSupportImage);
    }
}

